/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.util.Arrays;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;

public class FileProcessDriver
implements GeneralProcessConnectionInterface {
    public ProcessEngine engine;

    public void disposeResource() {
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public void format() {
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_FILE_START") || string.equals("___exists") || string.equals("___directory") || string.equals("___mkdir") || string.equals("___isdir") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_makeDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_makeFile") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_removeFile") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_renameFile") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_moveFile") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_copyFile") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileList") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileName") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileRelativePath") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileAbsolutePath") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getParentDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getCurrentDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getMainDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getHomeDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getRootDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getTmpDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_getLibraryDirectory") || string.equals("SYSTEM_PROCESS_DRIVER_FILE_END");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        Object object;
        Object object2;
        File file;
        Object object3;
        Object object4;
        Object[] objectArray = new String[]{"false"};
        if (string.equals("___exists")) {
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            object4 = ((File)object3).exists() ? "true" : "false";
            objectArray = new String[]{object4};
        }
        if (string.equals("directory")) {
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            object4 = ((File)object3).isDirectory() ? "true" : "false";
            objectArray = new String[]{object4};
        }
        if (string.equals("___isdir")) {
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            object4 = ((File)object3).isDirectory() ? "true" : "false";
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_makeDirectory")) {
            if (!this.engine.getSecurity().request_WRITE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            ((File)object3).mkdir();
            objectArray = new String[]{object4};
        }
        if (string.equals("___mkdir")) {
            if (!this.engine.getSecurity().request_WRITE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            ((File)object3).mkdir();
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_makeFile")) {
            if (!this.engine.getSecurity().request_WRITE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            try {
                ((File)object3).createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_removeFile")) {
            if (!this.engine.getSecurity().request_DELETE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            ((File)object3).delete();
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_renameFile")) {
            if (!new File(stringArray[1]).isAbsolute() && !((ProcessCompatibilityException)(object4 = new ProcessCompatibilityException())).alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("File.renameFile \u306e\u7b2c\u4e8c\u5f15\u6570\u306b\u306f\u3001\u7d76\u5bfe\u30d1\u30b9\u3092\u6307\u5b9a\u3059\u308b\u4e8b\u304c\u63a8\u5968\u3055\u308c\u307e\u3059\u3002\u76f8\u5bfe\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u305f\u5834\u5408\u306e\u6319\u52d5\u306f\u3001\u5b9f\u884c\u74b0\u5883\u3084\u51e6\u7406\u7cfb\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306b\u4f9d\u5b58\u3057\u307e\u3059\u3002VCSSL 3.2.16\u4ee5\u524d\u3067\u306f\u3001\u76f8\u5bfe\u30d1\u30b9\u306f\u51e6\u7406\u7cfb\u57fa\u6e96\u3068\u898b\u306a\u3055\u308c\u307e\u3059\u304c\u3001VCSSL 3.2.18\u4ee5\u964d\u3067\u306f\u3001\u76f8\u5bfe\u30d1\u30b9\u306f\u5b9f\u884c\u5bfe\u8c61\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u57fa\u6e96\u3068\u898b\u306a\u3055\u308c\u307e\u3059\u3002");
                } else {
                    this.engine.error("It is recommended to specify the absolute (not relative) file path to \"File.renameFile\" function. If a relative file path is specified, the behaviour of this function depends on the version of VCSSL.");
                }
                return null;
            }
            if (!this.engine.getSecurity().request_CHANGE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            file = this.engine.getMainRelativeFile(stringArray[1]);
            ((File)object3).renameTo(file);
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_moveFile")) {
            if (!this.engine.getSecurity().request_CHANGE_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            file = this.engine.getMainRelativeFile(stringArray[1]);
            ((File)object3).renameTo(file);
            objectArray = new String[]{object4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_copyFile")) {
            object4 = this.engine.getMainRelativeFile(stringArray[1]);
            if (!this.engine.getSecurity().request_WRITE_FILE(stringArray[1]) || !this.engine.getSecurity().request_READ_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            file = this.engine.getMainRelativeFile(stringArray[1]);
            if (file.exists() && !this.engine.getSecurity().request_OVERWRITE_FILE(stringArray[1])) {
                this.engine.exit();
                return new String[]{""};
            }
            try {
                object2 = new FileInputStream((File)object3);
                object = ((FileInputStream)object2).getChannel();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                ((FileChannel)object).transferTo(0L, ((FileChannel)object).size(), fileChannel);
                ((AbstractInterruptibleChannel)object).close();
                fileChannel.close();
                ((FileInputStream)object2).close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            objectArray = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileList")) {
            int n = stringArray.length;
            if (n == 1) {
                object3 = this.engine.getMainRelativeFile(stringArray[0]);
                objectArray = ((File)object3).list();
            } else {
                boolean bl = stringArray[1].equals("true");
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 == 21) {
                    object2 = this.engine.getMainRelativeFile(stringArray[0]);
                    object = ((File)object2).list();
                    if (bl) {
                        Arrays.sort(object, String.CASE_INSENSITIVE_ORDER);
                        objectArray = object;
                    } else {
                        Arrays.sort((Object[])object);
                        objectArray = object;
                    }
                } else {
                    object2 = this.engine.getMainRelativeFile(stringArray[0]);
                    objectArray = ((File)object2).list();
                }
            }
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileName")) {
            String string2 = "";
            object3 = new File(stringArray[0]);
            string2 = ((File)object3).getName();
            objectArray = new String[]{string2};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileRelativePath")) {
            ProcessCompatibilityException processCompatibilityException;
            if ((stringArray[0].length() == 0 || stringArray.length == 2 && stringArray[1].length() == 0) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                object3 = new ProcessRuntimeException(this.engine);
                ((ProcessRuntimeException)object3).setInfo(1);
                throw object3;
            }
            String string3 = "";
            object3 = new File(stringArray[0]);
            if (stringArray.length == 2) {
                object3 = new File(new File(stringArray[1]), stringArray[0]);
            }
            string3 = ((File)object3).getPath();
            objectArray = new String[]{string3};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getFileAbsolutePath")) {
            String string4 = "";
            object3 = this.engine.getMainRelativeFile(stringArray[0]);
            if (stringArray.length == 2) {
                object3 = new File(this.engine.getMainRelativeFile(stringArray[1]), stringArray[0]);
            }
            try {
                string4 = FileSystems.getDefault().getPath(((File)object3).getPath(), new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException iOException) {
                string4 = ((File)object3).getAbsolutePath();
            }
            catch (Exception exception) {
                string4 = ((File)object3).getPath();
            }
            objectArray = new String[]{string4};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getParentDirectory")) {
            String string5 = "";
            object3 = new File(stringArray[0]);
            string5 = ((File)object3).getParent();
            objectArray = new String[]{string5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getMainDirectory")) {
            String string6 = "";
            string6 = this.engine.mainProgramDirectory.getPath();
            objectArray = new String[]{string6};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getCurrentDirectory")) {
            String string7 = "";
            string7 = System.getProperty("user.dir");
            objectArray = new String[]{string7};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getHomeDirectory")) {
            String string8 = "";
            string8 = System.getProperty("user.home");
            objectArray = new String[]{string8};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getTmpDirectory")) {
            String string9 = "";
            string9 = System.getProperty("java.io.tmpdir");
            if (string9.endsWith((String)(object3 = System.getProperty("file.separator")))) {
                string9 = string9.substring(0, string9.length() - ((String)object3).length());
            }
            objectArray = new String[]{string9};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getRootDirectory")) {
            File[] fileArray = File.listRoots();
            objectArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                objectArray[i] = fileArray[i].getPath();
            }
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_FILE_getLibraryDirectory")) {
            try {
                File file2 = new File("lib/");
                URL uRL = file2.toURI().toURL();
                String string10 = uRL.getPath();
                object2 = new File(string10);
                string10 = FileSystems.getDefault().getPath(((File)object2).getPath(), new String[0]).toRealPath(new LinkOption[0]).toString();
                objectArray = new String[]{string10};
            }
            catch (Exception exception) {
                objectArray = new String[]{""};
            }
        }
        return objectArray;
    }
}

