/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.process.graphics.gui.ButtonMount;
import rxvesapi.process.graphics.gui.CheckBoxMount;
import rxvesapi.process.graphics.gui.FrameMount;
import rxvesapi.process.graphics.gui.GUIProcessMount;
import rxvesapi.process.graphics.gui.ImageLabelMount;
import rxvesapi.process.graphics.gui.NativeTextAreaMount;
import rxvesapi.process.graphics.gui.NativeTextFieldMount;
import rxvesapi.process.graphics.gui.PanelMount;
import rxvesapi.process.graphics.gui.ScrollPanelMount;
import rxvesapi.process.graphics.gui.SelectAreaMount;
import rxvesapi.process.graphics.gui.SelectFieldMount;
import rxvesapi.process.graphics.gui.SliderMount;
import rxvesapi.process.graphics.gui.TabPanelMount;
import rxvesapi.process.graphics.gui.TextAreaMount;
import rxvesapi.process.graphics.gui.TextFieldMount;
import rxvesapi.process.graphics.gui.TextLabelMount;
import rxvesapi.process.graphics.gui.function.Function_getComponentColor;
import rxvesapi.process.graphics.gui.function.Function_getComponentFloatValue;
import rxvesapi.process.graphics.gui.function.Function_getComponentIntegerValue;
import rxvesapi.process.graphics.gui.function.Function_getComponentText;
import rxvesapi.process.graphics.gui.function.Function_repaintComponent;
import rxvesapi.process.graphics.gui.function.Function_setComponentFloatValue;
import rxvesapi.process.graphics.gui.function.Function_setComponentIntegerValue;
import rxvesapi.process.graphics.gui.function.Function_setComponentText;
import rxvesapi.process.kernel.FunctionCallKernel;

public class GUIProcessDriver
implements GeneralProcessConnectionInterface {
    public ProcessEngine engine;
    public Image[] image;
    public JFrame frame;
    public GUIProcessMount[] Mount;
    public int guiCounter = 0;
    public FunctionCallKernel[] kernel;
    public GraphicsProcessDriver graphicsDriver;
    public Font systemFont;
    public Color clearColor;
    public Color whiteColor;
    public Color blackColor;
    public Font defaultFont_SIZE1;
    public double[] defaultModelSize3;
    public double[] defaultModelSize2;
    public Color colorBuffer;
    public int colorBuffer_RED;
    public int colorBuffer_GREEN;
    public int colorBuffer_BLUE;
    public int colorBuffer_ALPHA;

    @Override
    public void init() {
        this.format();
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public GUIProcessDriver(GraphicsProcessDriver graphicsProcessDriver) {
        this.graphicsDriver = graphicsProcessDriver;
        this.Mount = new GUIProcessMount[0];
        this.systemFont = new Font("Dialog", 0, 14);
        this.defaultFont_SIZE1 = new Font("Dialog", 0, 1);
        this.clearColor = new Color(255, 255, 255, 0);
        this.whiteColor = Color.white;
        this.blackColor = Color.black;
        this.colorBuffer_RED = 255;
        this.colorBuffer_GREEN = 255;
        this.colorBuffer_BLUE = 255;
        this.colorBuffer_ALPHA = 255;
        this.colorBuffer = new Color(this.colorBuffer_RED, this.colorBuffer_GREEN, this.colorBuffer_BLUE, this.colorBuffer_ALPHA);
        this.createKernel();
    }

    public void disposeResource() {
        this.frame = null;
        if (this.Mount != null) {
            for (int i = 0; i < this.Mount.length; ++i) {
                if (this.Mount[i] == null) continue;
                this.Mount[i].disposeResource();
                this.Mount[i] = null;
            }
        }
        this.Mount = null;
        this.graphicsDriver = this.graphicsDriver;
    }

    public void format() {
        if (this.Mount != null) {
            for (int i = 0; i < this.Mount.length; ++i) {
                if (this.Mount[i] == null) continue;
                this.Mount[i].disposeResource();
                this.Mount[i] = null;
            }
        }
        this.Mount = new GUIProcessMount[0];
        this.guiCounter = 0;
    }

    public FunctionCallKernel[] getKernel() {
        return this.kernel;
    }

    public void createKernel() {
        int n = 8;
        int n2 = 0;
        this.kernel = new FunctionCallKernel[n];
        this.kernel[n2] = new Function_repaintComponent(this);
        this.kernel[++n2] = new Function_setComponentText(this);
        this.kernel[++n2] = new Function_getComponentText(this);
        this.kernel[++n2] = new Function_setComponentFloatValue(this);
        this.kernel[++n2] = new Function_getComponentFloatValue(this);
        this.kernel[++n2] = new Function_setComponentIntegerValue(this);
        this.kernel[++n2] = new Function_getComponentIntegerValue(this);
        this.kernel[++n2] = new Function_getComponentColor(this);
        ++n2;
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_START") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTEST") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createWindow") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createButton") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextField") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextArea") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createNativeTextArea") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createNativeTextField") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextLabel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGraphicsLabel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createCheckBox") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectField") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectField_ADD_ITEM") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectArea") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectArea_SET_LIST") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider_FVALUE_FMAX_FMIN") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider_IVALUE_IMAX_IMIN") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider_FVALUE_FMAX_FMIN") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider_IVALUE_IMAX_IMIN") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGridPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createFlowPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createLevelPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTabPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createScrollPanel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_addComponent") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_removeComponent") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_disposeComponent") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentColor") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentVisible") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentVertex") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFont") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontBold") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontItalic") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontName") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFloatValue") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentState") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentList") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentListSelected") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentIntArrayValue") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentVisible") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentVertex") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentInnerSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentFloatValue") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentState") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentList") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentListSelected") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentIntArrayValue") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_END");
    }

    public void expandMount() {
        int n;
        GUIProcessMount[] gUIProcessMountArray = new GUIProcessMount[this.Mount.length];
        for (n = 0; n < this.Mount.length; ++n) {
            gUIProcessMountArray[n] = this.Mount[n];
        }
        this.Mount = new GUIProcessMount[this.Mount.length + 1];
        for (n = 0; n < gUIProcessMountArray.length; ++n) {
            this.Mount[n] = gUIProcessMountArray[n];
        }
        gUIProcessMountArray = null;
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTEST")) {
            stringArray2 = new String[]{"a", "b", "c"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createWindow")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new FrameMount(n4, n3, n2, n);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createButton")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new ButtonMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextField")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new TextFieldMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextArea")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new TextAreaMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createNativeTextField")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new NativeTextFieldMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createNativeTextArea")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new NativeTextAreaMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTextLabel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new TextLabelMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGraphicsLabel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            int n6 = -1;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                n6 = Integer.parseInt(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new ImageLabelMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].graphicsID = n6;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setImage(this.graphicsDriver.image[n6]);
            this.Mount[n5].setImageID(n6);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createCheckBox")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            boolean bl = false;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray[5].equals("true")) {
                bl = true;
            }
            this.Mount[n5] = new CheckBoxMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].setState(bl);
            this.Mount[n5].setText(stringArray[4]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectField")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            n4 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SelectFieldMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n4, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectField_ADD_ITEM")) {
            this.expandMount();
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5].addItem(stringArray[1]);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectArea")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n7 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n7 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SelectAreaMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n7, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createSelectArea_SET_LIST")) {
            this.expandMount();
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray3 = new String[stringArray.length - 1];
            for (n3 = 0; n3 < stringArray3.length; ++n3) {
                stringArray3[n3] = stringArray[n3 + 1];
            }
            this.Mount[n5].setList(stringArray3);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n8 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            double d2 = 0.0;
            try {
                n8 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                d2 = Double.parseDouble(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.VERTICAL);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n8, n3, n2, n);
            this.Mount[n5].setDoubleValue(d2);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider_FVALUE_FMAX_FMIN")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n9 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            double d3 = 0.0;
            double d4 = 1.0;
            d = 0.0;
            try {
                n9 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                d3 = Double.parseDouble(stringArray[4]);
                d4 = Double.parseDouble(stringArray[5]);
                d = Double.parseDouble(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.VERTICAL, d4, d);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n9, n3, n2, n);
            this.Mount[n5].setDoubleValue(d3);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalSlider_IVALUE_IMAX_IMIN")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n10 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            int n11 = 0;
            int n12 = 1;
            int n13 = 0;
            try {
                n10 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                n11 = Integer.parseInt(stringArray[4]);
                n12 = Integer.parseInt(stringArray[5]);
                n13 = Integer.parseInt(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.VERTICAL, n12, n13);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n10, n3, n2, n);
            this.Mount[n5].setIntValue(n11);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n14 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            double d5 = 0.0;
            try {
                n14 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                d5 = Double.parseDouble(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.HORIZONTAL);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n14, n3, n2, n);
            this.Mount[n5].setDoubleValue(d5);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider_FVALUE_FMAX_FMIN")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n15 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            double d6 = 0.0;
            double d7 = 1.0;
            d = 0.0;
            try {
                n15 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                d6 = Double.parseDouble(stringArray[4]);
                d7 = Double.parseDouble(stringArray[5]);
                d = Double.parseDouble(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.HORIZONTAL, d7, d);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n15, n3, n2, n);
            this.Mount[n5].setDoubleValue(d6);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createHorizontalSlider_IVALUE_IMAX_IMIN")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n16 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            int n17 = 0;
            int n18 = 1;
            int n19 = 0;
            try {
                n16 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                n17 = Integer.parseInt(stringArray[4]);
                n18 = Integer.parseInt(stringArray[5]);
                n19 = Integer.parseInt(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new SliderMount(SliderMount.HORIZONTAL, n18, n19);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n16, n3, n2, n);
            this.Mount[n5].setIntValue(n17);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n20 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n20 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new PanelMount(null);
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n20, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGridPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n21 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            int n22 = 1;
            int n23 = 1;
            try {
                n21 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
                n22 = Integer.parseInt(stringArray[4]);
                n23 = Integer.parseInt(stringArray[5]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new PanelMount(new GridLayout(n22, n23));
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n21, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createFlowPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n24 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n24 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new PanelMount(new FlowLayout());
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n24, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createVerticalPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n25 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n25 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new PanelMount(null);
            JPanel jPanel = (JPanel)this.Mount[n5].component;
            jPanel.setLayout(new BoxLayout((JPanel)this.Mount[n5].component, 1));
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n25, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createLevelPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n26 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n26 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new PanelMount(null);
            JPanel jPanel = (JPanel)this.Mount[n5].component;
            jPanel.setLayout(new BoxLayout((JPanel)this.Mount[n5].component, 0));
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n26, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createTabPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n27 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n27 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new TabPanelMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n27, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createScrollPanel")) {
            this.expandMount();
            n5 = this.Mount.length - 1;
            int n28 = 0;
            n3 = 0;
            n2 = 100;
            n = 100;
            try {
                n28 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5] = new ScrollPanelMount();
            this.Mount[n5].id = n5;
            this.Mount[n5].engine = this.engine;
            this.Mount[n5].driver = this.graphicsDriver;
            this.Mount[n5].setBounds(n28, n3, n2, n);
            this.Mount[n5].EVENT_ENABLED = true;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_addComponent")) {
            n5 = 0;
            int n29 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n29 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.Mount[n29].type == 125) {
                this.Mount[n29].add(this.Mount[n5].getText(), this.Mount[n5].getComponent());
            } else if (this.Mount[n29].type == 126) {
                JComponent jComponent = (JComponent)this.Mount[n29].getComponent();
                jComponent.setPreferredSize(new Dimension((int)this.Mount[n5].getBounds().getWidth(), (int)this.Mount[n5].getBounds().getHeight()));
                this.Mount[n29].add(this.Mount[n5].getComponent());
                this.Mount[n5].setParent(this.Mount[n29]);
            } else {
                this.Mount[n29].add(this.Mount[n5].getComponent());
            }
            this.Mount[n5].repaint();
            this.Mount[n29].repaint();
            this.Mount[n5].setVisible(false);
            this.Mount[n5].setVisible(true);
            this.Mount[n5].repaint();
            this.Mount[n29].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_removeComponent")) {
            n5 = 0;
            int n30 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n30 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n30].remove(this.Mount[n5].getComponent());
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_disposeComponent")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5].disposeResource();
            this.Mount[n5] = null;
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentList")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray4 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray4.length; ++i) {
                stringArray4[i] = stringArray[i + 1];
            }
            this.Mount[n5].setList(stringArray4);
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentListSelected")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray5 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray5.length; ++i) {
                stringArray5[i] = stringArray[i + 1];
            }
            this.Mount[n5].setListSelected(stringArray5);
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentList")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray6 = this.Mount[n5].getList();
            stringArray2 = stringArray6;
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentListSelected")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray7 = this.Mount[n5].getListSelected();
            stringArray2 = stringArray7;
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentIntArrayValue")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                int[] nArray = new int[stringArray.length - 1];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i + 1]);
                }
                this.Mount[n5].setIntArrayValue(nArray);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentIntArrayValue")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int[] nArray = this.Mount[n5].getIntArrayValue();
            String[] stringArray8 = new String[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                stringArray8[n2] = "" + nArray[n2];
            }
            stringArray2 = stringArray8;
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontSize")) {
            n5 = 0;
            int n31 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n31 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5].setFontSize(n31);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontBold")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray[1].equals("true")) {
                this.Mount[n5].setFontBold(true);
            } else {
                this.Mount[n5].setFontBold(false);
            }
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontItalic")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray[1].equals("true")) {
                this.Mount[n5].setFontItalic(true);
            } else {
                this.Mount[n5].setFontItalic(false);
            }
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFont")) {
            n5 = 0;
            int n32 = 0;
            String string2 = stringArray[1];
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n32 = Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n2 = 0;
            if (stringArray[3].equals("true")) {
                n2 = 1;
            }
            if (stringArray[4].equals("true")) {
                n2 = 2;
            }
            Font font = new Font(string2, n2, n32);
            this.Mount[n5].setFont(font);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentFontName")) {
            n5 = 0;
            String string3 = stringArray[1];
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5].setFontName(string3);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentSize")) {
            n5 = 0;
            int n33 = 0;
            int n34 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n33 = Integer.parseInt(stringArray[1]);
                n34 = Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Rectangle rectangle = this.Mount[n5].getBounds();
            this.Mount[n5].setBounds((int)rectangle.getX(), (int)rectangle.getY(), n33, n34);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentSize")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Rectangle rectangle = this.Mount[n5].getBounds();
            stringArray2 = new String[]{"" + (int)rectangle.getWidth(), "" + (int)rectangle.getHeight()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentInnerSize")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Rectangle rectangle = this.Mount[n5].getInnerBounds();
            stringArray2 = new String[]{"" + (int)rectangle.getWidth(), "" + (int)rectangle.getHeight()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentVertex")) {
            n5 = 0;
            int n35 = 0;
            int n36 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n35 = Integer.parseInt(stringArray[1]);
                n36 = Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Rectangle rectangle = this.Mount[n5].getBounds();
            this.Mount[n5].setBounds(n35, n36, (int)rectangle.getWidth(), (int)rectangle.getHeight());
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentVertex")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Rectangle rectangle = this.Mount[n5].getBounds();
            stringArray2 = new String[]{"" + (int)rectangle.getX(), "" + (int)rectangle.getY()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentColor")) {
            n5 = 0;
            int n37 = 0;
            int n38 = 0;
            int n39 = 0;
            int n40 = 0;
            int n41 = 0;
            int n42 = 0;
            int n43 = 0;
            int n44 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n37 = Integer.parseInt(stringArray[1]);
                n38 = Integer.parseInt(stringArray[2]);
                n39 = Integer.parseInt(stringArray[3]);
                n40 = Integer.parseInt(stringArray[4]);
                n41 = Integer.parseInt(stringArray[5]);
                n42 = Integer.parseInt(stringArray[6]);
                n43 = Integer.parseInt(stringArray[7]);
                n44 = Integer.parseInt(stringArray[8]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n37 < 0 && n38 < 0 && n39 < 0 && n40 < 0) {
                this.Mount[n5].setForeground(null);
            } else {
                this.Mount[n5].setForeground(new Color(n37, n38, n39, n40));
            }
            if (n41 < 0 && n42 < 0 && n43 < 0 && n44 < 0) {
                this.Mount[n5].setBackground(null);
            } else {
                this.Mount[n5].setBackground(new Color(n41, n42, n43, n44));
            }
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentGraphics")) {
            n5 = 0;
            int n45 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
                n45 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.Mount[n5].setImage(this.graphicsDriver.image[n45]);
            this.Mount[n5].setImageID(n45);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentGraphics")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stringArray2 = new String[]{"" + this.Mount[n5].getImageID()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentVisible")) {
            n5 = 0;
            boolean bl = false;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray[1].equals("true")) {
                bl = true;
            }
            this.Mount[n5].setVisible(bl);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentVisible")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stringArray2 = new String[]{"" + this.Mount[n5].isVisible()};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_setComponentState")) {
            n5 = 0;
            boolean bl = false;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray[1].equals("true")) {
                bl = true;
            }
            this.Mount[n5].setState(bl);
            this.Mount[n5].repaint();
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getComponentState")) {
            n5 = 0;
            try {
                n5 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stringArray2 = new String[]{"" + this.Mount[n5].getState()};
        }
        return stringArray2;
    }
}

