/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import com.rinearn.rxg2dlegacyimpl.ProcessDrivenGraph2DWindow;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessEnvironmentProperty;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.process.graph.graph2d.function.Function_addGraph2DData;
import rxvesapi.process.graph.graph2d.function.Function_setGraph2DData;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.system.kernel.cache.VirtualizedIOServer;

public class Graph2DProcessDriver
implements GeneralProcessConnectionInterface,
WindowListener {
    ProcessDrivenGraph2DWindow[] graph;
    public double[][][] vertexX;
    public double[][][] vertexY;
    public ProcessEngine engine;
    public GraphicsProcessDriver graphicsDriver;
    public FunctionCallKernel[] kernel;
    protected int defaultGraphIndex = -1;
    boolean frameEventInited = false;
    private ProcessUnit[] windowArgUnit;
    private FunctionCallUnit[] windowClosingUnit;
    private FunctionCallKernel[] windowClosingKernel;

    public void disposeResource() {
        for (int i = 0; i < this.graph.length; ++i) {
            if (this.graph[i] != null) {
                if (this.graph[i].isDisposable()) {
                    this.graph[i].disposeResource();
                } else {
                    this.graph[i].disposeDriver();
                    this.graph[i].removeWindowListener(this);
                    this.graph[i].setVisible(true);
                }
            }
            this.graph[i] = null;
        }
        this.graph = null;
        this.vertexX = null;
        this.vertexY = null;
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public void format() {
        if (this.graph != null) {
            for (int i = 0; i < this.graph.length; ++i) {
                if (this.graph[i].isDisposable()) {
                    this.graph[i].disposeResource();
                } else {
                    this.graph[i].disposeDriver();
                    this.graph[i].removeWindowListener(this);
                }
                this.graph[i] = null;
            }
            this.graph = null;
        }
        this.graph = new ProcessDrivenGraph2DWindow[1];
        this.vertexX = new double[1][0][0];
        this.vertexY = new double[1][0][0];
        this.createKernel();
    }

    public FunctionCallKernel[] getKernel() {
        return this.kernel;
    }

    public void createKernel() {
        int n = 2;
        int n2 = 0;
        this.kernel = new FunctionCallKernel[n];
        this.kernel[n2] = new Function_setGraph2DData(this);
        this.kernel[++n2] = new Function_addGraph2DData(this);
        ++n2;
    }

    public void setDefaultGraph(ProcessDrivenGraph2DWindow processDrivenGraph2DWindow) {
        this.defaultGraphIndex = this.generateGraph(processDrivenGraph2DWindow);
    }

    public int getDefaultGraph() {
        if (0 <= this.defaultGraphIndex) {
            return this.defaultGraphIndex;
        }
        return this.generateGraph();
    }

    public int generateGraph() {
        return this.generateGraph(new ProcessDrivenGraph2DWindow());
    }

    public int generateGraph(ProcessDrivenGraph2DWindow processDrivenGraph2DWindow) {
        int n = this.graph.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (this.graph[i] != null) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            int n3;
            ProcessDrivenGraph2DWindow[] processDrivenGraph2DWindowArray = new ProcessDrivenGraph2DWindow[n];
            for (n3 = 0; n3 < n; ++n3) {
                processDrivenGraph2DWindowArray[n3] = this.graph[n3];
            }
            this.graph = new ProcessDrivenGraph2DWindow[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.graph[n3] = processDrivenGraph2DWindowArray[n3];
            }
            processDrivenGraph2DWindowArray = null;
            this.vertexX = new double[n * 2][0][0];
            this.vertexY = new double[n * 2][0][0];
            n2 = n;
        }
        this.graph[n2] = processDrivenGraph2DWindow;
        this.graph[n2].graphicsDriver = this.graphicsDriver;
        this.graph[n2].graphID = n2;
        this.graph[n2].addWindowListener(this);
        this.graph[n2].setFirstPlotState(false);
        this.waitFor(n2);
        return n2;
    }

    public void setGraph2DData(int n, int[] nArray, double[] dArray, double[] dArray2) {
        this.waitFor(n);
        if (nArray.length == 1) {
            this.addGraph2DData1D(n, nArray, dArray, dArray2, true);
        } else if (nArray.length == 2) {
            this.addGraph2DData2D(n, nArray, dArray, dArray2, true);
        }
        this.waitFor(n);
    }

    public void addGraph2DData(int n, int[] nArray, double[] dArray, double[] dArray2) {
        this.waitFor(n);
        if (nArray.length == 1) {
            this.addGraph2DData1D(n, nArray, dArray, dArray2, false);
        } else if (nArray.length == 2) {
            this.addGraph2DData2D(n, nArray, dArray, dArray2, false);
        }
        this.waitFor(n);
    }

    public void clearGraph2D(int n) {
        this.waitFor(n);
        int n2 = n;
        if (this.graph[n2] != null) {
            this.graph[n2].format();
            this.graph[n2].repaintGraph();
            this.graph[n2].repaint();
        }
        this.waitFor(n);
    }

    public void addGraph2DData2D(int n, int[] nArray, double[] dArray, double[] dArray2, boolean bl) {
        int n2;
        double[][] dArray3;
        double[][] dArray4;
        this.waitFor(n);
        int n3 = 0;
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (bl) {
            if (n4 != this.vertexX[n].length || 1 > n4 || n5 != this.vertexX[n][0].length || 1 > n5) {
                this.vertexX[n] = new double[n4][n5];
                this.vertexY[n] = new double[n4][n5];
            }
            dArray4 = this.vertexX[n];
            dArray3 = this.vertexY[n];
        } else {
            dArray4 = new double[n4][n5];
            dArray3 = new double[n4][n5];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                n3 = n2 * n5 + i;
                dArray4[n2][i] = dArray[n3];
                dArray3[n2][i] = dArray2[n3];
            }
        }
        if (bl) {
            this.graph[n].format();
        }
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            this.graph[n].addSystem(dArray4[n2], dArray3[n2]);
        }
        this.fitRange(n, dArray4, dArray3, bl);
        this.waitFor(n);
        this.graph[n].repaintGraph();
        this.waitFor(n);
    }

    public void addGraph2DData1D(int n, int[] nArray, double[] dArray, double[] dArray2, boolean bl) {
        double[][] dArray3;
        double[][] dArray4;
        this.waitFor(n);
        int n2 = 0;
        int n3 = nArray[0];
        if (bl) {
            if (1 != this.vertexX[n].length || n3 != this.vertexX[n][0].length) {
                this.vertexX[n] = new double[1][n3];
                this.vertexY[n] = new double[1][n3];
            }
            dArray4 = this.vertexX[n];
            dArray3 = this.vertexY[n];
        } else {
            dArray4 = new double[1][n3];
            dArray3 = new double[1][n3];
        }
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            dArray4[0][i] = dArray[n2];
            dArray3[0][i] = dArray2[n2];
        }
        if (bl) {
            this.graph[n].format();
        }
        this.graph[n].addSystem(dArray4[0], dArray3[0]);
        this.fitRange(n, dArray4, dArray3, bl);
        this.waitFor(n);
        this.graph[n].repaintGraph();
        this.waitFor(n);
    }

    public void fitRange(int n, double[][] dArray, double[][] dArray2, boolean bl) {
        int n2;
        int n3;
        double d;
        double d2;
        this.waitFor(n);
        if (this.graph[n].isAutomaticSetRangeX()) {
            if (bl) {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
            } else {
                d2 = this.graph[n].getXMax();
                d = this.graph[n].getXMin();
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                for (n2 = 0; n2 < dArray[n3].length; ++n2) {
                    if (d2 < dArray[n3][n2]) {
                        d2 = dArray[n3][n2];
                    }
                    if (!(dArray[n3][n2] < d)) continue;
                    d = dArray[n3][n2];
                }
            }
            this.graph[n].setXRange(d2, d);
        }
        if (this.graph[n].isAutomaticSetRangeY()) {
            if (bl) {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
            } else {
                d2 = this.graph[n].getYMax();
                d = this.graph[n].getYMin();
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                for (n2 = 0; n2 < dArray2[n3].length; ++n2) {
                    if (d2 < dArray2[n3][n2]) {
                        d2 = dArray2[n3][n2];
                    }
                    if (!(dArray2[n3][n2] < d)) continue;
                    d = dArray2[n3][n2];
                }
            }
            this.graph[n].setYRange(d2, d);
        }
        this.waitFor(n);
    }

    @Override
    public synchronized boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_START") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_newGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_deleteGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_clearGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_getGraph2DSystemDefaultInstance") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_newGraph2DGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_hideGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_showGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DWindowTitle") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLocation") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DSize") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DFile") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DFiles") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DDataString") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_exportGraph2DData") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DBackgroundColor") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DScaleColor") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DAutoRange") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRange") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRangeX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRangeY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTickX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTickY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabelX") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabelY") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DOption") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DMenu") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTitle") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabel") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLegend") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_exportGraph2D") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_INTERNAL_FLOW_CONTROL_waitForInterruptible") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DAnimation") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DConfigurationFile") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DConfigurationLine") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_END");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        Color color;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_newGraph2D")) {
            n5 = this.generateGraph();
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_deleteGraph2D")) {
            n5 = Integer.parseInt(stringArray[0]);
            if (this.graph[n5] != null) {
                if (this.graph[n5].isDisposable()) {
                    this.graph[n5].disposeResource();
                } else {
                    this.graph[n5].disposeDriver();
                    this.graph[n5].removeWindowListener(this);
                }
            }
            this.graph[n5] = null;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_clearGraph2D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (this.graph[n5] != null) {
                this.graph[n5].format();
            }
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_getGraph2DSystemDefaultInstance")) {
            n5 = this.getDefaultGraph();
            stringArray2 = new String[]{"" + n5};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_newGraph2DGraphics")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = this.graphicsDriver.getAvailableImageIndex();
            this.graphicsDriver.image[n4] = this.graph[n5].getImage();
            this.graph[n5].lastImage = this.graph[n5].getImage();
            this.graph[n5].graphicsDriver = this.graphicsDriver;
            this.graph[n5].imageID = n4;
            this.graph[n5].imageSync = true;
            stringArray2 = new String[]{"" + n4};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_deleteGraph2DGraphics")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            this.graphicsDriver.image[n4] = null;
            this.graph[n5].graphicsDriver = null;
            this.graph[n5].imageID = -1;
            this.graph[n5].imageSync = false;
            stringArray2 = new String[]{""};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_hideGraph2D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setVisible(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_showGraph2D")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setVisible(true);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DWindowTitle")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setTitle(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLocation")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            n3 = Integer.parseInt(stringArray[2]);
            n2 = (int)this.graph[n5].getBounds().getWidth();
            n = (int)this.graph[n5].getBounds().getHeight();
            this.graph[n5].setBounds(n4, n3, n2, n);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DSize")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            n4 = Integer.parseInt(stringArray[1]);
            n3 = Integer.parseInt(stringArray[2]);
            n2 = (int)this.graph[n5].getBounds().getX();
            n = (int)this.graph[n5].getBounds().getY();
            this.graph[n5].setBounds(n2, n, n4, n3);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DFile")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string2 = stringArray[1];
            File file = this.engine.getResourceFile(string2);
            if (ProcessEnvironmentProperty.isOnline()) {
                String string3 = file.getPath();
                String string4 = VirtualizedIOServer.getInstance().getFileContent(string3);
                this.graph[n5].plotVertexString(string4, string3);
            } else {
                string2 = file.getPath();
                this.graph[n5].plotFile(string2);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DFiles")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String[] stringArray3 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringArray3[i] = stringArray[i + 1];
                File file = this.engine.getResourceFile(stringArray3[i]);
                stringArray3[i] = file.getPath();
            }
            if (ProcessEnvironmentProperty.isOnline()) {
                String string5 = System.getProperty("line.separator");
                String string6 = VirtualizedIOServer.getInstance().getFileContentsSeparatedByBlankLines(stringArray3, string5);
                this.graph[n5].plotVertexString(string6, "");
            } else {
                this.graph[n5].plotFile(stringArray3);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DConfigurationFile")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string7 = stringArray[1];
            File file = this.engine.getResourceFile(string7);
            string7 = file.getPath();
            try {
                this.graph[n5].loadConfigurationFile(string7);
                stringArray2 = new String[]{"true"};
            }
            catch (IOException iOException) {
                stringArray2 = new String[]{"false"};
            }
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DConfigurationLine")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string8 = stringArray[1];
            this.graph[n5].setConfigurationLine(string8);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_exportGraph2DData")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string9 = stringArray[1];
            File file = this.engine.getResourceFile(string9);
            string9 = file.getPath();
            try {
                this.graph[n5].exportData(string9, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_exportGraph2D")) {
            n5 = Integer.parseInt(stringArray[0]);
            String string10 = stringArray[1];
            String string11 = stringArray[2].toLowerCase();
            if (string11.equals("png") && !string10.endsWith(".png")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u62e1\u5f35\u5b50\u304c\u3001\u6307\u5b9a\u3055\u308c\u305f\u5f62\u5f0f\u3068\u6574\u5408\u3057\u307e\u305b\u3093\u3002");
                } else {
                    this.engine.error("The extension of the specified file name does not match with the specified file format.");
                }
                this.engine.exit();
            }
            if ((string11.equals("jpg") || string11.equals("jpeg")) && !string10.endsWith(".jpg") && !string10.endsWith(".jpeg")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u62e1\u5f35\u5b50\u304c\u3001\u6307\u5b9a\u3055\u308c\u305f\u5f62\u5f0f\u3068\u6574\u5408\u3057\u307e\u305b\u3093\u3002");
                } else {
                    this.engine.error("The extension of the specified file name does not match with the specified file format.");
                }
                this.engine.exit();
            }
            File file = this.engine.getResourceFile(string10);
            if (!this.engine.getSecurity().request_WRITE_FILE(string10)) {
                this.engine.exit();
                return new String[]{"false"};
            }
            if (file.exists() && !this.engine.getSecurity().request_OVERWRITE_FILE(string10)) {
                this.engine.exit();
                return new String[]{"false"};
            }
            if (this.graph[n5].imageSavePathField == null) {
                this.graph[n5].launchSaveMenuWindow();
                this.graph[n5].saveMenuWindow.setVisible(false);
            }
            this.graph[n5].saveFormatChoice.setSelectedItem(stringArray[2]);
            this.graph[n5].imageQualityField.setText(stringArray[3]);
            boolean bl = false;
            this.graph[n5].waitForInterruptable();
            this.graph[n5].save(this.graph[n5].graphImage, string10, file.getParentFile().getAbsolutePath(), bl);
            this.graph[n5].waitForInterruptable();
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_INTERNAL_FLOW_CONTROL_waitForInterruptible")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.graph[n5].waitForInterruptable();
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DDataString")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string12 = stringArray[1];
            this.graph[n5].plotVertexString(string12, "");
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DBackgroundColor")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            int n6 = Integer.parseInt(stringArray[1]);
            int n7 = Integer.parseInt(stringArray[2]);
            int n8 = Integer.parseInt(stringArray[3]);
            int n9 = Integer.parseInt(stringArray[4]);
            color = new Color(n6, n7, n8, n9);
            this.graph[n5].setGraphBackgroundColor(color);
            this.graph[n5].setGrayScreenState(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DScaleColor")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            int n10 = Integer.parseInt(stringArray[1]);
            int n11 = Integer.parseInt(stringArray[2]);
            int n12 = Integer.parseInt(stringArray[3]);
            int n13 = Integer.parseInt(stringArray[4]);
            color = new Color(n10, n11, n12, n13);
            this.graph[n5].setGraphScaleColor(color);
            this.graph[n5].setGrayScreenState(false);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DAutoRange")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (stringArray[1].equals("true")) {
                this.graph[n5].setAutomaticSetRangeX(true);
            } else {
                this.graph[n5].setAutomaticSetRangeX(false);
            }
            if (stringArray[2].equals("true")) {
                this.graph[n5].setAutomaticSetRangeY(true);
            } else {
                this.graph[n5].setAutomaticSetRangeY(false);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRange")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d2 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setXRange(d, d2);
            d = Double.parseDouble(stringArray[3]);
            d2 = Double.parseDouble(stringArray[4]);
            this.graph[n5].setYRange(d, d2);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRangeX")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setXRange(d, d3);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DRangeY")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            double d = Double.parseDouble(stringArray[1]);
            double d4 = Double.parseDouble(stringArray[2]);
            this.graph[n5].setYRange(d, d4);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTickX")) {
            int n14;
            n5 = Integer.parseInt(stringArray[0]);
            int n15 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n15];
            String[] stringArray4 = new String[n15];
            int n16 = 2;
            for (n14 = 0; n14 < n15; ++n14) {
                dArray[n14] = Double.parseDouble(stringArray[n16]);
                ++n16;
            }
            for (n14 = 0; n14 < n15; ++n14) {
                stringArray4[n14] = stringArray[n16];
                ++n16;
            }
            this.waitFor(n5);
            this.graph[n5].setXTicks(dArray, stringArray4);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTickY")) {
            int n17;
            n5 = Integer.parseInt(stringArray[0]);
            int n18 = Integer.parseInt(stringArray[1]);
            double[] dArray = new double[n18];
            String[] stringArray5 = new String[n18];
            int n19 = 2;
            for (n17 = 0; n17 < n18; ++n17) {
                dArray[n17] = Double.parseDouble(stringArray[n19]);
                ++n19;
            }
            for (n17 = 0; n17 < n18; ++n17) {
                stringArray5[n17] = stringArray[n19];
                ++n19;
            }
            this.waitFor(n5);
            this.graph[n5].setYTicks(dArray, stringArray5);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabelX")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setXName(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabelY")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setYName(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DOption")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string13 = stringArray[1];
            boolean bl = false;
            if (stringArray[2].equals("true")) {
                bl = true;
            }
            if (string13.equals("WITH_POINTS") || string13.equals("POINT")) {
                this.graph[n5].setWithPointsState(bl);
            }
            if (string13.equals("WITH_LINES") || string13.equals("LINE")) {
                this.graph[n5].setWithLinesState(bl);
            }
            if (string13.equals("WITH_DOTS") || string13.equals("DOT")) {
                this.graph[n5].setWithDotsState(bl);
            }
            if (string13.equals("GRID") || string13.equals("GRID_LINE") || string13.equals("WITH_GRID_LINE")) {
                this.graph[n5].withGridLineBox.setState(bl);
            }
            if (string13.equals("ZERO_LINE") || string13.equals("WITH_ZERO_LINE")) {
                this.graph[n5].withZeroLineBox.setState(bl);
            }
            if (string13.equals("LOG_X")) {
                this.graph[n5].setXLogState(bl);
            }
            if (string13.equals("LOG_Y")) {
                this.graph[n5].setYLogState(bl);
            }
            if (string13.equals("REVERSE_X")) {
                // empty if block
            }
            if (string13.equals("REVERSE_Y")) {
                // empty if block
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DMenu")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String string14 = stringArray[1];
            if (string14.equals("SET_LABEL_X") || string14.equals("SET_X_LABEL")) {
                this.graph[n5].setXName(stringArray[2]);
            }
            if (string14.equals("SET_LABEL_Y") || string14.equals("SET_Y_LABEL")) {
                this.graph[n5].setYName(stringArray[2]);
            }
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DTitle")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setGraphTitle(stringArray[1]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLabel")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            this.graph[n5].setXName(stringArray[1]);
            this.graph[n5].setYName(stringArray[2]);
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DLegend")) {
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            String[] stringArray6 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray6.length; ++i) {
                stringArray6[i] = stringArray[i + 1];
            }
            this.graph[n5].setGraphLegend(stringArray6);
            this.graph[n5].repaintGraph();
            stringArray2 = new String[]{"true"};
            this.waitFor(n5);
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPH2D_setGraph2DAnimation")) {
            stringArray[0] = stringArray[0].replaceAll("INDEX", "INDEX-POINT");
            stringArray[0] = stringArray[0].replaceAll("SERIES_INDEX", "INDEX-SERIES");
            stringArray[0] = stringArray[0].replaceAll("SERIES-INDEX", "INDEX-SERIES");
            n5 = Integer.parseInt(stringArray[0]);
            this.waitFor(n5);
            if (stringArray[2].equals("true")) {
                this.graph[n5].setAnimationState(true);
                this.graph[n5].setAnimationMode(stringArray[1]);
            } else {
                this.graph[n5].setAnimationState(false);
            }
            this.waitFor(n5);
        }
        return stringArray2;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        try {
            Object object = windowEvent.getSource();
            ProcessDrivenGraph2DWindow processDrivenGraph2DWindow = (ProcessDrivenGraph2DWindow)object;
            int n = processDrivenGraph2DWindow.graphID;
            this.waitFor(n);
            this.frameEventInit();
            if (this.windowClosingKernel != null) {
                this.windowArgUnit[0].setIntegerValue(n);
                for (int i = 0; i < this.windowClosingKernel.length; ++i) {
                    try {
                        this.windowClosingUnit[i].process();
                        continue;
                    }
                    catch (ProcessRuntimeException processRuntimeException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    void frameEventInit() {
        if (!this.frameEventInited) {
            this.windowArgUnit = new ProcessUnit[1];
            this.windowArgUnit[0] = new IntegerUnit(-1L, this.engine);
            this.windowClosingKernel = this.engine.getAllFunctionCallKernel("onGraph2DClose");
            if (this.windowClosingKernel != null) {
                this.windowClosingUnit = new FunctionCallUnit[this.windowClosingKernel.length];
                for (int i = 0; i < this.windowClosingKernel.length; ++i) {
                    this.windowClosingUnit[i] = new FunctionCallUnit(this.windowArgUnit, this.windowClosingKernel[i], this.engine);
                    this.windowClosingUnit[i].setProcessKernel(this.windowClosingKernel[i]);
                }
            }
            this.frameEventInited = true;
        }
    }

    public void waitFor(int n) {
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
        while (!this.graph[n].isInterruptible()) {
            this.engine.sleep(10);
        }
    }
}

