/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import com.rinearn.rxg2dlegacyimpl.Graph2DWindow;
import com.rinearn.rxg3dlegacyimpl.Graph3DWindow;
import java.io.File;
import java.io.IOException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;

public class GraphProcessDriver
implements GeneralProcessConnectionInterface {
    int[] mode;
    Graph3DWindow[] graph3d;
    Graph2DWindow[] graph2d;
    public ProcessEngine engine;
    public static int GRAPH3D = 100;
    public static int GRAPH2D = 101;

    public void disposeResource() {
        if (this.mode != null) {
            int n = this.mode.length;
            for (int i = 0; i < n; ++i) {
                this.graph3d[i] = null;
                this.graph2d[i] = null;
            }
        }
        this.graph3d = null;
        this.graph2d = null;
        this.mode = null;
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("graph3DOpen") || string.equals("graph3DPlotFile") || string.equals("graph3DPlotString") || string.equals("graph3DAutoRange") || string.equals("graph3DSetRange") || string.equals("graph3DOption") || string.equals("graph3DEdit") || string.equals("graph3DClose") || string.equals("graph2DOpen") || string.equals("graph2DPlotFile") || string.equals("graph2DPlotString") || string.equals("graph2DAutoRange") || string.equals("graph2DSetRange") || string.equals("graph2DOption") || string.equals("graph2DEdit") || string.equals("graph2DClose");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        File file;
        String string2;
        int n;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("graph3DOpen")) {
            n = Integer.parseInt(stringArray[0]);
            this.setStreamCapacity(n);
            this.graph3d[n] = new Graph3DWindow();
            this.graph3d[n].setDefaultCloseOperation(2);
            this.mode[n] = GRAPH3D;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DOpen")) {
            n = Integer.parseInt(stringArray[0]);
            this.setStreamCapacity(n);
            this.graph2d[n] = new Graph2DWindow();
            this.graph2d[n].setDefaultCloseOperation(2);
            this.mode[n] = GRAPH2D;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DPlotFile")) {
            n = Integer.parseInt(stringArray[0]);
            string2 = stringArray[1];
            file = this.engine.getResourceFile(string2);
            string2 = file.getPath();
            try {
                this.graph3d[n].plotFile(string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DPlotFile")) {
            n = Integer.parseInt(stringArray[0]);
            string2 = stringArray[1];
            file = this.engine.getResourceFile(string2);
            string2 = file.getPath();
            this.graph2d[n].plotFile(string2);
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DPlotString")) {
            n = Integer.parseInt(stringArray[0]);
            string2 = stringArray[1];
            this.graph3d[n].plotVertexString_steals(string2);
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DPlotString")) {
            n = Integer.parseInt(stringArray[0]);
            string2 = stringArray[1];
            this.graph2d[n].plotVertexString(string2, "");
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DClose")) {
            n = Integer.parseInt(stringArray[0]);
            this.graph3d[n].setVisible(false);
            this.graph3d[n].stop();
            this.graph3d[n] = null;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DClose")) {
            n = Integer.parseInt(stringArray[0]);
            this.graph2d[n].setVisible(false);
            this.graph2d[n].stop();
            this.graph2d[n] = null;
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DAutoRange")) {
            n = Integer.parseInt(stringArray[0]);
            if (stringArray[0].equals("true")) {
                this.graph3d[n].setAutomaticSetRange(true);
            } else {
                this.graph3d[n].setAutomaticSetRange(false);
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DAutoRange")) {
            n = Integer.parseInt(stringArray[0]);
            if (stringArray[0].equals("true")) {
                this.graph2d[n].setAutomaticSetRange(true);
            } else {
                this.graph2d[n].setAutomaticSetRange(false);
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DSetRange")) {
            n = Integer.parseInt(stringArray[0]);
            double d = Double.parseDouble(stringArray[1]);
            double d2 = Double.parseDouble(stringArray[2]);
            this.graph3d[n].setXRange(d, d2);
            d = Double.parseDouble(stringArray[3]);
            d2 = Double.parseDouble(stringArray[4]);
            this.graph3d[n].setYRange(d, d2);
            d = Double.parseDouble(stringArray[5]);
            d2 = Double.parseDouble(stringArray[6]);
            this.graph3d[n].setZRange(d, d2);
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DSetRange")) {
            n = Integer.parseInt(stringArray[0]);
            double d = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            this.graph2d[n].setXRange(d, d3);
            d = Double.parseDouble(stringArray[3]);
            d3 = Double.parseDouble(stringArray[4]);
            this.graph2d[n].setYRange(d, d3);
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DOption")) {
            n = Integer.parseInt(stringArray[0]);
            String string3 = stringArray[1];
            boolean bl = false;
            if (stringArray[2].equals("true")) {
                bl = true;
            }
            if (string3.equals("WITH_DOTS")) {
                this.graph2d[n].setWithDotsState(bl);
            }
            if (string3.equals("WITH_POINTS")) {
                this.graph2d[n].setWithPointsState(bl);
            }
            if (string3.equals("WITH_LINES")) {
                this.graph2d[n].setWithLinesState(bl);
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DOption")) {
            n = Integer.parseInt(stringArray[0]);
            String string4 = stringArray[1];
            boolean bl = false;
            if (stringArray[2].equals("true")) {
                bl = true;
            }
            if (string4.equals("WITH_MEMBRANES")) {
                this.graph3d[n].setWithMembranesState(bl);
            }
            if (string4.equals("WITH_MESHES")) {
                this.graph3d[n].setWithMeshesState(bl);
            }
            if (string4.equals("WITH_POINTS")) {
                this.graph3d[n].setWithPointsState(bl);
            }
            if (string4.equals("WITH_LINES")) {
                this.graph3d[n].setWithLinesState(bl);
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph2DEdit")) {
            n = Integer.parseInt(stringArray[0]);
            String string5 = stringArray[1];
            if (string5.equals("SET_X_LABEL")) {
                this.graph2d[n].setXName(stringArray[2]);
            }
            if (string5.equals("SET_Y_LABEL")) {
                this.graph2d[n].setYName(stringArray[2]);
            }
            if (string5.equals("SET_TITLE")) {
                this.graph2d[n].setGraphTitle(stringArray[2]);
            }
            stringArray2 = new String[]{"true"};
        }
        if (string.equals("graph3DEdit")) {
            n = Integer.parseInt(stringArray[0]);
            String string6 = stringArray[1];
            if (string6.equals("SET_X_LABEL")) {
                this.graph3d[n].setXName(stringArray[2]);
            }
            if (string6.equals("SET_Y_LABEL")) {
                this.graph3d[n].setYName(stringArray[2]);
            }
            if (string6.equals("SET_Z_LABEL")) {
                this.graph3d[n].setZName(stringArray[2]);
            }
            stringArray2 = new String[]{"true"};
        }
        return stringArray2;
    }

    private void setStreamCapacity(int n) {
        int n2;
        ++n;
        if (this.mode == null) {
            this.graph3d = new Graph3DWindow[n];
            this.graph2d = new Graph2DWindow[n];
            this.mode = new int[n];
        }
        if ((n2 = this.mode.length) < n) {
            int n3;
            Graph3DWindow[] graph3DWindowArray = new Graph3DWindow[n2];
            Graph2DWindow[] graph2DWindowArray = new Graph2DWindow[n2];
            int[] nArray = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                graph3DWindowArray[n3] = this.graph3d[n3];
                graph2DWindowArray[n3] = this.graph2d[n3];
                nArray[n3] = this.mode[n3];
            }
            this.graph3d = new Graph3DWindow[n];
            this.graph2d = new Graph2DWindow[n];
            this.mode = new int[n];
            for (n3 = 0; n3 < n2; ++n3) {
                this.graph3d[n3] = graph3DWindowArray[n3];
                this.graph2d[n3] = graph2DWindowArray[n3];
                this.mode[n3] = nArray[n3];
            }
        }
    }
}

