/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFrame;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;

public class GraphicsProcessDriver
implements GeneralProcessConnectionInterface {
    public ProcessEngine engine;
    public Image[] image = new Image[1];
    public JFrame frame;
    private MediaTracker tracker;
    private BufferedImage dummyImage = new BufferedImage(1, 1, 5);

    public void createFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.setBounds(0, 0, 100, 100);
            this.frame.setVisible(true);
            this.frame.setBackground(Color.blue);
            this.frame.setVisible(false);
        }
    }

    @Override
    public void init() {
        this.format();
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        if (this.image != null) {
            for (int i = 0; i < this.image.length; ++i) {
                if (this.image[i] == null) continue;
                try {
                    this.image[i].flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.image[i] = null;
            }
        }
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
        this.image = null;
        this.dummyImage = null;
    }

    public void format() {
        if (this.image != null) {
            for (int i = 0; i < this.image.length; ++i) {
                if (this.image[i] == null) continue;
                this.image[i] = null;
            }
        }
        this.image = new Image[1];
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_START") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_loadGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_disposeGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createResizedGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getGraphicsWidth") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getGraphicsHeight") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_exportGraphics") || string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_END");
    }

    public void expandImage() {
        int n;
        int n2 = this.image.length;
        int n3 = this.image.length * 2;
        Image[] imageArray = new Image[n2];
        for (n = 0; n < n2; ++n) {
            imageArray[n] = this.image[n];
        }
        this.image = new Image[n3];
        for (n = 0; n < n2; ++n) {
            this.image[n] = imageArray[n];
        }
        imageArray = null;
    }

    public int getAvailableImageIndex() {
        int n;
        int n2 = -1;
        for (n = 0; n < this.image.length; ++n) {
            if (this.image[n] != null) continue;
            n2 = n;
        }
        if (n2 < 0) {
            this.expandImage();
            for (n = 0; n < this.image.length; ++n) {
                if (this.image[n] != null) continue;
                n2 = n;
            }
        }
        return n2;
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        int n;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_loadGraphics")) {
            if (!this.engine.getSecurity().request_READ_FILE(stringArray[0])) {
                this.engine.exit();
                return new String[]{""};
            }
            n = this.loadImage(stringArray[0]);
            stringArray2 = new String[]{"" + n};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createGraphics")) {
            n = this.getAvailableImageIndex();
            this.image[n] = this.dummyImage;
            stringArray2 = new String[]{"" + n};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_createResizedGraphics")) {
            n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n3 = Integer.parseInt(stringArray[2]);
                n4 = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n5 = this.getAvailableImageIndex();
            this.image[n5] = n4 == 0 ? this.image[n].getScaledInstance(n2, n3, 2) : (n4 == 1 ? this.image[n].getScaledInstance(n2, n3, 1) : (n4 == 2 ? this.image[n].getScaledInstance(n2, n3, 4) : null));
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(this.image[n5], 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_disposeGraphics")) {
            n = -1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.disposeImage(n);
            stringArray2 = new String[]{""};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getGraphicsWidth")) {
            n = 1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n6 = this.image[n].getWidth(null);
            stringArray2 = new String[]{"" + n6};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_getGraphicsHeight")) {
            n = 1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n7 = this.image[n].getHeight(null);
            stringArray2 = new String[]{"" + n7};
        }
        if (string.equals("SYSTEM_PROCESS_DRIVER_GRAPHICS_exportGraphics")) {
            n = 1;
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double d = 100.0;
            if (stringArray.length == 4) {
                try {
                    d = Double.parseDouble(stringArray[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.save(this.image[n], stringArray[1], stringArray[2], d);
            stringArray2 = new String[]{""};
        }
        return stringArray2;
    }

    public void save(Image image, String string, String string2, double d) {
        block15: {
            if (!this.engine.getSecurity().request_WRITE_FILE(string)) {
                this.engine.exit();
                return;
            }
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            BufferedImage bufferedImage = null;
            bufferedImage = string2.equals("PNG") ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            boolean bl = true;
            File file = this.engine.getResourceFile(string);
            if (file.exists() && !this.engine.getSecurity().request_OVERWRITE_FILE(string)) {
                this.engine.exit();
                return;
            }
            string = file.getName();
            if (!(file = new File(file.getParent())).exists()) {
                return;
            }
            File file2 = new File(file, string);
            string = file2.toString();
            if (bl) {
                try {
                    if (string2 == null) break block15;
                    if (string2.equals("JPEG")) {
                        float f = 1.0f;
                        try {
                            f = (float)(d / 100.0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
                        ImageWriter imageWriter = iterator.next();
                        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
                        imageWriter.setOutput(imageOutputStream);
                        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                        if (imageWriteParam.canWriteCompressed()) {
                            imageWriteParam.setCompressionMode(2);
                            imageWriteParam.setCompressionQuality(f);
                            imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                            imageWriter.dispose();
                            imageOutputStream.close();
                            imageOutputStream = null;
                            return;
                        }
                    }
                    if (string2.equals("JPEG")) {
                        ImageIO.write((RenderedImage)bufferedImage, "jpeg", new File(string));
                    } else if (string2.equals("BMP")) {
                        ImageIO.write((RenderedImage)bufferedImage, "bmp", new File(string));
                    } else if (string2.equals("PNG")) {
                        ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public Image createImage(int n, int n2) {
        this.createFrame();
        return this.frame.createImage(n, n2);
    }

    public int loadImage(String string) {
        int n;
        int n2 = -1;
        boolean bl = true;
        for (n = 0; n < this.image.length; ++n) {
            if (this.image[n] != null) continue;
            n2 = n;
            bl = false;
        }
        if (bl) {
            int n3;
            n = this.image.length;
            int n4 = this.image.length * 2;
            Image[] imageArray = new Image[n];
            for (n3 = 0; n3 < n; ++n3) {
                imageArray[n3] = this.image[n3];
            }
            this.image = new Image[n4];
            for (n3 = 0; n3 < n; ++n3) {
                this.image[n3] = imageArray[n3];
            }
            imageArray = null;
            n2 = n;
        }
        URL uRL = this.engine.getResourceURL(string);
        this.image[n2] = Toolkit.getDefaultToolkit().createImage(uRL);
        this.createFrame();
        this.tracker = new MediaTracker(this.frame);
        this.tracker.addImage(this.image[n2], 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return n2;
    }

    public void disposeImage(int n) {
        this.image[n] = null;
    }
}

