/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import rxvesapi.process.driver.GraphicsProcessDriver;
import rxvesapi.process.graphics.graphics2d.layer.Graphics2DProcessLayer;

public class Graphics2DProcessEngine {
    GraphicsProcessDriver driver;
    public Image image;
    public int id;
    public int imageID;
    public Graphics2D graphics;
    private BufferedImage bufferedImage;
    private int[] pixel;
    private int[] priorityList;
    private double[] zList;
    Color backgroundColor = Color.white;
    Color drawColor;
    Font font;
    FontMetrics fontMetrics;
    boolean bold;
    boolean italic;
    int red = -1;
    int green = -1;
    int blue = -1;
    int alpha = -1;
    int bgRed = 0;
    int bgGreen = 0;
    int bgBlue = 0;
    int bgAlpha = 0;
    public int width;
    public int height;
    int bufferedWidth;
    int bufferedHeight;
    private String lineFeedCode;
    private Graphics2DProcessLayer[] layer;
    int layerRegistered = 0;

    public Graphics2DProcessEngine() {
    }

    public Graphics2DProcessEngine(GraphicsProcessDriver graphicsProcessDriver) {
        this.driver = graphicsProcessDriver;
        this.init();
        this.font = new Font("Dialog", 0, 10);
    }

    public synchronized void init() {
        this.layer = new Graphics2DProcessLayer[1];
        this.layerRegistered = 1;
        this.priorityList = new int[1];
        this.zList = new double[1];
        this.lineFeedCode = System.getProperty("line.separator");
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        if (this.graphics != null) {
            this.fontMetrics = this.graphics.getFontMetrics(this.font);
            this.graphics.setFont(this.font);
        }
    }

    public synchronized void setFontSize(int n) {
        int n2 = this.font.getSize();
        String string = this.font.getName();
        int n3 = this.font.getStyle();
        Font font = new Font(string, n3, n);
        this.setFont(font);
    }

    public synchronized void setFontName(String string) {
        int n = this.font.getSize();
        String string2 = this.font.getName();
        int n2 = this.font.getStyle();
        string2 = string;
        Font font = new Font(string2, n2, n);
        this.setFont(font);
    }

    public synchronized void setFontBold(boolean bl) {
        int n = this.font.getSize();
        String string = this.font.getName();
        int n2 = this.font.getStyle();
        this.bold = bl;
        n2 = this.italic ? 2 : (this.bold ? 1 : 0);
        Font font = new Font(string, n2, n);
        this.setFont(font);
    }

    public synchronized void setFontItalic(boolean bl) {
        int n = this.font.getSize();
        String string = this.font.getName();
        int n2 = this.font.getStyle();
        this.italic = bl;
        n2 = this.italic ? 2 : (this.bold ? 1 : 0);
        Font font = new Font(string, n2, n);
        this.setFont(font);
    }

    public synchronized void setPriority() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.layer.length; ++n2) {
            this.priorityList[n2] = n2;
            this.zList[n2] = this.layer[n2] == null ? 0.0 : this.layer[n2].z;
        }
        n2 = this.layer.length * 10 / 13;
        int n3 = 0;
        int n4 = 0;
        while (n2 > 1) {
            n = 0;
            while (n + n2 < this.layer.length) {
                if (this.zList[this.priorityList[n]] < this.zList[this.priorityList[n + n2]]) {
                    n4 = this.priorityList[n];
                    this.priorityList[n] = this.priorityList[n + n2];
                    this.priorityList[n + n2] = n4;
                }
                ++n;
            }
            n2 = n2 * 10 / 13;
        }
        do {
            n3 = 0;
            n = 0;
            while (n + 1 < this.layer.length) {
                if (this.zList[this.priorityList[n]] < this.zList[this.priorityList[n + 1]]) {
                    n4 = this.priorityList[n];
                    this.priorityList[n] = this.priorityList[n + 1];
                    this.priorityList[n + 1] = n4;
                    ++n3;
                }
                ++n;
            }
        } while (n3 != 0);
    }

    public synchronized void repaint2D() {
        this.clearCanvas();
        this.setPriority();
        for (int i = 0; i < this.layer.length; ++i) {
            if (this.layer[this.priorityList[i]] == null) continue;
            this.layer[this.priorityList[i]].paint(this.graphics);
        }
    }

    public synchronized void addLayer(Graphics2DProcessLayer graphics2DProcessLayer) {
        int n;
        int n2 = this.layer.length;
        for (int i = 0; i < n2; ++i) {
            if (this.layer[i] != null) continue;
            this.layer[i] = graphics2DProcessLayer;
            return;
        }
        Graphics2DProcessLayer[] graphics2DProcessLayerArray = new Graphics2DProcessLayer[n2];
        for (n = 0; n < n2; ++n) {
            graphics2DProcessLayerArray[n] = this.layer[n];
        }
        this.layer = new Graphics2DProcessLayer[n2 * 2];
        for (n = 0; n < n2; ++n) {
            this.layer[n] = graphics2DProcessLayerArray[n];
        }
        this.priorityList = new int[n2 * 2];
        this.zList = new double[n2 * 2];
        this.layer[n2] = graphics2DProcessLayer;
        ++this.layerRegistered;
    }

    public synchronized void removeLayer(Graphics2DProcessLayer graphics2DProcessLayer) {
        for (int i = 0; i < this.layer.length; ++i) {
            if (this.layer[i] != graphics2DProcessLayer) continue;
            this.layer[i] = null;
        }
    }

    public synchronized void removeAllLayer() {
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i] = null;
        }
        this.layer = new Graphics2DProcessLayer[0];
    }

    public synchronized void disposeResource() {
        this.image = null;
        this.driver = null;
        this.pixel = null;
        this.drawColor = null;
        this.backgroundColor = null;
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        if (this.bufferedImage != null) {
            this.bufferedImage = null;
        }
    }

    public synchronized Image getCanvasImage() {
        return this.image;
    }

    public synchronized void setCanvasSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        Graphics2D graphics2D = this.graphics;
        Image image = this.image;
        this.bufferedImage = new BufferedImage(n, n2, 2);
        this.image = this.bufferedImage;
        this.graphics = (Graphics2D)this.image.getGraphics();
        if (graphics2D != null) {
            graphics2D.dispose();
            graphics2D = null;
        }
        if (image != null) {
            try {
                this.graphics.drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        image = null;
        if (this.font != null) {
            this.fontMetrics = this.graphics.getFontMetrics(this.font);
            this.graphics.setFont(this.font);
        }
        this.bufferedWidth = -1;
        this.bufferedHeight = -1;
    }

    public synchronized void setColor(int n, int n2, int n3, int n4) {
        if (this.red == n && this.green == n2 && this.blue == n3 && this.alpha == n4) {
            this.graphics.setColor(this.drawColor);
            return;
        }
        this.drawColor = new Color(n, n2, n3, n4);
        this.graphics.setColor(this.drawColor);
        this.red = n;
        this.green = n2;
        this.blue = n3;
        this.alpha = n4;
    }

    public synchronized void setBackground(int n, int n2, int n3, int n4) {
        if (this.bgRed == n && this.bgGreen == n2 && this.bgBlue == n3 && this.bgAlpha == n4) {
            return;
        }
        this.backgroundColor = new Color(n, n2, n3, n4);
        this.bgRed = n;
        this.bgGreen = n2;
        this.bgBlue = n3;
        this.bgAlpha = n4;
    }

    private synchronized void setBuffer() {
        if (this.pixel == null || this.width != this.bufferedWidth || this.height != this.bufferedHeight) {
            this.pixel = new int[this.width * this.height];
            this.bufferedWidth = this.width;
            this.bufferedHeight = this.width;
        }
    }

    public synchronized void setPixel(short[][] sArray, short[][] sArray2, short[][] sArray3, short[][] sArray4) {
        int n = sArray.length;
        int n2 = sArray[0].length;
        if (n != this.width || n2 != this.height) {
            this.setCanvasSize(n, n2);
            this.bufferedWidth = -1;
            this.bufferedHeight = -1;
        }
        int n3 = this.bufferedImage.getWidth();
        int n4 = this.bufferedImage.getHeight();
        if (this.pixel == null || this.pixel.length != n3 * n4) {
            this.pixel = new int[n3 * n4];
            this.bufferedWidth = n3;
            this.bufferedHeight = n4;
        }
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                n5 = i + j * n3;
                this.pixel[n5] = sArray4[i][j] * 256 * 256 * 256 + sArray[i][j] * 256 * 256 + sArray2[i][j] * 256 + sArray3[i][j];
            }
        }
        this.bufferedImage.getRaster().setDataElements(0, 0, n3, n4, this.pixel);
    }

    public synchronized int[] getPixel() {
        int n = 4 * this.width * this.height;
        int[] nArray = new int[n];
        try {
            boolean bl = false;
            boolean bl2 = false;
            nArray = this.bufferedImage.getRaster().getPixels(0, 0, this.width, this.height, nArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    public synchronized void clearCanvas() {
        this.graphics.setBackground(new Color(this.bgRed, this.bgGreen, this.bgBlue, this.bgAlpha));
        this.graphics.clearRect(0, 0, this.width, this.height);
    }

    public synchronized void drawLine(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.drawColor);
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public synchronized void drawLine(int n, int n2, int n3, int n4, int n5) {
        this.graphics.setColor(this.drawColor);
        BasicStroke basicStroke = new BasicStroke(n5, 0, 0);
        this.graphics.setStroke(basicStroke);
        this.graphics.draw(new Line2D.Double(n, n2, n3, n4));
        this.graphics.setStroke(new BasicStroke());
    }

    public synchronized void drawPolyline(int[] nArray, int[] nArray2) {
        this.graphics.setColor(this.drawColor);
        this.graphics.drawPolyline(nArray, nArray2, nArray.length);
    }

    public synchronized void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.graphics.setColor(this.drawColor);
        BasicStroke basicStroke = new BasicStroke(n, 0, 0);
        this.graphics.setStroke(basicStroke);
        GeneralPath generalPath = new GeneralPath();
        int n2 = nArray.length;
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n2; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        this.graphics.draw(generalPath);
        this.graphics.setStroke(new BasicStroke());
    }

    public synchronized void drawRect(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.drawColor);
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public synchronized void fillRect(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.drawColor);
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public synchronized void drawOval(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.drawColor);
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public synchronized void fillOval(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.drawColor);
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public synchronized void drawPolygon(int[] nArray, int[] nArray2) {
        this.graphics.setColor(this.drawColor);
        this.graphics.drawPolygon(nArray, nArray2, nArray.length);
    }

    public synchronized void fillPolygon(int[] nArray, int[] nArray2) {
        this.graphics.setColor(this.drawColor);
        this.graphics.fillPolygon(nArray, nArray2, nArray.length);
    }

    public synchronized void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.setColor(this.drawColor);
        BasicStroke basicStroke = new BasicStroke(n, 0, 0);
        this.graphics.setStroke(basicStroke);
        GeneralPath generalPath = new GeneralPath();
        int n2 = nArray.length;
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n2; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        generalPath.closePath();
        this.graphics.draw(generalPath);
        this.graphics.setStroke(new BasicStroke());
    }

    public synchronized void drawString(String string, int n, int n2, int n3, int n4) {
        int n5;
        this.graphics.setFont(this.font);
        this.fontMetrics = this.graphics.getFontMetrics(this.font);
        String[] stringArray = string.split(this.lineFeedCode);
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            stringArrayArray[n5] = this.getLines(stringArray[n5], n3);
        }
        n5 = n2;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            for (int j = 0; j < stringArrayArray[i].length; ++j) {
                this.drawString(stringArrayArray[i][j], n, n5);
                n5 += n4;
            }
        }
    }

    public synchronized void drawString(String string, int n, int n2) {
        this.graphics.setFont(this.font);
        this.graphics.drawString(string, n, n2);
    }

    public synchronized void drawGraphics(int n, int n2, int n3) {
        Image image = this.driver.image[n];
        this.graphics.drawImage(image, n2, n3, null);
    }

    public synchronized void drawGraphics(int n, int n2, int n3, int n4, int n5) {
        Image image = this.driver.image[n];
        this.graphics.drawImage(image, n2, n3, n4, n5, null);
    }

    public synchronized void drawGraphics(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Image image = this.driver.image[n];
        this.graphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null);
    }

    private synchronized String[] getLines(String string, int n) {
        char[] cArray = string.toCharArray();
        int n2 = this.fontMetrics.stringWidth(string);
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n < n5) {
                ++n4;
                n5 = 0;
                n5 += this.fontMetrics.charWidth(cArray[i]);
            }
            n5 += this.fontMetrics.charWidth(cArray[i]);
        }
        int[] nArray = new int[n4];
        n5 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n < n5) {
                nArray[n3] = i - 1;
                ++n3;
                n5 = 0;
                n5 += this.fontMetrics.charWidth(cArray[i]);
            }
            n5 += this.fontMetrics.charWidth(cArray[i]);
        }
        String[] stringArray = new String[n4];
        stringArray[0] = string.substring(0, nArray[0]);
        for (int i = 1; i < n4 - 1; ++i) {
            stringArray[i] = string.substring(nArray[i - 1], nArray[i]);
        }
        stringArray[n4 - 1] = 2 <= nArray.length ? string.substring(nArray[n4 - 2], string.length()) : string.substring(nArray[0], string.length());
        return stringArray;
    }
}

