/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import rxvesapi.process.graphics.gui.GUIProcessMount;

public class ImageLabelMount
extends GUIProcessMount
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public JLabel label;
    public ImageIcon icon;
    public Image image;
    public int imageID;
    int currentBuffer = 1;
    public BufferedImage bufferImageA;
    public Graphics2D bufferGraphicsA;
    public BufferedImage bufferImageB;
    public Graphics2D bufferGraphicsB;
    private boolean nowBuffering = false;

    public ImageLabelMount() {
        this.type = 104;
        this.label = new JLabel();
        this.label.setDoubleBuffered(true);
        this.label.setBounds(0, 0, 10, 10);
        this.component = this.label;
        this.label.setVisible(true);
        this.icon = new ImageIcon();
        this.label.setIcon(this.icon);
        this.label.addMouseListener(this);
        this.label.addMouseMotionListener(this);
        this.label.addMouseWheelListener(this);
        this.label.addKeyListener(this);
    }

    @Override
    public void disposeResource() {
        this.image = null;
        this.icon = null;
        this.bufferImageA = null;
        this.bufferImageB = null;
        if (this.bufferGraphicsA != null) {
            this.bufferGraphicsA.dispose();
            this.bufferGraphicsA = null;
        }
        if (this.bufferGraphicsB != null) {
            this.bufferGraphicsB.dispose();
            this.bufferGraphicsB = null;
        }
    }

    @Override
    public void setImageID(int n) {
        this.imageID = n;
    }

    @Override
    public int getImageID() {
        return this.imageID;
    }

    @Override
    public void setImage(Image image) {
        this.repaint();
    }

    @Override
    public synchronized void repaint() {
        if (this.image != this.driver.image[this.imageID]) {
            this.image = this.driver.image[this.imageID];
            if (this.bufferGraphicsA != null) {
                this.bufferGraphicsA.dispose();
            }
            this.bufferImageA = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            this.bufferGraphicsA = (Graphics2D)this.bufferImageA.getGraphics();
        }
        if (this.bufferImageA == null) {
            if (this.bufferGraphicsA != null) {
                this.bufferGraphicsA.dispose();
            }
            this.bufferImageA = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            this.bufferGraphicsA = (Graphics2D)this.bufferImageA.getGraphics();
        }
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        this.currentBuffer *= -1;
        bufferedImage = this.bufferImageA;
        graphics2D = this.bufferGraphicsA;
        graphics2D.setBackground(new Color(0, 0, 0, 0));
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawImage(this.image, 0, 0, null);
        this.icon.setImage(bufferedImage);
        this.label.setIcon(this.icon);
        this.label.repaint();
    }

    public synchronized Image getScreenImage() {
        return null;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.component.setBounds(n, n2, n3, n4);
        JComponent jComponent = (JComponent)this.component;
        jComponent.setPreferredSize(new Dimension(n3, n4));
        this.component.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyPressedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyReleasedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyTypedEventCall(this.id, keyEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseMovedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseEnteredEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseExitedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mousePressedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseReleasedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseClickedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseDraggedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseWheelMovedEventCall(this.id, mouseWheelEvent);
    }
}

