/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics.gui;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rxvesapi.process.graphics.gui.GUIProcessMount;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.unit.DecimalUnit;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;

public class SliderMount
extends GUIProcessMount
implements ChangeListener {
    public JButton button;
    public JSlider slider;
    public static int HORIZONTAL = 1;
    public static int VERTICAL = 2;
    public static int resolution = 10000;
    public int INT_MAX = 1;
    public int INT_MIN = 0;
    public double FLOAT_MAX = 1.0;
    public double FLOAT_MIN = 0.0;
    public boolean INT_SCALE = false;
    ProcessUnit[] sliderArgUnit;
    FunctionCallKernel[] sliderKernel;
    FunctionCallUnit[] sliderUnit;
    boolean sliderEventInited = false;
    ProcessUnit[] sliderArgUnit_INT;
    FunctionCallKernel[] sliderKernel_INT;
    FunctionCallUnit[] sliderUnit_INT;
    boolean sliderEventInited_INT = false;

    public SliderMount(int n) {
        resolution = 10000;
        this.type = 109;
        this.slider = n == HORIZONTAL ? new JSlider(0, 0, resolution, 0) : new JSlider(1, 0, resolution, 0);
        this.slider.setBounds(0, 0, 10, 10);
        this.component = this.slider;
        this.slider.setVisible(true);
        this.slider.addChangeListener(this);
    }

    public SliderMount(int n, double d, double d2) {
        this.FLOAT_MAX = Math.max(d, d2);
        this.FLOAT_MIN = Math.min(d, d2);
        resolution = 10000;
        this.type = 109;
        this.slider = n == HORIZONTAL ? new JSlider(0, 0, resolution, 0) : new JSlider(1, 0, resolution, 0);
        this.slider.setBounds(0, 0, 10, 10);
        this.component = this.slider;
        this.slider.setVisible(true);
        this.slider.addChangeListener(this);
    }

    public SliderMount(int n, double d, double d2, int n2) {
        this.FLOAT_MAX = Math.max(d, d2);
        this.FLOAT_MIN = Math.min(d, d2);
        resolution = n2;
        this.type = 109;
        this.slider = n == HORIZONTAL ? new JSlider(0, 0, resolution, 0) : new JSlider(1, 0, resolution, 0);
        this.slider.setBounds(0, 0, 10, 10);
        this.component = this.slider;
        this.slider.setVisible(true);
        this.slider.addChangeListener(this);
    }

    public SliderMount(int n, int n2, int n3) {
        this.type = 109;
        this.INT_MAX = Math.max(n2, n3);
        this.INT_MIN = Math.min(n2, n3);
        resolution = this.INT_MAX - this.INT_MIN;
        this.INT_SCALE = true;
        this.slider = n == HORIZONTAL ? new JSlider(0, 0, resolution, 0) : new JSlider(1, 0, resolution, 0);
        this.slider.setBounds(0, 0, 10, 10);
        this.component = this.slider;
        this.slider.setVisible(true);
        this.slider.addChangeListener(this);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(1);
        this.slider.setMinorTickSpacing(0);
    }

    @Override
    public void setIntValue(int n) {
        int n2 = n - this.INT_MIN;
        this.slider.setValue(n2);
        this.slider.repaint();
    }

    @Override
    public void setDoubleValue(double d) {
        int n = (int)((d - this.FLOAT_MIN) / (this.FLOAT_MAX - this.FLOAT_MIN) * (double)resolution);
        this.slider.setValue(n);
        this.slider.repaint();
    }

    @Override
    public double getDoubleValue() {
        double d = (this.FLOAT_MAX - this.FLOAT_MIN) * ((double)this.slider.getValue() / (double)resolution) + this.FLOAT_MIN;
        return d;
    }

    @Override
    public int getIntValue() {
        int n = this.slider.getValue() + this.INT_MIN;
        return n;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        if (this.INT_SCALE) {
            this.sliderEventCall_INT(this.id);
        } else {
            this.sliderEventCall(this.id);
        }
    }

    public synchronized void sliderEventCall(int n) {
        this.initSliderEvent();
        if (this.sliderKernel != null) {
            this.sliderArgUnit[0].setIntegerValue(n);
            this.sliderArgUnit[1].setDecimalValue(this.getDoubleValue());
            for (int i = 0; i < this.sliderKernel.length; ++i) {
                this.sliderUnit[i].process();
            }
        }
    }

    void initSliderEvent() {
        if (!this.sliderEventInited) {
            this.sliderArgUnit = new ProcessUnit[2];
            this.sliderArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.sliderArgUnit[1] = new DecimalUnit(0.0, this.engine);
            this.sliderKernel = this.engine.getAllFunctionCallKernel("onSliderMove", this.sliderArgUnit);
            if (this.sliderKernel != null) {
                this.sliderUnit = new FunctionCallUnit[this.sliderKernel.length];
                for (int i = 0; i < this.sliderKernel.length; ++i) {
                    this.sliderUnit[i] = new FunctionCallUnit(this.sliderArgUnit, this.sliderKernel[i], this.engine);
                    this.sliderUnit[i].setProcessKernel(this.sliderKernel[i]);
                }
            }
            this.sliderEventInited = true;
        }
    }

    public synchronized void sliderEventCall_INT(int n) {
        this.initSliderEvent_INT();
        if (this.sliderKernel_INT != null) {
            this.sliderArgUnit_INT[0].setIntegerValue(n);
            this.sliderArgUnit_INT[1].setIntegerValue(this.getIntValue());
            for (int i = 0; i < this.sliderKernel_INT.length; ++i) {
                this.sliderUnit_INT[i].process();
            }
        }
    }

    void initSliderEvent_INT() {
        if (!this.sliderEventInited_INT) {
            this.sliderArgUnit_INT = new ProcessUnit[2];
            this.sliderArgUnit_INT[0] = new IntegerUnit(this.id, this.engine);
            this.sliderArgUnit_INT[1] = new IntegerUnit(0L, this.engine);
            this.sliderKernel_INT = this.engine.getAllFunctionCallKernel("onSliderMove", this.sliderArgUnit_INT);
            if (this.sliderKernel_INT != null) {
                this.sliderUnit_INT = new FunctionCallUnit[this.sliderKernel_INT.length];
                for (int i = 0; i < this.sliderKernel_INT.length; ++i) {
                    this.sliderUnit_INT[i] = new FunctionCallUnit(this.sliderArgUnit_INT, this.sliderKernel_INT[i], this.engine);
                    this.sliderUnit_INT[i].setProcessKernel(this.sliderKernel_INT[i]);
                }
            }
            this.sliderEventInited_INT = true;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyPressedEventCall(this.id, keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyReleasedEventCall(this.id, keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyTypedEventCall(this.id, keyEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseMovedEventCall(this.id, mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseEnteredEventCall(this.id, mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseExitedEventCall(this.id, mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mousePressedEventCall(this.id, mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseReleasedEventCall(this.id, mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseClickedEventCall(this.id, mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseDraggedEventCall(this.id, mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseWheelMovedEventCall(this.id, mouseWheelEvent);
    }
}

