/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import rxvesapi.process.graphics.gui.GUIProcessMount;

public class TextAreaMount
extends GUIProcessMount
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private JPopupMenu popupMenu;
    public JTextArea area;
    public JScrollPane pane;

    public TextAreaMount() {
        this.type = 103;
        this.area = new JTextArea();
        this.area.setVisible(true);
        this.pane = new JScrollPane(this.area);
        this.pane.setVisible(true);
        this.pane.setBounds(0, 0, 10, 10);
        this.component = this.area;
        this.area.addMouseListener(this);
        this.area.addMouseMotionListener(this);
        this.pane.addMouseWheelListener(this);
        this.area.addKeyListener(this);
        this.initAction();
    }

    public void initAction() {
        this.cutAction = new DefaultEditorKit.CutAction();
        this.copyAction = new DefaultEditorKit.CopyAction();
        this.pasteAction = new DefaultEditorKit.PasteAction();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.cutAction);
        this.popupMenu.add(this.copyAction);
        this.popupMenu.add(this.pasteAction);
    }

    @Override
    public void setIntArrayValue(int[] nArray) {
        if (nArray == null || nArray.length != 2) {
            return;
        }
        if (nArray[0] == nArray[1]) {
            this.area.requestFocusInWindow();
            this.area.setCaretPosition(nArray[0]);
        } else {
            this.area.requestFocusInWindow();
            this.area.select(nArray[0], nArray[1]);
        }
    }

    @Override
    public int[] getIntArrayValue() {
        return new int[]{this.area.getSelectionStart(), this.area.getSelectionEnd()};
    }

    @Override
    public void setText(String string) {
        this.area.setText(string);
    }

    @Override
    public void appendText(String string) {
        this.area.append(string);
    }

    @Override
    public String getText() {
        String string = this.area.getText();
        string = string.replaceAll("\\r\\n", "\n");
        string = string.replaceAll("\\n\\r", "\n");
        string = string.replaceAll("\\r", "\n");
        string = string.replaceAll("\\n", System.getProperty("line.separator"));
        return string;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.pane.setBounds(n, n2, n3, n4);
        this.area.repaint();
        this.pane.repaint();
    }

    @Override
    public Rectangle getBounds() {
        return this.pane.getBounds();
    }

    @Override
    public void setVisible(boolean bl) {
        this.area.setVisible(bl);
        this.pane.setVisible(bl);
    }

    @Override
    public void repaint() {
        this.area.repaint();
        this.pane.repaint();
    }

    @Override
    public Component getComponent() {
        return this.pane;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyPressedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyReleasedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyTypedEventCall(this.id, keyEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseMovedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseEnteredEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseExitedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mousePressedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseReleasedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseClickedEventCall(this.id, mouseEvent);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupMenu.show(this.area, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseDraggedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseWheelMovedEventCall(this.id, mouseWheelEvent);
    }
}

