/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.graphics.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import rxvesapi.process.graphics.gui.GUIProcessMount;

public class TextFieldMount
extends GUIProcessMount
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private JPopupMenu popupMenu;
    public JTextField field;

    public TextFieldMount() {
        this.type = 102;
        this.field = new JTextField();
        this.field.setBounds(0, 0, 10, 10);
        this.component = this.field;
        this.field.setVisible(true);
        this.field.addMouseListener(this);
        this.field.addMouseMotionListener(this);
        this.field.addMouseWheelListener(this);
        this.field.addKeyListener(this);
        this.initAction();
    }

    public void initAction() {
        this.cutAction = new DefaultEditorKit.CutAction();
        this.copyAction = new DefaultEditorKit.CopyAction();
        this.pasteAction = new DefaultEditorKit.PasteAction();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.cutAction);
        this.popupMenu.add(this.copyAction);
        this.popupMenu.add(this.pasteAction);
    }

    @Override
    public void setIntArrayValue(int[] nArray) {
        if (nArray == null || nArray.length != 2) {
            return;
        }
        if (nArray[0] == nArray[1]) {
            this.field.requestFocusInWindow();
            this.field.setCaretPosition(nArray[0]);
        } else {
            this.field.requestFocusInWindow();
            this.field.select(nArray[0], nArray[1]);
        }
    }

    @Override
    public int[] getIntArrayValue() {
        return new int[]{this.field.getSelectionStart(), this.field.getSelectionEnd()};
    }

    @Override
    public void setText(String string) {
        this.field.setText(string);
        this.field.repaint();
    }

    @Override
    public void appendText(String string) {
        this.field.setText(this.field.getText() + string);
        this.field.repaint();
    }

    @Override
    public String getText() {
        String string = this.field.getText();
        string = string.replaceAll("\\r\\n", "\n");
        string = string.replaceAll("\\n\\r", "\n");
        string = string.replaceAll("\\r", "\n");
        string = string.replaceAll("\\n", System.getProperty("line.separator"));
        return string;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyPressedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyReleasedEventCall(this.id, keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.keyTypedEventCall(this.id, keyEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseMovedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseEnteredEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseExitedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mousePressedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseReleasedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseClickedEventCall(this.id, mouseEvent);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupMenu.show(this.field, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseDraggedEventCall(this.id, mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.EVENT_ENABLED) {
            return;
        }
        this.mouseWheelMovedEventCall(this.id, mouseWheelEvent);
    }
}

