/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.StringTokenizer;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessEnvironmentProperty;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.system.kernel.cache.VirtualizedInputStream;

public class FileInputEngine {
    private static final String LFC = System.getProperty("line.separator");
    private static final byte[] LFCB = System.getProperty("line.separator").getBytes();
    private int lineCount;
    private BufferedReader br;
    private FileReader fr;
    private InputStream fis;
    private InputStreamReader isr;
    private BufferedInputStream bis = null;
    private boolean online = ProcessEnvironmentProperty.isOnline();
    public static final int TEXT_WITHOUT_TOKEN = 0;
    public static final int TEXT_WITH_TOKEN = 100;
    public static final int TEXT_TSV = 101;
    public static final int TEXT_CSV = 102;
    public static final int BINARY = 300;
    private String token = null;
    private int mode = -1;

    public FileInputEngine(String string, int n, String string2, String string3) {
        this.mode = n;
        this.token = string2;
        if (n != 300) {
            this.lineCount = this.countLine(string, string3);
        }
        try {
            if (this.online) {
                URL uRL;
                File file = new File(ProcessEnvironmentProperty.getOnlineDirectoryPath());
                File file2 = new File(file, string);
                String string4 = file2.getPath();
                string4 = string4.replaceAll("\\\\", "/");
                if ((string4 = string4.replaceAll("\\./", "")).startsWith("http:/") || string4.startsWith("https:/")) {
                    if (string.startsWith("http:/") || string.startsWith("https:/")) {
                        System.out.println("FileInputEngine > Permission Denied: " + string);
                        return;
                    }
                    if (string4.startsWith("http:/") && string4.charAt(6) != '/') {
                        string4 = string4.replaceAll("http:/", "http://");
                    }
                    if (string4.startsWith("http://") && string4.charAt(7) != '/') {
                        string4 = string4.replaceAll("https:/", "https://");
                    }
                }
                if ((uRL = this.getClass().getClassLoader().getResource(string4)) == null) {
                    this.fis = new VirtualizedInputStream(string);
                } else {
                    uRL = this.verifyOrErrorURL(uRL);
                    this.fis = uRL.openStream();
                }
            } else {
                this.fis = string.equals("???//<SYSTEM_PROCESS_IO>::___STDIN___") ? System.in : (string.equals("???//<SYSTEM_PROCESS_IO>::___STDOUT___") ? null : (string.equals("???//<SYSTEM_PROCESS_IO>::___STDERR___") ? null : new FileInputStream(string)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (n == 300) {
            this.bis = new BufferedInputStream(this.fis);
        } else {
            if (string3 == null) {
                this.isr = new InputStreamReader(this.fis);
            } else {
                try {
                    this.isr = new InputStreamReader(this.fis, string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return;
                }
            }
            this.br = new BufferedReader(this.isr);
        }
    }

    public boolean exists() {
        if (this.mode == 300) {
            return this.bis != null;
        }
        return this.br != null;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    URL verifyOrErrorURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (ProcessEngine.verifyURL(uRL)) {
            return uRL;
        }
        System.out.println("Permission Denied: " + uRL);
        ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
        throw processRuntimeException;
    }

    private int countLine(String string, String string2) {
        try {
            try {
                Object object;
                Object object2;
                InputStream inputStream = null;
                if (this.online) {
                    URL uRL;
                    object2 = new File(ProcessEnvironmentProperty.getOnlineDirectoryPath());
                    object = new File((File)object2, string);
                    String string3 = ((File)object).getPath();
                    string3 = string3.replaceAll("\\\\", "/");
                    if ((string3 = string3.replaceAll("\\./", "")).startsWith("http:/") && string3.charAt(6) != '/') {
                        string3 = string3.replaceAll("http:/", "http://");
                    }
                    if ((uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
                        inputStream = new VirtualizedInputStream(string);
                    } else {
                        uRL = this.verifyOrErrorURL(uRL);
                        inputStream = uRL.openStream();
                    }
                } else {
                    inputStream = new FileInputStream(string);
                }
                object2 = string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2);
                object = new BufferedReader((Reader)object2);
                int n = 0;
                while (((BufferedReader)object).readLine() != null) {
                    ++n;
                }
                ((InputStream)inputStream).close();
                inputStream = null;
                ((InputStreamReader)object2).close();
                object2 = null;
                return n;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public String[] tokenize(String string) {
        if (this.mode == 0) {
            return new String[]{string};
        }
        if (this.mode == 102) {
            return string.split(",");
        }
        if (this.mode == 101) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            stringTokenizer = new StringTokenizer(string);
            String[] stringArray = new String[n];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String[] readLine() throws IOException {
        if (this.mode != 300) {
            String string = this.br.readLine();
            return this.tokenize(string);
        }
        return null;
    }

    public String[] readAll() throws IOException {
        int n;
        if (this.mode == 300) {
            int n2 = 1024;
            byte[] byArray = new byte[n2];
            StringBuffer stringBuffer = new StringBuffer("");
            int n3 = -1;
            while ((n3 = this.bis.read(byArray)) != -1) {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
                    stringBuffer.append(",");
                }
            }
            String string = stringBuffer.toString();
            stringBuffer = null;
            return string.split(",");
        }
        if (this.mode == 101 || this.mode == 102) {
            StringBuffer stringBuffer = new StringBuffer("");
            String string = null;
            String string2 = System.getProperty("line.separator");
            while ((string = this.br.readLine()) != null) {
                stringBuffer.append(string);
                if (this.mode == 101) {
                    stringBuffer.append(" ");
                    continue;
                }
                if (this.mode != 102) continue;
                stringBuffer.append(",");
            }
            String string3 = stringBuffer.toString();
            stringBuffer = null;
            return this.tokenize(string3);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n4 = 1024;
        byte[] byArray = new byte[n4];
        while ((n = this.br.read()) != -1) {
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        stringBuffer = null;
        return new String[]{string};
    }

    public String loadLine() throws IOException {
        if (this.mode != 300) {
            return this.br.readLine();
        }
        return null;
    }

    public String loadAll() throws IOException {
        if (this.mode != 300) {
            StringBuffer stringBuffer = new StringBuffer("");
            Object var2_2 = null;
            int n = -1;
            while (0 <= (n = this.br.read())) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            stringBuffer = null;
            return string;
        }
        return null;
    }

    public void close() {
        if (this.mode == 300) {
            try {
                if (this.bis != null) {
                    this.bis.close();
                    this.bis = null;
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                if (this.isr != null) {
                    this.isr.close();
                    this.isr = null;
                }
                if (this.br != null) {
                    this.br.close();
                    this.br = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.close();
    }
}

