/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import rxvesapi.process.ProcessEnvironmentProperty;
import rxvesapi.system.kernel.cache.VirtualizedIOServer;
import rxvesapi.system.kernel.cache.VirtualizedOutputStream;

public class FileOutputEngine {
    private static final String LFC = System.getProperty("line.separator");
    private OutputStream os = null;
    private OutputStreamWriter osw = null;
    private BufferedWriter bw = null;
    private boolean online = ProcessEnvironmentProperty.isOnline();
    private BufferedOutputStream bos = null;
    public static final int TEXT_WITHOUT_TOKEN = 0;
    public static final int TEXT_WITH_TOKEN = 100;
    public static final int BINARY = 300;
    private String token = null;
    private int mode = -1;

    public int getMode() {
        return this.mode;
    }

    public FileOutputEngine(String string, int n, String string2, String string3, boolean bl) {
        if (this.online) {
            if (!VirtualizedIOServer.getInstance().exists(string)) {
                if (n == 300) {
                    VirtualizedIOServer.getInstance().createConsoleIcon(string, "BINALY");
                } else {
                    VirtualizedIOServer.getInstance().createConsoleIcon(string, string3);
                }
            }
            VirtualizedIOServer.getInstance().setVisible(true);
        }
        this.mode = n;
        this.token = string2;
        try {
            this.os = this.online ? new VirtualizedOutputStream(string, bl) : (string.equals("???//<SYSTEM_PROCESS_IO>::___STDOUT___") ? System.out : (string.equals("???//<SYSTEM_PROCESS_IO>::___STDERR___") ? System.err : (string.equals("???//<SYSTEM_PROCESS_IO>::___STDIN___") ? null : new FileOutputStream(string, bl))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (n == 300) {
            this.bos = new BufferedOutputStream(this.os);
        } else {
            if (string3 == null) {
                this.osw = new OutputStreamWriter(this.os);
            } else {
                try {
                    this.osw = new OutputStreamWriter(this.os, string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return;
                }
            }
            this.bw = new BufferedWriter(this.osw);
        }
    }

    public boolean exists() {
        if (this.mode == 300) {
            return this.bos != null;
        }
        return this.bw != null;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public void write(String string) throws IOException {
        this.bw.write(string);
    }

    public void writeb(byte[] byArray) throws IOException {
        if (this.mode == 300) {
            this.bos.write(byArray, 0, byArray.length);
        }
    }

    public void write(String[] stringArray) throws IOException {
        int n;
        int n2 = stringArray.length;
        if (n2 <= 0) {
            return;
        }
        if (this.mode == 0) {
            for (n = 0; n < n2; ++n) {
                this.bw.write(stringArray[n]);
            }
        }
        if (this.mode == 100) {
            this.bw.write(stringArray[0]);
            for (n = 1; n < n2; ++n) {
                this.bw.write(this.token);
                this.bw.write(stringArray[n]);
            }
        }
        if (this.mode == 300) {
            byte[] byArray = new byte[stringArray.length];
            for (int i = 0; i < n2; ++i) {
                n = Integer.parseInt(stringArray[i]);
                byArray[i] = (byte)n;
            }
            this.bos.write(byArray, 0, byArray.length);
        }
    }

    public void lineFeed() throws IOException {
        if (this.mode == 300) {
            this.bos.write(LFC.getBytes(), 0, LFC.getBytes().length);
        } else {
            this.bw.write(LFC);
        }
    }

    public void flush() {
        try {
            if (this.mode == 300) {
                this.bos.flush();
            } else {
                this.bw.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.mode == 300) {
            try {
                if (this.bos != null) {
                    this.bos.flush();
                    this.bos.close();
                    this.bos = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                if (this.bw != null) {
                    this.bw.flush();
                }
                if (this.osw != null) {
                    this.osw.close();
                    this.osw = null;
                }
                if (this.bw != null) {
                    this.bw.close();
                    this.bw = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        this.close();
    }
}

