/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.kernel;

import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeGenericsTokenizer;
import rxvesapi.process.decode.ProcessCodeNameFilter;
import rxvesapi.process.decode.ProcessCodeScopeConstructor;
import rxvesapi.process.decode.ProcessCodeScopeForm;
import rxvesapi.process.decode.ProcessCodeTokenReplacer;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.scope.FunctionScope;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.ProcessUnit;

public class FunctionCallKernel
extends ProcessKernel {
    public String fileName = "";
    public boolean NATIVE_CALL = false;
    public boolean isProcessing = false;
    public boolean readying = false;
    public FunctionScope functionScope;
    public String functionName = "";
    public ProcessUnit returnUnit;
    public boolean override = false;
    public boolean using = false;
    public boolean generic = false;
    private String[] genericParameter;
    FunctionCallKernel[] genericKernel = null;

    public boolean isReady() {
        return this.ready;
    }

    public boolean isReadying() {
        return this.readying;
    }

    public boolean using() {
        return this.using;
    }

    public void use() {
        this.using = true;
    }

    public FunctionCallKernel() {
    }

    public FunctionCallKernel(FunctionScope functionScope, int n, int n2, ProcessEngine processEngine, ProcessProgram processProgram) {
        this.kernelNumber = n;
        this.scopeNumber = n2;
        this.processEngine = processEngine;
        this.setFunctionScope(functionScope);
        this.mainCircuit = new ProcessCircuit("", 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
        this.mainCircuit.setProcessKernel(this);
        this.mainCircuit.createCircuit("");
        functionScope.setProgram(processProgram);
        this.programInstance = processProgram;
        this.setGenerics(functionScope.getFunctionName());
        this.kernelType = ProcessKernel.FUNCTION_CALL_TYPE;
    }

    public FunctionCallKernel generateGeneric(String[] stringArray) {
        FunctionCallKernel functionCallKernel;
        if (stringArray == null) {
            return null;
        }
        ProcessCodeScopeConstructor processCodeScopeConstructor = new ProcessCodeScopeConstructor(this.processEngine, this.programInstance);
        processCodeScopeConstructor.setGenericsArgumentProcess(true);
        ProcessCodeScopeForm processCodeScopeForm = this.form.createClone();
        processCodeScopeForm.name = this.getFunctionName();
        processCodeScopeForm.type = ProcessCodeTokenReplacer.replaceTokens(processCodeScopeForm.type, this.genericParameter, stringArray);
        processCodeScopeForm.program = ProcessCodeTokenReplacer.replaceTokens(processCodeScopeForm.program, this.genericParameter, stringArray);
        processCodeScopeForm.argument = ProcessCodeTokenReplacer.replaceTokens(processCodeScopeForm.argument, this.genericParameter, stringArray);
        processCodeScopeForm.type = processCodeScopeForm.type.replaceAll(" ", "");
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < processCodeScopeForm.type.length(); ++i) {
            if (processCodeScopeForm.type.charAt(i) == '<') {
                ++n;
            }
            if (processCodeScopeForm.type.charAt(i) == '>') {
                --n;
            }
            if (processCodeScopeForm.type.charAt(i) != '[' || n != 0) continue;
            ++n3;
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (0 <= n2) {
            processCodeScopeForm.type = processCodeScopeForm.type.substring(0, n2);
            processCodeScopeForm.dimension = n3;
        }
        if ((functionCallKernel = processCodeScopeConstructor.constructFunction(processCodeScopeForm)) == null) {
            return null;
        }
        processCodeScopeConstructor.disposeResource();
        ProcessUnit[] processUnitArray = this.functionScope.getGlobalUnit();
        if (processUnitArray != null) {
            functionCallKernel.addVariable(processUnitArray);
        }
        functionCallKernel.setGenericType(stringArray);
        functionCallKernel.ready();
        functionCallKernel.fileName = this.fileName;
        return functionCallKernel;
    }

    public FunctionCallKernel createClone() {
        ProcessCodeScopeConstructor processCodeScopeConstructor = new ProcessCodeScopeConstructor(this.processEngine, this.programInstance);
        processCodeScopeConstructor.setGenericsArgumentProcess(!this.generic);
        ProcessCodeScopeForm processCodeScopeForm = this.form;
        FunctionCallKernel functionCallKernel = processCodeScopeConstructor.constructFunction(processCodeScopeForm);
        processCodeScopeConstructor.disposeResource();
        ProcessUnit[] processUnitArray = this.functionScope.getGlobalUnit();
        functionCallKernel.addVariable(processUnitArray);
        functionCallKernel.ready();
        functionCallKernel.fileName = this.fileName;
        return functionCallKernel;
    }

    public FunctionCallKernel getKernel(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        return this.getGeneric(stringArray);
    }

    private void addGeneric(FunctionCallKernel functionCallKernel) {
        int n;
        if (this.genericKernel == null) {
            this.genericKernel = new FunctionCallKernel[0];
        }
        int n2 = this.genericKernel.length;
        FunctionCallKernel[] functionCallKernelArray = new FunctionCallKernel[n2];
        for (n = 0; n < n2; ++n) {
            functionCallKernelArray[n] = this.genericKernel[n];
        }
        this.genericKernel = new FunctionCallKernel[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.genericKernel[n] = functionCallKernelArray[n];
        }
        functionCallKernelArray = null;
        this.genericKernel[n2] = functionCallKernel;
    }

    public FunctionCallKernel getGeneric(String[] stringArray) {
        if (this.genericKernel != null) {
            int n = this.genericKernel.length;
            for (int i = 0; i < n; ++i) {
                if (this.genericKernel[i] == null || !this.genericKernel[i].isProcessableGeneric(stringArray)) continue;
                return this.genericKernel[i];
            }
        }
        if (this.isGeneric()) {
            FunctionCallKernel functionCallKernel = this.generateGeneric(stringArray);
            this.addGeneric(functionCallKernel);
            return functionCallKernel;
        }
        return null;
    }

    public void setGenericType(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        this.genericParameter = stringArray2;
    }

    public boolean isProcessableGeneric(String[] stringArray) {
        int n = stringArray.length;
        if (n != this.genericParameter.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals(this.genericParameter[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public void setGenerics(String string) {
        if (0 <= string.indexOf("<")) {
            this.generic = true;
            this.genericParameter = ProcessCodeGenericsTokenizer.getTopLevelParameters(string);
            this.functionScope.setFunctionName(this.functionScope.getFunctionName().substring(0, this.functionScope.getFunctionName().indexOf("<")));
            this.functionName = this.functionScope.getFunctionName();
        }
    }

    public boolean isProcessableArgument(ProcessUnit[] processUnitArray) {
        if (this.generic) {
            return false;
        }
        return this.functionScope.isProcessableArgument(processUnitArray);
    }

    public boolean isProcessableArgument(ProcessUnit[] processUnitArray, String[] stringArray) {
        if (this.generic) {
            FunctionCallKernel functionCallKernel = this.getKernel(stringArray);
            if (functionCallKernel == null) {
                return false;
            }
            return functionCallKernel.isProcessableArgument(processUnitArray);
        }
        if (stringArray == null) {
            return this.functionScope.isProcessableArgument(processUnitArray);
        }
        return false;
    }

    public void checkArgument(ProcessUnit[] processUnitArray, ProcessCircuit processCircuit) {
        if (this.functionScope != null) {
            this.functionScope.checkArgument(processUnitArray, processCircuit);
        }
    }

    @Override
    public void setErrorDetection(boolean bl) {
        this.errorDetection = bl;
        if (this.functionScope != null) {
            this.functionScope.setErrorDetection(bl);
        }
    }

    public void setFunctionScope(FunctionScope functionScope) {
        this.functionScope = functionScope;
        this.functionName = functionScope.getFunctionName();
        this.functionScope = functionScope;
    }

    public boolean isConstructor() {
        if (this.functionScope == null) {
            return false;
        }
        return this.functionScope.isConstructor();
    }

    public ProcessUnit getDummyReturnUnit() {
        return this.functionScope.getDummyReturnUnit();
    }

    public boolean isSameArgument(FunctionCallKernel functionCallKernel) {
        FunctionScope functionScope = functionCallKernel.getFunctionScope();
        if (functionScope == null) {
            return false;
        }
        if (this.functionScope == null) {
            return false;
        }
        return this.functionScope.isSameArgument(functionScope);
    }

    public boolean isCompetitive(FunctionCallKernel functionCallKernel) {
        return this.getFunctionName().equals(functionCallKernel.getFunctionName()) && this.isSameArgument(functionCallKernel);
    }

    public boolean isProcessing() {
        return this.functionScope.isProcessing;
    }

    public ProcessUnit getReturnUnit() {
        return this.getFunctionScope().getReturnUnit();
    }

    @Override
    public void setParentScope(ProcessScope processScope) {
        this.functionScope.setParentScope(processScope);
        this.parentScope = processScope;
    }

    @Override
    public void nullResource() {
        if (this.functionScope != null) {
            this.functionScope.nullResource();
            this.functionScope = null;
        }
        this.functionName = null;
        if (this.processUnit != null) {
            this.counter = 0;
            for (int i = 0; i < this.processUnit.length; ++i) {
                if (this.processUnit[i] == null) continue;
                this.processUnit[i] = null;
            }
        }
        this.rootUnit = null;
        if (this.mainCircuit != null) {
            this.mainCircuit.nullResource();
            this.mainCircuit = null;
        }
        this.programLine = null;
        this.processFormula = null;
        this.kernelID = null;
        this.kernelName = null;
    }

    @Override
    public void disposeResource() {
        if (this.functionScope != null) {
            this.functionScope.disposeResource();
            this.functionScope = null;
        }
        this.functionName = null;
        if (this.processUnit != null) {
            this.counter = 0;
            for (int i = 0; i < this.processUnit.length; ++i) {
                if (this.processUnit[i] == null) continue;
                this.processUnit[i].disposeResource();
                this.processUnit[i] = null;
            }
        }
        this.rootUnit = null;
        if (this.mainCircuit != null) {
            this.mainCircuit.disposeResource();
            this.mainCircuit = null;
        }
        this.programLine = null;
        this.processFormula = null;
        this.kernelID = null;
        this.kernelName = null;
    }

    @Override
    public void exit() {
        if (this.parentScope != null) {
            this.parentScope.breakScope();
        }
        if (this.functionScope != null) {
            this.functionScope.breakFunctionScope();
            this.functionScope.exit();
        }
    }

    public String getArgumentDescription() {
        if (this.generic) {
            return this.form.argument;
        }
        if (this.functionScope != null) {
            return this.functionScope.getArgumentDescription();
        }
        return "ERROR NULL_SCOPE";
    }

    public String getGenericsDescription() {
        if (this.generic) {
            String string = "<";
            for (int i = 0; i < this.genericParameter.length - 1; ++i) {
                string = string + this.genericParameter[i] + ",";
            }
            string = string + this.genericParameter[this.genericParameter.length - 1] + ">";
            return string;
        }
        return null;
    }

    public void setFunctionName(String string) {
        if (0 <= string.indexOf(60)) {
            string = string.substring(0, string.indexOf(60));
        }
        this.functionName = string;
        this.functionScope.setFunctionName(string);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public FunctionScope getFunctionScope() {
        return this.functionScope;
    }

    @Override
    public void addVariable(ProcessUnit processUnit) {
        this.functionScope.addVariable(processUnit);
    }

    public void check() {
        this.lineAddressCode = "???@___KERNEL";
        if (this.functionName != null && !ProcessCodeNameFilter.filtering(this.functionName)) {
            this.error(ProcessCodeNameFilter.getInfo(this.functionName));
        }
        if (this.functionScope.getReturnUnit() == null && !this.isGeneric()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u623b\u308a\u5024\u306e\u578b\u304c\u3001\u6b63\u3057\u304f\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u305b\u3093: " + this.functionName);
            } else {
                this.error("The data type of the return value is not declared correctly: " + this.functionName);
            }
        }
    }

    @Override
    public void ready() {
        if (!this.generic && !this.ready) {
            this.check();
            this.readying = true;
            this.functionScope.setErrorDetection(this.errorDetection);
            this.functionScope.setProgram(this.programInstance);
            this.functionScope.parentKernel = this;
            this.functionScope.ready();
            this.returnUnit = this.functionScope.getReturnUnit();
            this.ready = true;
            this.readying = false;
        }
    }

    @Override
    public void process() {
    }

    @Override
    public synchronized ProcessUnit call(ProcessUnit[] processUnitArray) {
        this.functionScope.call(processUnitArray);
        try {
            return this.returnUnit;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public synchronized ProcessUnit call(ProcessUnit[] processUnitArray, FunctionCallUnit functionCallUnit) {
        this.functionScope.call(processUnitArray, functionCallUnit);
        try {
            return this.returnUnit;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void call_DIRECT(ProcessUnit[] processUnitArray) {
        this.functionScope.call(processUnitArray, null);
    }
}

