/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.kernel;

import java.util.StringTokenizer;
import rxvesapi.process.ProcessCircuit;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeConstructor;
import rxvesapi.process.decode.ProcessCodeLoader;
import rxvesapi.process.decode.ProcessCodeNameFilter;
import rxvesapi.process.decode.ProcessCodeScopeForm;
import rxvesapi.process.decode.ProcessCodeVariableConstructor;
import rxvesapi.process.decode.ProcessCodeVariableForm;
import rxvesapi.process.kernel.ScopeCallKernel;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.KernelCallUnit;
import rxvesapi.process.unit.NullProcessUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.ScopeCallUnit;

public class ProcessKernel {
    public boolean constDefined = false;
    public boolean driverProcess = false;
    public ProcessProgram programInstance;
    public String fileName = "";
    public boolean errorDetection = true;
    private boolean variableInitialized = false;
    public boolean field = false;
    public ProcessUnit[] processUnit;
    public ProcessUnit rootUnit;
    public ProcessCodeScopeForm form;
    public boolean error = false;
    public String errorMessage;
    public String errorInformation;
    public boolean ready = false;
    protected int counter = 0;
    public String kernelID = "";
    public long lineNumber = 0L;
    public ProcessCircuit mainCircuit;
    public String lineAddressCode = "";
    public String programLine;
    public ProcessScope parentScope;
    ProcessUnit variable;
    public String processFormula = "";
    public boolean array = false;
    public static int NULL_TYPE = 100;
    public static int CIRCUIT_TYPE = 101;
    public static int VARIABLE_TYPE = 102;
    public static int RETURN_TYPE = 104;
    public static int OUTPUT_TYPE = 200;
    public static int INPUT_TYPE = 201;
    public static int PRINT_TYPE = 202;
    public static int PRINTF_TYPE = 203;
    public static int SYSTEM_TYPE = 300;
    public static int SCOPE_CALL_TYPE = 301;
    public static int FUNCTION_CALL_TYPE = 302;
    public static int FUNCTION_MACRO_TYPE = 303;
    int kernelType = NULL_TYPE;
    String kernelName = "";
    boolean variableMade = false;
    public ProcessCircuit[] indexCircuit;
    public String macroCode;
    public static int PUBLIC = 100;
    public static int PRIVATE = 200;
    public static int PROTECTED = 300;
    public int accessPermission = PUBLIC;
    public int kernelNumber = Integer.MAX_VALUE;
    public int scopeNumber = Integer.MAX_VALUE;
    public ProcessEngine processEngine;

    public void setRuntimeCompileSecurity(boolean bl) {
        this.mainCircuit.setRuntimeCompileSecurity(bl);
    }

    public int getAccessPermission() {
        return this.accessPermission;
    }

    public void setAccessPermission(int n) {
        this.accessPermission = n;
    }

    public int getKernelNumber() {
        return this.kernelNumber;
    }

    public void setKernelNumber(int n) {
        this.kernelNumber = n;
    }

    public int getScopeNumber() {
        return this.scopeNumber;
    }

    public void setScopeNumber(int n) {
        this.scopeNumber = n;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isFieldDefine() {
        return this.field;
    }

    public void setFieldDefine(boolean bl) {
        this.field = bl;
    }

    public void setConst(boolean bl) {
        this.constDefined = bl;
    }

    public boolean isConst() {
        return this.constDefined;
    }

    public void setErrorDetection(boolean bl) {
        this.errorDetection = bl;
    }

    public ProcessUnit getExecutionUnit() {
        if (this.kernelType == NULL_TYPE) {
            NullProcessUnit nullProcessUnit = new NullProcessUnit();
            return nullProcessUnit;
        }
        if (this.kernelType == CIRCUIT_TYPE) {
            if (this.mainCircuit == null) {
                return null;
            }
            return this.mainCircuit.getRootProcessUnit();
        }
        if (this.kernelType == SCOPE_CALL_TYPE) {
            ScopeCallUnit scopeCallUnit = new ScopeCallUnit((ScopeCallKernel)this, this.processEngine);
            scopeCallUnit.setProcessKernel(this);
            return scopeCallUnit;
        }
        if (this.kernelType == FUNCTION_CALL_TYPE) {
            return null;
        }
        KernelCallUnit kernelCallUnit = new KernelCallUnit(this, this.processEngine);
        kernelCallUnit.setProcessKernel(this);
        return kernelCallUnit;
    }

    public boolean isDriverProcess() {
        return this.driverProcess;
    }

    public ProcessKernel() {
    }

    public boolean isConstOnly() {
        boolean bl = true;
        if (this.mainCircuit != null && !this.mainCircuit.isConstOnly()) {
            bl = false;
        }
        if (this.indexCircuit != null) {
            for (int i = 0; i < this.indexCircuit.length; ++i) {
                if (this.indexCircuit[i] == null || this.indexCircuit[i].isConstOnly()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean initConstOnly() {
        boolean bl = true;
        if (this.mainCircuit != null && !this.mainCircuit.isRightHandConstOnly() && this.getVariableProcessUnit() != this.mainCircuit.getRootProcessUnit() && !this.mainCircuit.formulaLine.startsWith("SYSTEM_PROCESS_initialize(")) {
            bl = false;
        }
        if (this.indexCircuit != null) {
            for (int i = 0; i < this.indexCircuit.length; ++i) {
                if (this.indexCircuit[i] == null || this.indexCircuit[i].isConstOnly()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void setProgram(ProcessProgram processProgram) {
        this.programInstance = processProgram;
        if (this.mainCircuit != null) {
            this.mainCircuit.setProgram(this.programInstance);
        }
    }

    public ProcessProgram getProgram() {
        return this.programInstance;
    }

    public void callExit() {
        this.exit();
        this.processEngine.exit();
    }

    public void exit() {
        if (this.parentScope != null) {
            this.parentScope.breakRootScope();
        }
    }

    public void setParentScope(ProcessScope processScope) {
        this.parentScope = processScope;
    }

    public ProcessScope getProcessScope() {
        return null;
    }

    public void nullResource() {
        this.counter = 0;
        this.programInstance = null;
        for (int i = 0; i < this.processUnit.length; ++i) {
            try {
                this.processUnit[i] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.form = null;
        this.rootUnit = null;
        try {
            this.mainCircuit.nullResource();
            this.mainCircuit = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (this.indexCircuit != null) {
                for (int i = 0; i < this.indexCircuit.length; ++i) {
                    this.indexCircuit[i] = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.programLine = null;
        this.processFormula = null;
        this.kernelID = null;
        this.kernelName = null;
    }

    public void disposeResource() {
        this.counter = 0;
        this.programInstance = null;
        for (int i = 0; i < this.processUnit.length; ++i) {
            try {
                this.processUnit[i].disposeResource();
                this.processUnit[i] = null;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.form = null;
        this.rootUnit = null;
        try {
            this.mainCircuit.disposeResource();
            this.mainCircuit = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (this.indexCircuit != null) {
                for (int i = 0; i < this.indexCircuit.length; ++i) {
                    this.indexCircuit[i].disposeResource();
                    this.indexCircuit[i] = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.programLine = null;
        this.processFormula = null;
        this.kernelID = null;
        this.kernelName = null;
    }

    public ProcessKernel(String string, int n, int n2, ProcessEngine processEngine, ProcessProgram processProgram) {
        this.kernelNumber = n;
        this.scopeNumber = n2;
        this.processEngine = processEngine;
        this.programLine = string;
        this.programInstance = processProgram;
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        processCodeLoader.setProcessEngine(this.processEngine);
        StringBuffer stringBuffer = new StringBuffer(this.programLine);
        processCodeLoader.escape(stringBuffer);
        processCodeLoader.removeLineAddressCode(stringBuffer);
        processCodeLoader.unescape(stringBuffer);
        processCodeLoader.dispose();
        processCodeLoader = null;
        this.programLine = stringBuffer.toString();
        this.init();
    }

    public ProcessUnit getVariable() {
        if (this.kernelType == VARIABLE_TYPE) {
            return this.variable;
        }
        return null;
    }

    public void setVariable(ProcessUnit processUnit) {
        this.variable = processUnit;
    }

    public void setVariableProcessUnit(ProcessUnit processUnit) {
        this.variable = processUnit;
    }

    public void setLineAddress(String string) {
        this.lineAddressCode = string;
    }

    public String getFunctionName() {
        return "NOT FUNCTION";
    }

    public void setKernelName(String string) {
        this.kernelName = string;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public ProcessUnit getVariableProcessUnit() {
        return this.getVariable();
    }

    public void setKernelID(String string) {
        this.kernelID = string;
    }

    public String getKernelID() {
        return this.kernelID;
    }

    public void init() {
        this.mainCircuit = new ProcessCircuit(this.programLine, 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
        this.mainCircuit.setProgram(this.programInstance);
        this.mainCircuit.parentScope = this.parentScope;
        this.mainCircuit.setProcessKernel(this);
        this.setKernelType(this.programLine);
    }

    public void ready() {
        if (this.kernelType == VARIABLE_TYPE) {
            if (this.variable == null) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u6587\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u5909\u6570\u306e\u5ba3\u8a00\u3068\u3057\u3066\u306f\u3001\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3059\u3002");
                } else {
                    this.error("Cannot interpret the statement. Incorrect for variable declaration statement.");
                }
                return;
            }
            if (this.variable.getName().length() == 0) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u6587\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u5909\u6570\u306e\u5ba3\u8a00\u3068\u3057\u3066\u306f\u3001\u5909\u6570\u540d\uff08\u8b58\u5225\u5b50\uff09\u306e\u8a18\u8ff0\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                } else {
                    this.error("Cannot interpret the statement. Incorrect for variable declaration statement (no variable name is declared).");
                }
                return;
            }
            if (!ProcessCodeNameFilter.filtering(this.variable.getName())) {
                this.error(ProcessCodeNameFilter.getInfo(this.variable.getName()));
                return;
            }
        }
        if (!this.ready) {
            this.mainCircuit.parentScope = this.parentScope;
            if (this.kernelType == VARIABLE_TYPE && this.variable != null) {
                boolean bl = true;
                this.mainCircuit.addVariable(this.variable, bl);
            }
            this.mainCircuit.setConst(this.isConst());
            this.createCircuit(this.processFormula);
            if (this.mainCircuit != null) {
                this.rootUnit = this.mainCircuit.getRootProcessUnit();
                this.ready = true;
            }
        }
    }

    public void setKernelType(int n) {
        this.kernelType = n;
    }

    public int getKernelType() {
        return this.kernelType;
    }

    public void createCircuit() {
        this.createCircuit(this.processFormula);
        this.rootUnit = this.mainCircuit.getRootProcessUnit();
    }

    public boolean isVariableInitialized() {
        return this.variableInitialized;
    }

    public void createCircuit(String string) {
        if (string.replaceAll(" ", "").replaceAll("\t", "").length() == 0) {
            this.variableInitialized = false;
            if (this.getKernelType() == VARIABLE_TYPE) {
                string = "SYSTEM_PROCESS_initialize(" + this.variable.getName() + ")";
            }
        } else {
            this.variableInitialized = true;
        }
        this.mainCircuit.createCircuit(string);
        this.mainCircuit.setKernelNumber(this.kernelNumber);
        this.mainCircuit.setScopeNumber(this.scopeNumber);
        if (this.indexCircuit != null) {
            for (int i = 0; i < this.indexCircuit.length; ++i) {
                this.indexCircuit[i].createCircuit();
                this.indexCircuit[i].setKernelNumber(this.kernelNumber);
                this.indexCircuit[i].setScopeNumber(this.scopeNumber);
            }
        }
        this.rootUnit = this.mainCircuit.getRootProcessUnit();
    }

    public void setKernelType(String string) {
        int n = ProcessCodeConstructor.getLHSEndIndex(string);
        String string2 = string.substring(0, n);
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("public")) {
                string3 = stringTokenizer.nextToken();
                this.accessPermission = PUBLIC;
            } else if (string3.equals("private")) {
                string3 = stringTokenizer.nextToken();
                this.accessPermission = PRIVATE;
            } else if (string3.equals("protected")) {
                string3 = stringTokenizer.nextToken();
                this.accessPermission = PROTECTED;
            }
            if (string3.equals("const")) {
                this.setConst(true);
                string3 = stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals("const")) {
            this.setConst(true);
            string4 = stringTokenizer.nextToken();
        }
        stringTokenizer = null;
        String string5 = string;
        string5 = string5.replaceAll(" ", "");
        string5 = string5.replaceAll("\\t", "");
        try {
            if (string3.equals("int") || string3.equals("long")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("int&") || string3.startsWith("int[") || string3.startsWith("long[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("double") || string3.equals("float")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("double&") || string3.startsWith("double[") || string3.startsWith("float[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("varint")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("varint&") || string3.startsWith("varint[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("varfloat")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("varfloat&") || string3.startsWith("varfloat[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("complex")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("complex&") || string3.startsWith("complex[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("varcomplex")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("varcomplex&") || string3.startsWith("varcomplex[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("string")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("string&") || string3.startsWith("string[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("bool") || string3.equals("boolean")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("bool&") || string3.startsWith("bool[") || string3.startsWith("boolean&") || string3.startsWith("boolean[")) {
                this.variableDeclaration(string);
            } else if (string3.equals("SYSTEM_PROCESS_VARIABLE_TYPE_UNDEFINED")) {
                this.variableDeclaration(string);
            } else if (string3.startsWith("SYSTEM_PROCESS_VARIABLE_TYPE_UNDEFINED&") || string3.startsWith("SYSTEM_PROCESS_VARIABLE_TYPE_UNDEFINED[")) {
                this.variableDeclaration(string);
            } else if (this.programInstance.getStruct(string3) != null || 0 <= string3.indexOf("[") && this.programInstance.getStruct(string3.substring(0, string3.indexOf(91))) != null || 0 <= string3.indexOf("&") && this.programInstance.getStruct(string3.substring(0, string3.indexOf(38))) != null) {
                this.variableDeclaration(string);
            } else if (string5.startsWith("SYSTEM_PROCESS_KERNEL_")) {
                this.kernelType = SYSTEM_TYPE;
            } else if (!string5.equals("") && !string5.equals(";")) {
                this.kernelType = CIRCUIT_TYPE;
                this.processFormula = string;
                if (this.processFormula == null) {
                    this.processFormula = "";
                }
            } else {
                this.kernelType = NULL_TYPE;
            }
        }
        catch (ProcessSyntaxException processSyntaxException) {
            this.error(processSyntaxException.getInfoMessage());
        }
    }

    public void initIndexCircuit() {
        if (this.indexCircuit != null) {
            for (int i = 0; i < this.indexCircuit.length; ++i) {
                this.indexCircuit[i].createCircuit();
                this.indexCircuit[i].setKernelNumber(this.kernelNumber);
                this.indexCircuit[i].setScopeNumber(this.scopeNumber);
            }
        }
    }

    public void formatArray() {
        int[] nArray = new int[this.indexCircuit.length];
        for (int i = 0; i < this.indexCircuit.length; ++i) {
            ProcessUnit processUnit = this.indexCircuit[i].getRootProcessUnit();
            nArray[i] = (int)processUnit.getIntegerValue();
        }
        this.variable.setLength(nArray);
    }

    public boolean variableDeclaration(String string) {
        if (this.variableMade) {
            return false;
        }
        this.kernelType = VARIABLE_TYPE;
        ProcessCodeVariableConstructor processCodeVariableConstructor = new ProcessCodeVariableConstructor();
        ProcessCodeVariableForm processCodeVariableForm = processCodeVariableConstructor.construct(string, this.programInstance);
        processCodeVariableConstructor = null;
        if (processCodeVariableForm != null) {
            this.variable = processCodeVariableForm.unit;
            if (this.variable.arrayType) {
                this.array = true;
            }
            this.variable.setProcessEngine(this.processEngine);
            if (processCodeVariableForm.array) {
                this.indexCircuit = new ProcessCircuit[processCodeVariableForm.dimension];
                for (int i = 0; i < processCodeVariableForm.dimension; ++i) {
                    this.indexCircuit[i] = new ProcessCircuit(processCodeVariableForm.lengthFormula[i], 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
                    this.indexCircuit[i].setProgram(this.programInstance);
                    this.indexCircuit[i].setProcessKernel(this);
                }
            }
            this.processFormula = processCodeVariableForm.initFormula;
            this.variableMade = true;
            return true;
        }
        this.variableMade = true;
        return false;
    }

    public void addVariable(ProcessUnit[] processUnitArray) {
        for (int i = 0; i < processUnitArray.length; ++i) {
            this.addVariable(processUnitArray[i]);
        }
    }

    public void addVariable(ProcessUnit processUnit) {
        if (this.mainCircuit == null) {
            this.mainCircuit = new ProcessCircuit(this.programLine, 1024, this.kernelNumber, this.scopeNumber, this.processEngine);
            this.mainCircuit.setProgram(this.programInstance);
            this.mainCircuit.setProcessKernel(this);
            this.mainCircuit.createCircuit("");
        }
        this.mainCircuit.addVariable(processUnit);
        if (this.indexCircuit != null) {
            for (int i = 0; i < this.indexCircuit.length; ++i) {
                this.indexCircuit[i].addVariable(processUnit);
            }
        }
    }

    public ProcessCircuit getMainProcessCircuit() {
        return this.mainCircuit;
    }

    public void process() {
        if (this.kernelType == CIRCUIT_TYPE) {
            this.rootUnit.process();
        } else if (this.kernelType == VARIABLE_TYPE) {
            if (this.variable.arrayType) {
                this.formatArray();
            }
            this.rootUnit.process();
        }
    }

    public ProcessUnit call(ProcessUnit[] processUnitArray) {
        return null;
    }

    public void error(String string) {
        if (!this.errorDetection) {
            return;
        }
        this.error = true;
        this.errorInformation = string;
        this.errorMessage = this.getErrorMessage();
        if (this.processEngine != null) {
            this.processEngine.error(this.errorMessage);
        }
        if (this.parentScope != null) {
            this.parentScope.error(this.errorMessage);
            this.parentScope.breakRootScope();
        }
    }

    public boolean hasError() {
        return this.error;
    }

    public String getFileName() {
        if (this.lineAddressCode == null) {
            return "UNKNOWN";
        }
        String[] stringArray = this.lineAddressCode.split("@");
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return "UNKNOWN";
    }

    public String getLineIndex() {
        if (this.lineAddressCode == null) {
            return "???";
        }
        String[] stringArray = this.lineAddressCode.split("@");
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return "???";
    }

    public String getFileNameFromLineAddressCode() {
        if (this.lineAddressCode == null) {
            return null;
        }
        String[] stringArray = this.lineAddressCode.split("@");
        if (stringArray.length == 2) {
            String string = stringArray[1];
            String string2 = stringArray[0];
            return string;
        }
        return null;
    }

    public String getLineCodeFromLineAddressCode() {
        if (this.lineAddressCode == null) {
            return null;
        }
        String[] stringArray = this.lineAddressCode.split("@");
        if (stringArray.length == 2) {
            String string = stringArray[1];
            String string2 = stringArray[0];
            return string2;
        }
        return null;
    }

    public String getErrorMessage() {
        return this.getErrorMessage(this.errorInformation);
    }

    public String getErrorMessage(String string) {
        String string2;
        if (this.programLine == null) {
            this.programLine = "???";
        }
        if (0 <= this.programLine.indexOf("return=")) {
            string2 = this.programLine.replaceAll(" ", "");
            string2 = string2.replaceAll("\t", "");
            string2 = string2.replaceAll("\r", "");
            if ((string2 = string2.replaceAll("\n", "")).startsWith("return=")) {
                this.programLine = this.programLine.replaceFirst("return=", "return ");
            }
        }
        string2 = "";
        if (this.error) {
            Object object;
            String string3 = this.programLine;
            while (string3.startsWith(" ") || string3.startsWith("\t") || string3.startsWith("\u3000")) {
                string3 = string3.substring(1, string3.length());
            }
            if (0 <= string3.indexOf("SYSTEM_PROCESS")) {
                string3 = string3.replaceAll("SYSTEM_PROCESS_VARIABLE_TYPE_UNDEFINED ", "");
            }
            if (0 <= string3.indexOf("SYSTEM_PROCESS_CAUTION_SEMICOLON_NOT_FOUND")) {
                string3 = string3.replaceAll("SYSTEM_PROCESS_CAUTION_SEMICOLON_NOT_FOUND", "");
            }
            try {
                if (0 <= string3.indexOf("SYSTEM_PROCESS_ARRAY_INITIALIZER(")) {
                    object = string3.substring(string3.indexOf("INITIALIZER_CODE=") + 17, string3.length() - 2);
                    object = ((String)object).replaceAll("\\\\\"", "\"");
                    string3 = string3.substring(0, string3.indexOf("SYSTEM_PROCESS_ARRAY_INITIALIZER("));
                    string3 = string3 + (String)object + ";";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lineAddressCode == null) {
                if (ScriptProcessor.locale.isJapanese()) {
                    string2 = string2 + "[ \u5834\u6240 ] ???" + System.getProperty("line.separator");
                    string2 = string2 + "[ \u5185\u5bb9 ] " + string3 + System.getProperty("line.separator");
                } else {
                    string2 = string2 + "[ LINE ] ???" + System.getProperty("line.separator");
                    string2 = string2 + "[ CODE ] " + string3 + System.getProperty("line.separator");
                }
            } else {
                object = this.lineAddressCode.split("@");
                if (((String[])object).length == 2) {
                    String string4 = object[1];
                    Object object2 = object[0];
                    if (ScriptProcessor.locale.isJapanese()) {
                        string2 = string2 + "[ \u5834\u6240 ] " + string4 + " : " + (String)object2 + " \u884c\u76ee\u4ed8\u8fd1" + System.getProperty("line.separator");
                        string2 = string2 + "[ \u5185\u5bb9 ] " + string3 + System.getProperty("line.separator");
                    } else {
                        string2 = string2 + "[ LINE ] " + string4 + " : Near the line " + (String)object2 + "" + System.getProperty("line.separator");
                        string2 = string2 + "[ CODE ] " + string3 + System.getProperty("line.separator");
                    }
                } else if (((String[])object).length < 2) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        string2 = string2 + "[ \u5834\u6240 ] ???" + System.getProperty("line.separator");
                        string2 = string2 + "[ \u5185\u5bb9 ] " + string3 + System.getProperty("line.separator");
                    } else {
                        string2 = string2 + "[ LINE ] ???" + System.getProperty("line.separator");
                        string2 = string2 + "[ CODE ] " + string3 + System.getProperty("line.separator");
                    }
                } else if (2 < ((Object)object).length) {
                    Object object3 = object[((Object)object).length - 1];
                    String string5 = "";
                    for (int i = 0; i < ((Object)object).length - 1; ++i) {
                        string5 = string5 + (String)object[i];
                        if (i >= ((Object)object).length - 2) continue;
                        string5 = string5 + "@";
                    }
                    if (ScriptProcessor.locale.isJapanese()) {
                        string2 = string2 + "[ \u5834\u6240 ] " + (String)object3 + " : " + string5 + System.getProperty("line.separator");
                        string2 = string2 + "[ \u5185\u5bb9 ] " + string3 + System.getProperty("line.separator");
                    } else {
                        string2 = string2 + "[ LINE ] " + (String)object3 + " : " + string5 + System.getProperty("line.separator");
                        string2 = string2 + "[ CODE ] " + string3 + System.getProperty("line.separator");
                    }
                }
            }
            string2 = ScriptProcessor.locale.isJapanese() ? string2 + "[ \u8a73\u7d30 ] " : string2 + "[ INFO ] ";
            string2 = string2 + string;
            string2 = string2 + System.getProperty("line.separator");
        }
        return string2;
    }

    public ProcessCircuit getProcessCircuit() {
        return this.mainCircuit;
    }
}

