/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.object;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.decode.ProcessCodeGenericsTokenizer;
import rxvesapi.process.decode.ProcessCodeScopeConstructor;
import rxvesapi.process.decode.ProcessCodeScopeForm;
import rxvesapi.process.decode.ProcessCodeTokenReplacer;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.kernel.ScopeCallKernel;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.SIMDSubstitutionUnit;

public class ProcessStruct {
    private ProcessEngine engine;
    private String type;
    public ProcessUnit[] unit;
    public SIMDSubstitutionUnit[] substUnit;
    public ScopeCallKernel kernel;
    public ProcessScope scope;
    ProcessCodeScopeForm form;
    ProcessProgram programInstance;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 200;
    public static final int PROTECTED = 300;
    private int accessPermission = 1;
    private boolean generic = false;
    private String[] genericParameter;
    ProcessStruct[] genericStruct = null;

    public ProcessStruct getStruct(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (this.isGeneric()) {
            return this.getGeneric(stringArray);
        }
        return null;
    }

    public ProcessStruct(ProcessCodeScopeForm processCodeScopeForm, ProcessProgram processProgram, ProcessEngine processEngine) {
        this.engine = processEngine;
        this.form = processCodeScopeForm;
        this.type = processCodeScopeForm.name;
        this.programInstance = processProgram;
        this.setGenerics(this.type);
    }

    private void addGeneric(ProcessStruct processStruct) {
        int n;
        if (this.genericStruct == null) {
            this.genericStruct = new ProcessStruct[0];
        }
        int n2 = this.genericStruct.length;
        ProcessStruct[] processStructArray = new ProcessStruct[n2];
        for (n = 0; n < n2; ++n) {
            processStructArray[n] = this.genericStruct[n];
        }
        this.genericStruct = new ProcessStruct[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.genericStruct[n] = processStructArray[n];
        }
        processStructArray = null;
        this.genericStruct[n2] = processStruct;
    }

    public ProcessStruct getGeneric(String[] stringArray) {
        if (this.genericStruct != null) {
            int n = this.genericStruct.length;
            for (int i = 0; i < n; ++i) {
                if (!this.genericStruct[i].isProcessableGeneric(stringArray)) continue;
                return this.genericStruct[i];
            }
        }
        ProcessStruct processStruct = this.generateGeneric(stringArray);
        this.addGeneric(processStruct);
        return processStruct;
    }

    public boolean isProcessableGeneric(String[] stringArray) {
        int n = stringArray.length;
        if (n != this.genericParameter.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals(this.genericParameter[i])) continue;
            return false;
        }
        return true;
    }

    public ProcessStruct generateGeneric(String[] stringArray) {
        if (stringArray.length != this.genericParameter.length) {
            return null;
        }
        ProcessCodeScopeForm processCodeScopeForm = new ProcessCodeScopeForm();
        processCodeScopeForm.name = this.type;
        String string = this.form.program;
        processCodeScopeForm.program = string = ProcessCodeTokenReplacer.replaceTokens(string, this.genericParameter, stringArray);
        ProcessStruct processStruct = new ProcessStruct(processCodeScopeForm, this.programInstance, this.engine);
        processStruct.setGenericType(stringArray);
        processStruct.ready();
        return processStruct;
    }

    public void setGenericType(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        this.genericParameter = stringArray2;
    }

    public void setAccessPermission(int n) {
        this.accessPermission = n;
    }

    public void setAccessPermission(String string) {
        if (string.equals("public")) {
            this.accessPermission = 1;
        }
        if (string.equals("private")) {
            this.accessPermission = 200;
        }
        if (string.equals("protected")) {
            this.accessPermission = 300;
        }
    }

    public int getAccessPermission() {
        return this.accessPermission;
    }

    public void setGenerics(String string) {
        if (0 <= string.indexOf("<")) {
            this.generic = true;
            this.genericParameter = ProcessCodeGenericsTokenizer.getTopLevelParameters(string);
            this.type = this.type.substring(0, this.type.indexOf("<"));
        }
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public SIMDSubstitutionUnit[] getSubstitutionUnit() {
        return this.substUnit;
    }

    public ProcessProgram getProcessProgram() {
        return this.programInstance;
    }

    public void ready() {
        if (!this.isGeneric()) {
            int n;
            String string = this.form.program;
            ProcessCodeScopeConstructor processCodeScopeConstructor = new ProcessCodeScopeConstructor(this.engine, this.programInstance);
            this.kernel = processCodeScopeConstructor.constructScope(this.form);
            this.scope = this.kernel.getProcessScope();
            ProcessKernel[] processKernelArray = this.scope.getProcessKernel();
            int n2 = 0;
            for (n = 0; n < processKernelArray.length; ++n) {
                if (processKernelArray[n].getKernelType() == ProcessKernel.VARIABLE_TYPE) {
                    ++n2;
                    continue;
                }
                processKernelArray[n].error(new ProcessSyntaxException(this.engine).getInfo(8));
            }
            this.unit = new ProcessUnit[n2];
            this.substUnit = new SIMDSubstitutionUnit[n2];
            n = 0;
            for (int i = 0; i < processKernelArray.length; ++i) {
                if (processKernelArray[i].getKernelType() != ProcessKernel.VARIABLE_TYPE) continue;
                this.unit[n] = processKernelArray[i].getVariable();
                this.substUnit[n] = new SIMDSubstitutionUnit(new ProcessUnit[]{this.unit[n], null}, this.engine);
                ++n;
            }
        }
    }

    public void initMemberVariable() {
        block8: {
            int n;
            block7: {
                if (!this.generic) break block7;
                if (this.genericStruct == null) break block8;
                int n2 = this.genericStruct.length;
                for (int i = 0; i < n2; ++i) {
                    this.genericStruct[i].initMemberVariable();
                }
                break block8;
            }
            this.scope.ready();
            ProcessKernel[] processKernelArray = this.scope.getProcessKernel();
            int n3 = 0;
            for (n = 0; n < processKernelArray.length; ++n) {
                if (processKernelArray[n].getKernelType() != ProcessKernel.VARIABLE_TYPE) continue;
                processKernelArray[n].ready();
                if (this.unit[n3].isConst()) {
                    processKernelArray[n].error(new ProcessSyntaxException(this.engine).getInfo(9));
                }
                if (processKernelArray[n].getKernelType() == ProcessKernel.VARIABLE_TYPE && processKernelArray[n].isArray()) {
                    processKernelArray[n].initIndexCircuit();
                    processKernelArray[n].formatArray();
                }
                if (processKernelArray[n].isVariableInitialized() && !processKernelArray[n].initConstOnly()) {
                    processKernelArray[n].error(new ProcessSyntaxException(this.engine).getInfo(10));
                }
                if (processKernelArray[n].isArray() && !processKernelArray[n].initConstOnly()) {
                    processKernelArray[n].error(new ProcessSyntaxException(this.engine).getInfo(10));
                }
                processKernelArray[n].process();
                ++n3;
            }
            for (n = 0; n < this.unit.length; ++n) {
                if (this.unit[n].getValueType() != 200 || this.unit[n].isArrayType() && this.unit[n].getCapacity() == 0) continue;
                this.unit[n].setDefaulted(false);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public ProcessUnit[] getVariable() {
        return this.unit;
    }

    public ProcessUnit createInstance() {
        return null;
    }

    public int getVariableIndex(String string) {
        int n = this.getVariable().length;
        for (int i = 0; i < n; ++i) {
            if (this.getVariable()[i] == null || !this.getVariable()[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }
}

