/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.system.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.kernel.ExternalFunctionCallKernel;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StringUnit;

public class Function_sround
extends ExternalFunctionCallKernel {
    private static final int SIG_UP = 1;
    private static final int SIG_DOWN = 2;
    private static final int SIG_HALF_UP = 3;
    private static final int SIG_HALF_DOWN = 4;
    private static final int SIG_HALF_TO_EVEN = 5;
    private static final int DEC_UP = 21;
    private static final int DEC_DOWN = 22;
    private static final int DEC_HALF_UP = 23;
    private static final int DEC_HALF_DOWN = 24;
    private static final int DEC_HALF_TO_EVEN = 25;
    public ProcessEngine processEngine;

    public Function_sround(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.argumentUnit = new ProcessUnit[3];
        this.argumentUnit[0] = new StringUnit();
        this.argumentUnit[1] = new IntegerUnit();
        this.argumentUnit[2] = new IntegerUnit();
        this.returnUnit = new StringUnit();
        this.setFunctionName("___sround");
    }

    private RoundingMode toRoundingMode(int n) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                if (n == 1) break block10;
                                                if (n != 21) break block11;
                                            }
                                            return RoundingMode.UP;
                                        }
                                        if (n == 2) break block12;
                                        if (n != 22) break block13;
                                    }
                                    return RoundingMode.DOWN;
                                }
                                if (n == 3) break block14;
                                if (n != 23) break block15;
                            }
                            return RoundingMode.HALF_UP;
                        }
                        if (n == 4) break block16;
                        if (n != 24) break block17;
                    }
                    return RoundingMode.HALF_DOWN;
                }
                if (n == 5) break block18;
                if (n != 25) break block19;
            }
            return RoundingMode.HALF_EVEN;
        }
        return null;
    }

    private boolean isFixed(int n) {
        block11: {
            block10: {
                block9: {
                    block8: {
                        if (n == 21) break block8;
                        if (n == 22) break block8;
                        if (n == 23) break block8;
                        if (n == 24) break block8;
                        if (n != 25) break block9;
                    }
                    return true;
                }
                if (n == 1) break block10;
                if (n == 2) break block10;
                if (n == 3) break block10;
                if (n == 4) break block10;
                if (n != 5) break block11;
            }
            return false;
        }
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u4e38\u3081\u30e2\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\uff1a" + n);
        } else {
            this.error("Unsupported rounding-mode:" + n);
        }
        return false;
    }

    @Override
    public void call() {
        String string = this.argumentUnit[0].getStringValue();
        int n = (int)this.argumentUnit[1].getIntegerValue();
        int n2 = (int)this.argumentUnit[2].getIntegerValue();
        String string2 = null;
        BigDecimal bigDecimal = new BigDecimal(string);
        RoundingMode roundingMode = this.toRoundingMode(n2);
        if (this.isFixed(n2)) {
            bigDecimal = bigDecimal.setScale(n, roundingMode);
        } else {
            MathContext mathContext = new MathContext(n, roundingMode);
            bigDecimal = bigDecimal.round(mathContext);
        }
        string2 = bigDecimal.toString();
        if (string2.toUpperCase().contains("E+")) {
            string2 = string2.replace("E+", "E");
            string2 = string2.replace("e+", "e");
        }
        this.returnUnit.setStringValue(string2);
    }
}

