/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.thread;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;

public class ThreadProcessEngine
implements Runnable {
    Thread thread = null;
    int id = -1;
    ProcessEngine engine;
    ProcessUnit[] runArgUnit;
    FunctionCallKernel[] runKernel;
    FunctionCallUnit[] runUnit;
    boolean runEventInited = false;
    ProcessUnit[] terminateArgUnit;
    FunctionCallKernel[] terminateKernel;
    FunctionCallUnit[] terminateUnit;
    boolean terminateEventInited = false;

    public ThreadProcessEngine(int n, ProcessEngine processEngine) {
        this.engine = processEngine;
        this.id = n;
    }

    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        this.thread = null;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.runEventCall(this.id);
            this.terminateEventCall(this.id);
            this.thread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sleep(int n, int n2) {
        try {
            Thread.sleep(n, n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void join(int n) {
        try {
            this.thread.join(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void join(int n, int n2) {
        try {
            this.thread.join(n, n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void runEvent() {
        if (!this.runEventInited) {
            this.runArgUnit = new ProcessUnit[1];
            this.runArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.runKernel = this.engine.getAllFunctionCallKernel("onThreadStart");
            if (this.runKernel != null) {
                this.runUnit = new FunctionCallUnit[this.runKernel.length];
                for (int i = 0; i < this.runKernel.length; ++i) {
                    this.runUnit[i] = new FunctionCallUnit(this.runArgUnit, this.runKernel[i], this.engine);
                    this.runUnit[i].setProcessKernel(this.runKernel[i]);
                }
            }
            this.runEventInited = true;
        }
    }

    public void runEventCall(int n) {
        this.runEvent();
        if (this.runKernel != null) {
            this.runArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.runKernel.length; ++i) {
                this.runUnit[i].process();
            }
        }
    }

    void terminateEvent() {
        if (!this.terminateEventInited) {
            this.terminateArgUnit = new ProcessUnit[1];
            this.terminateArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.terminateKernel = this.engine.getAllFunctionCallKernel("onThreadEnd");
            if (this.terminateKernel != null) {
                this.terminateUnit = new FunctionCallUnit[this.terminateKernel.length];
                for (int i = 0; i < this.terminateKernel.length; ++i) {
                    this.terminateUnit[i] = new FunctionCallUnit(this.terminateArgUnit, this.terminateKernel[i], this.engine);
                    this.terminateUnit[i].setProcessKernel(this.terminateKernel[i]);
                }
            }
            this.terminateEventInited = true;
        }
    }

    public void terminateEventCall(int n) {
        this.terminateEvent();
        if (this.terminateKernel != null) {
            this.terminateArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.terminateKernel.length; ++i) {
                this.terminateUnit[i].process();
            }
        }
    }
}

