/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigInteger;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class BigIntegerUnit
extends ProcessUnit {
    public BigIntegerUnit() {
        this.bigIntegerValue = BigInteger.ZERO;
        this.valueType = 104;
        this.nodeType = 200;
    }

    public BigIntegerUnit(String string, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.valueType = 104;
        this.nodeType = 200;
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\t", "");
        string = string.replaceAll("\u3000", "");
        this.bigIntegerValue = new BigInteger(string);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.bigIntegerValue;
    }

    @Override
    public void increment() {
        this.bigIntegerValue = this.bigIntegerValue.add(bi_one);
    }

    @Override
    public void decrement() {
        this.bigIntegerValue = this.bigIntegerValue.subtract(bi_one);
    }

    @Override
    public String getFormula() {
        if (this.isConst()) {
            if (this.bigIntegerValue.compareTo(new BigInteger("0")) < 0) {
                return "(" + this.bigIntegerValue.toString() + ")";
            }
            return this.bigIntegerValue.toString() + "vi";
        }
        return this.name;
    }

    @Override
    public String getFormula(int n) {
        if (this.isConst()) {
            return this.getFormula();
        }
        return this.name;
    }
}

