/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class DecimalUnit
extends ProcessUnit {
    public DecimalUnit() {
        this.valueType = 100;
        this.nodeType = 200;
    }

    public DecimalUnit(double d, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.valueType = 100;
        this.nodeType = 200;
        this.decimalValue = d;
    }

    public DecimalUnit(String string, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.valueType = 100;
        this.nodeType = 200;
        this.decimalValue = d;
    }

    @Override
    public final double getDecimalValue() {
        return this.decimalValue;
    }

    @Override
    public final long getIntegerValue() {
        return (long)this.decimalValue;
    }

    @Override
    public final void increment() {
        this.decimalValue += 1.0;
    }

    @Override
    public final void decrement() {
        this.decimalValue -= 1.0;
    }

    @Override
    public String getFormula() {
        if (this.isConst()) {
            if (this.decimalValue < 0.0) {
                return "(" + Double.toString(this.decimalValue) + ")";
            }
            return Double.toString(this.decimalValue);
        }
        return this.name;
    }

    @Override
    public String getFormula(int n) {
        if (this.isConst()) {
            return Double.toString(this.decimalValue);
        }
        return this.name;
    }
}

