/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StructUnit;

public class EqualUnit
extends ProcessUnit {
    private boolean arrayNullProcess = false;

    public EqualUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        int n;
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setType();
        this.setValueType(105);
        this.arrayType = false;
        boolean bl = false;
        for (n = 0; n < this.inputUnit.length; ++n) {
            if (this.inputUnit[n].getValueType() != -100) continue;
            bl = true;
        }
        for (n = 0; n < this.inputUnit.length; ++n) {
            if (!this.inputUnit[n].isArrayType()) continue;
            if (bl) {
                // empty if block
            }
            this.arrayType = true;
            this.dimension = this.inputUnit[n].getDimension();
            this.length = this.inputUnit[n].getLength();
            this.capacity = this.inputUnit[n].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayNullProcess) {
            this.nullArrayProcess();
        } else if (this.arrayType) {
            if (this.getInputType() == 105) {
                this.booleanArrayProcess();
            } else if (this.getInputType() == 101) {
                this.integerArrayProcess();
            } else if (this.getInputType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getInputType() == 140) {
                this.complexArrayProcess();
            } else if (this.getInputType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getInputType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getInputType() == 141) {
                this.bigComplexArrayProcess();
            } else if (this.getInputType() == 102) {
                this.stringArrayProcess();
            } else if (this.getInputType() == 200) {
                this.structArrayProcess();
            } else if (this.getInputType() == Integer.MAX_VALUE) {
                this.unknownArrayProcess();
            } else {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u3048\u306a\u3044\u578b\u3067\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot perform comparison operation on unsupported data types." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
        } else if (this.getInputType() == 105) {
            this.booleanProcess();
        } else if (this.getInputType() == 101) {
            this.integerProcess();
        } else if (this.getInputType() == 100) {
            this.decimalProcess();
        } else if (this.getInputType() == 140) {
            this.complexProcess();
        } else if (this.getInputType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getInputType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getInputType() == 141) {
            this.bigComplexProcess();
        } else if (this.getInputType() == 102) {
            this.stringProcess();
        } else if (this.getInputType() == 200) {
            this.structProcess();
        } else if (this.getInputType() == Integer.MAX_VALUE) {
            this.unknownProcess();
        } else {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u3048\u306a\u3044\u578b\u3067\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot perform comparison operation on unsupported data types." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
    }

    private void unknownProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u4f55\u3089\u304b\u306e\u539f\u56e0\u306b\u3088\u308a\u3001\u6bd4\u8f03\u6f14\u7b97\u30e6\u30cb\u30c3\u30c8\u5165\u529b\u5024\u306e\u5909\u6570\u578b\u304c\u672a\u8a2d\u5b9a\u306e\u72b6\u614b\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) The comparison operation unit is uninitialized." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    private void unknownArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\uff08\u5185\u90e8\u30a8\u30e9\u30fc\uff09\u4f55\u3089\u304b\u306e\u539f\u56e0\u306b\u3088\u308a\u3001\u6bd4\u8f03\u6f14\u7b97\u30e6\u30cb\u30c3\u30c8\u5165\u529b\u5024\u306e\u5909\u6570\u578b\u304c\u672a\u8a2d\u5b9a\u306e\u72b6\u614b\u3067\u3059\u3002" + System.getProperty("line.separator") : this.errorMessage + "(Internal Error) The comparison operation unit is uninitialized." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    public void nullArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (!this.inputUnit[i].isArrayType() || this.inputUnit[i].isArrayNull()) continue;
            this.booleanValue = false;
        }
    }

    private void booleanArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getBooleanValue() == this.inputUnit[i + 1].getBooleanValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void integerArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getIntegerValue() == this.inputUnit[i + 1].getIntegerValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void decimalArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getDecimalValue() == this.inputUnit[i + 1].getDecimalValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void complexArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            double[] dArray = this.inputUnit[i].getComplexValue();
            double[] dArray2 = this.inputUnit[i + 1].getComplexValue();
            if (dArray[0] == dArray2[0] && dArray[1] == dArray2[1]) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigIntegerArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getBigIntegerValue().compareTo(this.inputUnit[i + 1].getBigIntegerValue()) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigDecimalArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            if (this.inputUnit[i].getBigDecimalValue().compareTo(this.inputUnit[i + 1].getBigDecimalValue()) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigComplexArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            BigDecimal[] bigDecimalArray = this.inputUnit[i].getBigComplexValue();
            BigDecimal[] bigDecimalArray2 = this.inputUnit[i + 1].getBigComplexValue();
            if (bigDecimalArray[0].compareTo(bigDecimalArray2[0]) == 0 && bigDecimalArray[1].compareTo(bigDecimalArray2[1]) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void stringArrayProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.inputUnit[i + 1].index = this.index;
            this.inputUnit[i + 1].setIndexedValue();
            String string = this.inputUnit[i].getStringValue();
            String string2 = this.inputUnit[i + 1].getStringValue();
            if (string == null && string2 == null) continue;
            if (string == null || string2 == null) {
                this.booleanValue = false;
                return;
            }
            if (string.equals(string2)) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void structArrayProcess() {
        this.booleanValue = true;
        int n = this.inputUnit[0].getValueType();
        int n2 = this.inputUnit[1].getValueType();
        if (n == -100 || n2 == -100) {
            if (this.inputUnit[0].isArrayType()) {
                this.inputUnit[0].index = this.index;
                this.inputUnit[0].setIndexedValue();
            } else {
                this.inputUnit[1].index = this.index;
                this.inputUnit[1].setIndexedValue();
            }
            if (!(this.inputUnit[0].getStructValue() != null && this.inputUnit[0].getStructValue().getMemberVariable() != null || this.inputUnit[1].getStructValue() != null && this.inputUnit[1].getStructValue().getMemberVariable() != null)) {
                this.setBooleanValue(true);
                return;
            }
            this.setBooleanValue(false);
            return;
        }
        if (n == 200 && n2 == 200 && this.inputUnit[0].getStruct() == this.inputUnit[1].getStruct()) {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            this.inputUnit[1].index = this.index;
            this.inputUnit[1].setIndexedValue();
            boolean bl = StructUnit.isNullInputtedStructUnit(this.inputUnit[0]);
            boolean bl2 = StructUnit.isNullInputtedStructUnit(this.inputUnit[1]);
            if (bl && bl2) {
                this.setBooleanValue(true);
            } else if (bl || bl2) {
                this.setBooleanValue(false);
            } else {
                this.setBooleanValue(this.inputUnit[0].equalsMember(this.inputUnit[1]));
            }
        } else if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u3048\u306a\u3044\u578b\u3067\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002");
        } else {
            this.error("Cannot perform comparison operation on unsupported data types.");
        }
    }

    private void booleanProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getBooleanValue() == this.inputUnit[i + 1].getBooleanValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void integerProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getIntegerValue() == this.inputUnit[i + 1].getIntegerValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void decimalProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getDecimalValue() == this.inputUnit[i + 1].getDecimalValue()) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void complexProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            double[] dArray;
            double[] dArray2 = this.inputUnit[i].getComplexValue();
            if (dArray2[0] == (dArray = this.inputUnit[i + 1].getComplexValue())[0] && dArray2[1] == dArray[1]) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigIntegerProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getBigIntegerValue().compareTo(this.inputUnit[i + 1].getBigIntegerValue()) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigDecimalProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            if (this.inputUnit[i].getBigDecimalValue().compareTo(this.inputUnit[i + 1].getBigDecimalValue()) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void bigComplexProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            BigDecimal[] bigDecimalArray;
            BigDecimal[] bigDecimalArray2 = this.inputUnit[i].getBigComplexValue();
            if (bigDecimalArray2[0].compareTo((bigDecimalArray = this.inputUnit[i + 1].getBigComplexValue())[0]) == 0 && bigDecimalArray2[1].compareTo(bigDecimalArray[1]) == 0) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void stringProcess() {
        this.booleanValue = true;
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            String string = this.inputUnit[i].getStringValue();
            String string2 = this.inputUnit[i + 1].getStringValue();
            if (string == null && string2 == null) continue;
            if (string == null || string2 == null) {
                this.booleanValue = false;
                return;
            }
            if (string.equals(string2)) continue;
            this.booleanValue = false;
            return;
        }
    }

    private void structProcess() {
        this.booleanValue = true;
        int n = this.inputUnit[0].getValueType();
        int n2 = this.inputUnit[1].getValueType();
        if (n == -100 || n2 == -100) {
            if (n2 == -100 && (this.inputUnit[0].getStructValue() == null || this.inputUnit[0].getStructValue().getMemberVariable() == null)) {
                this.setBooleanValue(true);
                return;
            }
            if (n == -100 && (this.inputUnit[1].getStructValue() == null || this.inputUnit[1].getStructValue().getMemberVariable() == null)) {
                this.setBooleanValue(true);
                return;
            }
            this.setBooleanValue(false);
            return;
        }
        if (n == 200 && n2 == 200 && this.inputUnit[0].getStruct() == this.inputUnit[1].getStruct()) {
            boolean bl = StructUnit.isNullInputtedStructUnit(this.inputUnit[0]);
            boolean bl2 = StructUnit.isNullInputtedStructUnit(this.inputUnit[1]);
            if (bl && bl2) {
                this.setBooleanValue(true);
            } else if (bl || bl2) {
                this.setBooleanValue(false);
            } else {
                this.setBooleanValue(this.inputUnit[0].equalsMember(this.inputUnit[1]));
            }
        } else if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u3048\u306a\u3044\u578b\u3067\u3001\u6bd4\u8f03\u6f14\u7b97\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002");
        } else {
            this.error("Cannot perform comparison operation on unsupported data types.");
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "==";
        }
        string = n == this.getRank() + 1 ? string + " = " + this.getStringValue() + " ]" : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

