/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class MinusUnit
extends ProcessUnit {
    public MinusUnit(ProcessUnit processUnit, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = new ProcessUnit[]{processUnit};
        this.nodeType = 201;
        this.setValueType(this.inputUnit[0].getValueType());
        this.arrayType = false;
        if (this.inputUnit[0].isArrayType()) {
            this.arrayType = true;
            this.dimension = this.inputUnit[0].getDimension();
            this.length = this.inputUnit[0].getLength();
            this.capacity = this.inputUnit[0].getCapacity();
        }
    }

    @Override
    public void setIndexedValue() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
    }

    @Override
    public void setLength(int[] nArray) {
        this.inputUnit[0].setLength(nArray);
    }

    @Override
    public int[] getLength() {
        if (this.inputUnit[0].isArrayType()) {
            this.length = this.inputUnit[0].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        this.inputUnit[0].operateArray();
    }

    @Override
    public void process() {
        this.inputUnit[0].process();
    }

    @Override
    public long getIntegerValue() {
        return -this.inputUnit[0].getIntegerValue();
    }

    @Override
    public double getDecimalValue() {
        return -this.inputUnit[0].getDecimalValue();
    }

    @Override
    public double[] getComplexValue() {
        double[] dArray = this.inputUnit[0].getComplexValue();
        dArray[0] = -dArray[0];
        dArray[1] = -dArray[1];
        return dArray;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.inputUnit[0].getBigIntegerValue().negate();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return this.inputUnit[0].getBigDecimalValue().negate();
    }

    @Override
    public BigDecimal[] getBigComplexValue() {
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue();
        bigDecimalArray[0] = bigDecimalArray[0].negate();
        bigDecimalArray[1] = bigDecimalArray[1].negate();
        return bigDecimalArray;
    }

    @Override
    public String getStringValue() {
        if (this.getValueType() == 101) {
            return Long.toString(this.getIntegerValue());
        }
        if (this.getValueType() == 100) {
            return Double.toString(this.getDecimalValue());
        }
        if (this.getValueType() == 140) {
            double[] dArray = this.getComplexValue();
            return "(" + dArray[0] + "," + dArray[1] + ")";
        }
        if (this.getValueType() == 104) {
            return this.getBigIntegerValue().toString();
        }
        if (this.getValueType() == 103) {
            return this.getBigDecimalValue().toString();
        }
        if (this.getValueType() == 141) {
            BigDecimal[] bigDecimalArray = this.getBigComplexValue();
            return "(" + bigDecimalArray[0].toString() + "," + bigDecimalArray[1].toString() + ")";
        }
        if (this.getValueType() == 102) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u8ca0\u306e\u6587\u5b57\u5217\u306f\u6271\u3048\u307e\u305b\u3093\u3002");
            } else {
                this.error("Cannot handle a \"negative\" string.");
            }
            return null;
        }
        if (this.getValueType() == 200) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u8ca0\u306e\u69cb\u9020\u4f53\u306f\u6271\u3048\u307e\u305b\u3093\u3002");
            } else {
                this.error("Cannot handle a \"negative\" struct.");
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean getBooleanValue() {
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("bool\u578b\u306b\u6f14\u7b97\u5b50\u300c-\u300d\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
        } else {
            this.error("Cannot perform \"-\" operations to bool type values.");
        }
        return false;
    }

    @Override
    public synchronized long getIntegerValue(int n) {
        return -this.inputUnit[0].getIntegerValue(n);
    }

    @Override
    public synchronized double getDecimalValue(int n) {
        return -this.inputUnit[0].getDecimalValue(n);
    }

    @Override
    public synchronized double[] getComplexValue(int n) {
        double[] dArray = this.inputUnit[0].getComplexValue(n);
        dArray[0] = -dArray[0];
        dArray[1] = -dArray[1];
        return dArray;
    }

    @Override
    public BigInteger getBigIntegerValue(int n) {
        return this.inputUnit[0].getBigIntegerValue(n).negate();
    }

    @Override
    public BigDecimal getBigDecimalValue(int n) {
        return this.inputUnit[0].getBigDecimalValue(n).negate();
    }

    @Override
    public BigDecimal[] getBigComplexValue(int n) {
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue(n);
        bigDecimalArray[0] = bigDecimalArray[0].negate();
        bigDecimalArray[1] = bigDecimalArray[1].negate();
        return bigDecimalArray;
    }

    @Override
    public String getStringValue(int n) {
        if (this.getValueType() == 101) {
            return Long.toString(this.getIntegerValue(n));
        }
        if (this.getValueType() == 100) {
            return Double.toString(this.getDecimalValue(n));
        }
        if (this.getValueType() == 140) {
            double[] dArray = this.getComplexValue(n);
            return "(" + dArray[0] + "," + dArray[1] + ")";
        }
        if (this.getValueType() == 104) {
            return this.getBigIntegerValue(n).toString();
        }
        if (this.getValueType() == 103) {
            return this.getBigDecimalValue(n).toString();
        }
        if (this.getValueType() == 141) {
            BigDecimal[] bigDecimalArray = this.getBigComplexValue(n);
            return "(" + bigDecimalArray[0].toString() + "," + bigDecimalArray[1].toString() + ")";
        }
        if (this.getValueType() == 102) {
            this.error("\u8ca0\u306e\u6587\u5b57\u5217\u306f\u6271\u3048\u307e\u305b\u3093\u3002");
            return null;
        }
        if (this.getValueType() == 200) {
            this.error("\u8ca0\u306e\u69cb\u9020\u4f53\u306f\u6271\u3048\u307e\u305b\u3093\u3002");
            return null;
        }
        return null;
    }

    @Override
    public boolean getBooleanValue(int n) {
        this.error("bool\u578b\u306b\u6f14\u7b97\u5b50\u300c-\u300d\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
        return false;
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string = "";
        if (n == this.getRank() + 1) {
            string = "[ ";
            string = string + this.getStringValue();
            string = string + " ]";
        } else {
            string = string + "-" + this.inputUnit[0].getFormula(n);
        }
        return string;
    }
}

