/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ProcessUnitBigDecimalCore;

public class ProcessUnit {
    public ProcessKernel kernel;
    public ProcessUnit[] inputUnit;
    public ProcessEngine processEngine;
    public ProcessUnit inputUnit0;
    public ProcessUnit inputUnit1;
    public ProcessUnit inputUnit2;
    public String errorMessage = null;
    public String id = null;
    public String name = null;
    public boolean automaticProcess = true;
    public static final BigInteger bi_ten = new BigInteger("10");
    public static final BigInteger bi_zero = new BigInteger("0");
    public static final BigInteger bi_one = new BigInteger("1");
    public static final BigDecimal bd_ten = new BigDecimal("1E1");
    public static final BigDecimal bd_one_over_ten = new BigDecimal("1E-1");
    public static final BigDecimal bd_zero = new BigDecimal("0.0");
    public static final BigDecimal bd_one = new BigDecimal("1.0");
    public static final int PUBLIC = 100;
    public static final int PRIVATE = 200;
    public static final int PROTECTED = 300;
    public int accessPermission = 100;
    public long integerValue = 0L;
    public double decimalValue = 0.0;
    public BigInteger bigIntegerValue;
    public BigDecimal bigDecimalValue;
    public String stringValue = "";
    public boolean booleanValue = false;
    private double[] complexValue;
    private BigDecimal[] bigComplexValue;
    public static final int NULL_INTEGER_TYPE = -100;
    public static final int UNKNOWN_TYPE = Integer.MAX_VALUE;
    public static final int DECIMAL_TYPE = 100;
    public static final int INTEGER_TYPE = 101;
    public static final int STRING_TYPE = 102;
    public static final int BIGDECIMAL_TYPE = 103;
    public static final int BIGINTEGER_TYPE = 104;
    public static final int BOOLEAN_TYPE = 105;
    public static final int VAR_TYPE = 106;
    public static final int COMPLEX_TYPE = 140;
    public static final int BIGCOMPLEX_TYPE = 141;
    public static final int STRUCT_TYPE = 200;
    public boolean arrayType = false;
    public static final int STANDARD_PROCESS = 10001;
    public int valueType = Integer.MAX_VALUE;
    public int inputType = Integer.MAX_VALUE;
    public static final int VALUE_TYPE = 200;
    public static final int FUNCTION_TYPE = 201;
    public int nodeType = 200;
    public static final int STANDARD_TYPE = 10001;
    public static final int ARRAY_ACCESS_TYPE = 10002;
    public int specialType = 10001;
    public int rank = 0;
    public boolean valueLock = false;
    public boolean typeLock = false;
    public long operator = 0L;
    public int capacity;
    public int index = 0;
    public int dimension;
    public int[] length;
    public boolean processPermission = true;
    ProcessUnitBigDecimalCore bigDecimalCore = null;

    public void throwError(String string) {
        this.errorMessage = string;
        this.error(string);
        throw new ProcessRuntimeException();
    }

    public boolean isDefaulted() {
        return false;
    }

    public void setDefaulted(boolean bl) {
    }

    public boolean isArrayNull() {
        return false;
    }

    public void initialize() {
    }

    public int getArrayDimension() {
        return this.dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getArrayLength(int n) {
        if (0 <= n && n <= this.dimension) {
            return this.length[n - 1];
        }
        if (this.errorMessage == null) {
            this.errorMessage = "";
        }
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "" + this.dimension + "\u6b21\u5143\u914d\u5217\u300c" + this.name + "\u300d\u306b\u5bfe\u3057\u3066\u3001" + n + "\u6b21\u5143\u30a2\u30af\u30bb\u30b9\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot access to " + this.dimension + "-dimensional array \"" + this.name + "\" with " + n + "-dimensional indices." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        return 0;
    }

    public boolean isMemberInitialized() {
        return false;
    }

    public boolean isUniversalRank() {
        return false;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setArrayType(boolean bl) {
        this.arrayType = bl;
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    public void alloc(int[] nArray) {
    }

    public void free() {
    }

    public void indexedFree() {
    }

    public void indexedAlloc(int[] nArray) {
    }

    public long countOperator() {
        if (this.nodeType == 200) {
            this.operator = 0L;
            return 0L;
        }
        if (this.inputUnit == null) {
            this.operator = 0L;
            return 0L;
        }
        long l = 0L;
        if ((l += (long)(this.inputUnit.length - 1)) < 0L) {
            l = 0L;
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (this.inputUnit[i] == null) continue;
            l += this.inputUnit[i].countOperator();
        }
        this.operator = l;
        return l;
    }

    public int getAccessPermission() {
        return this.accessPermission;
    }

    public void setAccessPermission(int n) {
        this.accessPermission = n;
    }

    public void setReference(ProcessUnit processUnit) {
        if (this.errorMessage == null) {
            this.errorMessage = "";
        }
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5909\u6570\u300c " + this.name + " \u300d\u306e\u53c2\u7167\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot change the reference to the variable \"" + this.name + "\"" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    public ProcessUnit getReference() {
        return this;
    }

    public int stringToValueType(String string, boolean bl) {
        if (string == null) {
            return Integer.MAX_VALUE;
        }
        if (string.equals("float") || string.equals("double")) {
            return 100;
        }
        if (string.equals("int") || string.equals("long")) {
            return 101;
        }
        if (string.equals("string")) {
            return 102;
        }
        if (string.equals("varfloat")) {
            return 103;
        }
        if (string.equals("varint")) {
            return 104;
        }
        if (string.equals("bool") || string.equals("boolean")) {
            return 105;
        }
        if (string.equals("complex")) {
            return 140;
        }
        if (string.equals("varcomplex")) {
            return 141;
        }
        if (bl || this.processEngine.getStructByType(string) != null) {
            return 105;
        }
        return Integer.MAX_VALUE;
    }

    public String valueTypeToString(int n) {
        if (n == 100) {
            return "float";
        }
        if (n == 101) {
            return "int";
        }
        if (n == 103) {
            return "varfloat";
        }
        if (n == 104) {
            return "varint";
        }
        if (n == 105) {
            return "bool";
        }
        if (n == 102) {
            return "string";
        }
        if (n == 140) {
            return "complex";
        }
        if (n == 141) {
            return "varcomplex";
        }
        if (n == 200) {
            return "struct";
        }
        return null;
    }

    public static int stringToValueType(String string) {
        if (string == null) {
            return Integer.MAX_VALUE;
        }
        if (string.equals("float") || string.equals("double")) {
            return 100;
        }
        if (string.equals("int") || string.equals("long")) {
            return 101;
        }
        if (string.equals("string")) {
            return 102;
        }
        if (string.equals("varfloat")) {
            return 103;
        }
        if (string.equals("varint")) {
            return 104;
        }
        if (string.equals("bool") || string.equals("boolean")) {
            return 105;
        }
        if (string.equals("complex")) {
            return 140;
        }
        if (string.equals("varcomplex")) {
            return 141;
        }
        return Integer.MAX_VALUE;
    }

    public void upRefreshInformation() {
    }

    public void downRefreshInformation() {
    }

    public void reloadInputUnit() {
    }

    public void setProcessKernel(ProcessKernel processKernel) {
        this.kernel = processKernel;
    }

    public void error(String string) {
        if (this.kernel != null) {
            this.processEngine.errorWaitFor = true;
            ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
            this.kernel.error(string);
            throw processRuntimeException;
        }
        if (this.processEngine == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                System.err.println("\u4f55\u3089\u304b\u306e\u539f\u56e0\u306b\u3088\u308a\u3001\u30a8\u30f3\u30b8\u30f3\u306b\u30a8\u30e9\u30fc\u60c5\u5831\u3092\u6e21\u305b\u306a\u304b\u3063\u305f\u305f\u3081\u3001\u6a19\u6e96\u30a8\u30e9\u30fc\u51fa\u529b\u306b\u30a8\u30e9\u30fc\u3092\u51fa\u529b\u3057\u307e\u3059\uff1a" + string);
            } else {
                System.err.println("Failed to pass the error information to the engine, so printing it to the standard-error ourput:" + string);
            }
        }
        this.processEngine.error(string);
    }

    void throwRuntimeError(String string) {
        this.processEngine.errorWaitFor = true;
        this.error(string);
        ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
        processRuntimeException.sourceFile = this.kernel.getFileNameFromLineAddressCode();
        processRuntimeException.sourceLine = this.kernel.getLineCodeFromLineAddressCode();
        throw processRuntimeException;
    }

    public boolean getProcessPermission() {
        return this.processPermission;
    }

    public void setProcessPermission(boolean bl) {
        this.processPermission = bl;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessMode(int n) {
        if (this.inputUnit != null) {
            for (int i = 0; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i] != null) continue;
                this.inputUnit[i].setProcessMode(n);
            }
        }
    }

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n];
        }
        this.length = nArray2;
        this.dimension = nArray.length;
        n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n *= this.length[i];
        }
        this.capacity = n;
        this.formatArray(n);
    }

    public void copyLength(int[] nArray) {
        if (nArray == null) {
            this.free();
            return;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        this.setLength(nArray2);
    }

    public void setUniversalLength(int[] nArray) {
        int n;
        if (this.length.length == 1) {
            int n2 = 1;
            for (n = 0; n < nArray.length; ++n) {
                n2 *= nArray[n];
            }
            this.length[0] = n2;
            this.capacity = n2;
            this.formatArray(n2);
        }
        if (this.length.length == nArray.length) {
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = nArray[n];
            }
            this.setLength(nArray2);
        }
    }

    public void setIndex(int[] nArray) {
        this.index = 0;
        int n = 1;
        for (int i = this.dimension - 1; 0 <= i; --i) {
            this.index += n * nArray[i];
            n *= this.length[i];
        }
    }

    public void formatArray(int n) {
    }

    public void loadArray() {
    }

    public void operateArray() {
    }

    public void setIndexedValue() {
    }

    public void disposeResource() {
        if (this.inputUnit != null) {
            for (int i = 0; i < this.inputUnit.length; ++i) {
                try {
                    this.inputUnit[i].disposeResource();
                    this.inputUnit[i] = null;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        this.stringValue = null;
        this.id = null;
        this.name = null;
        this.errorMessage = null;
    }

    public int getRank() {
        return this.rank;
    }

    public int getMaxRank() {
        int n = this.getRank();
        if (this.inputUnit != null) {
            for (int i = 0; i < this.inputUnit.length; ++i) {
                int n2;
                if (this.inputUnit[i] == null || n >= (n2 = this.inputUnit[i].getMaxRank())) continue;
                n = n2;
            }
        }
        return n;
    }

    public boolean hasError() {
        try {
            return this.errorMessage.length() != 0;
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConst() {
        return this.valueLock;
    }

    public void setConst(boolean bl) {
        this.valueLock = bl;
    }

    public void lockValue(boolean bl) {
        this.valueLock = bl;
    }

    public void lockValue() {
        this.valueLock = true;
    }

    public void unLockValue() {
        this.valueLock = false;
    }

    public boolean isLockValue() {
        return this.valueLock;
    }

    public void lockType(boolean bl) {
        this.valueLock = bl;
    }

    public void lockType() {
        this.valueLock = true;
    }

    public boolean equalsMember(ProcessUnit processUnit) {
        return false;
    }

    public void setRoot() {
        this.setRank(0);
    }

    public void setRank(int n) {
        this.rank = n;
        if (this.inputUnit != null) {
            for (int i = 0; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i] == null) continue;
                this.inputUnit[i].setRank(this.rank + 1);
            }
        }
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValueType(int n) {
        this.valueType = n;
    }

    public void setInputType(int n) {
        this.inputType = n;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int getInputType() {
        return this.inputType;
    }

    public void readyMember() {
    }

    public void setType() {
    }

    public void setBestInputType() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        for (n4 = 0; n4 < this.inputUnit.length; ++n4) {
            if (this.inputUnit[n4] == null || this.inputUnit[n4].getValueType() != Integer.MAX_VALUE) continue;
            bl = true;
        }
        n4 = 1;
        for (n3 = 0; n3 < this.inputUnit.length; ++n3) {
            if (this.inputUnit[n3] == null || this.inputUnit[n3].getValueType() == 105) continue;
            n4 = 0;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.inputUnit.length; ++n2) {
            if (this.inputUnit[n2] == null || this.inputUnit[n2].getValueType() != 102) continue;
            n3 = 1;
        }
        n2 = 0;
        for (n = 0; n < this.inputUnit.length; ++n) {
            if (this.inputUnit[n] == null || this.inputUnit[n].getValueType() != 200) continue;
            n2 = 1;
        }
        if (bl) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u30c7\u30fc\u30bf\u306b\u4e0d\u660e\u306a\u5909\u6570\u578b\u306e\u3082\u306e\u304c\u5b58\u5728\u3057\u307e\u3059: \"" + this.stringValue + "\"" + this.getErrorVariableName() : this.errorMessage + "Unknows data type: \"" + this.stringValue + "\"" + this.getErrorVariableName();
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        } else if (n4 != 0) {
            this.setInputType(105);
        } else if (n3 != 0) {
            this.setInputType(102);
        } else if (n2 != 0) {
            this.setInputType(200);
        } else {
            int n5;
            this.setInputType(101);
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n] == null || this.inputUnit[n].getValueType() != 100) continue;
                this.setInputType(100);
            }
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n] == null || this.inputUnit[n].getValueType() != 104) continue;
                if (this.getValueType() == 100 || this.getValueType() == 103) {
                    this.setInputType(103);
                    continue;
                }
                this.setInputType(104);
            }
            n = 0;
            for (n5 = 0; n5 < this.inputUnit.length; ++n5) {
                if (this.inputUnit[n5] == null || this.inputUnit[n5].getValueType() != 103) continue;
                this.setInputType(103);
                n = 1;
            }
            for (n5 = 0; n5 < this.inputUnit.length; ++n5) {
                if (this.inputUnit[n5] == null || this.inputUnit[n5].getValueType() != 140) continue;
                if (n != 0) {
                    this.setInputType(141);
                    continue;
                }
                this.setInputType(140);
            }
            for (n5 = 0; n5 < this.inputUnit.length; ++n5) {
                if (this.inputUnit[n5] == null || this.inputUnit[n5].getValueType() != 141) continue;
                this.setInputType(141);
            }
            for (n5 = 0; n5 < this.inputUnit.length; ++n5) {
                if (this.inputUnit[n5] == null || this.inputUnit[n5].getValueType() != 102) continue;
                this.setInputType(102);
            }
        }
    }

    public void setValueType() {
        if (!this.typeLock) {
            int n;
            int n2;
            this.setValueType(101);
            for (n2 = 0; n2 < this.inputUnit.length; ++n2) {
                if (this.inputUnit[n2].getValueType() != 100) continue;
                this.setValueType(100);
            }
            for (n2 = 0; n2 < this.inputUnit.length; ++n2) {
                if (this.inputUnit[n2].getValueType() != 104) continue;
                if (this.getValueType() == 100 || this.getValueType() == 103) {
                    this.setValueType(103);
                    continue;
                }
                this.setValueType(104);
            }
            n2 = 0;
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n].getValueType() != 103) continue;
                this.setValueType(103);
                n2 = 1;
            }
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n] == null || this.inputUnit[n].getValueType() != 140) continue;
                if (n2 != 0) {
                    this.setValueType(141);
                    continue;
                }
                this.setValueType(140);
            }
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n] == null || this.inputUnit[n].getValueType() != 141) continue;
                this.setValueType(141);
            }
            for (n = 0; n < this.inputUnit.length; ++n) {
                if (this.inputUnit[n].getValueType() != 102) continue;
                this.setValueType(102);
            }
            this.inputType = this.valueType;
        } else {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u578b\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059: \"" + this.stringValue + "\"" + this.getErrorVariableName() : this.errorMessage + "Failed to convert a data type. The type is internally locked: \"" + this.stringValue + "\"" + this.getErrorVariableName();
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
    }

    public String getFormula() {
        return "";
    }

    public String getFormula(int n) {
        return "";
    }

    public void incrementAt() {
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u4e0d\u53ef\u80fd\u306a\u578b\u306b\u5bfe\u3057\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u5b9f\u884c\u3055\u308c\u307e\u3057\u305f\u3002 ( \u5185\u90e8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a" + this + " )");
        } else {
            this.error("Performing an increment operation on an unsupported data type. ( Internal object: " + this + " )");
        }
    }

    public void decrementAt() {
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u4e0d\u53ef\u80fd\u306a\u578b\u306b\u5bfe\u3057\u3066\u3001\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u5b9f\u884c\u3055\u308c\u307e\u3057\u305f\u3002 ( \u5185\u90e8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a" + this + " )");
        } else {
            this.error("Performing an decrement operation on an unsupported data type. ( Internal object: " + this + " )");
        }
    }

    public void increment() {
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u4e0d\u53ef\u80fd\u306a\u578b\u306b\u5bfe\u3057\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u5b9f\u884c\u3055\u308c\u307e\u3057\u305f\u3002 ( \u5185\u90e8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a" + this + " )");
        } else {
            this.error("Performing an increment operation on an unsupported data type. ( Internal object: " + this + " )");
        }
    }

    public void decrement() {
        if (ScriptProcessor.locale.isJapanese()) {
            this.error("\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u4e0d\u53ef\u80fd\u306a\u578b\u306b\u5bfe\u3057\u3066\u3001\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u304c\u5b9f\u884c\u3055\u308c\u307e\u3057\u305f\u3002 ( \u5185\u90e8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a" + this + " )");
        } else {
            this.error("Performing an decrement operation on an unsupported data type. ( Internal object: " + this + " )");
        }
    }

    public synchronized void setIntegerValue(int n, long l) {
        this.index = n;
        this.setIndexedValue();
        this.setIntegerValue(l);
    }

    public synchronized void setDecimalValue(int n, double d) {
        this.index = n;
        this.setIndexedValue();
        this.setDecimalValue(d);
    }

    public synchronized void setComplexValue(int n, double[] dArray) {
        this.index = n;
        this.setIndexedValue();
        this.setComplexValue(dArray);
    }

    public synchronized void setBigIntegerValue(int n, BigInteger bigInteger) {
        this.index = n;
        this.setIndexedValue();
        this.setBigIntegerValue(bigInteger);
    }

    public synchronized void setBigDecimalValue(int n, BigDecimal bigDecimal) {
        this.index = n;
        this.setIndexedValue();
        this.setBigDecimalValue(bigDecimal);
    }

    public synchronized void setBigComplexValue(int n, BigDecimal[] bigDecimalArray) {
        this.index = n;
        this.setIndexedValue();
        this.setBigComplexValue(bigDecimalArray);
    }

    public synchronized void setBooleanValue(int n, boolean bl) {
        this.index = n;
        this.setIndexedValue();
        this.setBooleanValue(bl);
    }

    public synchronized void setStringValue(int n, String string) {
        this.index = n;
        this.setIndexedValue();
        this.setStringValue(string);
    }

    public synchronized void setStructValue(int n, ProcessUnit processUnit) {
        this.index = n;
        this.setIndexedValue();
        this.setStructValue(processUnit);
    }

    public synchronized long getIntegerValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getIntegerValue();
    }

    public synchronized double getDecimalValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getDecimalValue();
    }

    public synchronized double[] getComplexValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getComplexValue();
    }

    public synchronized BigInteger getBigIntegerValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getBigIntegerValue();
    }

    public synchronized BigDecimal getBigDecimalValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getBigDecimalValue();
    }

    public synchronized BigDecimal[] getBigComplexValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getBigComplexValue();
    }

    public synchronized boolean getBooleanValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getBooleanValue();
    }

    public synchronized String getStringValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getStringValue();
    }

    public synchronized ProcessUnit getStructValue(int n) {
        this.index = n;
        this.setIndexedValue();
        return this.getStructValue();
    }

    public void setStructValue(ProcessUnit processUnit) {
    }

    public ProcessUnit getStructValue() {
        return null;
    }

    public ProcessStruct getStruct() {
        return null;
    }

    public void setStruct(ProcessStruct processStruct) {
    }

    public ProcessUnit[] getMemberVariable() {
        return null;
    }

    public void setDecimalValue(double d) {
        this.decimalValue = d;
    }

    public void setDecimalValue(String string) {
        try {
            this.decimalValue = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.decimalValue = Double.NaN;
        }
    }

    public void setIntegerValue(long l) {
        this.integerValue = l;
    }

    public void setIntegerValue(String string) {
        block14: {
            try {
                if (string.startsWith("0b") || string.startsWith("0B")) {
                    this.integerValue = Long.parseLong(string.substring(2, string.length()), 2);
                } else if (string.startsWith("0o") || string.startsWith("0O")) {
                    this.integerValue = Long.parseLong(string.substring(2, string.length()), 8);
                } else if (string.startsWith("0x") || string.startsWith("0X")) {
                    this.integerValue = Long.decode(string);
                } else if (string.startsWith("0") && string.indexOf(".") < 0 && 2 <= string.length()) {
                    ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                    if (!processCompatibilityException.alert()) {
                        this.error(new ProcessRuntimeException().getInfoMessage(2));
                    }
                    this.integerValue = Long.decode(string);
                } else {
                    this.integerValue = Long.parseLong(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.integerValue = new BigDecimal(this.stringValue).longValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.throwError("int\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                        break block14;
                    }
                    this.throwError("Cannot convert to an int type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                }
            }
        }
    }

    public void setBigDecimalValue(String string) {
        this.bigDecimalValue = this.getFixedDigitBigDecimal(new BigDecimal(string));
    }

    public void setBigDecimalValue(BigDecimal bigDecimal) {
        this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal);
    }

    public void setBigIntegerValue(String string) {
        block5: {
            try {
                this.bigIntegerValue = new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.bigIntegerValue = new BigDecimal(this.stringValue).toBigInteger();
                }
                catch (NumberFormatException numberFormatException2) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.throwError("varint\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                        break block5;
                    }
                    this.throwError("Cannot convert to an varint type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                }
            }
        }
    }

    public void setBigIntegerValue(BigInteger bigInteger) {
        this.bigIntegerValue = bigInteger;
    }

    public void setBooleanValue(boolean bl) {
        this.booleanValue = bl;
    }

    public void setBooleanValue(String string) {
        string = string.replaceAll(" ", "");
        if ((string = string.replaceAll("\\t", "")).equals("true")) {
            this.booleanValue = true;
        }
        if (string.equals("false")) {
            this.booleanValue = false;
        }
    }

    public void setComplexValue(String string) {
        String[] stringArray;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        int n3 = string.indexOf(44);
        if (n < 0 || n2 < 0 || n3 < 0) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("complex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            } else {
                this.throwError("Cannot convert to a complex type value: \"" + string + "\"" + this.getErrorVariableName());
            }
        }
        if ((stringArray = (string = string.substring(n + 1, n2)).split(",")).length != 2) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("complex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            } else {
                this.throwError("Cannot convert to a complex type value: \"" + string + "\"" + this.getErrorVariableName());
            }
        }
        try {
            if (this.complexValue == null) {
                this.complexValue = new double[2];
            }
            this.complexValue[0] = Double.parseDouble(stringArray[0]);
            this.complexValue[1] = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("complex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            }
            this.throwError("Cannot convert to a complex type value: \"" + string + "\"" + this.getErrorVariableName());
        }
    }

    public void setComplexValue(double[] dArray) {
        if (this.complexValue == null) {
            this.complexValue = new double[2];
        }
        this.complexValue[0] = dArray[0];
        this.complexValue[1] = dArray[1];
    }

    public void setComplexValue(double d) {
        if (this.complexValue == null) {
            this.complexValue = new double[2];
        }
        this.complexValue[0] = d;
        this.complexValue[1] = 0.0;
    }

    public void setBigComplexValue(String string) {
        String[] stringArray;
        boolean bl = true;
        if (string.startsWith("SYSTEM_PROCESS_LITERAL_VARCOMPLEX_RAW(")) {
            bl = false;
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        int n3 = string.indexOf(44);
        if (n < 0 || n2 < 0 || n3 < 0) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("varcomplex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            } else {
                this.throwError("Cannot convert to a varcomplex type value: \"" + string + "\"" + this.getErrorVariableName());
            }
        }
        if ((stringArray = (string = string.substring(n + 1, n2)).split(",")).length != 2) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("varcomplex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            } else {
                this.throwError("Cannot convert to a varcomplex type value: \"" + string + "\"" + this.getErrorVariableName());
            }
        }
        try {
            if (this.bigComplexValue == null) {
                this.bigComplexValue = new BigDecimal[2];
            }
            if (bl) {
                this.bigComplexValue[0] = this.getFixedDigitBigDecimal(new BigDecimal(stringArray[0]));
                this.bigComplexValue[1] = this.getFixedDigitBigDecimal(new BigDecimal(stringArray[1]));
            } else {
                this.bigComplexValue[0] = new BigDecimal(stringArray[0]);
                this.bigComplexValue[1] = new BigDecimal(stringArray[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.throwError("varcomplex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + string + "\"" + this.getErrorVariableName());
            }
            this.throwError("Cannot convert to a varcomplex type value: \"" + string + "\"" + this.getErrorVariableName());
        }
    }

    public void setBigComplexValue(BigDecimal[] bigDecimalArray) {
        try {
            if (this.bigComplexValue == null) {
                this.bigComplexValue = new BigDecimal[2];
            }
            this.bigComplexValue[0] = this.getFixedDigitBigDecimal(bigDecimalArray[0]);
            this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bigDecimalArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bigComplexValue[0] = null;
            this.bigComplexValue[1] = null;
        }
    }

    public void setBigComplexValue(BigDecimal bigDecimal) {
        if (this.bigComplexValue == null) {
            this.bigComplexValue = new BigDecimal[2];
        }
        this.bigComplexValue[0] = this.getFixedDigitBigDecimal(bigDecimal);
        this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bd_zero);
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public void process() {
    }

    public long getIntegerValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 101) {
                return this.integerValue;
            }
            if (this.getValueType() == 100) {
                return (long)this.decimalValue;
            }
            if (this.getValueType() == 104) {
                return this.bigIntegerValue.longValue();
            }
            if (this.getValueType() == 103) {
                return this.bigDecimalValue.longValue();
            }
            if (this.getValueType() == 102) {
                long l;
                block36: {
                    l = 0L;
                    try {
                        if (this.stringValue.startsWith("0b") || this.stringValue.startsWith("0B")) {
                            l = Long.parseLong(this.stringValue.substring(2, this.stringValue.length()), 2);
                        } else if (this.stringValue.startsWith("0o") || this.stringValue.startsWith("0O")) {
                            l = Long.parseLong(this.stringValue.substring(2, this.stringValue.length()), 8);
                        } else if (this.stringValue.startsWith("0x") || this.stringValue.startsWith("0X")) {
                            l = Long.decode(this.stringValue);
                        } else if (this.stringValue.startsWith("0") && this.stringValue.indexOf(".") < 0 && 2 <= this.stringValue.length()) {
                            ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                            if (!processCompatibilityException.alert()) {
                                this.error(new ProcessRuntimeException().getInfoMessage(2));
                            }
                            l = Long.decode(this.stringValue);
                        } else {
                            l = Long.parseLong(this.stringValue);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            l = new BigDecimal(this.stringValue).longValue();
                        }
                        catch (NumberFormatException numberFormatException2) {
                            if (ScriptProcessor.locale.isJapanese()) {
                                this.throwError("int\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                                break block36;
                            }
                            this.throwError("Cannot convert to an int type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                        }
                    }
                }
                return l;
            }
            if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("int\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to an int type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("int\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to an int type value: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("int\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to an int type value: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
        }
        return 0L;
    }

    public double getDecimalValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 100) {
                return this.decimalValue;
            }
            if (this.getValueType() == 101) {
                return this.integerValue;
            }
            if (this.getValueType() == 104) {
                return this.bigIntegerValue.doubleValue();
            }
            if (this.getValueType() == 103) {
                return this.bigDecimalValue.doubleValue();
            }
            if (this.getValueType() == 102) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                return d;
            }
            if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("float\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a float type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("float\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a float type value: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("float\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a float type value: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
        }
        return 0.0;
    }

    public BigInteger getBigIntegerValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 101) {
                return new BigInteger(Long.toString(this.integerValue));
            }
            if (this.getValueType() == 100) {
                return new BigInteger(Long.toString((long)this.decimalValue));
            }
            if (this.getValueType() == 104) {
                if (this.bigIntegerValue != null) {
                    return this.bigIntegerValue;
                }
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                    this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
                } else {
                    this.errorMessage = this.errorMessage + "The stored data is invalid.";
                    this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
                }
                this.error(this.errorMessage);
                return new BigInteger("0");
            }
            if (this.getValueType() == 103) {
                return this.bigDecimalValue.toBigInteger();
            }
            if (this.getValueType() == 102) {
                try {
                    return new BigInteger(this.stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return new BigDecimal(this.stringValue).toBigInteger();
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.throwError("varint\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                        } else {
                            this.throwError("Cannot convert to a varint type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                        }
                    }
                }
            } else if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varint\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varint type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varint\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varint type value: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                }
                this.error(this.errorMessage);
            } else if (this.getValueType() == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varint\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varint type value: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
            this.error(this.errorMessage);
        }
        return new BigInteger("0");
    }

    public BigDecimal getBigDecimalValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 101) {
                return this.getFixedDigitBigDecimal(new BigDecimal(Long.toString(this.integerValue)));
            }
            if (this.getValueType() == 100) {
                if (Double.isNaN(this.decimalValue)) {
                    if (this.errorMessage == null) {
                        this.errorMessage = "";
                    }
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306e\u5024\u304c NaN \u3067\u3059\u3002\u3053\u306e\u5024\u306f varfloat\u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot convert the variable \"" + this.name + "\" to a varfloat type value, because its value is NaN." + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                    this.error(this.errorMessage);
                    return this.getFixedDigitBigDecimal(new BigDecimal("0.0"));
                }
                if (this.decimalValue == Double.POSITIVE_INFINITY || this.decimalValue == Double.NEGATIVE_INFINITY) {
                    if (this.errorMessage == null) {
                        this.errorMessage = "";
                    }
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306e\u5024\u304c\u7121\u9650\u5927\u3067\u3059\u3002\u3053\u306e\u5024\u306f varfloat\u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot convert the variable \"" + this.name + "\" to a varfloat type value, because its value is infinity." + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                    this.error(this.errorMessage);
                    return this.getFixedDigitBigDecimal(new BigDecimal("0.0"));
                }
                return this.getFixedDigitBigDecimal(new BigDecimal(Double.toString(this.decimalValue)));
            }
            if (this.getValueType() == 104) {
                return this.getFixedDigitBigDecimal(new BigDecimal(this.bigIntegerValue));
            }
            if (this.getValueType() == 103) {
                if (this.bigDecimalValue != null) {
                    return this.getFixedDigitBigDecimal(this.bigDecimalValue);
                }
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5909\u6570\u300c" + this.name + "\u300d\u306f\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "The variable \"" + this.name + "\" does not store a valid value." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
                return this.getFixedDigitBigDecimal(new BigDecimal("0.0"));
            }
            if (this.getValueType() == 102) {
                try {
                    return this.getFixedDigitBigDecimal(new BigDecimal(this.stringValue));
                }
                catch (NumberFormatException numberFormatException) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.throwError("varfloat\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                    } else {
                        this.throwError("Cannot convert to a varfloat type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                    }
                }
            } else if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varfloat\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varfloat type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varfloat\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varfloat type value: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                }
            } else if (this.getValueType() == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varfloat\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varfloat type value: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
            this.error(this.errorMessage);
        }
        return this.getFixedDigitBigDecimal(new BigDecimal(0.0));
    }

    public double[] getComplexValue() {
        try {
            if (this.complexValue == null) {
                this.complexValue = new double[2];
            }
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 100) {
                this.complexValue[0] = this.decimalValue;
                this.complexValue[1] = 0.0;
                return this.complexValue;
            }
            if (this.getValueType() == 101) {
                this.complexValue[0] = this.integerValue;
                this.complexValue[1] = 0.0;
                return this.complexValue;
            }
            if (this.getValueType() == 104) {
                this.complexValue[0] = this.bigIntegerValue.doubleValue();
                this.complexValue[1] = 0.0;
                return this.complexValue;
            }
            if (this.getValueType() == 103) {
                this.complexValue[0] = this.bigDecimalValue.doubleValue();
                this.complexValue[1] = 0.0;
                return this.complexValue;
            }
            if (this.getValueType() == 140) {
                return new double[]{this.complexValue[0], this.complexValue[1]};
            }
            if (this.getValueType() == 141) {
                double d = this.bigComplexValue[0].doubleValue();
                double d2 = this.bigComplexValue[1].doubleValue();
                return new double[]{d, d2};
            }
            if (this.getValueType() == 102) {
                this.setComplexValue(this.stringValue);
                return this.complexValue;
            }
            if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("complex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a complex type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
            this.error(this.errorMessage);
        }
        return null;
    }

    public BigDecimal[] getBigComplexValue() {
        try {
            if (this.bigComplexValue == null) {
                this.bigComplexValue = new BigDecimal[2];
            }
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 100) {
                this.bigComplexValue[0] = this.getFixedDigitBigDecimal(new BigDecimal(this.decimalValue));
                this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bd_zero);
                return this.bigComplexValue;
            }
            if (this.getValueType() == 101) {
                this.bigComplexValue[0] = this.getFixedDigitBigDecimal(new BigDecimal(this.integerValue));
                this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bd_zero);
                return this.bigComplexValue;
            }
            if (this.getValueType() == 104) {
                this.bigComplexValue[0] = this.getFixedDigitBigDecimal(new BigDecimal(this.bigIntegerValue));
                this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bd_zero);
                return this.bigComplexValue;
            }
            if (this.getValueType() == 103) {
                this.bigComplexValue[0] = this.getFixedDigitBigDecimal(this.bigDecimalValue);
                this.bigComplexValue[1] = this.getFixedDigitBigDecimal(bd_zero);
                return this.bigComplexValue;
            }
            if (this.getValueType() == 140) {
                BigDecimal bigDecimal = this.getFixedDigitBigDecimal(new BigDecimal(this.complexValue[0]));
                BigDecimal bigDecimal2 = this.getFixedDigitBigDecimal(new BigDecimal(this.complexValue[1]));
                return new BigDecimal[]{bigDecimal, bigDecimal2};
            }
            if (this.getValueType() == 141) {
                return new BigDecimal[]{this.getFixedDigitBigDecimal(this.bigComplexValue[0]), this.getFixedDigitBigDecimal(this.bigComplexValue[1])};
            }
            if (this.getValueType() == 102) {
                this.setBigComplexValue(this.stringValue);
                return this.bigComplexValue;
            }
            if (this.getValueType() == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("varcomplex\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a varcomplex type value: \"" + this.booleanValue + "\"" + this.getErrorVariableName());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (this.getName() != null && (this.getName().equals("___VCI") || this.getName().equals("___VFI"))) {
                return null;
            }
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
            this.error(this.errorMessage);
        }
        return null;
    }

    private String getErrorVariableName() {
        if (this.getName() == null) {
            return "";
        }
        if (ScriptProcessor.locale.isJapanese()) {
            return " ( \u5909\u6570 " + this.getName() + " )";
        }
        return " ( Variable \"" + this.getName() + "\" )";
    }

    public String getStringValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 101) {
                return Long.toString(this.integerValue);
            }
            if (this.getValueType() == 100) {
                return Double.toString(this.decimalValue);
            }
            if (this.getValueType() == 104) {
                return this.bigIntegerValue.toString();
            }
            if (this.getValueType() == 103) {
                String string = this.bigDecimalValue.toString();
                return string;
            }
            if (this.getValueType() == 105) {
                if (this.booleanValue) {
                    return "true";
                }
                return "false";
            }
            if (this.getValueType() == 102) {
                return this.stringValue;
            }
            if (this.getValueType() == 140) {
                return "(" + this.complexValue[0] + "," + this.complexValue[1] + ")";
            }
            if (this.getValueType() == 141) {
                return "(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")";
            }
            return this.stringValue;
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093: " + this.getErrorVariableName() + System.getProperty("line.separator") : this.errorMessage + "The stored data is invalid: " + this.getErrorVariableName() + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            return "SYSTEM_PROCESS_NULL @ GET STR # PU (" + this + ")" + System.getProperty("line.separator") + "EXIT";
        }
    }

    public boolean getBooleanValue() {
        try {
            if (this.automaticProcess) {
                this.process();
            }
            if (this.getValueType() == 105) {
                return this.booleanValue;
            }
            if (this.getValueType() == 101) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.integerValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"" + this.integerValue + "\"" + this.getErrorVariableName());
                }
                this.error(this.errorMessage);
            } else if (this.getValueType() == 100) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.decimalValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"" + this.decimalValue + "\"" + this.getErrorVariableName());
                }
                this.error(this.errorMessage);
            } else if (this.getValueType() == 104) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.bigIntegerValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"" + this.bigIntegerValue + "\"" + this.getErrorVariableName());
                }
                this.error(this.errorMessage);
            } else if (this.getValueType() == 103) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.bigDecimalValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"" + this.bigDecimalValue + "\"" + this.getErrorVariableName());
                }
                this.error(this.errorMessage);
            } else if (this.getValueType() == 102) {
                if (this.stringValue.equals("true") || this.stringValue.equals("TRUE")) {
                    this.booleanValue = true;
                    return true;
                }
                if (this.stringValue.equals("false") || this.stringValue.equals("FALSE")) {
                    this.booleanValue = false;
                    return false;
                }
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"" + this.stringValue + "\"" + this.getErrorVariableName());
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            } else if (this.getValueType() == 140) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"(" + this.complexValue[0] + "," + this.complexValue[1] + ")\"" + this.getErrorVariableName());
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            } else if (this.getValueType() == 141) {
                if (this.errorMessage == null) {
                    this.errorMessage = "";
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwError("bool\u578b\u3078\u5909\u63db\u3067\u304d\u307e\u305b\u3093: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                } else {
                    this.throwError("Cannot convert to a bool type value: \"(" + this.bigComplexValue[0].toString() + "," + this.bigComplexValue[1].toString() + ")\"" + this.getErrorVariableName());
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.error(this.errorMessage);
            }
            return this.booleanValue;
        }
        catch (NullPointerException nullPointerException) {
            if (this.errorMessage == null) {
                this.errorMessage = "";
            }
            if (ScriptProcessor.locale.isJapanese()) {
                this.errorMessage = this.errorMessage + "\u30c7\u30fc\u30bf\u304c\u6b63\u5e38\u306a\u5024\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.errorMessage = this.errorMessage + "\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u51e6\u7406\u4e0d\u80fd\u306a\u6f14\u7b97\u304c\u884c\u308f\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + this.getErrorVariableName();
            } else {
                this.errorMessage = this.errorMessage + "The stored data is invalid.";
                this.errorMessage = this.errorMessage + "It is uninitialized, or performed invalid operations." + this.getErrorVariableName();
            }
            this.error(this.errorMessage);
            this.error(this.errorMessage);
            return false;
        }
    }

    public long getLastBigDecimalExponentPart() {
        if (this.processEngine == null) {
            try {
                this.processEngine.getMathContext();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        if (this.bigDecimalCore == null) {
            this.bigDecimalCore = new ProcessUnitBigDecimalCore(this.processEngine);
        }
        return this.bigDecimalCore.getOrder(this.bigDecimalValue);
    }

    public BigDecimal getFixedDigitBigDecimal(BigDecimal bigDecimal) {
        if (this.processEngine == null) {
            try {
                this.processEngine.getMathContext();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        if (this.bigDecimalCore == null) {
            this.bigDecimalCore = new ProcessUnitBigDecimalCore(this.processEngine);
        }
        return this.bigDecimalCore.getFixedDigitBigDecimal(bigDecimal);
    }

    public static String getArrayLine(ProcessUnit processUnit) {
        int n = processUnit.getCapacity();
        String string = "{";
        string = string + "...";
        string = string + "}";
        return string;
    }
}

