/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;

public class ProcessUnitBigDecimalCore {
    ProcessEngine processEngine;
    public static final BigInteger bi_ten = new BigInteger("10");
    public static final BigInteger bi_zero = new BigInteger("0");
    public static final BigInteger bi_one = new BigInteger("1");
    public static final BigDecimal bd_ten = new BigDecimal("1E1");
    public static final BigDecimal bd_one_over_ten = new BigDecimal("1E-1");
    public static final BigDecimal bd_zero = new BigDecimal("0.0");
    public static final BigDecimal bd_one = new BigDecimal("1.0");
    private int scale;
    private BigDecimal getBD;
    private BigDecimal retBD;
    private BigDecimal ex;
    private BigDecimal notScaled;
    private BigInteger unScaled;
    private byte[] unScaledByte;
    private int byteN;
    private BigInteger tenPower;
    private BigDecimal tenPowerBD;
    private BigDecimal unScaledBD;
    private BigInteger shifter;
    private boolean minus;
    private String dstr;
    private int newEx;
    private int exPlus;
    private int shift;
    private int bit;
    private int baseDigit;
    private double baseDigitDouble;
    private char char_one = (char)49;
    private char char_zero = (char)48;
    private char[] tenPowerChar;
    private String tenPowerString;
    private long exponentPartBuffer;
    private double logRate = Math.log(256.0) / Math.log(10.0);
    int shiftStock;
    BigInteger shifterStock;

    public ProcessUnitBigDecimalCore(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public BigDecimal getFixedDigitBigDecimal(BigDecimal bigDecimal) {
        if (this.processEngine == null) {
            try {
                this.processEngine.getMathContext();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        try {
            return bigDecimal.round((MathContext)this.processEngine.getMathContext());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return this.REGACY_getFixedDigitBigDecimal(bigDecimal);
        }
    }

    public long getOrder(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(bd_one) == 0) {
            return 0L;
        }
        if (bigDecimal.compareTo(bd_zero) == 0) {
            return 0L;
        }
        BigInteger bigInteger = bigDecimal.unscaledValue();
        BigDecimal bigDecimal2 = bigDecimal.divide(new BigDecimal(bigInteger));
        long l = 0L;
        if (bigDecimal2.unscaledValue().compareTo(bi_one) != 0) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.processEngine.error("varfloat\u6f14\u7b97\u30a8\u30e9\u30fc\uff08\u6307\u6570\u90e8\u53d6\u5f97\uff09");
            } else {
                this.processEngine.error("varfloat operation error (failed to get the exponent part)");
            }
            throw new ProcessRuntimeException();
        }
        l = -bigDecimal2.scale();
        long l2 = l + ((long)bigDecimal.precision() - 1L);
        return l2;
    }

    private BigInteger REGACY_getExponentBigInteger(int n) {
        BigDecimal bigDecimal = bd_one.add(bd_zero);
        bigDecimal = new BigDecimal(bi_one, -n);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        return bigInteger;
    }

    private long REGACY_getLastBigDecimalExponentPart() {
        return this.exponentPartBuffer;
    }

    private int REGACY_getBigIntegerSize(BigInteger bigInteger) {
        this.unScaledByte = bigInteger.toByteArray();
        this.byteN = this.unScaledByte.length;
        this.baseDigit = (int)(((double)bigInteger.toByteArray().length - 1.0) * this.logRate) - 1;
        if (this.baseDigit <= 0) {
            this.baseDigit = 1;
        }
        this.tenPower = bi_ten.pow(this.baseDigit);
        ++this.baseDigit;
        if (0 == bigInteger.compareTo(bi_zero)) {
            this.baseDigit = 1;
        } else if (0 < bigInteger.compareTo(this.tenPower)) {
            while (0 < bigInteger.compareTo(this.tenPower)) {
                this.tenPower = this.tenPower.multiply(bi_ten);
                ++this.baseDigit;
            }
            --this.baseDigit;
        } else if (bigInteger.compareTo(this.tenPower) < 0) {
            while (bigInteger.compareTo(this.tenPower) < 0) {
                this.tenPower = this.tenPower.divide(bi_ten);
                --this.baseDigit;
            }
        }
        if (this.baseDigit <= 0) {
            this.baseDigit = 1;
        }
        return this.baseDigit++;
    }

    private BigDecimal REGACY_getFixedDigitBigDecimal(BigDecimal bigDecimal) {
        this.minus = false;
        this.scale = bigDecimal.scale();
        this.unScaled = bigDecimal.unscaledValue();
        if (this.unScaled.compareTo(bi_zero) < 0) {
            this.unScaled = this.unScaled.negate();
            this.minus = true;
        }
        this.baseDigit = this.REGACY_getBigIntegerSize(this.unScaled);
        if (this.baseDigit > this.processEngine.getProcessDigit()) {
            this.newEx = this.scale - (this.baseDigit - this.processEngine.getProcessDigit());
            this.shift = this.baseDigit - this.processEngine.getProcessDigit();
            this.shifter = this.shifterStock != null && this.shiftStock == this.shift ? this.shifterStock : bi_ten.pow(this.shift);
            this.unScaled = this.unScaled.divide(this.shifter);
            this.retBD = new BigDecimal(this.unScaled, this.newEx);
            this.exponentPartBuffer = -((long)(this.newEx + 1 - this.processEngine.getProcessDigit()));
        } else {
            this.exPlus = 0;
            this.shift = this.processEngine.getProcessDigit() - this.baseDigit;
            if (0 < this.shift) {
                this.shifter = this.shifterStock != null && this.shiftStock == this.shift ? this.shifterStock : bi_ten.pow(this.shift);
                this.unScaled = this.unScaled.multiply(this.shifter);
            }
            this.exPlus = this.shift;
            this.retBD = new BigDecimal(this.unScaled, this.scale + this.exPlus);
            this.exponentPartBuffer = -((long)(this.scale + this.exPlus + 1 - this.processEngine.getProcessDigit()));
        }
        this.shiftStock = this.shift;
        this.shifterStock = this.shifter;
        if (this.minus) {
            this.retBD = this.retBD.negate();
        }
        return this.retBD;
    }
}

