/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDAdditionUnit
extends ProcessUnit {
    public SIMDAdditionUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getValueType() == 101) {
                this.integerArrayProcess();
            } else if (this.getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 140) {
                this.complexArrayProcess();
            } else if (this.getValueType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 141) {
                this.bigComplexArrayProcess();
            } else if (this.getValueType() == 102) {
                this.stringArrayProcess();
            }
        } else if (this.getValueType() == 101) {
            this.integerProcess();
        } else if (this.getValueType() == 100) {
            this.decimalProcess();
        } else if (this.getValueType() == 140) {
            this.complexProcess();
        } else if (this.getValueType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 141) {
            this.bigComplexProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    private void integerArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.integerValue += this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.decimalValue += this.inputUnit[i].getDecimalValue();
        }
    }

    private void complexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        double[] dArray = this.inputUnit[1].getComplexValue();
        double[] dArray2 = this.inputUnit[0].getComplexValue();
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
        this.setComplexValue(dArray2);
    }

    private void bigIntegerArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            bigInteger = bigInteger.add(this.inputUnit[i].getBigIntegerValue());
        }
        this.bigIntegerValue = bigInteger;
    }

    private void bigDecimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            bigDecimal = bigDecimal.add(this.inputUnit[i].getBigDecimalValue(), mathContext);
        }
        this.bigDecimalValue = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal);
    }

    private void bigComplexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        BigDecimal[] bigDecimalArray = this.inputUnit[1].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[0].getBigComplexValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        bigDecimalArray2[0] = bigDecimalArray2[0].add(bigDecimalArray[0], mathContext);
        bigDecimalArray2[1] = bigDecimalArray2[1].add(bigDecimalArray[1], mathContext);
        this.setBigComplexValue(bigDecimalArray2);
    }

    private void stringArrayProcess() {
        String string = "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            String string2 = this.inputUnit[i].getStringValue();
            if (string2 == null) {
                this.stringValue = null;
                return;
            }
            string = string + string2;
        }
        this.stringValue = string;
    }

    private void integerProcess() {
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.integerValue += this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalProcess() {
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.decimalValue += this.inputUnit[i].getDecimalValue();
        }
    }

    private void complexProcess() {
        double[] dArray = this.inputUnit[1].getComplexValue();
        double[] dArray2 = this.inputUnit[0].getComplexValue();
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
        this.setComplexValue(dArray2);
    }

    private void bigIntegerProcess() {
        BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            bigInteger = bigInteger.add(this.inputUnit[i].getBigIntegerValue());
        }
        this.bigIntegerValue = bigInteger;
    }

    private void bigDecimalProcess() {
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            bigDecimal = bigDecimal.add(this.inputUnit[i].getBigDecimalValue(), mathContext);
        }
        this.bigDecimalValue = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal);
    }

    private void bigComplexProcess() {
        BigDecimal[] bigDecimalArray = this.inputUnit[1].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[0].getBigComplexValue();
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        bigDecimalArray2[0] = bigDecimalArray2[0].add(bigDecimalArray[0], mathContext);
        bigDecimalArray2[1] = bigDecimalArray2[1].add(bigDecimalArray[1], mathContext);
        this.setBigComplexValue(bigDecimalArray2);
    }

    private void stringProcess() {
        String string = "";
        for (int i = 1; i < this.inputUnit.length; ++i) {
            String string2 = this.inputUnit[i].getStringValue();
            if (string2 == null) {
                this.stringValue = null;
                return;
            }
            string = string + string2;
        }
        this.stringValue = string;
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDAdditionUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "+";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDAdditionUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

