/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDDivisionUnit
extends ProcessUnit {
    public SIMDDivisionUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        this.arrayType = true;
        this.arrayType = false;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getValueType() == 101) {
                this.integerArrayProcess();
            } else if (this.getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 140) {
                this.complexArrayProcess();
            } else if (this.getValueType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 141) {
                this.bigComplexArrayProcess();
            } else if (this.getValueType() == 102) {
                this.stringArrayProcess();
            }
        } else if (this.getValueType() == 101) {
            this.integerProcess();
        } else if (this.getValueType() == 100) {
            this.decimalProcess();
        } else if (this.getValueType() == 140) {
            this.complexProcess();
        } else if (this.getValueType() == 104) {
            this.bigIntegerProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 141) {
            this.bigComplexProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    private void integerArrayProcess() {
        try {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            this.integerValue = this.inputUnit[0].getIntegerValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.inputUnit[i].index = this.index;
                this.inputUnit[i].setIndexedValue();
                this.integerValue /= this.inputUnit[i].getIntegerValue();
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigIntegerValue = new BigInteger("0");
            return;
        }
    }

    private void decimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.decimalValue /= this.inputUnit[i].getDecimalValue();
        }
    }

    private void complexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        double[] dArray = this.inputUnit[0].getComplexValue();
        double[] dArray2 = this.inputUnit[1].getComplexValue();
        double d = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        double[] dArray3 = new double[]{(dArray[0] * dArray2[0] + dArray[1] * dArray2[1]) / d, (dArray[1] * dArray2[0] - dArray[0] * dArray2[1]) / d};
        this.setComplexValue(dArray3);
    }

    private void bigIntegerArrayProcess() {
        try {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            BigInteger bigInteger = this.inputUnit[0].getBigIntegerValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.inputUnit[i].index = this.index;
                this.inputUnit[i].setIndexedValue();
                bigInteger = bigInteger.divide(this.inputUnit[i].getBigIntegerValue());
            }
            this.bigIntegerValue = bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            this.bigIntegerValue = new BigInteger("0");
            return;
        }
    }

    private void bigDecimalArrayProcess() {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        try {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            BigDecimal bigDecimal2 = this.inputUnit[0].getBigDecimalValue();
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                this.inputUnit[i].index = this.index;
                this.inputUnit[i].setIndexedValue();
                BigDecimal bigDecimal3 = this.inputUnit[i].getBigDecimalValue();
                bigDecimal2 = bigDecimal2.divide(bigDecimal3, mathContext);
            }
            this.bigDecimalValue = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal2);
        }
        catch (ArithmeticException arithmeticException) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void bigComplexArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.inputUnit[1].index = this.index;
        this.inputUnit[1].setIndexedValue();
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[1].getBigComplexValue();
        BigDecimal bigDecimal = bigDecimalArray2[0].multiply(bigDecimalArray2[0]).add(bigDecimalArray2[1].multiply(bigDecimalArray2[1]));
        bigDecimal = this.getFixedDigitBigDecimal(bigDecimal);
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        BigDecimal[] bigDecimalArray3 = new BigDecimal[]{bigDecimalArray[0].multiply(bigDecimalArray2[0], mathContext).add(bigDecimalArray[1].multiply(bigDecimalArray2[1], mathContext), mathContext), bigDecimalArray[1].multiply(bigDecimalArray2[0], mathContext).subtract(bigDecimalArray[0].multiply(bigDecimalArray2[1], mathContext), mathContext)};
        bigDecimalArray3[0] = this.div(bigDecimalArray3[0], bigDecimal);
        bigDecimalArray3[1] = this.div(bigDecimalArray3[1], bigDecimal);
        this.setBigComplexValue(bigDecimalArray3);
    }

    private void stringArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u9664\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the division ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "/";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    private void integerProcess() {
        this.integerValue = this.inputUnit[0].getIntegerValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.integerValue /= this.inputUnit[i].getIntegerValue();
        }
    }

    private void decimalProcess() {
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.decimalValue /= this.inputUnit[i].getDecimalValue();
        }
    }

    private void bigIntegerProcess() {
        BigInteger bigInteger = new BigInteger("0");
        try {
            if (this.inputUnit[0].getBigIntegerValue().compareTo(bigInteger) == 0) {
                this.bigIntegerValue = new BigInteger("0");
                return;
            }
            BigInteger bigInteger2 = this.inputUnit[0].getBigIntegerValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                bigInteger2 = bigInteger2.divide(this.inputUnit[i].getBigIntegerValue());
            }
            this.bigIntegerValue = bigInteger2;
        }
        catch (ArithmeticException arithmeticException) {
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigIntegerValue().compareTo(bigInteger) != 0) continue;
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u30bc\u30ed\u306b\u3088\u308b\u9664\u7b97\u304c\u884c\u308f\u308c\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : this.errorMessage + "Divided by zero." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigIntegerValue = new BigInteger("0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : this.errorMessage + "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigIntegerValue = new BigInteger("0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void complexProcess() {
        double[] dArray = this.inputUnit[0].getComplexValue();
        double[] dArray2 = this.inputUnit[1].getComplexValue();
        double d = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        double[] dArray3 = new double[]{(dArray[0] * dArray2[0] + dArray[1] * dArray2[1]) / d, (dArray[1] * dArray2[0] - dArray[0] * dArray2[1]) / d};
        this.setComplexValue(dArray3);
    }

    private void bigComplexProcess() {
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        BigDecimal[] bigDecimalArray = this.inputUnit[0].getBigComplexValue();
        BigDecimal[] bigDecimalArray2 = this.inputUnit[1].getBigComplexValue();
        BigDecimal bigDecimal = bigDecimalArray2[0].multiply(bigDecimalArray2[0], mathContext).add(bigDecimalArray2[1].multiply(bigDecimalArray2[1], mathContext), mathContext);
        bigDecimal = this.getFixedDigitBigDecimal(bigDecimal);
        BigDecimal[] bigDecimalArray3 = new BigDecimal[]{bigDecimalArray[0].multiply(bigDecimalArray2[0], mathContext).add(bigDecimalArray[1].multiply(bigDecimalArray2[1], mathContext), mathContext), bigDecimalArray[1].multiply(bigDecimalArray2[0], mathContext).subtract(bigDecimalArray[0].multiply(bigDecimalArray2[1], mathContext), mathContext)};
        bigDecimalArray3[0] = this.div(bigDecimalArray3[0], bigDecimal);
        bigDecimalArray3[1] = this.div(bigDecimalArray3[1], bigDecimal);
        this.setBigComplexValue(bigDecimalArray3);
    }

    private void bigDecimalProcess() {
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        BigDecimal bigDecimal = new BigDecimal("0.0");
        try {
            if (this.inputUnit[0].getBigDecimalValue().compareTo(bigDecimal) == 0) {
                this.bigDecimalValue = new BigDecimal(0);
                return;
            }
            BigDecimal bigDecimal2 = this.inputUnit[0].getBigDecimalValue();
            for (int i = 1; i < this.inputUnit.length; ++i) {
                BigDecimal bigDecimal3 = this.inputUnit[i].getBigDecimalValue();
                bigDecimal2 = bigDecimal2.divide(bigDecimal3, mathContext);
            }
            this.bigDecimalValue = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal2);
        }
        catch (ArithmeticException arithmeticException) {
            for (int i = 1; i < this.inputUnit.length; ++i) {
                if (this.inputUnit[i].getBigDecimalValue().compareTo(bigDecimal) != 0) continue;
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c" + this.inputUnit[i].getName() + "\u300d\u306e\u5024\u304c0\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + "\u3053\u306e\u5909\u6570\u3067\u9664\u7b97\u3092\u5b9f\u884c\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
                } else {
                    this.errorMessage = this.errorMessage + "Cannot divide by the variable \"" + this.inputUnit[i].getName() + "\", because its value is zero." + System.getProperty("line.separator");
                }
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4e0d\u660e\u306a\u6f14\u7b97\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : this.errorMessage + "Unexpected error has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return;
        }
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "[ \u5185\u5bb9 ] \u9664\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "[ INFO ] Cannot perform the division. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "/";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    private BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bd_zero;
        try {
            if (bigDecimal.compareTo(bigDecimal3) == 0) {
                return bd_zero;
            }
            MathContext mathContext = (MathContext)this.processEngine.getMathContext();
            bigDecimal = bigDecimal.divide(bigDecimal2, mathContext);
            return this.getFixedDigitBigDecimal(bigDecimal);
        }
        catch (ArithmeticException arithmeticException) {
            if (this.inputUnit[0].getBigDecimalValue().compareTo(bigDecimal3) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return null;
            }
            if (this.inputUnit[1].getBigDecimalValue().compareTo(bigDecimal3) == 0) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\uff08\u30bc\u30ed\u9664\u7b97\u306a\u3069\uff09\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error (e.g. divided by zero) has occurred on the division." + System.getProperty("line.separator");
                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                this.bigDecimalValue = new BigDecimal("0.0");
                this.error(this.errorMessage);
                return null;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u9664\u7b97\u306e\u5b9f\u884c\u306b\u3088\u308a\u4f55\u3089\u304b\u306e\u7b97\u8853\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") : "An arithmetic error has occurred on the division." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.bigDecimalValue = new BigDecimal("0.0");
            this.error(this.errorMessage);
            return null;
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDDivisionUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "/";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDDivisionUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

