/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDPostIncrementUnit
extends ProcessUnit {
    boolean operateArrayCalled = false;

    public SIMDPostIncrementUnit(ProcessUnit processUnit, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = new ProcessUnit[]{processUnit};
        this.nodeType = 201;
        this.setValueType();
        if (this.inputUnit[0].isArrayType()) {
            this.arrayType = true;
            this.dimension = this.inputUnit[0].getDimension();
            this.length = this.inputUnit[0].getLength();
            this.capacity = this.inputUnit[0].getCapacity();
        }
    }

    @Override
    public int[] getLength() {
        this.length = this.inputUnit[0].getLength();
        return this.length;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.isArrayType()) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
        this.inputUnit[0].increment();
        this.operateArrayCalled = true;
    }

    @Override
    public void process() {
        if (this.operateArrayCalled) {
            this.inputUnit[0].index = this.index;
            this.inputUnit[0].setIndexedValue();
            if (this.getValueType() == 101) {
                this.integerValue = this.inputUnit[0].getIntegerValue() - 1L;
            } else if (this.getValueType() == 100) {
                this.decimalValue = this.inputUnit[0].getDecimalValue() - 1.0;
            } else if (this.getValueType() == 104) {
                this.bigIntegerValue = this.inputUnit[0].getBigIntegerValue().subtract(bi_one);
            } else if (this.getValueType() == 103) {
                MathContext mathContext = (MathContext)this.processEngine.getMathContext();
                this.bigDecimalValue = this.inputUnit[0].getBigDecimalValue().subtract(bd_one, mathContext);
            }
        } else {
            this.inputUnit[0].increment();
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDPostIncrementUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        string = string + this.inputUnit[0].getFormula(n) + "++";
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDPostIncrementUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

