/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.MathContext;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.ProcessUnit;

public class SIMDPowerUnit
extends ProcessUnit {
    public SIMDPowerUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType();
        int n = this.getValueType();
        if (n == 101) {
            this.setValueType(100);
        }
        if (n == 104) {
            this.setValueType(103);
        }
        this.arrayType = true;
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.arrayType = true;
            this.dimension = this.inputUnit[i].getDimension();
            this.length = this.inputUnit[i].getLength();
            this.capacity = this.inputUnit[i].getCapacity();
            break;
        }
    }

    @Override
    public int[] getLength() {
        for (int i = 0; i < this.inputUnit.length; ++i) {
            if (!this.inputUnit[i].isArrayType()) continue;
            this.length = this.inputUnit[i].getLength();
            return this.length;
        }
        return null;
    }

    public void reloadLength() {
        this.length = this.getLength();
        this.dimension = this.length.length;
        this.capacity = 0;
        for (int i = 0; i < this.dimension; ++i) {
            this.capacity += this.length[i];
        }
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            this.reloadLength();
        }
        for (int i = 0; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].operateArray();
        }
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.getValueType() == 101) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.getValueType() == 104) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.getValueType() == 102) {
                this.stringArrayProcess();
            }
        } else if (this.getValueType() == 101) {
            this.decimalProcess();
        } else if (this.getValueType() == 100) {
            this.decimalProcess();
        } else if (this.getValueType() == 104) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 103) {
            this.bigDecimalProcess();
        } else if (this.getValueType() == 102) {
            this.stringProcess();
        }
    }

    BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        long l = 0L;
        boolean bl = false;
        try {
            l = Long.parseLong(bigDecimal2.toString());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        MathContext mathContext = (MathContext)this.processEngine.getMathContext();
        if (bl) {
            if (l == 0L) {
                return new BigDecimal("1");
            }
            if (0L < l) {
                BigDecimal bigDecimal3 = new BigDecimal("1");
                for (long i = 0L; i < l; ++i) {
                    bigDecimal3 = bigDecimal3.multiply(bigDecimal, mathContext);
                }
                bigDecimal3 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal3);
                return bigDecimal3;
            }
            if (0L > l) {
                long l2 = -l;
                BigDecimal bigDecimal4 = new BigDecimal("1");
                for (long i = 0L; i < l2; ++i) {
                    bigDecimal4 = bigDecimal4.multiply(bigDecimal, mathContext);
                }
                bigDecimal4 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal4);
                BigDecimal bigDecimal5 = new BigDecimal("1");
                bigDecimal5 = bigDecimal5.divide(bigDecimal4, mathContext);
                bigDecimal5 = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal5);
                return bigDecimal5;
            }
        }
        if (!bl) {
            // empty if block
        }
        return new BigDecimal("0");
    }

    private void decimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            this.decimalValue = Math.pow(this.decimalValue, this.inputUnit[i].getDecimalValue());
        }
    }

    private void bigDecimalArrayProcess() {
        this.inputUnit[0].index = this.index;
        this.inputUnit[0].setIndexedValue();
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.inputUnit[i].index = this.index;
            this.inputUnit[i].setIndexedValue();
            bigDecimal = this.pow(bigDecimal, this.inputUnit[i].getBigDecimalValue());
        }
        this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal);
    }

    private void stringArrayProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "*";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    private void decimalProcess() {
        this.decimalValue = this.inputUnit[0].getDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            this.decimalValue = Math.pow(this.decimalValue, this.inputUnit[i].getDecimalValue());
        }
    }

    private void bigDecimalProcess() {
        BigDecimal bigDecimal = this.inputUnit[0].getBigDecimalValue();
        for (int i = 1; i < this.inputUnit.length; ++i) {
            bigDecimal = this.pow(bigDecimal, this.inputUnit[i].getBigDecimalValue());
        }
        this.bigDecimalValue = this.getFixedDigitBigDecimal(bigDecimal);
    }

    private void stringProcess() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u3067\u304d\u307e\u305b\u3093\u3002 ( \"" : this.errorMessage + "Cannot perform the operation. ( \"";
        for (int i = 0; i < this.inputUnit.length - 1; ++i) {
            this.errorMessage = this.errorMessage + "\"" + this.inputUnit[i].getStringValue() + "\"";
            this.errorMessage = this.errorMessage + "*";
        }
        this.errorMessage = this.errorMessage + "\"" + this.inputUnit[this.inputUnit.length - 1].getStringValue() + "\" )" + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
        this.stringValue = "SYSTEM_ERROR_VALUE";
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDPowerUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? "[ " : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "**";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDPowerUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

