/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.BigInteger;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.system.function.Function_SYSTEM_PROCESS_ARRAY;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StructUnit;

public class SIMDSubstitutionUnit
extends ProcessUnit {
    public SIMDSubstitutionUnit() {
        this.nodeType = 201;
    }

    public SIMDSubstitutionUnit(ProcessUnit[] processUnitArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.inputUnit = processUnitArray;
        this.nodeType = 201;
        this.setValueType(this.inputUnit[0].getValueType());
        this.setInputType(this.inputUnit[0].getValueType());
        this.arrayType = true;
    }

    public SIMDSubstitutionUnit createClone() {
        SIMDSubstitutionUnit sIMDSubstitutionUnit = new SIMDSubstitutionUnit();
        sIMDSubstitutionUnit.nodeType = 201;
        sIMDSubstitutionUnit.processEngine = this.processEngine;
        sIMDSubstitutionUnit.inputUnit = this.inputUnit;
        sIMDSubstitutionUnit.nodeType = this.nodeType;
        sIMDSubstitutionUnit.inputType = this.inputType;
        sIMDSubstitutionUnit.valueType = this.valueType;
        sIMDSubstitutionUnit.arrayType = this.arrayType;
        return sIMDSubstitutionUnit;
    }

    public void dimensionError() {
        this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "" + this.inputUnit[0].getDimension() + "\u6b21\u5143\u306e\u914d\u5217\u300c " + this.inputUnit[0].getName() + " \u300d\u306b\u3001" + this.inputUnit[this.inputUnit.length - 1].getDimension() + "\u6b21\u5143\u306e\u914d\u5217\u300c " + this.inputUnit[this.inputUnit.length - 1].getName() + " \u300d\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot assign (=) " + this.inputUnit[this.inputUnit.length - 1].getDimension() + "-dimensional array \"" + this.inputUnit[this.inputUnit.length - 1].getName() + "\" to " + this.inputUnit[0].getDimension() + "-dimensional array \"" + this.inputUnit[0].getName() + "\"." + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.error(this.errorMessage);
    }

    @Override
    public void process() {
        if (this.inputUnit[0].isArrayType() && this.inputUnit[1].getValueType() == -100) {
            this.error(new ProcessSyntaxException().getInfoMessage(24));
        }
        this.inputUnit[this.inputUnit.length - 1].operateArray();
        try {
            if (this.inputUnit[this.inputUnit.length - 1] instanceof FunctionCallUnit && ((FunctionCallUnit)this.inputUnit[this.inputUnit.length - 1]).functionCallKernel instanceof Function_SYSTEM_PROCESS_ARRAY) {
                int n = this.inputUnit[0].getDimension();
                int[] nArray = this.inputUnit[0].getLength();
                int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
                if (nArray != null && nArray2 != null) {
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (nArray[i] == 0 || nArray[i] == nArray2[i]) continue;
                        bl = true;
                    }
                    if (bl) {
                        String string = "";
                        for (int i = 0; i < n; ++i) {
                            string = string + "[" + nArray[i] + "]";
                        }
                        ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                        if (!processCompatibilityException.alert()) {
                            if (ScriptProcessor.locale.isJapanese()) {
                                this.error("\u914d\u5217\u300c " + this.inputUnit[0].getName() + " \u300d\u306e\u5ba3\u8a00\u306b\u304a\u3051\u308b\u8981\u7d20\u6570 " + string + " \u3068\u3001\u914d\u5217\u521d\u671f\u5316\u5b50 {...} \u306e\u8981\u7d20\u6570\u3068\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u3053\u306e\u7d50\u679c\u306f\u51e6\u7406\u7cfb\u4f9d\u5b58\u3067\u3059\u3002\u3053\u306e\u3088\u3046\u306a\u5834\u5408\u306f\u3001\u6df7\u4e71\u3092\u907f\u3051\u308b\u305f\u3081\u3001\u914d\u5217\u5ba3\u8a00\u306b\u304a\u3044\u3066\u8981\u7d20\u6570\u3092\u7701\u7565\u3059\u308b\u4e8b\u304c\u63a8\u5968\u3055\u308c\u307e\u3059\u3002( \u4f8b\uff1a int a[ ] = {1, 2, 3}; )");
                            } else {
                                this.error("The declared length of the array \"" + this.inputUnit[0].getName() + "\" is " + string + ", but it does not match with the length of its array-initializer. Note that, you can omit to declare the array length when using array initializers, e.g.: int a[ ] = {1, 2, 3};");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.inputUnit[0].isArrayType()) {
            if (this.inputUnit[1].getValueType() == -100) {
                this.disposeArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 101) {
                this.integerArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 100) {
                this.decimalArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 140) {
                this.complexArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 104) {
                this.bigIntegerArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 103) {
                this.bigDecimalArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.bigComplexArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 105) {
                this.booleanArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 102) {
                this.stringArrayProcess();
            } else if (this.inputUnit[0].getValueType() == 200) {
                this.structArrayProcess();
            }
        } else {
            if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
                if (this.inputUnit[this.inputUnit.length - 1].getDimension() == 1 && this.inputUnit[this.inputUnit.length - 1].getLength()[0] == 1) {
                    this.inputUnit[this.inputUnit.length - 1].index = 0;
                    this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                } else {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u914d\u5217\u3067\u306f\u306a\u3044\u5909\u6570\u306b\u3001\u914d\u5217\uff08\u8981\u7d20\u6570\u304c1\u4ee5\u5916\uff09\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot assign (=) an array to a scalar variable, excluding the array length is 1." + System.getProperty("line.separator");
                    this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                    this.error(this.errorMessage);
                }
            }
            if (this.inputUnit[0].getValueType() == 101) {
                this.integerProcess();
            } else if (this.inputUnit[0].getValueType() == 100) {
                this.decimalProcess();
            } else if (this.inputUnit[0].getValueType() == 140) {
                this.complexProcess();
            } else if (this.inputUnit[0].getValueType() == 104) {
                this.bigIntegerProcess();
            } else if (this.inputUnit[0].getValueType() == 103) {
                this.bigDecimalProcess();
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.bigComplexProcess();
            } else if (this.inputUnit[0].getValueType() == 105) {
                this.booleanProcess();
            } else if (this.inputUnit[0].getValueType() == 102) {
                this.stringProcess();
            } else if (this.inputUnit[0].getValueType() == 200) {
                this.structProcess();
            }
        }
    }

    private void disposeArrayProcess() {
        this.inputUnit[0].free();
    }

    private void integerProcess() {
        this.inputUnit[0].setIntegerValue(this.inputUnit[this.inputUnit.length - 1].getIntegerValue());
        this.integerValue = this.inputUnit[0].getIntegerValue();
    }

    private void decimalProcess() {
        this.inputUnit[0].setDecimalValue(this.inputUnit[this.inputUnit.length - 1].getDecimalValue());
        this.decimalValue = this.inputUnit[0].getDecimalValue();
    }

    private void complexProcess() {
        double[] dArray = this.inputUnit[1].getComplexValue();
        this.setComplexValue(dArray);
        this.inputUnit[0].setComplexValue(dArray);
    }

    private void bigIntegerProcess() {
        this.inputUnit[0].setBigIntegerValue(this.inputUnit[this.inputUnit.length - 1].getBigIntegerValue());
        this.bigIntegerValue = this.inputUnit[0].getBigIntegerValue();
    }

    private void bigDecimalProcess() {
        this.inputUnit[0].setBigDecimalValue(this.getFixedDigitBigDecimal(this.inputUnit[this.inputUnit.length - 1].getBigDecimalValue()));
        this.bigDecimalValue = this.inputUnit[0].getBigDecimalValue();
    }

    private void bigComplexProcess() {
        BigDecimal[] bigDecimalArray = this.inputUnit[1].getBigComplexValue();
        this.setBigComplexValue(bigDecimalArray);
        this.inputUnit[0].setBigComplexValue(bigDecimalArray);
    }

    private void booleanProcess() {
        this.inputUnit[0].setBooleanValue(this.inputUnit[this.inputUnit.length - 1].getBooleanValue());
        this.booleanValue = this.inputUnit[0].getBooleanValue();
    }

    private void stringProcess() {
        String string;
        this.inputUnit[0].setStringValue(this.inputUnit[this.inputUnit.length - 1].getStringValue());
        this.stringValue = string = this.inputUnit[0].getStringValue();
    }

    private void structProcess() {
        this.inputUnit[0].setStructValue(this.inputUnit[this.inputUnit.length - 1].getStructValue());
    }

    private void integerArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[this.inputUnit.length - 1].isUniversalRank()) {
                if (this.inputUnit[this.inputUnit.length - 1] != this.inputUnit[0]) {
                    this.inputUnit[0].setUniversalLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            } else {
                if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                    this.dimensionError();
                }
                n = this.inputUnit[0].getDimension();
                int[] nArray = this.inputUnit[0].getLength();
                int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
                if (nArray == null || nArray2 == null) {
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (nArray[i] == nArray2[i]) continue;
                        this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                    }
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n2 = 0;
            while (n2 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n2;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.integerValue = this.inputUnit[this.inputUnit.length - 1].getIntegerValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n2++;
                this.inputUnit[0].setIntegerValue(this.integerValue);
            }
        } else {
            long l = this.inputUnit[this.inputUnit.length - 1].getIntegerValue();
            int n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setIntegerValue(l);
            }
        }
    }

    private void decimalArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.decimalValue = this.inputUnit[this.inputUnit.length - 1].getDecimalValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setDecimalValue(this.decimalValue);
            }
        } else {
            double d = this.inputUnit[this.inputUnit.length - 1].getDecimalValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setDecimalValue(d);
            }
        }
    }

    private void complexArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                double[] dArray = this.inputUnit[this.inputUnit.length - 1].getComplexValue();
                this.setComplexValue(dArray);
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setComplexValue(dArray);
            }
        } else {
            double[] dArray = this.inputUnit[this.inputUnit.length - 1].getComplexValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setComplexValue(dArray);
            }
        }
    }

    private void bigIntegerArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.bigIntegerValue = this.inputUnit[this.inputUnit.length - 1].getBigIntegerValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setBigIntegerValue(this.bigIntegerValue);
            }
        } else {
            BigInteger bigInteger = this.inputUnit[this.inputUnit.length - 1].getBigIntegerValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setBigIntegerValue(bigInteger);
            }
        }
    }

    private void bigDecimalArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.bigDecimalValue = this.inputUnit[this.inputUnit.length - 1].getBigDecimalValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.bigDecimalValue = this.inputUnit[0].getFixedDigitBigDecimal(this.bigDecimalValue);
                this.inputUnit[0].setBigDecimalValue(this.bigDecimalValue);
            }
        } else {
            BigDecimal bigDecimal = this.inputUnit[this.inputUnit.length - 1].getBigDecimalValue();
            bigDecimal = this.inputUnit[0].getFixedDigitBigDecimal(bigDecimal);
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setBigDecimalValue(bigDecimal);
            }
        }
    }

    private void bigComplexArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                BigDecimal[] bigDecimalArray = this.inputUnit[this.inputUnit.length - 1].getBigComplexValue();
                this.setBigComplexValue(bigDecimalArray);
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setBigComplexValue(bigDecimalArray);
            }
        } else {
            BigDecimal[] bigDecimalArray = this.inputUnit[this.inputUnit.length - 1].getBigComplexValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setBigComplexValue(bigDecimalArray);
            }
        }
    }

    private void booleanArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.booleanValue = this.inputUnit[this.inputUnit.length - 1].getBooleanValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setBooleanValue(this.booleanValue);
            }
        } else {
            boolean bl = this.inputUnit[this.inputUnit.length - 1].getBooleanValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setBooleanValue(bl);
            }
        }
    }

    private void stringArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.stringValue = this.inputUnit[this.inputUnit.length - 1].getStringValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setStringValue(this.stringValue);
            }
        } else {
            String string = this.inputUnit[this.inputUnit.length - 1].getStringValue();
            int n = this.inputUnit[0].getCapacity();
            int n4 = 0;
            while (n4 < n) {
                this.inputUnit[0].index = n4++;
                this.inputUnit[0].setStringValue(string);
            }
        }
    }

    private void structArrayProcess() {
        if (this.inputUnit[this.inputUnit.length - 1].isArrayType()) {
            int n;
            if (this.inputUnit[0].getDimension() != this.inputUnit[this.inputUnit.length - 1].getDimension()) {
                this.dimensionError();
            }
            int n2 = this.inputUnit[0].getDimension();
            int[] nArray = this.inputUnit[0].getLength();
            int[] nArray2 = this.inputUnit[this.inputUnit.length - 1].getLength();
            if (nArray == null || nArray2 == null) {
                this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
            } else {
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.inputUnit[0].copyLength(this.inputUnit[this.inputUnit.length - 1].getLength());
                }
            }
            n = this.inputUnit[0].getCapacity();
            int n3 = 0;
            while (n3 < n) {
                this.inputUnit[this.inputUnit.length - 1].index = n3;
                this.inputUnit[this.inputUnit.length - 1].setIndexedValue();
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(false);
                this.inputUnit[0].index = n3++;
                this.inputUnit[0].setStructValue(this.inputUnit[this.inputUnit.length - 1].getStructValue());
                this.inputUnit[this.inputUnit.length - 1].setProcessPermission(true);
            }
        } else {
            this.error(((StructUnit)this.inputUnit[1]).getStruct().getType() + " : " + new ProcessRuntimeException(this.processEngine).getInfoMessage(0));
            throw new ProcessRuntimeException();
        }
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        if (this.getRank() == n) {
            if (this.isArrayType()) {
                return SIMDSubstitutionUnit.getArrayLine(this);
            }
            return this.getStringValue();
        }
        String string = "";
        string = n == this.getRank() + 1 ? " [" : "";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string = string + this.inputUnit[i].getFormula(n);
            if (i >= this.inputUnit.length - 1) continue;
            string = string + "=";
        }
        string = n == this.getRank() + 1 ? (this.isArrayType() ? string + " = " + SIMDSubstitutionUnit.getArrayLine(this) + " ]" : string + " = " + this.getStringValue() + " ]") : string + "";
        if (this.inputUnit.length == 1) {
            string = this.getStringValue();
        }
        return string;
    }
}

