/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.util.Objects;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StructUnit;

public class StructArrayUnit
extends ProcessUnit {
    private ProcessStruct struct;
    private ProcessUnit[] array;
    private ProcessUnit indexedStructUnit;
    final boolean READY_ELEMENT = true;
    boolean dummy = false;

    public StructArrayUnit(ProcessStruct processStruct, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.struct = processStruct;
        this.valueType = 200;
        this.nodeType = 200;
        this.arrayType = true;
        this.formatArray(1);
        this.indexedStructUnit = this.array[0];
    }

    public StructArrayUnit(int[] nArray, ProcessStruct processStruct, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.struct = processStruct;
        this.valueType = 200;
        this.nodeType = 200;
        this.arrayType = true;
        this.setLength(nArray);
    }

    public StructArrayUnit(int[] nArray, ProcessStruct processStruct, ProcessEngine processEngine, boolean bl) {
        this.dummy = bl;
        this.processEngine = processEngine;
        this.struct = processStruct;
        this.valueType = 200;
        this.nodeType = 200;
        this.arrayType = true;
        this.setLength(nArray);
    }

    public StructArrayUnit(int[] nArray, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.struct = null;
        this.valueType = 200;
        this.nodeType = 200;
        this.arrayType = true;
        this.setLength(nArray);
    }

    @Override
    public boolean isArrayNull() {
        return this.array == null;
    }

    @Override
    public void setStruct(ProcessStruct processStruct) {
        this.struct = processStruct;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int[] getLength() {
        return this.length;
    }

    @Override
    public void formatArray(int n) {
        if (this.array == null || n != this.array.length) {
            this.capacity = n;
            this.array = new StructUnit[this.capacity];
        }
        for (int i = 0; i < n; ++i) {
            this.array[i] = new StructUnit(this.struct, this.processEngine);
        }
        if (!this.dummy && this.struct != null) {
            this.readyElement();
        }
    }

    @Override
    public void alloc(int[] nArray) {
        int n;
        int n2;
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = nArray[n2];
        }
        n2 = this.capacity;
        int[] nArray3 = this.length;
        ProcessUnit[] processUnitArray = this.array;
        int n3 = nArray3.length;
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            n4 *= nArray2[i];
        }
        ProcessUnit[] processUnitArray2 = new ProcessUnit[n4];
        for (int i = 0; i < n4; ++i) {
            processUnitArray2[i] = new StructUnit(this.struct, this.processEngine);
        }
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int n5 = 1;
        for (n = n3 - 1; 0 <= n; --n) {
            nArray5[n] = n5;
            n5 *= nArray3[n];
        }
        for (n = 0; n < n2; ++n) {
            int n6;
            int n7;
            int n8 = n;
            for (n7 = 0; n7 < n3; ++n7) {
                nArray4[n7] = n8 / nArray5[n7];
                n8 %= nArray5[n7];
            }
            n7 = 1;
            for (n6 = 0; n6 < n3; ++n6) {
                if (nArray2[n6] - 1 >= nArray4[n6]) continue;
                n7 = 0;
            }
            if (n7 == 0) continue;
            n6 = 1;
            int n9 = 0;
            for (int i = n3 - 1; 0 <= i; --i) {
                n9 += n6 * nArray4[i];
                n6 *= nArray2[i];
            }
            processUnitArray2[n9] = processUnitArray[n];
        }
        this.capacity = n4;
        this.length = nArray2;
        this.array = processUnitArray2;
        this.readyElement();
    }

    public void readyElement() {
        Objects.requireNonNull(this);
        for (int i = 0; i < this.capacity; ++i) {
            StructUnit structUnit = (StructUnit)this.array[i];
            structUnit.readyMember();
        }
    }

    @Override
    public void indexedFree() {
        this.array[this.index].free();
    }

    @Override
    public void indexedAlloc(int[] nArray) {
        this.array[this.index].alloc(nArray);
    }

    @Override
    public void free() {
        int n;
        for (n = 0; n < this.array.length; ++n) {
            this.array[n].free();
        }
        for (n = 0; n < this.array.length; ++n) {
            this.array[n].disposeResource();
        }
        this.array = new StructUnit[0];
        this.capacity = 0;
        for (n = 0; n < this.dimension; ++n) {
            this.length[n] = 0;
        }
        this.capacity = 0;
        this.length = null;
        this.array = null;
    }

    @Override
    public ProcessStruct getStruct() {
        return this.struct;
    }

    public ProcessUnit[] getArray() {
        return this.array;
    }

    @Override
    public void setIndexedValue() {
        this.indexedStructUnit = this.array[this.index];
    }

    @Override
    public void setStructValue(ProcessUnit processUnit) {
        this.indexedStructUnit = this.array[this.index];
        this.array[this.index].setStructValue(processUnit);
    }

    @Override
    public ProcessUnit getStructValue() {
        this.indexedStructUnit = this.array[this.index];
        return this.array[this.index];
    }

    @Override
    public ProcessUnit[] getMemberVariable() {
        if (this.index < this.array.length) {
            this.indexedStructUnit = this.array[this.index];
            return this.array[this.index].getMemberVariable();
        }
        return null;
    }

    @Override
    public boolean isMemberInitialized() {
        this.indexedStructUnit = this.array[this.index];
        return this.array[this.index].isMemberInitialized();
    }

    @Override
    public void initialize() {
        this.indexedStructUnit = this.array[this.index];
        this.array[this.index].initialize();
    }

    @Override
    public boolean isDefaulted() {
        this.indexedStructUnit = this.array[this.index];
        return this.array[this.index].isDefaulted();
    }

    @Override
    public void setDefaulted(boolean bl) {
        this.indexedStructUnit = this.array[this.index];
        this.array[this.index].setDefaulted(bl);
    }

    public void setAllElementDefaulted(boolean bl) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i].setDefaulted(bl);
        }
        this.indexedStructUnit = null;
    }

    @Override
    public boolean equalsMember(ProcessUnit processUnit) {
        this.indexedStructUnit = this.array[this.index];
        return this.indexedStructUnit.equalsMember(processUnit);
    }
}

