/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ArrayAccessUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.ReferenceUnit;
import rxvesapi.process.unit.StructUnit;

public class StructMemberAccessUnit
extends ReferenceUnit {
    private ProcessUnit structUnit;
    private int memberIndex;

    public StructMemberAccessUnit(ProcessUnit processUnit, int n) {
        this.structUnit = processUnit;
        this.memberIndex = n;
        ProcessUnit processUnit2 = null;
        processUnit2 = this.structUnit.getStruct().getVariable()[this.memberIndex];
        this.setValueType(processUnit2.getValueType());
        this.setArrayType(processUnit2.isArrayType());
        this.dimension = processUnit2.getDimension();
        int[] nArray = new int[this.dimension];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        this.length = nArray;
    }

    public boolean hasArrayAncestor() {
        if (this.structUnit instanceof ArrayAccessUnit) {
            return true;
        }
        if (this.structUnit instanceof StructMemberAccessUnit && this.structUnit != null) {
            ((StructMemberAccessUnit)this.structUnit).hasArrayAncestor();
        }
        return false;
    }

    @Override
    public int getDimension() {
        ProcessUnit processUnit = this.structUnit.getStruct().getVariable()[this.memberIndex];
        return processUnit.getDimension();
    }

    public ProcessStruct getMemberStruct() {
        this.reloadInputUnit();
        this.checkReference();
        ProcessUnit[] processUnitArray = this.structUnit.getMemberVariable();
        if (processUnitArray != null) {
            ProcessUnit processUnit = processUnitArray[this.memberIndex];
            return processUnit.getStruct();
        }
        return null;
    }

    public void setStructUnit(StructUnit structUnit) {
        this.structUnit = structUnit;
        this.reloadMemberReference();
    }

    @Override
    public ProcessStruct getStruct() {
        ProcessStruct processStruct = this.structUnit.getStruct();
        ProcessUnit[] processUnitArray = processStruct.getVariable();
        if (processUnitArray != null) {
            ProcessUnit processUnit = processUnitArray[this.memberIndex];
            return processUnit.getStruct();
        }
        return null;
    }

    @Override
    public void reloadInputUnit() {
        if (this.structUnit instanceof StructMemberAccessUnit) {
            ((StructMemberAccessUnit)this.structUnit).reloadMemberReference();
        }
        this.structUnit.reloadInputUnit();
        ProcessUnit[] processUnitArray = null;
        processUnitArray = this.structUnit.getMemberVariable();
        if (processUnitArray != null) {
            ProcessUnit processUnit = processUnitArray[this.memberIndex];
            processUnit.reloadInputUnit();
            this.setReference(processUnit);
        }
    }

    @Override
    public boolean checkReference() {
        this.reloadMemberReference();
        return true;
    }

    public ProcessStruct getParentStruct() {
        return this.structUnit.getStruct();
    }

    private int getMemberIndex() {
        return this.memberIndex;
    }

    private void reloadMemberReference_NOINIT() {
        ProcessUnit processUnit = this.structUnit.getMemberVariable()[this.memberIndex];
        this.setReference(processUnit);
    }

    @Override
    public void initialize() {
        this.reloadMemberReference();
        this.getReference().initialize();
    }

    private void reloadMemberReference() {
        ProcessUnit[] processUnitArray;
        this.reloadInputUnit();
        if (!this.structUnit.isDefaulted()) {
            this.structUnit.initialize();
            this.structUnit.setDefaulted(true);
        }
        if ((processUnitArray = this.structUnit.getMemberVariable()) == null) {
            this.error(this.structUnit.getName() + " : " + new ProcessSyntaxException(this.processEngine).getInfo(15));
            return;
        }
        ProcessUnit processUnit = processUnitArray[this.memberIndex];
        this.setReference(processUnit);
        if (processUnit.getValueType() == 200 && !processUnit.isArrayType() && !processUnit.isDefaulted()) {
            processUnit.initialize();
            processUnit.setDefaulted(true);
        }
    }
}

