/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.unit;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.unit.BigComplexArrayUnit;
import rxvesapi.process.unit.BigDecimalArrayUnit;
import rxvesapi.process.unit.BigIntegerArrayUnit;
import rxvesapi.process.unit.BooleanArrayUnit;
import rxvesapi.process.unit.ComplexArrayUnit;
import rxvesapi.process.unit.DecimalArrayUnit;
import rxvesapi.process.unit.IntegerArrayUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.ProcessUnitBigDecimalCore;
import rxvesapi.process.unit.ReferenceUnit;
import rxvesapi.process.unit.StringArrayUnit;
import rxvesapi.process.unit.StructArrayUnit;

public class SystemFunctionUnit
extends ProcessUnit {
    private static final int ROUND_UP = 1;
    private static final int ROUND_DOWN = 2;
    private static final int ROUND_HALF_UP = 3;
    private static final int ROUND_HALF_DOWN = 4;
    private static final int ROUND_HALF_EVEN = 5;
    public int code;
    public String functionName;
    public int[] lengthBuffer;
    public long[] array;
    public static int EXIT = 101;
    public static int DIGIT = 102;
    public static int GETDIGIT = 103;
    public static int TIME = 104;
    public static int ERROR = 105;
    public static int ASSERT = 107;
    public static int ROUND = 108;
    public static int OUTPUT = 109;
    public static int DIMENSION = 201;
    public static int LENGTH = 202;
    public static int SIN = 10001;
    public static int COS = 10002;
    public static int TAN = 10003;
    public static int ASIN = 10004;
    public static int ACOS = 10005;
    public static int ATAN = 10006;
    public static int SINH = 10007;
    public static int COSH = 10008;
    public static int TANH = 10009;
    public static int ASINH = 10011;
    public static int ACOSH = 10012;
    public static int ATANH = 10013;
    public static int SQRT = 10014;
    public static int EXP = 10015;
    public static int LOG10 = 10016;
    public static int LN = 10017;
    public static int ABS = 10018;
    public static int FAC = 10019;
    public static int MAX = 10020;
    public static int MIN = 10021;
    public static int RAND = 10030;
    public static int POW = 10031;
    public static int ROOT = 10032;
    public static int ORDER = 10040;
    public static int FACTOR = 10041;
    public static int NAN = 10050;
    public static int INF = 10051;
    public static int INVALID = 10052;
    public static int BINARY = 10101;
    public static int OCTAL = 10102;
    public static int HEX = 10103;
    public static int AND = 10104;
    public static int OR = 10105;
    public static int XOR = 10106;
    public static int DEG = 10201;
    public static int RAD = 10202;
    public static int REAL = 10301;
    public static int IMAG = 10302;
    public static int REALSET = 10303;
    public static int IMAGSET = 10304;
    public static int INIT = 11101;
    public static int ALLOC = 12101;
    public static int FREE = 12102;
    private boolean operateArrayCalled;

    @Override
    public void setIndexedValue() {
        if (this.isArrayType()) {
            this.integerValue = this.array[this.index];
        }
    }

    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public void operateArray() {
        if (this.arrayType) {
            if (this.code == LENGTH && this.inputUnit.length == 1) {
                if (this.code == LENGTH) {
                    ProcessCompatibilityException processCompatibilityException;
                    int n = this.inputUnit[0].getDimension();
                    int[] nArray = this.inputUnit[0].getLength();
                    if (this.lengthBuffer == null || this.lengthBuffer.length != 1) {
                        this.lengthBuffer = new int[1];
                    }
                    this.lengthBuffer[0] = n;
                    if (2 <= n && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("2\u6b21\u5143\u4ee5\u4e0a\u306e\u914d\u5217\u306b\u5bfe\u3057\u3066 length \u95a2\u6570\u3092\u4f7f\u7528\u3059\u308b\u969b\u306f\u3001\u7b2c\u4e8c\u5f15\u6570\u306b\u6b21\u5143\u3092\u6307\u5b9a\u3059\u308b\u4e8b\u304c\u63a8\u5968\u3055\u308c\u307e\u3059\uff08  \u4f8b\uff1aint n = length(a, 2);  \uff09\u3002\u7b2c\u4e8c\u5f15\u6570\u3092\u7701\u7565\u3057\u305f length \u95a2\u6570\u306f\u3001\u6b21\u5143\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u6271\u3044\u304c\u9006\u9806\u3067\u3042\u308b\u305f\u3081\u30011\u6b21\u5143\u914d\u5217\u4ee5\u5916\u3078\u306e\u4f7f\u7528\u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002");
                        } else {
                            this.error("It is recommended to specify the index of the dimension to the 2nd argument of \"length\" function, e.g.: int n = length(a, 2);. Omitting the 2nd argument is not recommended excluding when getting the length of 1-dimensional array.");
                        }
                    }
                    this.setLength(this.lengthBuffer);
                    this.dimension = 1;
                    this.capacity = n;
                    if (this.array == null || this.array.length != n) {
                        this.array = new long[n];
                    }
                    for (int i = 0; i < n; ++i) {
                        this.array[i] = nArray[n - 1 - i];
                    }
                }
            }
        }
        if (this.arrayType) {
            this.operateArrayCalled = true;
        }
    }

    @Override
    public int[] getLength() {
        if (this.arrayType) {
            if (this.code == LENGTH) {
                if (this.code == LENGTH) {
                    int n = this.inputUnit[0].getDimension();
                    int[] nArray = this.inputUnit[0].getLength();
                    if (this.lengthBuffer == null || this.lengthBuffer.length != 1) {
                        this.lengthBuffer = new int[1];
                    }
                    this.lengthBuffer[0] = n;
                    this.setLength(this.lengthBuffer);
                    this.dimension = 1;
                    this.capacity = n;
                    if (this.array == null || this.array.length != n) {
                        this.array = new long[n];
                    }
                    for (int i = 0; i < n; ++i) {
                        this.array[i] = nArray[n - 1 - i];
                    }
                }
            }
        }
        return this.length;
    }

    public SystemFunctionUnit() {
        this.code = 0;
        this.functionName = "";
        this.operateArrayCalled = false;
        this.valueType = Integer.MAX_VALUE;
        this.nodeType = 200;
    }

    /*
     * Unable to fully structure code
     */
    public SystemFunctionUnit(ProcessUnit[] var1_1, String var2_2, ProcessEngine var3_3) {
        block4: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block3: {
                                                                        block2: {
                                                                            super();
                                                                            this.code = 0;
                                                                            this.functionName = "";
                                                                            this.operateArrayCalled = false;
                                                                            this.processEngine = var3_3;
                                                                            this.code = this.getFunctionCode(var2_2);
                                                                            if (this.code == SystemFunctionUnit.EXIT) break block2;
                                                                            if (this.code == SystemFunctionUnit.TIME) break block2;
                                                                            if (this.code == SystemFunctionUnit.EXIT) break block2;
                                                                            if (this.code == SystemFunctionUnit.DIGIT) break block2;
                                                                            if (this.code == SystemFunctionUnit.ROUND) break block2;
                                                                            if (this.code == SystemFunctionUnit.GETDIGIT) break block2;
                                                                            if (this.code == SystemFunctionUnit.DIMENSION) break block2;
                                                                            if (this.code == SystemFunctionUnit.FAC) break block2;
                                                                            if (this.code == SystemFunctionUnit.ORDER) break block2;
                                                                            if (this.code != SystemFunctionUnit.OUTPUT) break block3;
                                                                        }
                                                                        this.valueType = 101;
                                                                        break block4;
                                                                    }
                                                                    if (this.code != SystemFunctionUnit.LENGTH) break block5;
                                                                    this.valueType = 101;
                                                                    this.dimension = 1;
                                                                    this.arrayType = var1_1.length == 1;
                                                                    break block4;
                                                                }
                                                                if (this.code != SystemFunctionUnit.ABS) break block6;
                                                                this.valueType = var1_1[0].getValueType();
                                                                break block4;
                                                            }
                                                            if (this.code == SystemFunctionUnit.MAX) break block7;
                                                            if (this.code != SystemFunctionUnit.MIN) break block8;
                                                        }
                                                        this.valueType = var1_1[0].getValueType() == 100 || var1_1[1].getValueType() == 100 ? 100 : 101;
                                                        break block4;
                                                    }
                                                    if (this.code == SystemFunctionUnit.NAN) break block9;
                                                    if (this.code == SystemFunctionUnit.INF) break block9;
                                                    if (this.code == SystemFunctionUnit.INVALID) break block9;
                                                    if (this.code != SystemFunctionUnit.ASSERT) break block10;
                                                }
                                                this.valueType = 105;
                                                break block4;
                                            }
                                            if (this.code == SystemFunctionUnit.BINARY) break block11;
                                            if (this.code == SystemFunctionUnit.OCTAL) break block11;
                                            if (this.code != SystemFunctionUnit.HEX) break block12;
                                        }
                                        this.valueType = 102;
                                        break block4;
                                    }
                                    if (this.code == SystemFunctionUnit.AND) break block13;
                                    if (this.code == SystemFunctionUnit.OR) break block13;
                                    if (this.code != SystemFunctionUnit.XOR) break block14;
                                }
                                this.valueType = 101;
                                break block4;
                            }
                            if (this.code == SystemFunctionUnit.REAL) break block15;
                            if (this.code != SystemFunctionUnit.IMAG) break block16;
                        }
                        this.valueType = var1_1[0].getValueType() == 140 ? 100 : (var1_1[0].getValueType() == 141 ? 103 : 0x7FFFFFFF);
                        break block4;
                    }
                    if (this.code == SystemFunctionUnit.REALSET) break block17;
                    if (this.code != SystemFunctionUnit.IMAGSET) break block18;
                }
                this.valueType = var1_1[0].getValueType() == 140 ? 100 : (var1_1[0].getValueType() == 141 ? 103 : 0x7FFFFFFF);
                break block4;
            }
            if (this.code == SystemFunctionUnit.ALLOC) ** GOTO lbl-1000
            if (this.code == SystemFunctionUnit.FREE) lbl-1000:
            // 2 sources

            {
                this.valueType = 0x7FFFFFFF;
            } else {
                this.valueType = 100;
            }
        }
        this.nodeType = 200;
        this.inputUnit = var1_1;
    }

    public static boolean isProcessable(String string) {
        return string.equals("___exit") || string.equals("___error") || string.equals("___assert") || string.equals("___rank") || string.equals("dimension") || string.equals("___length") || string.equals("___round") || string.equals("___output") || string.equals("SYSTEM_PROCESS_SFU_complex_real") || string.equals("SYSTEM_PROCESS_SFU_complex_imag") || string.equals("SYSTEM_PROCESS_SFU_complex_realSet") || string.equals("SYSTEM_PROCESS_SFU_complex_imagSet") || string.equals("SYSTEM_PROCESS_CLOCK_millisecond") || string.equals("SYSTEM_PROCESS_initialize") || string.equals("SYSTEM_PROCESS_MMU_alloc") || string.equals("SYSTEM_PROCESS_MMU_free") || string.equals("SYSTEM_PROCESS_FPU_sin") || string.equals("SYSTEM_PROCESS_FPU_cos") || string.equals("SYSTEM_PROCESS_FPU_tan") || string.equals("SYSTEM_PROCESS_FPU_acos") || string.equals("SYSTEM_PROCESS_FPU_asin") || string.equals("SYSTEM_PROCESS_FPU_atan") || string.equals("SYSTEM_PROCESS_FPU_sinh") || string.equals("SYSTEM_PROCESS_FPU_cosh") || string.equals("SYSTEM_PROCESS_FPU_tanh") || string.equals("SYSTEM_PROCESS_FPU_acosh") || string.equals("SYSTEM_PROCESS_FPU_asinh") || string.equals("SYSTEM_PROCESS_FPU_atanh") || string.equals("SYSTEM_PROCESS_FPU_sqrt") || string.equals("SYSTEM_PROCESS_FPU_exp") || string.equals("SYSTEM_PROCESS_FPU_log10") || string.equals("SYSTEM_PROCESS_FPU_ln") || string.equals("SYSTEM_PROCESS_FPU_abs") || string.equals("SYSTEM_PROCESS_FPU_fac") || string.equals("SYSTEM_PROCESS_FPU_max") || string.equals("SYSTEM_PROCESS_FPU_min") || string.equals("SYSTEM_PROCESS_FPU_rand") || string.equals("SYSTEM_PROCESS_FPU_pow") || string.equals("SYSTEM_PROCESS_FPU_root") || string.equals("SYSTEM_PROCESS_FPU_orderVF") || string.equals("SYSTEM_PROCESS_FPU_factorVF") || string.equals("SYSTEM_PROCESS_FPU_nanF") || string.equals("SYSTEM_PROCESS_FPU_infF") || string.equals("SYSTEM_PROCESS_FPU_invalidS") || string.equals("SYSTEM_PROCESS_FPU_binary") || string.equals("SYSTEM_PROCESS_FPU_octal") || string.equals("SYSTEM_PROCESS_FPU_hex") || string.equals("SYSTEM_PROCESS_FPU_and") || string.equals("SYSTEM_PROCESS_FPU_or") || string.equals("SYSTEM_PROCESS_FPU_xor") || string.equals("SYSTEM_PROCESS_FPU_deg") || string.equals("SYSTEM_PROCESS_FPU_rad");
    }

    public int getFunctionCode(String string) {
        this.functionName = string;
        if (string.equals("___exit")) {
            return EXIT;
        }
        if (string.equals("___error")) {
            return ERROR;
        }
        if (string.equals("___assert")) {
            return ASSERT;
        }
        if (string.equals("___rank") || string.equals("dimension")) {
            return DIMENSION;
        }
        if (string.equals("___length")) {
            return LENGTH;
        }
        if (string.equals("___output")) {
            return OUTPUT;
        }
        if (string.equals("SYSTEM_PROCESS_SFU_complex_real")) {
            return REAL;
        }
        if (string.equals("SYSTEM_PROCESS_SFU_complex_imag")) {
            return IMAG;
        }
        if (string.equals("SYSTEM_PROCESS_SFU_complex_realSet")) {
            return REALSET;
        }
        if (string.equals("SYSTEM_PROCESS_SFU_complex_imagSet")) {
            return IMAGSET;
        }
        if (string.equals("SYSTEM_PROCESS_CLOCK_millisecond")) {
            return TIME;
        }
        if (string.equals("SYSTEM_PROCESS_initialize")) {
            return INIT;
        }
        if (string.equals("SYSTEM_PROCESS_MMU_alloc")) {
            return ALLOC;
        }
        if (string.equals("SYSTEM_PROCESS_MMU_free")) {
            return FREE;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_sin")) {
            return SIN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_cos")) {
            return COS;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_tan")) {
            return TAN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_asin")) {
            return ASIN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_acos")) {
            return ACOS;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_atan")) {
            return ATAN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_sinh")) {
            return SINH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_cosh")) {
            return COSH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_tanh")) {
            return TANH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_asinh")) {
            return ASINH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_acosh")) {
            return ACOSH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_atanh")) {
            return ATANH;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_sqrt")) {
            return SQRT;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_exp")) {
            return EXP;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_log10")) {
            return LOG10;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_ln")) {
            return LN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_abs")) {
            return ABS;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_fac")) {
            return FAC;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_max")) {
            return MAX;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_min")) {
            return MIN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_rand")) {
            return RAND;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_pow")) {
            return POW;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_root")) {
            return ROOT;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_orderVF")) {
            return ORDER;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_factorVF")) {
            return FACTOR;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_nanF")) {
            return NAN;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_infF")) {
            return INF;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_invalidS")) {
            return INVALID;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_binary")) {
            return BINARY;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_octal")) {
            return OCTAL;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_hex")) {
            return HEX;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_and")) {
            return AND;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_or")) {
            return OR;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_xor")) {
            return XOR;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_rad")) {
            return RAD;
        }
        if (string.equals("SYSTEM_PROCESS_FPU_deg")) {
            return DEG;
        }
        if (string.equals("___round")) {
            return ROUND;
        }
        return -1;
    }

    @Override
    public void process() {
        if (this.arrayType) {
            if (this.code == LENGTH && this.inputUnit.length == 1) {
                return;
            }
        }
        if (this.code == INIT) {
            if (this.inputUnit[0].getValueType() == 200) {
                if (this.inputUnit[0].isArrayType()) {
                    if (this.inputUnit[0] instanceof StructArrayUnit) {
                        ((StructArrayUnit)this.inputUnit[0]).setAllElementDefaulted(false);
                    } else if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u69cb\u9020\u4f53\u914d\u5217\u300c " + this.inputUnit[0].getName() + " \u300d\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                    } else {
                        this.error("Failed to initialize the array of the struct \"" + this.inputUnit[0].getName() + "\".");
                    }
                } else {
                    this.inputUnit[0].setDefaulted(false);
                }
            }
            this.inputUnit[0].readyMember();
        } else if (this.code == LENGTH && this.inputUnit.length != 1) {
            int n;
            int n2 = (int)this.inputUnit[1].getIntegerValue();
            if (this.inputUnit[0] instanceof ReferenceUnit) {
                ((ReferenceUnit)this.inputUnit[0]).checkReference();
            }
            if ((n = this.inputUnit[0].getLength().length) <= n2) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.throwRuntimeError(n + "\u6b21\u5143\u306e\u914d\u5217\u300c " + this.inputUnit[0].getName() + " \u300d\u306b\u5bfe\u3057\u3066\u3001" + n2 + " \u6b21\u5143\u76ee\uff08\u5de6\u304b\u30890,1,2, ...\uff09\u306e\u8981\u7d20\u6570\u3092 length \u95a2\u6570\u3067\u8abf\u3079\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u305d\u306e\u6b21\u5143\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                } else {
                    this.throwRuntimeError(n + "Cannot get the length of " + n2 + "-th dimension (from the left, 0, 1, 2...) of the array \"" + this.inputUnit[0].getName() + "\", because such dimension does not exist.");
                }
            }
            this.integerValue = this.inputUnit[0].getLength()[n2];
        } else if (this.code == SIN) {
            this.decimalValue = Math.sin(this.inputUnit[0].getDecimalValue());
        } else if (this.code == COS) {
            this.decimalValue = Math.cos(this.inputUnit[0].getDecimalValue());
        } else if (this.code == TAN) {
            this.decimalValue = Math.tan(this.inputUnit[0].getDecimalValue());
        } else if (this.code == SQRT) {
            this.decimalValue = Math.sqrt(this.inputUnit[0].getDecimalValue());
        } else if (this.code == EXP) {
            this.decimalValue = Math.exp(this.inputUnit[0].getDecimalValue());
        } else if (this.code == LOG10) {
            this.decimalValue = Math.log(this.inputUnit[0].getDecimalValue()) / Math.log(10.0);
        } else if (this.code == LN) {
            this.decimalValue = Math.log(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ABS) {
            if (this.valueType == 101) {
                this.integerValue = this.inputUnit[0].getIntegerValue();
                if (this.integerValue < 0L) {
                    this.integerValue = -this.integerValue;
                }
            }
            if (this.valueType == 100) {
                this.decimalValue = this.inputUnit[0].getDecimalValue();
                if (this.decimalValue < 0.0) {
                    this.decimalValue = -this.decimalValue;
                }
            }
        } else if (this.code == REAL) {
            if (this.inputUnit[0].getValueType() == 140) {
                this.decimalValue = this.inputUnit[0].getComplexValue()[0];
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.bigDecimalValue = this.inputUnit[0].getBigComplexValue()[0];
            }
        } else if (this.code == IMAG) {
            if (this.inputUnit[0].getValueType() == 140) {
                this.decimalValue = this.inputUnit[0].getComplexValue()[1];
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.bigDecimalValue = this.inputUnit[0].getBigComplexValue()[1];
            }
        } else if (this.code == REALSET) {
            if (this.inputUnit[0].getValueType() == 140) {
                this.inputUnit[0].setComplexValue(new double[]{this.inputUnit[1].getDecimalValue(), this.inputUnit[0].getComplexValue()[1]});
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.inputUnit[0].setBigComplexValue(new BigDecimal[]{this.inputUnit[1].getFixedDigitBigDecimal(this.inputUnit[1].getBigDecimalValue()), this.inputUnit[0].getBigComplexValue()[1]});
            }
        } else if (this.code == IMAGSET) {
            if (this.inputUnit[0].getValueType() == 140) {
                this.inputUnit[0].setComplexValue(new double[]{this.inputUnit[0].getComplexValue()[0], this.inputUnit[1].getDecimalValue()});
            } else if (this.inputUnit[0].getValueType() == 141) {
                this.inputUnit[0].setBigComplexValue(new BigDecimal[]{this.inputUnit[0].getBigComplexValue()[0], this.inputUnit[1].getFixedDigitBigDecimal(this.inputUnit[1].getBigDecimalValue())});
            }
        } else if (this.code == ASIN) {
            this.decimalValue = Math.asin(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ACOS) {
            this.decimalValue = Math.acos(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ATAN) {
            this.decimalValue = Math.atan(this.inputUnit[0].getDecimalValue());
        } else if (this.code == SINH) {
            this.decimalValue = this.sinh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == COSH) {
            this.decimalValue = this.cosh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == TANH) {
            this.decimalValue = this.tanh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ASINH) {
            this.decimalValue = this.asinh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ACOSH) {
            this.decimalValue = this.acosh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == ATANH) {
            this.decimalValue = this.atanh(this.inputUnit[0].getDecimalValue());
        } else if (this.code == POW) {
            this.decimalValue = Math.pow(this.inputUnit[0].getDecimalValue(), this.inputUnit[1].getDecimalValue());
        } else if (this.code == ROOT) {
            this.decimalValue = Math.pow(this.inputUnit[0].getDecimalValue(), 1.0 / (double)this.inputUnit[1].getIntegerValue());
        } else if (this.code == BINARY) {
            this.stringValue = "0b" + Long.toBinaryString(this.inputUnit[0].getIntegerValue());
        } else if (this.code == OCTAL) {
            this.stringValue = "0o" + Long.toOctalString(this.inputUnit[0].getIntegerValue());
        } else if (this.code == HEX) {
            this.stringValue = "0x" + Long.toHexString(this.inputUnit[0].getIntegerValue());
        } else if (this.code == AND) {
            this.integerValue = this.inputUnit[0].getIntegerValue() & this.inputUnit[1].getIntegerValue();
        } else if (this.code == OR) {
            this.integerValue = this.inputUnit[0].getIntegerValue() | this.inputUnit[1].getIntegerValue();
        } else if (this.code == XOR) {
            this.integerValue = this.inputUnit[0].getIntegerValue() ^ this.inputUnit[1].getIntegerValue();
        } else if (this.code == DEG) {
            this.decimalValue = this.inputUnit[0].getDecimalValue() * 180.0 / Math.PI;
        } else if (this.code == RAD) {
            this.decimalValue = this.inputUnit[0].getDecimalValue() * Math.PI / 180.0;
        } else if (this.code == MAX) {
            if (this.valueType == 101) {
                this.integerValue = Math.max(this.inputUnit[0].getIntegerValue(), this.inputUnit[1].getIntegerValue());
            }
            if (this.valueType == 100) {
                this.decimalValue = Math.max(this.inputUnit[0].getDecimalValue(), this.inputUnit[1].getDecimalValue());
            }
        } else if (this.code == MIN) {
            if (this.valueType == 101) {
                this.integerValue = Math.min(this.inputUnit[0].getIntegerValue(), this.inputUnit[1].getIntegerValue());
            }
            if (this.valueType == 100) {
                this.decimalValue = Math.min(this.inputUnit[0].getDecimalValue(), this.inputUnit[1].getDecimalValue());
            }
        } else if (this.code == FAC) {
            long l = this.inputUnit[0].getIntegerValue();
            long l2 = 1L;
            for (long i = 1L; i <= l; ++i) {
                l2 *= i;
            }
            this.integerValue = l2;
        } else if (this.code == RAND) {
            this.decimalValue = Math.random();
        } else if (this.code == TIME) {
            this.integerValue = System.currentTimeMillis() - this.processEngine.startTime;
        } else if (this.code == EXIT) {
            this.kernel.callExit();
        } else {
            if (this.code == ERROR) {
                String string = this.inputUnit[0].getStringValue();
                this.processEngine.errorWaitFor = true;
                this.error(string);
                ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
                processRuntimeException.sourceFile = "???";
                processRuntimeException.sourceLine = "???";
                throw processRuntimeException;
            }
            if (this.code == DIGIT) {
                int n = (int)this.inputUnit[0].getIntegerValue();
                if (0 < n) {
                    MathContext mathContext = (MathContext)this.processEngine.getMathContext();
                    this.processEngine.setMathContext(new MathContext(n, mathContext.getRoundingMode()));
                }
                this.integerValue = this.processEngine.getProcessDigit();
            } else if (this.code == ROUND) {
                MathContext mathContext = (MathContext)this.processEngine.getMathContext();
                int n = (int)this.inputUnit[0].getIntegerValue();
                if (n == 1) {
                    this.processEngine.setMathContext(new MathContext(mathContext.getPrecision(), RoundingMode.UP));
                } else if (n == 2) {
                    this.processEngine.setMathContext(new MathContext(mathContext.getPrecision(), RoundingMode.DOWN));
                } else if (n == 3) {
                    this.processEngine.setMathContext(new MathContext(mathContext.getPrecision(), RoundingMode.HALF_UP));
                } else if (n == 4) {
                    this.processEngine.setMathContext(new MathContext(mathContext.getPrecision(), RoundingMode.HALF_DOWN));
                } else if (n == 5) {
                    this.processEngine.setMathContext(new MathContext(mathContext.getPrecision(), RoundingMode.HALF_EVEN));
                }
            } else if (this.code == GETDIGIT) {
                this.integerValue = this.processEngine.getProcessDigit();
            } else if (this.code == DIMENSION) {
                this.integerValue = this.inputUnit[0].getArrayDimension();
            } else if (this.code == ORDER) {
                if (this.bigDecimalCore == null) {
                    this.bigDecimalCore = new ProcessUnitBigDecimalCore(this.processEngine);
                }
                this.integerValue = this.bigDecimalCore.getOrder(this.inputUnit[0].getBigDecimalValue());
            } else if (this.code == NAN) {
                this.booleanValue = Double.isNaN(this.inputUnit[0].getDecimalValue());
            } else if (this.code == INF) {
                this.booleanValue = Double.isInfinite(this.inputUnit[0].getDecimalValue());
            } else if (this.code == INVALID) {
                this.booleanValue = this.inputUnit[0].getStringValue() == null;
            } else if (this.code == ASSERT) {
                if (!this.inputUnit[0].getBooleanValue()) {
                    String string = ScriptProcessor.locale.isJapanese() ? "assert \u306e\u5185\u5bb9\u304c false \u306b\u306a\u308a\u307e\u3057\u305f\u3002" : "The value/expression passed to \"assert\" function is false.";
                    this.processEngine.errorWaitFor = true;
                    this.error(string);
                    ProcessRuntimeException processRuntimeException = new ProcessRuntimeException();
                    processRuntimeException.sourceFile = "???";
                    processRuntimeException.sourceLine = "???";
                    throw processRuntimeException;
                }
            } else if (this.code == OUTPUT) {
                if (1 < this.inputUnit.length) {
                    for (int i = 0; i < this.inputUnit.length; ++i) {
                        if (!this.inputUnit[i].isArrayType()) continue;
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u53ef\u5909\u9577\u5f15\u6570\u306b\u914d\u5217\u3092\u6e21\u3059\u5834\u5408\u306f\u30011\u500b\u306b\u9650\u3089\u308c\u307e\u3059\u3002");
                            continue;
                        }
                        this.error("Cannot pass multiple arrays for variadic arguments.");
                    }
                }
                this.processEngine.output(this.inputUnit);
            } else if (this.code == ALLOC) {
                int n;
                int n3;
                if (!(this.inputUnit[0] instanceof IntegerArrayUnit || this.inputUnit[0] instanceof DecimalArrayUnit || this.inputUnit[0] instanceof ComplexArrayUnit || this.inputUnit[0] instanceof BigIntegerArrayUnit || this.inputUnit[0] instanceof BigDecimalArrayUnit || this.inputUnit[0] instanceof BigComplexArrayUnit || this.inputUnit[0] instanceof BooleanArrayUnit || this.inputUnit[0] instanceof StringArrayUnit || this.inputUnit[0] instanceof StructArrayUnit || this.inputUnit[0] instanceof ReferenceUnit && this.inputUnit[0].isArrayType())) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("alloc \u95a2\u6570\u306e\u6700\u521d\u306e\u5f15\u6570\u3068\u3057\u3066\u6e21\u305b\u308b\u306e\u306f\u3001\u914d\u5217\u5909\u6570\u306b\u9650\u3089\u308c\u307e\u3059\u3002");
                    } else {
                        this.error("The first argument of \"alloc\" function must be an array, not a scalar");
                    }
                }
                int n4 = n3 = this.inputUnit[0].getLength() == null ? 0 : this.inputUnit[0].getLength().length;
                if (this.inputUnit.length - 1 != n3) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("alloc \u95a2\u6570\u306e2\u756a\u76ee\u4ee5\u964d\u306e\u5f15\u6570\u306e\u500b\u6570\u306f\u3001\u914d\u5217\u306e\u6b21\u5143\u306e\u6570(" + n3 + ")\u3068\u540c\u3058\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u7570\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
                    } else {
                        this.error("The number of arguments passed to \"alloc\" function must be the number of the array dimensions + 1.");
                    }
                }
                for (n = 0; n < n3; ++n) {
                    if (this.inputUnit[n + 1].getValueType() == 101) continue;
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("alloc \u95a2\u6570\u306e2\u756a\u76ee\u4ee5\u964d\u306e\u5f15\u6570\u3068\u3057\u3066\u6e21\u305b\u308b\u306e\u306f\u3001int \u578b\u306e\u5024\u306b\u9650\u3089\u308c\u307e\u3059\u3002");
                        continue;
                    }
                    this.error("For the second or latter arguments of \"alloc\" function, only int type values/variables are acceptable.");
                }
                n = this.inputUnit.length;
                int[] nArray = new int[n - 1];
                for (int i = 0; i < n - 1; ++i) {
                    nArray[i] = (int)this.inputUnit[i + 1].getIntegerValue();
                }
                this.inputUnit[0].alloc(nArray);
            } else if (this.code == FREE) {
                if (!(this.inputUnit[0] instanceof IntegerArrayUnit || this.inputUnit[0] instanceof DecimalArrayUnit || this.inputUnit[0] instanceof ComplexArrayUnit || this.inputUnit[0] instanceof BigIntegerArrayUnit || this.inputUnit[0] instanceof BigDecimalArrayUnit || this.inputUnit[0] instanceof BigComplexArrayUnit || this.inputUnit[0] instanceof BooleanArrayUnit || this.inputUnit[0] instanceof StringArrayUnit || this.inputUnit[0] instanceof StructArrayUnit || this.inputUnit[0] instanceof ReferenceUnit && this.inputUnit[0].isArrayType())) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("free \u95a2\u6570\u306e\u6700\u521d\u306e\u5f15\u6570\u3068\u3057\u3066\u6e21\u305b\u308b\u306e\u306f\u3001\u914d\u5217\u5909\u6570\u306b\u9650\u3089\u308c\u307e\u3059\u3002");
                    } else {
                        this.error("For the argument of \"free\" function, only an array variable is acceptable.");
                    }
                }
                int n = this.inputUnit[0].getLength() == null ? 0 : this.inputUnit[0].getLength().length;
                int[] nArray = new int[n];
                Arrays.fill(nArray, 0);
                this.inputUnit[0].alloc(nArray);
            }
        }
    }

    public double sinh(double d) {
        double d2 = (Math.exp(d) - Math.exp(-d)) / 2.0;
        return d2;
    }

    public double cosh(double d) {
        double d2 = (Math.exp(d) + Math.exp(-d)) / 2.0;
        return d2;
    }

    public double tanh(double d) {
        double d2 = (Math.exp(d) - Math.exp(-d)) / (Math.exp(d) + Math.exp(-d));
        return d2;
    }

    public double asinh(double d) {
        double d2 = Math.log(d + Math.sqrt(d * d + 1.0));
        return d2;
    }

    public double acosh(double d) {
        double d2 = Math.log(d + Math.sqrt(d * d - 1.0));
        return d2;
    }

    public double atanh(double d) {
        double d2 = (Math.log(1.0 + d) - Math.log(1.0 - d)) / 2.0;
        return d2;
    }

    @Override
    public String getFormula() {
        return this.getFormula(Integer.MAX_VALUE);
    }

    @Override
    public String getFormula(int n) {
        String string = this.functionName;
        if (string.startsWith("SYSTEM_PROCESS_FPU_")) {
            string = string.replaceAll("SYSTEM_PROCESS_FPU_", "");
        }
        if (this.getRank() == n) {
            return this.getStringValue();
        }
        String string2 = "";
        string2 = n == this.getRank() + 1 ? "[ " + string + "(" : string + "(";
        for (int i = 0; i < this.inputUnit.length; ++i) {
            string2 = i < this.inputUnit.length - 1 ? string2 + this.inputUnit[i].getFormula(n) + "," : string2 + this.inputUnit[i].getFormula(n);
        }
        string2 = n == this.getRank() + 1 ? string2 + ") = " + this.getStringValue() + " ]" : string2 + ")";
        return string2;
    }
}

