/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import rxvesapi.system.PinsetOperatorKernel;

public class DecompressionEngine {
    ZipInputStream zipInputStream;
    ZipEntry zipEntry;
    File decompressLocationFile;
    File decompressTargetFile;
    public PinsetOperatorKernel kernel;

    public DecompressionEngine() {
    }

    public DecompressionEngine(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
    }

    public void setKernel(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
    }

    public void open(String string) throws FileNotFoundException {
        this.decompressTargetFile = new File(string);
        this.zipInputStream = new ZipInputStream(new FileInputStream(this.decompressTargetFile));
    }

    public void open(File file) throws FileNotFoundException {
        this.decompressTargetFile = file;
        this.zipInputStream = new ZipInputStream(new FileInputStream(this.decompressTargetFile));
    }

    public void close() {
        try {
            this.zipInputStream.closeEntry();
            this.zipInputStream.close();
            this.zipInputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setDecompressLocation(String string) {
        this.decompressLocationFile = new File(string);
    }

    public void setDecompressLocation(File file) {
        this.decompressLocationFile = file;
    }

    public int getTotalNumberOfEntries() {
        int n = 0;
        try {
            this.open(this.decompressTargetFile);
            while (this.zipInputStream.getNextEntry() != null) {
                ++n;
            }
            this.open(this.decompressTargetFile);
            return n;
        }
        catch (IOException iOException) {
            return 1;
        }
    }

    public File decompressNext() {
        try {
            this.zipEntry = this.zipInputStream.getNextEntry();
            if (this.zipEntry == null) {
                return null;
            }
            if (this.zipEntry.isDirectory()) {
                File file = new File(this.decompressLocationFile, this.zipEntry.getName());
                file.mkdir();
                return file;
            }
            File file = new File(this.decompressLocationFile, this.zipEntry.getName());
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdir();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = this.zipInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

