/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.io.File;
import rxvesapi.system.FileSortManager;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorDirectoryManager {
    public PinsetOperatorKernel kernel;
    private FileSortManager sorter;
    private File currentDirectory;
    private File[] currentList;
    private File[] previousDirectory;
    private File[] nextDirectory;
    private int previousCapacity = 50;
    private int nextCapacity = 50;
    private int previousReserving_N = 0;
    private int nextReserving_N = 0;

    public PinsetOperatorDirectoryManager(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
        this.init();
    }

    public PinsetOperatorDirectoryManager() {
        this.init();
    }

    public void init() {
        int n;
        this.sorter = new FileSortManager();
        this.previousDirectory = new File[this.previousCapacity];
        this.nextDirectory = new File[this.nextCapacity];
        for (n = 0; n < this.previousCapacity; ++n) {
            this.previousDirectory[n] = new File(".");
        }
        for (n = 0; n < this.nextCapacity; ++n) {
            this.nextDirectory[n] = new File(".");
        }
    }

    public File[] listFiles() {
        if (this.currentDirectory.getName().equals("DRIVE SELECT")) {
            PinsetOperatorDirectoryManager pinsetOperatorDirectoryManager = this;
            this.currentList = pinsetOperatorDirectoryManager.currentDirectory.listRoots();
        } else {
            this.currentList = this.currentDirectory.listFiles();
        }
        this.currentList = this.sorter.getSortedFile(this.currentList);
        return this.currentList;
    }

    public String[] list() {
        this.listFiles();
        String[] stringArray = new String[this.currentList.length];
        for (int i = 0; i < this.currentList.length; ++i) {
            stringArray[i] = this.currentList[i].getName();
            if (!this.currentList[i].getName().equals("") && this.currentList[i] != null) continue;
            stringArray[i] = this.currentList[i].getPath();
        }
        return stringArray;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        if (this.currentDirectory != null) {
            this.savePreviousDirectory(this.currentDirectory);
        }
        this.currentDirectory = file;
        this.currentList = this.currentDirectory.listFiles();
        this.currentList = this.sorter.getSortedFile(this.currentList);
    }

    public void goParent() {
        if (!this.currentDirectory.getName().equals("DRIVE SELECT")) {
            try {
                this.savePreviousDirectory(this.currentDirectory);
                this.currentDirectory = new File(this.currentDirectory.getParent());
                this.currentList = this.currentDirectory.listFiles();
                this.currentList = this.sorter.getSortedFile(this.currentList);
            }
            catch (NullPointerException nullPointerException) {
                this.goDriveSelecter();
            }
        }
    }

    public void goNext() {
        try {
            if (this.nextReserving_N > 0) {
                this.savePreviousDirectory(this.currentDirectory);
                this.currentDirectory = this.loadNextDirectory();
                if (this.currentDirectory.getName().equals("DRIVE SELECT")) {
                    this.goDriveSelecter();
                } else {
                    this.currentList = this.currentDirectory.listFiles();
                    this.currentList = this.sorter.getSortedFile(this.currentList);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.goDriveSelecter();
        }
    }

    public void goPrevious() {
        try {
            if (this.previousReserving_N > 0) {
                this.saveNextDirectory(this.currentDirectory);
                this.currentDirectory = this.loadPreviousDirectory();
                if (this.currentDirectory.getName().equals("DRIVE SELECT")) {
                    this.goDriveSelecter();
                } else {
                    this.currentList = this.currentDirectory.listFiles();
                    this.currentList = this.sorter.getSortedFile(this.currentList);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.goDriveSelecter();
        }
    }

    public void goDriveSelecter() {
        this.currentDirectory = new File("./DRIVE SELECT");
        PinsetOperatorDirectoryManager pinsetOperatorDirectoryManager = this;
        this.currentList = pinsetOperatorDirectoryManager.currentDirectory.listRoots();
        this.currentList = this.sorter.getSortedFile(this.currentList);
        this.currentList = this.sorter.getSortedFile(this.currentList);
    }

    public void savePreviousDirectory(File file) {
        int n = this.previousDirectory.length;
        for (int i = n - 1; i > 0; --i) {
            this.previousDirectory[i] = this.previousDirectory[i - 1];
        }
        this.previousDirectory[0] = file;
        ++this.previousReserving_N;
    }

    public void saveNextDirectory(File file) {
        int n = this.nextDirectory.length;
        for (int i = n - 1; i > 0; --i) {
            this.nextDirectory[i] = this.nextDirectory[i - 1];
        }
        this.nextDirectory[0] = file;
        ++this.nextReserving_N;
    }

    public File loadPreviousDirectory() {
        File file = this.previousDirectory[0];
        int n = this.previousDirectory.length;
        for (int i = 0; i < n - 1; ++i) {
            this.previousDirectory[i] = this.previousDirectory[i + 1];
        }
        this.previousDirectory[n - 1] = this.previousDirectory[n - 2];
        --this.previousReserving_N;
        return file;
    }

    public File loadNextDirectory() {
        File file = this.nextDirectory[0];
        int n = this.nextDirectory.length;
        for (int i = 0; i < n - 1; ++i) {
            this.nextDirectory[i] = this.nextDirectory[i + 1];
        }
        this.nextDirectory[n - 1] = this.nextDirectory[n - 2];
        --this.nextReserving_N;
        return file;
    }
}

