/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rxvesapi.system.PinsetOperatorBrowsable;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorFileReserveWindow
extends JFrame
implements ActionListener {
    public TextArea displayArea;
    private File[] selectingFile;
    private File[] copyTargetFile;
    private File[] removeTargetFile;
    PinsetOperatorKernel kernel;
    public JButton copyButton;
    public JButton removeButton;
    public JButton listButton;
    public PinsetOperatorBrowsable browsable;

    public void addBrowserListener(PinsetOperatorBrowsable pinsetOperatorBrowsable) {
        this.browsable = pinsetOperatorBrowsable;
    }

    public PinsetOperatorFileReserveWindow(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
        this.init();
    }

    public PinsetOperatorFileReserveWindow() {
    }

    public void init() {
        this.selectingFile = new File[0];
        this.setBounds(0, 0, 350, 160);
        this.setVisible(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Select");
        this.displayArea = new TextArea();
        this.displayArea.setBounds(10, 10, 320, 70);
        this.displayArea.setVisible(true);
        this.getContentPane().add(this.displayArea);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(this);
        this.copyButton.setVisible(true);
        jPanel.add(this.copyButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setVisible(true);
        jPanel.add(this.removeButton);
        this.listButton = new JButton("List");
        this.listButton.addActionListener(this);
        this.listButton.setVisible(true);
        jPanel.add(this.listButton);
        jPanel.setBounds(10, 90, 320, 24);
        this.getContentPane().add(jPanel);
        jPanel.setVisible(true);
    }

    public void reserve(File[] fileArray) {
        int n;
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (!this.isVisible()) {
            this.format();
        }
        File[] fileArray2 = new File[this.selectingFile.length];
        for (n = 0; n < this.selectingFile.length; ++n) {
            fileArray2[n] = this.selectingFile[n];
        }
        this.selectingFile = new File[this.selectingFile.length + fileArray.length];
        for (n = 0; n < fileArray2.length; ++n) {
            this.selectingFile[n] = fileArray2[n];
        }
        for (n = 0; n < fileArray.length; ++n) {
            this.selectingFile[fileArray2.length + n] = fileArray[n];
            this.displayArea.append(fileArray[n].getName());
            this.displayArea.append(System.getProperty("line.separator"));
        }
        fileArray2 = null;
        this.setVisible(true);
    }

    public void reserve(File file) {
        int n;
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (!this.isVisible()) {
            this.format();
        }
        File[] fileArray = new File[this.selectingFile.length];
        for (n = 0; n < this.selectingFile.length; ++n) {
            fileArray[n] = this.selectingFile[n];
        }
        this.selectingFile = new File[this.selectingFile.length + 1];
        for (n = 0; n < fileArray.length; ++n) {
            this.selectingFile[n] = fileArray[n];
        }
        this.selectingFile[this.selectingFile.length - 1] = file;
        fileArray = null;
        this.displayArea.append(file.getName());
        this.displayArea.append(System.getProperty("line.separator"));
        this.setVisible(true);
    }

    public void format() {
        this.selectingFile = new File[0];
        this.removeTargetFile = new File[0];
        this.displayArea.setText("");
    }

    public File[] getReservedFiles() {
        return this.selectingFile;
    }

    public void setEnglish() {
        this.copyButton.setText("Copy");
        this.removeButton.setText("Remove");
        this.listButton.setText("List");
    }

    public void setJapanese() {
        this.copyButton.setText("\u30b3\u30d4\u30fc");
        this.removeButton.setText("\u524a\u9664");
        this.listButton.setText("\u30ea\u30b9\u30c8");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        this.kernel.keyPressing_CTRL = false;
        if (object == this.copyButton) {
            this.kernel.copyTargetFiles = this.selectingFile;
            this.setVisible(false);
        } else if (object == this.removeButton) {
            if (!this.kernel.isTrashReserved(this.selectingFile[0])) {
                String[] stringArray = new String[]{"\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u524a\u9664\u4fdd\u7ba1\u5834\u6240\u306b\u79fb\u52d5\u3057\u307e\u3059\u304b?", "Do you want to move these files ( or directories ) to `TrashReserver' directory?"};
                int n = JOptionPane.showConfirmDialog(null, stringArray, "\uff01 CAUTION ", 0);
                if (n == 0) {
                    for (int i = 0; i < this.selectingFile.length; ++i) {
                        this.kernel.trashFile(this.selectingFile[i]);
                        if (this.browsable == null) continue;
                        this.browsable.fileRemoved(this.selectingFile[i]);
                    }
                }
            } else {
                String[] stringArray = new String[]{"\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u30b3\u30f3\u30d4\u30e5\u30fc\u30bf\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002", "\u524a\u9664\u3059\u308b\u3068\u3001\u30b4\u30df\u7bb1\u306a\u3069\u304b\u3089\u3082\u5fa9\u5143\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002", "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b?", "You will be unable to restor these files ( or directories ) anyway, if you delete it.", "Are you sure you want to delete these files ( or directories ) from your computer?"};
                int n = JOptionPane.showConfirmDialog(null, stringArray, "\uff01 CAUTION ", 0);
                if (n == 0) {
                    int n2 = this.kernel.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_PROCESSRESERVE"));
                    int n3 = this.kernel.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_REMOVEPROCESS"));
                    if (n3 > 0 && n2 > 0) {
                        for (int i = 0; i < this.selectingFile.length; ++i) {
                            String[] stringArray2 = new String[]{Integer.toString(n3), this.selectingFile[i].getPath()};
                            this.kernel.generate_DIRECT(stringArray2, n2);
                        }
                    } else {
                        for (int i = 0; i < this.selectingFile.length; ++i) {
                            this.kernel.deleteFile(this.selectingFile[i]);
                        }
                    }
                    this.format();
                }
            }
            this.setVisible(false);
        } else if (object == this.listButton) {
            int n = this.kernel.getPreferredApplicationID(new File("a.filelist"));
            this.kernel.generate(this.selectingFile, n);
            this.setVisible(false);
        }
    }
}

