/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rxvesapi.io.TSVVertexWriter;
import rxvesapi.system.ClassFileEngine;
import rxvesapi.system.JarFileEngine;
import rxvesapi.system.PinsetApplication;
import rxvesapi.system.PinsetApplicationPropertyWindow;
import rxvesapi.system.PinsetFileLink;
import rxvesapi.system.PinsetOperatorApplicationMenu;
import rxvesapi.system.PinsetOperatorBrowsable;
import rxvesapi.system.PinsetOperatorDirectoryManager;
import rxvesapi.system.PinsetOperatorFileMenu;
import rxvesapi.system.PinsetOperatorFileReserveWindow;
import rxvesapi.system.PinsetOperatorMainThread;
import rxvesapi.system.PinsetOperatorMenuBar;
import rxvesapi.system.PinsetOperatorSecurityManager;
import rxvesapi.system.PinsetOperatorStatusDisplayWindow;
import rxvesapi.system.PinsetOperatorSubThread;
import rxvesapi.system3d.geometry.CoordinateSystem3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;
import rxvesapi.system3d.model.BoxModel3DEG;
import rxvesapi.system3d.model.ConeModel3DEG;
import rxvesapi.system3d.renderer.FixedSizeImageElement3DEG;
import rxvesapi.system3d.renderer.FixedSizeStringElement3DEG;
import rxvesapi.system3d.renderer.ImageElement3DEG;
import rxvesapi.system3d.renderer.LineElement3DEG;
import rxvesapi.system3d.renderer.PointLightElement3DEG;
import rxvesapi.system3d.renderer.Realtime3DPanel;
import rxvesapi.system3d.renderer.ScreenSystem3DEG;
import rxvesapi.system3d.renderer.StringElement3DEG;

public class PinsetOperatorKernel
extends JFrame
implements WindowListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener,
ActionListener,
PinsetOperatorBrowsable {
    public static String VERSION = "2.0.BETA";
    public static String DEVELOPMENT_ID = "RVOEKERN_INT100208";
    public static String CODENAME = "INTEGRAL";
    public static int JARFILE = -5;
    public static int CLASSFILE = -4;
    public static int NULLTYPE = -3;
    public static int UNKNOWN = -2;
    public static int DIRECTORY = -1;
    public static int IMPORT_MODE_CUSTOM = -1000;
    public static int IMPORT_MODE_FULL = -1001;
    public static int LANGUAGE_ENGLISH = -2000;
    public static int LANGUAGE_JAPANESE = -2001;
    public double springStrength = 140.0;
    public double springRate_level = 30.0;
    public double springRate_vertical = 30.0;
    public double springRate_center = 30.0;
    public double springFriction = 2.0;
    public double frameRate = 30.0;
    public int importMode = IMPORT_MODE_CUSTOM;
    public ClassFileEngine classFileEngine;
    public JarFileEngine jarFileEngine;
    private double ringRadiusMagnification = 0.24;
    private PinsetApplicationPropertyWindow applicationPropertyWindow;
    private int log_crystal_red = 30;
    private int log_crystal_green = 255;
    private int log_crystal_blue = 255;
    private int log_crystal_alpha = 120;
    private String log_browser = "null";
    private String log_command = "null";
    private String log_screen_absolute = "null";
    private String log_screen_relative = "null";
    private String log_homepage = "";
    private String log_shell = "";
    private String log_lastdirectory_absolute = System.getProperty("user.dir");
    private String log_lastdirectory_relative = System.getProperty("user.dir");
    private String currentPath = System.getProperty("user.dir");
    private File currentDirectory;
    private File stockedDirectory;
    private int directoriesHistoryRegistered_N = 0;
    private int directoriesHistoryCapacity = 50;
    private File[] directoriesHistory = new File[this.directoriesHistoryCapacity];
    private File[] directoriesHistory_cache = new File[this.directoriesHistoryCapacity];
    private String[] ringStrings;
    private File[] ringFiles;
    private StringElement3DEG[] ringStringElements;
    private StringElement3DEG[] ringStringShadowElements;
    private LineElement3DEG[] ringLineElements;
    public ImageElement3DEG[] ringImageElements;
    private int[] ringFileTypes;
    private Vector3DEG[] ringVertexVectors;
    private Vector3DEG[] ringVertexVectors_transformed;
    private int[] ringVertexProjectedX;
    private int[] ringVertexProjectedY;
    private StringElement3DEG[] hierarchyStringElements;
    private StringElement3DEG[] hierarchyStringShadowElements;
    private ImageElement3DEG[] hierarchyImageElements;
    private Realtime3DPanel displayPanel;
    private int width;
    private int height;
    private Dimension dim;
    private double ringRadius;
    private Font offCursorFont;
    private Font onCursorFont;
    private Font hierarchyFont;
    private Font linkFont;
    private double offCursorSize;
    private double onCursorSize;
    ScreenSystem3DEG screen;
    CoordinateSystem3DEG world;
    CoordinateSystem3DEG ringSystem;
    Color onCursorColor;
    Color offCursorColor;
    int cursorOnIndex;
    private double theta;
    private double phi;
    private double lambda;
    private double d_angle;
    private Image backGroundImage;
    private boolean backGroundImageFrag;
    private FixedSizeImageElement3DEG screenImageElement;
    private FixedSizeImageElement3DEG returnIconElement;
    private FixedSizeStringElement3DEG returnPathElement;
    private FixedSizeStringElement3DEG returnPathShadowElement;
    private FixedSizeImageElement3DEG sidebarElement;
    private FixedSizeStringElement3DEG zElement;
    private Image unknownIconImage;
    private Image directoryIconImage;
    private Image classFileIconImage;
    private Image listIconImage;
    private Image returnIconImage;
    private Image browserStayImage;
    private Image browserOpenImage;
    private Image browserCloseImage;
    private ImageIcon returnIcon;
    private Image returnOnImage;
    private Image sidebarImage;
    private ConeModel3DEG centralBarModel;
    private BoxModel3DEG centralFlapModel1;
    private BoxModel3DEG centralFlapModel2;
    private BoxModel3DEG centralFlapModel3;
    private PointLightElement3DEG light1;
    private PointLightElement3DEG light2;
    private PointLightElement3DEG light3;
    private PointLightElement3DEG sun;
    private Image resizedBackGroundImage;
    private Graphics resizedBackGroundGraphics;
    private int centerX;
    private int centerY;
    private Image iconButtonImage;
    private Image pointerImage;
    private FixedSizeImageElement3DEG pointerElement;
    private FixedSizeImageElement3DEG iconButtonElement;
    private FixedSizeImageElement3DEG dragAndDropElement;
    int iconDy;
    int iconOffsetY;
    int iconDx;
    int iconOffsetX;
    int numberOfApplication_TOTAL;
    int numberOfApplication_X;
    int numberOfApplication_Y;
    private double desktopSphereOffsetX;
    private double desktopSphereOffsetY;
    private double desktopSphereOffsetZ;
    private PinsetFileLink[] links;
    private ImageElement3DEG[] linkImageElements;
    private StringElement3DEG[] linkStringElements;
    private StringElement3DEG[] linkStringShadowElements;
    private int[] linkTypes;
    private JPopupMenu fileRightClickMenu;
    private JPopupMenu blankRightClickMenu;
    private JPopupMenu fileLinkRightClickMenu;
    private JPopupMenu applicationRightClickMenu;
    private boolean realtimeFrag;
    private PinsetApplication[] application;
    private FixedSizeImageElement3DEG[] applicationElement;
    private boolean dragAndDropFrag;
    private boolean dragAndDropLocker;
    private boolean linkDragging;
    private int draggingLinkIndex;
    private File rightClickTargetFile;
    public File copyTargetFile;
    private String fileSeparator;
    private String launchPath;
    private String trashPath;
    private File trashDirectory;
    private double fileLinkIconSize;
    private double fileLinkStringSize;
    private double fileLinkDefaultZ;
    private int rightClickedApplicationID;
    public PinsetOperatorSecurityManager pinsetOperatorSecurityManager;
    private double worldOffsetX;
    public int targetedLinkIndex;
    public boolean mouseListenerEnabled;
    public boolean componentListenerEnabled;
    public double ringOffsetX;
    public double ringOffsetY;
    public boolean withCrystalBrowserState;
    public PinsetOperatorMainThread mainThread;
    public PinsetOperatorSubThread subThread;
    private int[] palletApplicationID;
    private boolean backScreenModeState;
    public PinsetOperatorMenuBar mainMenuBar;
    private PinsetOperatorApplicationMenu applicationMenu;
    private PinsetOperatorFileMenu fileMenu;
    public int language;
    public File[] selectingFiles;
    public File[] copyTargetFiles;
    public boolean securityManageFrag;
    public PinsetOperatorStatusDisplayWindow statusDisplayWindow;
    public PinsetOperatorFileReserveWindow fileReserveWindow;
    public PinsetOperatorDirectoryManager directoryManager;
    public boolean keyPressing_CTRL;
    public String nativeShellPath;
    public double iconOffsetX_off;
    public double iconOffsetY_off;
    public double iconOffsetX_on;
    public double iconOffsetY_on;
    public PinsetOperatorBrowsable[] browsable;
    private boolean areaSelecting;
    private boolean areaSelected;
    private int areaSelectingSx;
    private int areaSelectingSy;
    private int areaSelectingEx;
    private int areaSelectingEy;
    public boolean fileGripping;
    public int grippingTargetFileIndex;
    double valueX;
    double valueY;
    int cell_x;
    int cell_y;
    int id;
    double linkDragStartX;
    double linkDragStartY;
    double linkDragStartZ;
    int mouseDraggingStartX;
    int mouseDraggingStartY;
    int mouse_sx;
    int mouse_sy;
    int mouse_ex;
    int mouse_ey;
    int mouse_cursorX;
    int mouse_cursorY;
    double mouse_dx;
    double mouse_dy;
    double mouse_iconDy;
    double x1;
    double x2;
    double y1;
    double y2;
    double R1;
    double d_r;
    double d_theta;
    double dragSpeed;
    int systemFragInt;
    int mouse_sx_first;
    int mouse_sy_first;
    int cursorOnIndexStock;
    private File targetFile;

    public void addBrowserListener(PinsetOperatorBrowsable pinsetOperatorBrowsable) {
        int n;
        PinsetOperatorBrowsable[] pinsetOperatorBrowsableArray = new PinsetOperatorBrowsable[this.browsable.length];
        for (n = 0; n < this.browsable.length; ++n) {
            pinsetOperatorBrowsableArray[n] = this.browsable[n];
        }
        this.browsable = new PinsetOperatorBrowsable[this.browsable.length + 1];
        for (n = 0; n < pinsetOperatorBrowsableArray.length; ++n) {
            this.browsable[n] = pinsetOperatorBrowsableArray[n];
        }
        this.browsable[this.browsable.length - 1] = pinsetOperatorBrowsable;
    }

    public void removeBrowserListener(PinsetOperatorBrowsable pinsetOperatorBrowsable) {
        int n;
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.browsable.length; ++n2) {
            if (this.browsable[n2] != pinsetOperatorBrowsable) continue;
            n3 = n2;
        }
        for (n2 = n3; n2 < this.browsable.length - 1; ++n2) {
            this.browsable[n2] = this.browsable[n2 + 1];
        }
        PinsetOperatorBrowsable[] pinsetOperatorBrowsableArray = new PinsetOperatorBrowsable[this.browsable.length - 1];
        for (n = 0; n < this.browsable.length - 1; ++n) {
            pinsetOperatorBrowsableArray[n] = this.browsable[n];
        }
        this.browsable = new PinsetOperatorBrowsable[this.browsable.length - 1];
        for (n = 0; n < pinsetOperatorBrowsableArray.length; ++n) {
            this.browsable[n] = pinsetOperatorBrowsableArray[n];
        }
    }

    public void setNativeShell(String string) {
        this.nativeShellPath = string;
    }

    public String getNativeShell() {
        return this.nativeShellPath;
    }

    public PinsetOperatorFileReserveWindow getFileReserveWindow() {
        return this.fileReserveWindow;
    }

    public PinsetOperatorStatusDisplayWindow getStatusDisplayWindow() {
        return this.statusDisplayWindow;
    }

    public void setCopyTargetFile(File file) {
        this.copyTargetFiles = new File[]{file};
    }

    public void setCopyTargetFiles(File[] fileArray) {
        this.copyTargetFiles = fileArray;
    }

    public File[] getCopyTargetFiles() {
        return this.copyTargetFiles;
    }

    @Override
    public void linkRemoved(File file) {
        this.delayedRepaint(50);
        for (int i = 0; i < this.browsable.length; ++i) {
            this.browsable[i].fileRemoved(file);
        }
    }

    @Override
    public void fileCopied(File file) {
        for (int i = 0; i < this.browsable.length; ++i) {
            this.browsable[i].fileCopied(file);
        }
    }

    @Override
    public void filePasted(File file) {
        int n;
        this.reloadRing();
        for (n = 0; n < this.ringFiles.length; ++n) {
            if (!this.ringFiles[n].getPath().equals(file.getPath())) continue;
            this.rotRing(n);
            this.setTargetFileEffect(n);
        }
        for (n = 0; n < this.browsable.length; ++n) {
            this.browsable[n].filePasted(file);
        }
        this.delayedRepaint(50);
    }

    @Override
    public void fileRemoved(File file) {
        this.reloadRing();
        this.delayedRepaint(50);
        for (int i = 0; i < this.browsable.length; ++i) {
            this.browsable[i].fileRemoved(file);
        }
    }

    @Override
    public void fileRenamed(File file) {
        this.reloadRing();
        for (int i = 0; i < this.browsable.length; ++i) {
            this.browsable[i].fileRenamed(file);
        }
    }

    @Override
    public void fileMade(File file) {
        int n;
        this.reloadRing();
        for (n = 0; n < this.ringFiles.length; ++n) {
            if (!this.ringFiles[n].getPath().equals(file.getPath())) continue;
            this.rotRing(n);
            this.setTargetFileEffect(n);
        }
        this.delayedRepaint(50);
        for (n = 0; n < this.browsable.length; ++n) {
            this.browsable[n].fileMade(file);
        }
    }

    @Override
    public void directoryMade(File file) {
        int n;
        this.reloadRing();
        for (n = 0; n < this.ringFiles.length; ++n) {
            if (!this.ringFiles[n].getPath().equals(file.getPath())) continue;
            this.rotRing(n);
            this.setTargetFileEffect(n);
        }
        this.delayedRepaint(50);
        for (n = 0; n < this.browsable.length; ++n) {
            this.browsable[n].directoryMade(file);
        }
    }

    public void setLanguage(int n) {
        this.language = n;
    }

    public int getLanguage() {
        return this.language;
    }

    @Override
    public void currentDirectoryChanged(File file) {
        if (!this.withCrystalBrowserState) {
            this.directoryManager.setCurrentDirectory(file);
            this.subThread.browserOpenAnimation();
        } else {
            this.directoryManager.setCurrentDirectory(file);
            this.subThread.goDifferentRingAnimation(file);
        }
    }

    @Override
    public void currentDirectoryChangedPrevious() {
        if (!this.withCrystalBrowserState) {
            this.directoryManager.goPrevious();
            this.reloadRing();
            this.setRing();
            this.rotRing();
            this.subThread.browserOpenAnimation();
        } else {
            File file = this.directoryManager.getCurrentDirectory();
            this.directoryManager.goPrevious();
            File file2 = this.directoryManager.getCurrentDirectory();
            if (!file.getPath().equals(file2.getPath())) {
                this.subThread.goNeighborRingAnimation(file, file2);
            }
        }
    }

    @Override
    public void currentDirectoryChangedNext() {
        if (!this.withCrystalBrowserState) {
            this.directoryManager.goNext();
            this.reloadRing();
            this.setRing();
            this.rotRing();
            this.subThread.browserOpenAnimation();
        } else {
            File file = this.directoryManager.getCurrentDirectory();
            this.directoryManager.goNext();
            File file2 = this.directoryManager.getCurrentDirectory();
            if (!file.getPath().equals(file2.getPath())) {
                this.subThread.goNeighborRingAnimation(file, file2);
            }
        }
    }

    @Override
    public void currentDirectoryChangedUpper() {
        this.directoryManager.goParent();
        if (!this.withCrystalBrowserState) {
            this.reloadRing();
            this.rotRing();
            this.subThread.browserOpenAnimation();
        } else {
            this.subThread.goUpperRingAnimation(this.currentDirectory);
        }
    }

    public Realtime3DPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public void setBackgroundMode(boolean bl) {
    }

    public boolean isBackgroundMode(boolean bl) {
        return this.mainMenuBar.isBackgroundMode();
    }

    public void addApplication(PinsetApplication pinsetApplication) {
        int n;
        PinsetApplication[] pinsetApplicationArray = new PinsetApplication[this.application.length];
        for (n = 0; n < this.application.length; ++n) {
            pinsetApplicationArray[n] = this.application[n];
        }
        this.application = new PinsetApplication[this.application.length + 1];
        for (n = 0; n < pinsetApplicationArray.length; ++n) {
            this.application[n] = pinsetApplicationArray[n];
        }
        this.application[this.application.length - 1] = pinsetApplication;
        if (this.application[this.application.length - 1].desktop) {
            this.addPalletApplication(this.application.length - 1);
        }
        this.mainMenuBar.reloadApplicationMenu();
        this.reloadFileLink();
    }

    public void removeApplication(int n) {
        if (0 <= n && n < this.application.length) {
            int n2;
            this.removePalletApplication(n);
            this.reloadPallet();
            for (int i = n; i < this.application.length - 1; ++i) {
                this.application[i] = this.application[i + 1];
            }
            PinsetApplication[] pinsetApplicationArray = new PinsetApplication[this.application.length - 1];
            for (n2 = 0; n2 < this.application.length - 1; ++n2) {
                pinsetApplicationArray[n2] = this.application[n2];
            }
            this.application = new PinsetApplication[this.application.length - 1];
            for (n2 = 0; n2 < pinsetApplicationArray.length; ++n2) {
                this.application[n2] = pinsetApplicationArray[n2];
            }
            pinsetApplicationArray = null;
            this.displayPanel.format();
            this.reloadRing();
            this.reloadFileLink();
        }
    }

    public void addPalletApplication() {
        this.palletApplicationID = new int[this.application.length];
        for (int i = 0; i < this.palletApplicationID.length; ++i) {
            this.palletApplicationID[i] = i;
        }
    }

    public void formatPalletApplication() {
        this.palletApplicationID = new int[0];
    }

    public void addPalletApplication(int n) {
        int n2;
        int[] nArray = new int[this.palletApplicationID.length];
        for (n2 = 0; n2 < this.palletApplicationID.length; ++n2) {
            nArray[n2] = this.palletApplicationID[n2];
        }
        this.palletApplicationID = new int[this.palletApplicationID.length + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.palletApplicationID[n2] = nArray[n2];
        }
        this.palletApplicationID[this.palletApplicationID.length - 1] = n;
        this.application[n].desktop = true;
    }

    public void removePalletApplication(int n) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.palletApplicationID.length; ++n2) {
            if (this.palletApplicationID[n2] != n) continue;
            n3 = n2;
        }
        if (n3 != -1) {
            int n4;
            for (n2 = n3; n2 < this.palletApplicationID.length - 1; ++n2) {
                this.palletApplicationID[n2] = this.palletApplicationID[n2 + 1];
            }
            int[] nArray = new int[this.palletApplicationID.length - 1];
            for (n4 = 0; n4 < this.palletApplicationID.length - 1; ++n4) {
                nArray[n4] = this.palletApplicationID[n4];
            }
            this.palletApplicationID = new int[this.palletApplicationID.length - 1];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                this.palletApplicationID[n4] = nArray[n4];
            }
        }
        this.application[n].desktop = false;
    }

    public void reloadPallet() {
        this.displayPanel.format();
        this.applicationElement = new FixedSizeImageElement3DEG[this.palletApplicationID.length];
        this.numberOfApplication_TOTAL = this.palletApplicationID.length;
        for (int i = 0; i < this.palletApplicationID.length; ++i) {
            this.applicationElement[i] = new FixedSizeImageElement3DEG(0.0, 0.0, -10.0, this.application[this.palletApplicationID[i]].image);
            this.applicationElement[i].setOffset(-this.width + this.iconOffsetX + this.iconDx * this.palletIndexToCell_x(i), this.height / 2 + this.iconOffsetY - this.iconDy * this.palletIndexToCell_y(i));
            this.screen.add(this.applicationElement[i]);
            this.screen.request(this.applicationElement[i]);
        }
        this.numberOfApplication_Y = (this.height + this.iconOffsetY - this.iconOffsetY - 40) / this.iconDy;
        this.numberOfApplication_X = this.palletApplicationID.length == this.numberOfApplication_Y ? 1 : this.palletApplicationID.length / this.numberOfApplication_Y + 1;
        this.reloadRing();
        this.displayPanel.repaint3DRequest();
    }

    public void setImportMode(int n) {
        this.importMode = n;
    }

    public int getImportMode() {
        return this.importMode;
    }

    public PinsetApplication[] getApplication() {
        return this.application;
    }

    public void setApplication(PinsetApplication[] pinsetApplicationArray) {
        this.application = pinsetApplicationArray;
    }

    public File getTrashReserverDirectory() {
        return this.trashDirectory;
    }

    public String getLaunchPath() {
        return this.launchPath;
    }

    public String getHomeURLValue() {
        return this.log_homepage;
    }

    public void setHomeURLValue(String string) {
        this.log_homepage = string;
    }

    public String getWebBrowserValue() {
        return this.log_browser;
    }

    public void setWebBrowserValue(String string) {
        this.log_browser = string;
    }

    public String getWallpaperValue() {
        return this.log_screen_absolute;
    }

    public void setWallpaperValue(String string) {
        File file = new File(string);
        try {
            this.log_screen_absolute = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.log_screen_absolute = string;
        }
        this.log_screen_relative = this.getRelativePath(this.log_screen_absolute);
    }

    public int getCrystalRedValue() {
        return this.log_crystal_red;
    }

    public void setCrystalRedValue(int n) {
        this.log_crystal_red = n;
    }

    public int getCrystalGreenValue() {
        return this.log_crystal_green;
    }

    public void setCrystalGreenValue(int n) {
        this.log_crystal_green = n;
    }

    public int getCrystalBlueValue() {
        return this.log_crystal_blue;
    }

    public void setCrystalBlueValue(int n) {
        this.log_crystal_blue = n;
    }

    public int getCrystalAlphaValue() {
        return this.log_crystal_alpha;
    }

    public void setCrystalAlphaValue(int n) {
        this.log_crystal_alpha = n;
    }

    public String getRelativePath(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\\\", "/");
        String string3 = this.launchPath.replaceAll("\\\\", "/");
        string2 = (string2 = string2.replaceFirst(string3, "")).startsWith("/") ? "." + string2 : "./" + string2;
        return string2;
    }

    public void stop() {
    }

    public static void main(String[] stringArray) {
        new PinsetOperatorKernel();
    }

    public PinsetOperatorKernel() {
        int[] nArray = new int[1];
        nArray[0] = DIRECTORY;
        this.ringFileTypes = nArray;
        this.width = 600;
        this.height = 500;
        this.ringRadius = 14.0;
        this.offCursorFont = new Font("Dialog", 0, 9);
        this.onCursorFont = new Font("Dialog", 1, 12);
        this.hierarchyFont = new Font("Dialog", 1, 12);
        this.linkFont = new Font("DIALOG", 0, 11);
        this.offCursorSize = 1.7;
        this.onCursorSize = 2.0;
        this.onCursorColor = Color.red;
        this.offCursorColor = Color.white;
        this.cursorOnIndex = 0;
        this.theta = 5.5415926535897935;
        this.phi = 0.0;
        this.lambda = 0.0;
        this.backGroundImageFrag = false;
        this.centerX = 0;
        this.centerY = 340;
        this.iconDy = 90;
        this.iconOffsetY = -20;
        this.iconDx = 90;
        this.iconOffsetX = 10;
        this.numberOfApplication_TOTAL = 6;
        this.numberOfApplication_X = 1;
        this.numberOfApplication_Y = 6;
        this.desktopSphereOffsetX = 0.0;
        this.desktopSphereOffsetY = 0.0;
        this.desktopSphereOffsetZ = 0.0;
        this.realtimeFrag = false;
        this.dragAndDropFrag = false;
        this.dragAndDropLocker = false;
        this.linkDragging = false;
        this.draggingLinkIndex = 0;
        this.fileSeparator = System.getProperty("file.separator");
        this.launchPath = System.getProperty("user.dir");
        this.trashPath = this.launchPath + this.fileSeparator + "TrashReserver";
        this.fileLinkIconSize = 1.54;
        this.fileLinkStringSize = 1.54;
        this.fileLinkDefaultZ = -37.0;
        this.rightClickedApplicationID = -1;
        this.worldOffsetX = 12.0;
        this.mouseListenerEnabled = true;
        this.componentListenerEnabled = true;
        this.ringOffsetX = -100.0;
        this.ringOffsetY = 0.0;
        this.withCrystalBrowserState = false;
        this.palletApplicationID = new int[0];
        this.backScreenModeState = false;
        this.language = LANGUAGE_ENGLISH;
        this.securityManageFrag = true;
        this.keyPressing_CTRL = false;
        this.nativeShellPath = "null";
        this.iconOffsetX_off = 0.7;
        this.iconOffsetY_off = 0.7;
        this.iconOffsetX_on = 1.4;
        this.iconOffsetY_on = 1.4;
        this.areaSelecting = false;
        this.areaSelected = false;
        this.areaSelectingSx = 0;
        this.areaSelectingSy = 0;
        this.areaSelectingEx = 0;
        this.areaSelectingEy = 0;
        this.fileGripping = false;
        this.dragSpeed = 0.0047;
        this.cursorOnIndexStock = 0;
        this.targetFile = new File(".");
        if (this.securityManageFrag) {
            this.pinsetOperatorSecurityManager = new PinsetOperatorSecurityManager();
        }
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.setTitle("DIALOID");
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.directoryManager = new PinsetOperatorDirectoryManager();
        this.setLayout(null);
        this.setBounds(0, 0, this.width, this.height);
        this.setVisible(false);
        this.classFileEngine = new ClassFileEngine();
        this.classFileEngine.setKernel(this);
        this.jarFileEngine = new JarFileEngine();
        this.jarFileEngine.setKernel(this);
        this.application = new PinsetApplication[0];
        this.displayPanel = new Realtime3DPanel();
        this.displayPanel.setBounds(0, 0, this.width, this.height);
        this.displayPanel.reSize();
        this.getContentPane().add(this.displayPanel);
        this.displayPanel.setLayout(null);
        this.setVisible(true);
        this.screen = this.displayPanel.getScreenSystem();
        this.screen.setMagnification(1.0);
        this.displayPanel.setScreenBackground(Color.black);
        this.displayPanel.setScreenBackground(Color.blue);
        this.world = this.displayPanel.getWorldSystem();
        this.world.setOrigin(30.0, 0.0, -30.0);
        this.ringSystem = new CoordinateSystem3DEG();
        this.ringSystem.setAngle(this.theta, this.phi, this.lambda);
        this.world.add(this.ringSystem);
        this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
        this.screen.setNearClipping(-3.0);
        this.screen.setScreenCenter(this.centerX, this.centerY);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("rxvesapi/system/icon_directory.png");
        this.directoryIconImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/icon_unknown.png");
        this.unknownIconImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/icon_gear.png");
        this.classFileIconImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/icon_list.png");
        this.listIconImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/return.png");
        this.returnIconImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/return_on.png");
        this.returnOnImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/browser_stay.png");
        this.browserStayImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/browser_open.png");
        this.browserOpenImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/browser_close.png");
        this.browserCloseImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/select.png");
        this.iconButtonImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/pointer.png");
        this.pointerImage = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("rxvesapi/system/shaft.png");
        this.sidebarImage = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.directoryIconImage, 0);
        mediaTracker.addImage(this.browserStayImage, 0);
        mediaTracker.addImage(this.browserCloseImage, 0);
        mediaTracker.addImage(this.browserOpenImage, 0);
        mediaTracker.addImage(this.unknownIconImage, 0);
        mediaTracker.addImage(this.classFileIconImage, 0);
        mediaTracker.addImage(this.listIconImage, 0);
        mediaTracker.addImage(this.returnIconImage, 0);
        mediaTracker.addImage(this.returnOnImage, 0);
        mediaTracker.addImage(this.sidebarImage, 0);
        mediaTracker.addImage(this.iconButtonImage, 0);
        mediaTracker.addImage(this.pointerImage, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.mainMenuBar = new PinsetOperatorMenuBar(this);
        this.loadLogFile();
        this.setJMenuBar(this.mainMenuBar);
        this.mainMenuBar.addBrowserListener(this);
        this.currentDirectory = new File(this.log_lastdirectory_absolute);
        if (!this.currentDirectory.exists()) {
            this.currentDirectory = new File(this.log_lastdirectory_relative);
        }
        if (!this.currentDirectory.exists()) {
            this.currentDirectory = new File(this.launchPath);
        }
        this.directoryManager.setCurrentDirectory(this.currentDirectory);
        File file = new File(this.log_screen_absolute);
        try {
            this.loadScreenImage(this.log_screen_absolute);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!file.exists()) {
            file = new File(this.log_screen_relative);
            try {
                this.loadScreenImage(this.log_screen_relative);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!file.exists()) {
            try {
                this.loadScreenImage("defaultScreen.jpg");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.iconButtonElement = new FixedSizeImageElement3DEG(0.0, 0.0, -5.1, this.iconButtonImage);
        this.iconButtonElement.setOffset(10000, 10000);
        this.screen.add(this.iconButtonElement);
        this.pointerElement = new FixedSizeImageElement3DEG(0.0, 0.0, -5.1, this.pointerImage);
        this.pointerElement.setOffset(10000, 10000);
        this.screen.add(this.pointerElement);
        this.dragAndDropElement = new FixedSizeImageElement3DEG(0.0, 0.0, -4.7, this.iconButtonImage);
        this.dragAndDropElement.setOffset(10000, 10000);
        this.screen.add(this.dragAndDropElement);
        this.returnIconElement = new FixedSizeImageElement3DEG(1.0 - this.worldOffsetX, 0.0, 0.0, this.returnIconImage);
        this.returnIconElement.setOffset(0, 120);
        this.returnPathElement = new FixedSizeStringElement3DEG(4.0 - this.worldOffsetX, -0.0, 0.0, "" + this.currentDirectory, new Font("DIALOG", 1, 24), Color.lightGray);
        this.returnPathShadowElement = new FixedSizeStringElement3DEG(3.9000000000000004 - this.worldOffsetX, -0.1, -0.1, "" + this.currentDirectory, new Font("DIALOG", 1, 24), Color.black);
        this.zElement = new FixedSizeStringElement3DEG(4.0 - this.worldOffsetX, -0.0, 0.0, "DEPTH = 0 M", new Font("DIALOG", 0, 11), Color.white);
        this.zElement.setOffset(-5.0, -27.0);
        this.sidebarElement = new FixedSizeImageElement3DEG(0.5 - this.worldOffsetX, 0.0, -3.0, this.sidebarImage);
        this.sidebarElement.setOffset(0, 77);
        this.centralBarModel = new ConeModel3DEG(7, 1);
        this.centralBarModel.setHeight(14.0);
        this.centralBarModel.setRadius(14.0);
        this.centralBarModel.setColor(new Color(this.log_crystal_red, this.log_crystal_green, this.log_crystal_blue, this.log_crystal_alpha));
        this.centralBarModel.rotX(Math.PI);
        this.centralFlapModel1 = new BoxModel3DEG(5.0, 0.3, 4.0, 0.3, 2.5, Color.black);
        this.centralFlapModel1.rotY(1.5707963267948966);
        this.centralFlapModel1.move(8.0, 0.0, -14.0);
        this.ringSystem.add(this.centralFlapModel1);
        this.centralFlapModel2 = new BoxModel3DEG(5.0, 0.3, 4.0, 0.3, 2.5, Color.black);
        this.centralFlapModel2.rotY(1.5707963267948966);
        this.centralFlapModel2.move(8.0, 0.0, -14.0);
        this.centralFlapModel2.rotZ(2.0943951023931953);
        this.ringSystem.add(this.centralFlapModel2);
        this.centralFlapModel3 = new BoxModel3DEG(5.0, 0.3, 4.0, 0.3, 2.5, Color.black);
        this.centralFlapModel3.rotY(1.5707963267948966);
        this.centralFlapModel3.move(8.0, 0.0, -14.0);
        this.centralFlapModel3.rotZ(4.1887902047863905);
        this.ringSystem.add(this.centralFlapModel3);
        this.light1 = new PointLightElement3DEG(1000.0, 0.0, -1000.0, 0.4, Color.magenta);
        this.light2 = new PointLightElement3DEG(1000.0, 0.0, -1000.0, 0.4, Color.cyan);
        this.light3 = new PointLightElement3DEG(1000.0, 0.0, 1000.0, 0.2, Color.white);
        this.light2.rotZ(2.0943951023931953);
        this.light3.rotZ(4.1887902047863905);
        this.light1.rotZ(0.8);
        this.light2.rotZ(0.8);
        this.light3.rotZ(0.8);
        this.sun = new PointLightElement3DEG(1000.0, 1000.0, 1000.0, 0.2, Color.white);
        this.ringSystem.add(this.centralBarModel);
        this.world.add(this.returnIconElement);
        this.world.add(this.returnPathElement);
        this.world.add(this.returnPathShadowElement);
        this.world.add(this.zElement);
        this.world.add(this.sidebarElement);
        this.ringSystem.add(this.light1);
        this.ringSystem.add(this.light2);
        this.ringSystem.add(this.light3);
        this.world.add(this.sun);
        this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
        this.displayPanel.removeMouseListener(this.displayPanel);
        this.displayPanel.removeMouseMotionListener(this.displayPanel);
        this.displayPanel.addMouseListener(this);
        this.displayPanel.addMouseMotionListener(this);
        this.displayPanel.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.displayPanel.setFrameRate(this.frameRate);
        this.applicationRightClickMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Property and settings");
        jMenuItem.addActionListener(this);
        this.applicationRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Uninstall");
        jMenuItem.addActionListener(this);
        this.applicationRightClickMenu.add(jMenuItem);
        this.applicationRightClickMenu.add(new JMenuItem("Cancel"));
        this.fileRightClickMenu = new JPopupMenu();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Make File");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Make Directory");
        jMenuItem.addActionListener(this);
        this.fileRightClickMenu.add(jMenuItem);
        this.fileRightClickMenu.add(new JMenuItem("Cancel"));
        this.fileLinkRightClickMenu = new JPopupMenu();
        jMenuItem = new JMenuItem("Location");
        jMenuItem.addActionListener(this);
        this.fileLinkRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete ( desktop link )");
        jMenuItem.addActionListener(this);
        this.fileLinkRightClickMenu.add(jMenuItem);
        this.fileLinkRightClickMenu.add(new JMenuItem("Cancel"));
        this.blankRightClickMenu = new JPopupMenu();
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        this.blankRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Make File");
        jMenuItem.addActionListener(this);
        this.blankRightClickMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Make Directory");
        jMenuItem.addActionListener(this);
        this.blankRightClickMenu.add(jMenuItem);
        this.blankRightClickMenu.add(new JMenuItem("Cancel"));
        this.trashDirectory = new File(this.trashPath);
        if (!this.trashDirectory.exists()) {
            this.trashDirectory.mkdir();
        }
        this.setExtendedState(6);
        this.applicationMenu = new PinsetOperatorApplicationMenu(this);
        this.fileMenu = new PinsetOperatorFileMenu(this);
        this.fileMenu.addBrowserListener(this);
        this.mainThread = new PinsetOperatorMainThread(this);
        this.subThread = new PinsetOperatorSubThread(this);
        this.statusDisplayWindow = new PinsetOperatorStatusDisplayWindow(this);
        this.fileReserveWindow = new PinsetOperatorFileReserveWindow(this);
        this.fileReserveWindow.addBrowserListener(this);
        this.copyTargetFiles = new File[0];
        this.browsable = new PinsetOperatorBrowsable[0];
        this.componentListenerEnabled = true;
        this.reloadRing();
        this.transformVertexVectors();
        this.displayPanel.wait(100);
        this.subThread.browserOpenAnimation();
    }

    public void delayedRepaint(int n) {
        this.displayPanel.wait(n);
        while (this.screen.isBusy()) {
            this.displayPanel.wait(10);
        }
        try {
            if (!this.subThread.isAnimating()) {
                this.displayPanel.repaint3D();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.displayPanel.repaint3D();
        }
    }

    public void repaintAndDelay(int n) {
        while (this.screen.isBusy()) {
            this.displayPanel.wait(5);
        }
        try {
            if (!this.subThread.isAnimating()) {
                this.displayPanel.repaint3D();
                this.displayPanel.wait(n);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.displayPanel.repaint3D();
            this.displayPanel.wait(n);
        }
    }

    public void reloadMenuBar() {
    }

    public boolean isFileLink(File file) {
        if (this.links == null) {
            return false;
        }
        if (this.links.length == 0) {
            return false;
        }
        for (int i = 0; i < this.links.length; ++i) {
            if (this.links[i].getFile() != file) continue;
            return true;
        }
        return false;
    }

    public void removeFileLink(File file) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.links.length; ++n2) {
            if (this.links[n2].getFile() != file) continue;
            n3 = n2;
            break;
        }
        for (n2 = n3; n2 < this.links.length - 1; ++n2) {
            this.links[n2] = this.links[n2 + 1];
            this.linkStringElements[n2] = this.linkStringElements[n2 + 1];
            this.linkStringShadowElements[n2] = this.linkStringShadowElements[n2 + 1];
            this.linkImageElements[n2] = this.linkImageElements[n2 + 1];
            this.linkTypes[n2] = this.linkTypes[n2 + 1];
        }
        PinsetFileLink[] pinsetFileLinkArray = new PinsetFileLink[this.links.length];
        StringElement3DEG[] stringElement3DEGArray = new StringElement3DEG[this.links.length];
        StringElement3DEG[] stringElement3DEGArray2 = new StringElement3DEG[this.links.length];
        ImageElement3DEG[] imageElement3DEGArray = new ImageElement3DEG[this.links.length];
        int[] nArray = new int[this.links.length];
        for (n = 0; n < this.links.length; ++n) {
            pinsetFileLinkArray[n] = this.links[n];
            stringElement3DEGArray[n] = this.linkStringElements[n];
            stringElement3DEGArray2[n] = this.linkStringShadowElements[n];
            imageElement3DEGArray[n] = this.linkImageElements[n];
            nArray[n] = this.linkTypes[n];
        }
        n = this.links.length - 1;
        this.links = new PinsetFileLink[n];
        this.linkStringElements = new StringElement3DEG[n];
        this.linkStringShadowElements = new StringElement3DEG[n];
        this.linkImageElements = new ImageElement3DEG[n];
        this.linkTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.links[i] = pinsetFileLinkArray[i];
            this.linkStringElements[i] = stringElement3DEGArray[i];
            this.linkStringShadowElements[i] = stringElement3DEGArray2[i];
            this.linkImageElements[i] = imageElement3DEGArray[i];
            this.linkTypes[i] = nArray[i];
        }
        this.setRing();
        this.delayedRepaint(50);
        this.linkDragging = false;
        this.dragAndDropFrag = false;
    }

    public void reloadFileLink() {
        try {
            for (int i = 0; i < this.links.length; ++i) {
                this.linkTypes[i] = this.getPreferredType(this.links[i].getFile());
                this.linkImageElements[i].setImage(this.getPreferredImage(this.links[i].getFile()));
                this.linkStringElements[i].setString(this.links[i].getFile().getName());
                this.linkStringShadowElements[i].setString(this.links[i].getFile().getName());
                if (!this.links[i].getFile().getName().equals("")) continue;
                this.linkStringElements[i].setString(this.links[i].getFile().getPath());
                this.linkStringShadowElements[i].setString(this.links[i].getFile().getPath());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addFileLink(File file, int n, int n2) {
        int n3 = this.getPreferredType(file);
        Image image = this.getPreferredImage(file);
        if (this.links != null) {
            int n4;
            PinsetFileLink[] pinsetFileLinkArray = new PinsetFileLink[this.links.length];
            StringElement3DEG[] stringElement3DEGArray = new StringElement3DEG[this.links.length];
            StringElement3DEG[] stringElement3DEGArray2 = new StringElement3DEG[this.links.length];
            ImageElement3DEG[] imageElement3DEGArray = new ImageElement3DEG[this.links.length];
            int[] nArray = new int[this.links.length];
            for (n4 = 0; n4 < this.links.length; ++n4) {
                pinsetFileLinkArray[n4] = this.links[n4];
                stringElement3DEGArray[n4] = this.linkStringElements[n4];
                stringElement3DEGArray2[n4] = this.linkStringShadowElements[n4];
                imageElement3DEGArray[n4] = this.linkImageElements[n4];
                nArray[n4] = this.linkTypes[n4];
            }
            this.links = new PinsetFileLink[this.links.length + 1];
            this.linkStringElements = new StringElement3DEG[this.links.length + 1];
            this.linkStringShadowElements = new StringElement3DEG[this.links.length + 1];
            this.linkImageElements = new ImageElement3DEG[this.links.length + 1];
            this.linkTypes = new int[this.links.length + 1];
            for (n4 = 0; n4 < this.links.length - 1; ++n4) {
                this.links[n4] = pinsetFileLinkArray[n4];
                this.linkStringElements[n4] = stringElement3DEGArray[n4];
                this.linkStringShadowElements[n4] = stringElement3DEGArray2[n4];
                this.linkImageElements[n4] = imageElement3DEGArray[n4];
                this.linkTypes[n4] = nArray[n4];
            }
        } else {
            this.links = new PinsetFileLink[1];
            this.linkStringElements = new StringElement3DEG[1];
            this.linkStringShadowElements = new StringElement3DEG[1];
            this.linkImageElements = new ImageElement3DEG[1];
            this.linkTypes = new int[1];
        }
        double d = this.fileLinkDefaultZ;
        double d2 = this.screen.getReverseProjectedX(n, d);
        double d3 = this.screen.getReverseProjectedY(n2, d);
        PinsetFileLink pinsetFileLink = new PinsetFileLink();
        pinsetFileLink.setFile(file);
        pinsetFileLink.setVertex(d2, d3, d - this.desktopSphereOffsetZ);
        pinsetFileLink.setSize(this.fileLinkIconSize, this.fileLinkIconSize);
        this.links[this.links.length - 1] = pinsetFileLink;
        this.linkStringElements[this.links.length - 1] = new StringElement3DEG(d2 - 0.07, d3 - 0.08, d, file.getName(), this.linkFont, Color.white);
        this.linkStringElements[this.links.length - 1].setSize(1.2);
        this.linkStringShadowElements[this.links.length - 1] = new StringElement3DEG(d2 - 0.072, d3 - 0.082, d - 0.002, file.getName(), this.linkFont, Color.black);
        this.linkStringShadowElements[this.links.length - 1].setSize(1.2);
        if (this.links[this.links.length - 1].getFile().getName().equals("")) {
            this.linkStringElements[this.links.length - 1].setString(this.links[this.links.length - 1].getFile().getPath());
            this.linkStringShadowElements[this.links.length - 1].setString(this.links[this.links.length - 1].getFile().getPath());
        }
        this.linkImageElements[this.links.length - 1] = new ImageElement3DEG(d2, d3, d, image, this.fileLinkIconSize, this.fileLinkIconSize);
        this.linkImageElements[this.links.length - 1].setOffset(this.fileLinkIconSize * 0.5, this.fileLinkIconSize * 0.5);
        this.linkTypes[this.links.length - 1] = n3;
        this.screen.add(this.linkStringElements[this.links.length - 1]);
        this.screen.add(this.linkStringShadowElements[this.links.length - 1]);
        this.screen.add(this.linkImageElements[this.links.length - 1]);
        this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
    }

    public void addFileLink(File file, double d, double d2, double d3) {
        int n = this.getPreferredType(file);
        Image image = this.getPreferredImage(file);
        if (this.links != null) {
            int n2;
            PinsetFileLink[] pinsetFileLinkArray = new PinsetFileLink[this.links.length];
            StringElement3DEG[] stringElement3DEGArray = new StringElement3DEG[this.links.length];
            StringElement3DEG[] stringElement3DEGArray2 = new StringElement3DEG[this.links.length];
            ImageElement3DEG[] imageElement3DEGArray = new ImageElement3DEG[this.links.length];
            int[] nArray = new int[this.links.length];
            for (n2 = 0; n2 < this.links.length; ++n2) {
                pinsetFileLinkArray[n2] = this.links[n2];
                stringElement3DEGArray[n2] = this.linkStringElements[n2];
                stringElement3DEGArray2[n2] = this.linkStringShadowElements[n2];
                imageElement3DEGArray[n2] = this.linkImageElements[n2];
                nArray[n2] = this.linkTypes[n2];
            }
            this.links = new PinsetFileLink[this.links.length + 1];
            this.linkStringElements = new StringElement3DEG[this.links.length + 1];
            this.linkStringShadowElements = new StringElement3DEG[this.links.length + 1];
            this.linkImageElements = new ImageElement3DEG[this.links.length + 1];
            this.linkTypes = new int[this.links.length + 1];
            for (n2 = 0; n2 < this.links.length - 1; ++n2) {
                this.links[n2] = pinsetFileLinkArray[n2];
                this.linkStringElements[n2] = stringElement3DEGArray[n2];
                this.linkStringShadowElements[n2] = stringElement3DEGArray2[n2];
                this.linkImageElements[n2] = imageElement3DEGArray[n2];
                this.linkTypes[n2] = nArray[n2];
            }
        } else {
            this.links = new PinsetFileLink[1];
            this.linkStringElements = new StringElement3DEG[1];
            this.linkStringShadowElements = new StringElement3DEG[1];
            this.linkImageElements = new ImageElement3DEG[1];
            this.linkTypes = new int[1];
        }
        double d4 = d3;
        double d5 = d;
        double d6 = d2;
        PinsetFileLink pinsetFileLink = new PinsetFileLink();
        pinsetFileLink.setFile(file);
        pinsetFileLink.setVertex(d5, d6, d4);
        pinsetFileLink.setSize(this.fileLinkIconSize, this.fileLinkIconSize);
        this.links[this.links.length - 1] = pinsetFileLink;
        this.linkStringElements[this.links.length - 1] = new StringElement3DEG(d5 - 0.07, d6 - 0.08, d4, file.getName(), this.linkFont, Color.white);
        this.linkStringElements[this.links.length - 1].setSize(1.2);
        this.linkStringShadowElements[this.links.length - 1] = new StringElement3DEG(d5 - 0.072, d6 - 0.082, d4 - 0.002, file.getName(), this.linkFont, Color.black);
        this.linkStringShadowElements[this.links.length - 1].setSize(1.2);
        this.linkImageElements[this.links.length - 1] = new ImageElement3DEG(d5, d6, d4, image, this.fileLinkIconSize, this.fileLinkIconSize);
        this.linkImageElements[this.links.length - 1].setOffset(this.fileLinkIconSize * 0.5, this.fileLinkIconSize * 0.5);
        this.linkTypes[this.links.length - 1] = n;
        this.screen.add(this.linkStringElements[this.links.length - 1]);
        this.screen.add(this.linkStringShadowElements[this.links.length - 1]);
        this.screen.add(this.linkImageElements[this.links.length - 1]);
    }

    public void setDesktopSphereOffset(double d, double d2, double d3) {
        this.desktopSphereOffsetX = d;
        this.desktopSphereOffsetY = d2;
        this.desktopSphereOffsetZ = d3;
        if (this.links != null) {
            for (int i = 0; i < this.links.length; ++i) {
                double d4 = this.links[i].getX();
                double d5 = this.links[i].getY();
                double d6 = this.links[i].getZ();
                double d7 = -0.47 * (d6 - this.fileLinkDefaultZ + d3);
                if (-300.0 < d6 + d3 && d6 + d3 < -20.0) {
                    this.links[i].setJudgementVertex(d4 + d + d7, d5 + d2, d6 + d3);
                    this.linkStringElements[i].setVertex(d4 + d + d7 - 0.7, d5 + d2 - 1.0, d6 + d3);
                    this.linkStringShadowElements[i].setVertex(d4 + d + d7 - 0.7, d5 + d2 - 1.0, d6 - 0.001 + d3);
                    this.linkStringShadowElements[i].setOffset(-0.02, -0.03);
                    this.linkImageElements[i].setVertex(d4 + d + d7, d5 + d2, d6 + d3);
                    continue;
                }
                this.links[i].setJudgementVertex(10000.0, 10000.0, 10000.0);
                this.linkStringElements[i].setVertex(10000.0, 10000.0, 10000.0);
                this.linkStringShadowElements[i].setVertex(10000.0, 10000.0, 10000.0);
                this.linkStringShadowElements[i].setVertex(10000.0, 10000.0, 10000.0);
                this.linkImageElements[i].setVertex(10000.0, 10000.0, 10000.0);
            }
        }
        this.zElement.setString("DEPTH = " + (int)d3 + " M");
        this.displayPanel.repaint3DRequest();
    }

    public int getOnCursorFileLink(int n, int n2) {
        boolean bl = false;
        int n3 = -1;
        double d = -10000.0;
        double d2 = 0.0;
        if (this.links != null) {
            for (int i = 0; i < this.links.length; ++i) {
                if (!this.links[i].onCursor(n, n2, this.screen)) continue;
                bl = true;
                d2 = this.links[i].getJudgementZ();
                if (!(d < d2)) continue;
                d = d2;
                n3 = i;
            }
            if (bl) {
                return n3;
            }
        }
        return -1;
    }

    public String getWebBrowser() {
        return this.log_browser;
    }

    public String getCommandInterface() {
        return this.log_command;
    }

    public String getHomePage() {
        return this.log_homepage;
    }

    public String getBackScreen() {
        return this.getWallpaperValue();
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
        this.displayPanel.setFrameRate(n);
    }

    public void setFrameRate(double d) {
        this.frameRate = d;
        this.displayPanel.setFrameRate(d);
    }

    public void setWebBrowser(String string) {
        this.log_browser = string;
    }

    public void setCommandInterface(String string) {
        this.log_command = string;
    }

    public void setHomePage(String string) {
        this.log_homepage = string;
    }

    public void setBackScreen(String string) {
        this.setWallpaperValue(string);
    }

    public void loadLogFile() {
        File file = new File("dialoid_setting.txt");
        if (file.exists()) {
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader("dialoid_setting.txt"));
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray;
                        String[] stringArray2 = string.split("=");
                        if (stringArray2[0].equals("FRAME_RATE") && stringArray2.length != 1) {
                            try {
                                this.frameRate = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("LANGUAGE") && stringArray2.length != 1) {
                            if (stringArray2[1].equals("ENGLISH")) {
                                this.language = LANGUAGE_ENGLISH;
                            }
                            if (stringArray2[1].equals("JAPANESE")) {
                                this.language = LANGUAGE_JAPANESE;
                            }
                        }
                        if (stringArray2[0].equals("BACK_GROUND_MODE") && stringArray2.length != 1) {
                            if (stringArray2[1].equals("ON")) {
                                this.mainMenuBar.setBackgroundMode(true);
                            }
                            if (stringArray2[1].equals("OFF")) {
                                this.mainMenuBar.setBackgroundMode(false);
                            }
                        }
                        if (stringArray2[0].equals("SPRING_RATE_VERTICAL") && stringArray2.length != 1) {
                            try {
                                this.springRate_vertical = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("SPRING_RATE_LEVEL") && stringArray2.length != 1) {
                            try {
                                this.springRate_level = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("SPRING_RATE_CENTER") && stringArray2.length != 1) {
                            try {
                                this.springRate_center = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("SPRING_FRICTION") && stringArray2.length != 1) {
                            try {
                                this.springFriction = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("SPRING_STRENGTH") && stringArray2.length != 1) {
                            try {
                                this.springStrength = Double.parseDouble(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("CRYSTAL_RED") && stringArray2.length != 1) {
                            try {
                                this.log_crystal_red = Integer.parseInt(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("CRYSTAL_GREEN") && stringArray2.length != 1) {
                            try {
                                this.log_crystal_green = Integer.parseInt(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("CRYSTAL_BLUE") && stringArray2.length != 1) {
                            try {
                                this.log_crystal_blue = Integer.parseInt(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("CRYSTAL_ALPHA") && stringArray2.length != 1) {
                            try {
                                this.log_crystal_alpha = Integer.parseInt(stringArray2[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray2[0].equals("BACKSCREEN") && stringArray2.length != 1) {
                            stringArray = stringArray2[1].split(";");
                            this.log_screen_absolute = stringArray[0];
                            this.log_screen_relative = 2 <= stringArray.length ? stringArray[1] : stringArray[0];
                        }
                        if (stringArray2[0].equals("SHELL") && stringArray2.length != 1) {
                            this.log_shell = stringArray2[1];
                        }
                        if (stringArray2[0].equals("BROWSER") && stringArray2.length != 1) {
                            this.log_browser = stringArray2[1];
                        }
                        if (stringArray2[0].equals("HOMEPAGE") && stringArray2.length != 1) {
                            this.log_homepage = stringArray2[1];
                        }
                        if (stringArray2[0].equals("IMPORTMODE") && stringArray2.length != 1) {
                            if (stringArray2[1].equals("CUSTOM")) {
                                this.importMode = IMPORT_MODE_CUSTOM;
                            } else if (stringArray2[1].equals("FULL")) {
                                this.importMode = IMPORT_MODE_FULL;
                            }
                        }
                        if (stringArray2[0].equals("LASTDIRECTORY") && stringArray2.length != 1) {
                            stringArray = stringArray2[1].split(";");
                            this.log_lastdirectory_absolute = stringArray[0];
                            this.log_lastdirectory_relative = stringArray[1];
                        }
                        if (!stringArray2[0].equals("DESKTOPFILE") || stringArray2.length == 1) continue;
                        stringArray = stringArray2[1].split(";");
                        File file2 = new File(stringArray[0]);
                        File file3 = new File(stringArray[1]);
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        try {
                            d = Double.parseDouble(stringArray[2]);
                            d2 = Double.parseDouble(stringArray[3]);
                            d3 = Double.parseDouble(stringArray[4]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (file2.exists()) {
                            this.addFileLink(file2, d, d2, d3);
                            continue;
                        }
                        if (!file3.exists()) continue;
                        this.addFileLink(file3, d, d2, d3);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void saveSettingFile() {
        int n;
        String string;
        String string2;
        int n2;
        TSVVertexWriter tSVVertexWriter = new TSVVertexWriter("dialoid_setting.txt");
        tSVVertexWriter.write("- SYSTEM -");
        if (this.language == LANGUAGE_ENGLISH) {
            tSVVertexWriter.write("LANGUAGE=ENGLISH");
        } else if (this.language == LANGUAGE_JAPANESE) {
            tSVVertexWriter.write("LANGUAGE=JAPANESE");
        }
        if (this.mainMenuBar.isBackgroundMode()) {
            tSVVertexWriter.write("BACK_GROUND_MODE=ON");
        } else {
            tSVVertexWriter.write("BACK_GROUND_MODE=OFF");
        }
        tSVVertexWriter.write("- DESKTOP -");
        tSVVertexWriter.write("BACKSCREEN=" + this.log_screen_absolute + ";" + this.log_screen_relative);
        tSVVertexWriter.write("SPRING_RATE_VERTICAL=" + this.springRate_vertical);
        tSVVertexWriter.write("SPRING_RATE_LEVEL=" + this.springRate_vertical);
        tSVVertexWriter.write("SPRING_RATE_CENTER=" + this.springRate_vertical);
        tSVVertexWriter.write("SPRING_FRICTION=" + this.springFriction);
        tSVVertexWriter.write("SPRING_STRENGTH=" + this.springStrength);
        tSVVertexWriter.write("CRYSTAL_RED=" + this.log_crystal_red);
        tSVVertexWriter.write("CRYSTAL_GREEN=" + this.log_crystal_green);
        tSVVertexWriter.write("CRYSTAL_BLUE=" + this.log_crystal_blue);
        tSVVertexWriter.write("CRYSTAL_ALPHA=" + this.log_crystal_alpha);
        tSVVertexWriter.write("");
        tSVVertexWriter.write("- GRAPHICS -");
        tSVVertexWriter.write("FRAME_RATE=" + this.displayPanel.getFrameRate());
        tSVVertexWriter.write("- NATIVE INFORMATION -");
        tSVVertexWriter.write("BROWSER=" + this.log_browser);
        tSVVertexWriter.write("HOMEPAGE=" + this.log_homepage);
        tSVVertexWriter.write("SHELL=" + this.log_shell);
        tSVVertexWriter.write("");
        tSVVertexWriter.write("- LOG -");
        tSVVertexWriter.write("LASTDIRECTORY=" + this.log_lastdirectory_absolute + ";" + this.log_lastdirectory_relative);
        tSVVertexWriter.write("");
        tSVVertexWriter.write("- LAUNCH -");
        if (this.importMode == IMPORT_MODE_CUSTOM) {
            tSVVertexWriter.write("IMPORTMODE=CUSTOM");
        } else if (this.importMode == IMPORT_MODE_FULL) {
            tSVVertexWriter.write("IMPORTMODE=FULL");
        }
        tSVVertexWriter.write("");
        tSVVertexWriter.write("- APPLICATION -");
        for (n2 = 0; n2 < this.application.length; ++n2) {
            this.application[n2].corePath_relative = this.getRelativePath(this.application[n2].corePath_absolute);
            this.application[n2].applicationImagePath_relative = this.getRelativePath(this.application[n2].applicationImagePath_absolute);
            this.application[n2].fileImagePath_relative = this.getRelativePath(this.application[n2].fileImagePath_absolute);
            string2 = "";
            for (int i = 0; i < this.application[n2].extention.length; ++i) {
                string2 = string2 + this.application[n2].extention[i] + "/";
            }
            string = "";
            for (n = 0; n < this.application[n2].args.length; ++n) {
                string = string + this.application[n2].args[n] + " ";
            }
            tSVVertexWriter.write("APPLICATION=" + this.application[n2].name + ";" + this.application[n2].info + ";" + this.application[n2].corePath_absolute + ";" + this.application[n2].corePath_relative + ";" + this.application[n2].applicationImagePath_absolute + ";" + this.application[n2].applicationImagePath_relative + ";" + this.application[n2].fileImagePath_absolute + ";" + this.application[n2].fileImagePath_relative + ";" + string2 + ";" + string + ";" + this.application[n2].category + ";" + this.application[n2].command + ";" + this.application[n2].desktop);
        }
        tSVVertexWriter.write("");
        tSVVertexWriter.write("- PALLET -");
        for (n2 = 0; n2 < this.palletApplicationID.length; ++n2) {
            tSVVertexWriter.write("PALLET=" + n2 + ">" + this.palletApplicationID[n2]);
        }
        tSVVertexWriter.write("");
        if (this.links != null) {
            tSVVertexWriter.write("- DESKTOP FILE -");
            for (n = 0; n < this.links.length; ++n) {
                File file = this.links[n].getFile();
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = file.getPath();
                }
                string = this.getRelativePath(string2);
                tSVVertexWriter.write("DESKTOPFILE=" + string2 + ";" + string + ";" + this.links[n].getX() + ";" + this.links[n].getY() + ";" + this.links[n].getZ());
            }
        }
        tSVVertexWriter.write("");
        tSVVertexWriter.close();
        tSVVertexWriter = null;
    }

    public void repaintHierarchyDisplay(File file) {
        String string;
        File file2 = file;
        int n = 0;
        int n2 = 0;
        while (file2.exists() && (string = file2.getParent()) != null) {
            file2 = new File(string);
            n = n2++;
        }
        this.hierarchyImageElements = new ImageElement3DEG[n + 1];
        this.hierarchyStringElements = new StringElement3DEG[n + 1];
        this.hierarchyStringShadowElements = new StringElement3DEG[n + 1];
        file2 = file;
        for (n2 = 0; n2 <= n && (string = file2.getParent()) != null; ++n2) {
            file2 = new File(string);
            if ((string = file2.getName()).length() == 0) {
                string = file2.getPath();
            }
            double d = 2.0;
            this.hierarchyImageElements[n2] = new ImageElement3DEG(d, 3.7 + 0.9 * (double)n2, -37.0 - 3.2 * (double)n2, this.directoryIconImage, 1.2, 1.2);
            this.hierarchyImageElements[n2].setOffset(1.2, 0.7);
            this.screen.add(this.hierarchyImageElements[n2]);
            this.screen.request(this.hierarchyImageElements[n2]);
            this.hierarchyStringElements[n2] = new StringElement3DEG(d, 3.7 + 0.9 * (double)n2, -37.0 - 3.2 * (double)n2, string, this.hierarchyFont, Color.white);
            this.hierarchyStringElements[n2].setSize(1.4);
            this.screen.add(this.hierarchyStringElements[n2]);
            this.screen.request(this.hierarchyStringElements[n2]);
            this.hierarchyStringShadowElements[n2] = new StringElement3DEG(d - 0.01, 3.67 + 0.9 * (double)n2, -37.1 - 3.2 * (double)n2, string, this.hierarchyFont, Color.black);
            this.hierarchyStringShadowElements[n2].setSize(1.4);
            this.screen.add(this.hierarchyStringShadowElements[n2]);
            this.screen.request(this.hierarchyStringShadowElements[n2]);
        }
    }

    public void returnRing() {
        this.reloadRing();
    }

    public void reloadRing() {
        this.currentDirectory = this.directoryManager.getCurrentDirectory();
        this.realtimeFrag = false;
        this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
        if (this.currentDirectory.getName().equals("")) {
            this.returnPathElement.setString("DRIVE " + this.currentDirectory);
            this.returnPathShadowElement.setString("DRIVE " + this.currentDirectory);
        } else {
            this.returnPathElement.setString("" + this.currentDirectory.getName());
            this.returnPathShadowElement.setString("" + this.currentDirectory.getName());
        }
        this.ringFiles = this.directoryManager.listFiles();
        this.ringStrings = this.directoryManager.list();
        try {
            if (this.ringFiles != null) {
                if (this.ringFiles.length == 0) {
                    this.ringStrings = new String[]{"None. "};
                    this.ringFiles = new File[]{new File("None.nullType")};
                    int[] nArray = new int[1];
                    nArray[0] = UNKNOWN;
                    this.ringFileTypes = nArray;
                    this.setRing_NOREPAINT();
                } else {
                    this.setRing_NOREPAINT();
                }
            } else {
                this.goParentRing();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.goParentRing();
        }
    }

    public void setRing() {
        this.setRing_NOREPAINT();
        this.rotRing();
    }

    public void setRing_NOREPAINT() {
        int n;
        int n2;
        this.realtimeFrag = false;
        this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
        if (this.ringFileTypes[0] != NULLTYPE) {
            this.ringFileTypes = new int[this.ringFiles.length];
            this.ringStringElements = new StringElement3DEG[this.ringFiles.length];
            this.ringStringShadowElements = new StringElement3DEG[this.ringFiles.length];
            this.ringLineElements = new LineElement3DEG[this.ringFiles.length];
            this.ringImageElements = new ImageElement3DEG[this.ringFiles.length];
            this.ringVertexVectors = new Vector3DEG[this.ringFiles.length];
            this.ringVertexVectors_transformed = new Vector3DEG[this.ringFiles.length];
            this.ringVertexProjectedX = new int[this.ringFiles.length];
            this.ringVertexProjectedY = new int[this.ringFiles.length];
        }
        this.screen.setMagnification(3.0);
        this.ringRadius = this.ringRadiusMagnification * (double)this.ringFiles.length;
        this.theta = 4.71238898038469;
        if (this.ringRadius < 10.0) {
            this.ringRadius = 10.0;
        }
        if (this.ringFileTypes.length == 1 || this.ringFileTypes.length == 0) {
            this.ringRadius = 1.0;
        }
        this.centralBarModel.setRadius(this.ringRadius * 0.9);
        this.centralBarModel.setHeight(this.ringRadius * 0.9);
        this.centralBarModel.rotX(Math.PI);
        this.world.setOrigin(this.worldOffsetX, 0.0, -this.ringRadius - 50.0);
        this.displayPanel.format();
        double d = Math.PI * 2 / (double)this.ringFiles.length;
        this.d_angle = Math.PI * 2 / (double)this.ringFiles.length;
        double d2 = 1.0 / (double)this.ringFiles.length;
        for (n2 = 0; n2 < this.ringFiles.length; ++n2) {
            Color color = Color.getHSBColor((float)n2 / (float)this.ringFiles.length, 1.0f, 1.0f);
            this.ringVertexVectors[n2] = new Vector3DEG(this.ringRadius, 0.0, 0.0);
            this.ringVertexVectors_transformed[n2] = new Vector3DEG(this.ringRadius, 0.0, 0.0);
            this.ringVertexVectors[n2].rotZ((double)n2 * d);
            this.ringSystem.add(this.ringVertexVectors[n2]);
            this.ringStringShadowElements[n2] = new StringElement3DEG(this.ringRadius, 0.0, 0.0, this.ringStrings[n2], this.offCursorFont, Color.black);
            this.ringStringShadowElements[n2].rotZ((double)n2 * d);
            this.ringStringShadowElements[n2].setDistanceOffset(-0.1);
            this.ringStringShadowElements[n2].setOffset(-0.05, -0.05);
            this.ringSystem.add(this.ringStringShadowElements[n2]);
            this.screen.request(this.ringStringShadowElements[n2]);
            this.ringStringElements[n2] = new StringElement3DEG(this.ringRadius, 0.0, 0.0, this.ringStrings[n2], this.offCursorFont, this.offCursorColor);
            this.ringStringElements[n2].rotZ((double)n2 * d);
            this.ringSystem.add(this.ringStringElements[n2]);
            this.screen.request(this.ringStringElements[n2]);
            Vector3DEG vector3DEG = new Vector3DEG(this.ringRadius * 0.97, 0.0, 1.4);
            vector3DEG.rotZ(d);
            this.ringLineElements[n2] = new LineElement3DEG(this.ringRadius * 0.97, 0.0, 1.4, vector3DEG.getX(), vector3DEG.getY(), vector3DEG.getZ(), Color.red);
            this.ringLineElements[n2].rotZ((double)n2 * d);
            this.ringSystem.add(this.ringLineElements[n2]);
            this.screen.request(this.ringLineElements[n2]);
            String[] stringArray = this.ringStrings[n2].split("\\.");
            n = 1;
            if (stringArray.length == 1 || this.ringFiles[n2].isDirectory()) {
                this.ringFileTypes[n2] = DIRECTORY;
                n = 0;
            } else {
                for (int i = 0; i < this.application.length; ++i) {
                    int n3 = this.application[i].extention.length;
                    for (int j = 0; j < n3; ++j) {
                        if (!this.application[i].extention[j].equals(stringArray[1])) continue;
                        this.ringFileTypes[n2] = i;
                        n = 0;
                    }
                }
            }
            if (n != 0) {
                this.ringFileTypes[n2] = UNKNOWN;
            }
            this.ringImageElements[n2] = new ImageElement3DEG(this.ringRadius, 0.0, 0.5, this.getPreferredImage(this.ringFiles[n2]), 1.0, 1.0);
            this.ringImageElements[n2].setOffset(0.7, 0.7);
            this.ringImageElements[n2].rotZ((double)n2 * d);
            this.ringSystem.add(this.ringImageElements[n2]);
            this.screen.request(this.ringImageElements[n2]);
        }
        this.screen.request(this.centralBarModel);
        this.screen.request(this.centralFlapModel1);
        this.screen.request(this.centralFlapModel2);
        this.screen.request(this.centralFlapModel3);
        this.screen.request(this.returnIconElement);
        this.screen.request(this.returnPathElement);
        this.screen.request(this.returnPathShadowElement);
        this.screen.request(this.zElement);
        this.screen.request(this.sidebarElement);
        this.screen.request(this.light1);
        this.screen.request(this.light2);
        this.screen.request(this.light3);
        if (this.palletApplicationID != null) {
            n2 = this.palletApplicationID.length;
            for (n = 0; n < n2; ++n) {
                this.screen.request(this.applicationElement[n]);
            }
        }
        this.screen.request(this.iconButtonElement);
        this.screen.request(this.pointerElement);
        this.screen.request(this.dragAndDropElement);
        this.screen.request(this.sun);
        if (this.backGroundImageFrag) {
            this.screen.request(this.screenImageElement);
            this.screen.add(this.screenImageElement);
        }
        if (this.links != null) {
            for (n2 = 0; n2 < this.links.length; ++n2) {
                this.screen.request(this.linkStringElements[n2]);
                this.screen.request(this.linkStringShadowElements[n2]);
                this.screen.request(this.linkImageElements[n2]);
            }
        }
        this.realtimeFrag = false;
        this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
        this.dragSpeed = this.ringFiles.length > 40 ? 0.5 / (double)this.ringFiles.length : 0.0125;
        this.repaintHierarchyDisplay(this.currentDirectory);
        this.rotRing_NOREPAINT();
    }

    public void componentRepaint() {
    }

    public void loadScreenImage(String string) {
        Object object;
        Object object2;
        try {
            object2 = new File(string);
            if (((File)object2).exists()) {
                object = new MediaTracker(this);
                this.backGroundImage = Toolkit.getDefaultToolkit().getImage(string);
                ((MediaTracker)object).addImage(this.backGroundImage, 0);
                try {
                    ((MediaTracker)object).waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.backGroundImageFrag = true;
                this.repaint();
            } else {
                object = new MediaTracker(this);
                this.backGroundImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("defaultScreen.jpg"));
                ((MediaTracker)object).addImage(this.backGroundImage, 0);
                try {
                    ((MediaTracker)object).waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.backGroundImageFrag = true;
                this.repaint();
            }
            object2 = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!this.backGroundImageFrag) {
            this.backGroundImage = this.createImage(this.width, this.height);
            object2 = (Graphics2D)this.backGroundImage.getGraphics();
            object = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, this.height, Color.black);
            ((Graphics2D)object2).setPaint((Paint)object);
            ((Graphics)object2).fillRect(0, 0, this.width, this.height);
            object2 = null;
            this.backGroundImageFrag = true;
        }
        if (this.backGroundImageFrag) {
            this.resizedBackGroundImage = this.createImage(this.width, this.height);
            this.resizedBackGroundGraphics = this.resizedBackGroundImage.getGraphics();
            this.resizedBackGroundGraphics.drawImage(this.backGroundImage, 0, 0, this.width, this.height, this);
            this.resizedBackGroundGraphics = null;
            this.screenImageElement = new FixedSizeImageElement3DEG(0.0, 0.0, -100000.0, this.resizedBackGroundImage);
            this.screenImageElement.setOffset(this.width / 2 - (this.width / 2 - this.centerX), this.height / 2 - (this.height / 2 - this.centerY));
            this.screen.add(this.screenImageElement);
            this.screen.request(this.screenImageElement);
            this.displayPanel.repaint3D();
            this.componentRepaint();
        }
    }

    private void transformVertexVectors() {
        for (int i = 0; i < this.ringFiles.length; ++i) {
            this.screen.see(this.ringVertexVectors[i], this.ringVertexVectors_transformed[i]);
            this.ringVertexProjectedX[i] = this.screen.getProjectedX(this.ringVertexVectors_transformed[i]);
            this.ringVertexProjectedY[i] = this.screen.getProjectedY(this.ringVertexVectors_transformed[i]);
        }
    }

    private void setTargetFileEffect(int n) {
        this.cursorOnIndex = n;
        for (int i = 0; i < this.ringFiles.length; ++i) {
            this.ringStringElements[i].setColor(this.offCursorColor);
            this.ringStringElements[i].setFont(this.offCursorFont);
            this.ringStringElements[i].setSize(this.offCursorSize);
            this.ringStringShadowElements[i].setFont(this.offCursorFont);
            this.ringStringShadowElements[i].setSize(this.offCursorSize);
            this.ringImageElements[i].setSize(0.8, 0.8);
            this.ringImageElements[i].setOffset(this.iconOffsetX_off, this.iconOffsetY_off);
        }
        Color color = Color.red;
        try {
            this.ringStringElements[this.cursorOnIndex].setColor(color);
            this.ringStringElements[this.cursorOnIndex].setFont(this.onCursorFont);
            this.ringStringElements[this.cursorOnIndex].setSize(this.onCursorSize);
            this.ringStringShadowElements[this.cursorOnIndex].setFont(this.onCursorFont);
            this.ringStringShadowElements[this.cursorOnIndex].setSize(this.onCursorSize);
            this.ringImageElements[this.cursorOnIndex].setSize(2.07, 2.07);
            this.ringImageElements[this.cursorOnIndex].setOffset(this.iconOffsetX_on, this.iconOffsetY_on);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private boolean mouseOnRingFiles(int n, int n2, int n3) {
        try {
            if (this.ringVertexProjectedX[n] - 10 - 50 < n2 && n2 < this.ringVertexProjectedX[n] - 10 + 14 && this.ringVertexProjectedY[n] - 14 < n3 && n3 < this.ringVertexProjectedY[n] + 14) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            if (this.linkDragging && !this.dragAndDropLocker) {
                double d = this.fileLinkDefaultZ;
                double d2 = this.screen.getReverseProjectedX(this.mouse_cursorX, d);
                double d3 = this.screen.getReverseProjectedY(this.mouse_cursorY, d);
                this.links[this.draggingLinkIndex].setVertex(d2, d3, d - this.desktopSphereOffsetZ);
            }
            this.desktopSphereOffsetZ += 2.0;
            this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.linkDragging && !this.dragAndDropLocker) {
                double d = this.fileLinkDefaultZ;
                double d4 = this.screen.getReverseProjectedX(this.mouse_cursorX, d);
                double d5 = this.screen.getReverseProjectedY(this.mouse_cursorY, d);
                this.links[this.draggingLinkIndex].setVertex(d4, d5, d - this.desktopSphereOffsetZ);
            }
            this.desktopSphereOffsetZ -= 2.0;
            this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
        } else if (keyEvent.getKeyCode() == 17) {
            this.keyPressing_CTRL = true;
        } else if (keyEvent.getKeyCode() == 65 && this.keyPressing_CTRL) {
            this.keyPressing_CTRL = false;
            this.fileReserveWindow.format();
            this.fileReserveWindow.reserve(this.ringFiles);
        } else if (keyEvent.getKeyCode() == 86 && this.keyPressing_CTRL) {
            int n;
            this.keyPressing_CTRL = false;
            File[] fileArray = new File[this.getCopyTargetFiles().length];
            for (n = 0; n < fileArray.length; ++n) {
                fileArray[n] = new File(this.getCurrentDirectory().getPath() + this.fileSeparator + this.getCopyTargetFiles()[n].getName());
                fileArray[n] = this.getPreferedNamedFile(fileArray[n]);
            }
            n = this.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_PROCESSRESERVE"));
            int n2 = this.getPreferredApplicationID(new File("a.SYSTEM_DAEMON_COPYPROCESS"));
            if (n2 > 0 && n > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    String[] stringArray = new String[]{Integer.toString(n2), this.getCopyTargetFiles()[i].getPath(), fileArray[i].getPath()};
                    this.generate_DIRECT(stringArray, n);
                }
            } else {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.copy(this.getCopyTargetFiles()[i], fileArray[i]);
                }
            }
            this.filePasted(fileArray[0]);
        } else if (keyEvent.getKeyCode() == 67 && this.keyPressing_CTRL) {
            if (this.areaSelected && !this.areaSelecting) {
                this.copyTargetFiles = this.selectingFiles;
                this.areaSelected = false;
                this.areaSelecting = false;
                this.fileReserveWindow.format();
                this.fileReserveWindow.setVisible(false);
                this.displayPanel.repaint3D();
            } else {
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                int n3 = 0;
                if (this.withCrystalBrowserState && this.cursorOnIndex < this.ringFiles.length && (this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy) || this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy + 20))) {
                    this.rightClickTargetFile = this.getTargetFile();
                    bl = true;
                    n3 = this.getTargetFileIndex();
                }
                if (this.links != null && (n = this.getOnCursorFileLink(this.mouse_sx, this.mouse_sy)) != -1) {
                    this.rightClickTargetFile = this.links[n].file;
                    bl2 = true;
                }
                if (bl) {
                    this.copyTargetFiles = new File[]{this.ringFiles[n3]};
                }
                if (bl2) {
                    this.copyTargetFiles = new File[]{this.links[n].getFile()};
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.getKeyCode();
        this.keyPressing_CTRL = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.getKeyCode();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.pinsetOperatorSecurityManager.setExitPermission(true);
        try {
            this.log_lastdirectory_absolute = this.currentDirectory.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.log_lastdirectory_absolute = "null";
        }
        this.log_lastdirectory_relative = this.getRelativePath(this.log_lastdirectory_absolute);
        this.saveSettingFile();
        this.stop();
        System.exit(0);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.componentListenerEnabled) {
            Dimension dimension = this.getSize();
            this.width = (int)dimension.getWidth();
            this.height = (int)dimension.getHeight() - 50;
            this.centerY = this.height / 2;
            dimension = null;
            this.numberOfApplication_Y = (this.height + this.iconOffsetY - this.iconOffsetY - 40) / this.iconDy;
            this.numberOfApplication_X = this.palletApplicationID.length == this.numberOfApplication_Y ? 1 : this.palletApplicationID.length / this.numberOfApplication_Y + 1;
            try {
                this.resizedBackGroundImage = this.createImage(this.width, this.height);
                this.resizedBackGroundGraphics = this.resizedBackGroundImage.getGraphics();
                this.resizedBackGroundGraphics.drawImage(this.backGroundImage, 0, 0, this.width, this.height, this);
                this.resizedBackGroundGraphics = null;
                this.screenImageElement.setImage(this.resizedBackGroundImage);
                this.screenImageElement.setOffset(this.width / 2 - (this.width / 2 - this.centerX), this.height / 2 - (this.height / 2 - this.centerY));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.displayPanel.setBounds(0, 0, this.width, this.height);
            this.displayPanel.reSize();
            this.screen.setScreenCenter(this.centerX, this.centerY);
            this.displayPanel.repaint3D();
            try {
                int n = this.palletApplicationID.length;
                for (int i = 0; i < n; ++i) {
                    this.applicationElement[i].setOffset(-this.width + this.iconOffsetX + this.iconDx * this.palletIndexToCell_x(i), this.height / 2 + this.iconOffsetY - this.iconDy * this.palletIndexToCell_y(i));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.displayPanel.repaint3D();
            this.componentRepaint();
        }
    }

    public int palletIndexToCell_x(int n) {
        if (this.palletApplicationID.length == this.numberOfApplication_Y) {
            return 1;
        }
        return n / this.numberOfApplication_Y + 1;
    }

    public int palletIndexToCell_y(int n) {
        int n2 = this.palletIndexToCell_x(n);
        return n - (n2 - 1) * this.numberOfApplication_Y;
    }

    public int getPalletIndex(int n, int n2) {
        return (n - 1) * this.numberOfApplication_Y + n2 - 1;
    }

    public PinsetApplication getFileBrowserApplication() {
        for (int i = 0; i < this.application.length; ++i) {
            for (int j = 0; j < this.application[i].extention.length; ++j) {
                if (!this.application[i].extention[j].equals("DIRECTORY")) continue;
                return this.application[i];
            }
        }
        return null;
    }

    public int getFileBrowserApplicationID() {
        for (int i = 0; i < this.application.length; ++i) {
            for (int j = 0; j < this.application[i].extention.length; ++j) {
                if (!this.application[i].extention[j].equals("DIRECTORY")) continue;
                return i;
            }
        }
        return -1;
    }

    public void fileDropping(File file) {
        if (this.mainMenuBar.isBackgroundMode()) {
            this.toBack();
        }
        this.dragAndDropElement.setImage(this.getPreferredImage(file));
        this.setTargetFile(file);
        this.linkDragging = false;
        this.dragAndDropFrag = true;
        this.linkDragging = false;
        this.cursorOnIndex = 0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseListenerEnabled) {
            if (this.mainMenuBar.isBackgroundMode()) {
                this.toBack();
            }
            this.subThread.fileWaveAnimation_INIT();
            this.dragAndDropFrag = false;
            this.pointerElement.setOffset(10000, 10000);
            this.iconButtonElement.setOffset(10000, 10000);
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
            this.mouse_sx_first = mouseEvent.getX();
            this.mouse_sy_first = mouseEvent.getY();
            this.mouseDraggingStartX = mouseEvent.getX();
            this.mouseDraggingStartY = mouseEvent.getY();
            if (this.areaSelected && !this.areaSelecting) {
                if (this.areaSelectingSx < mouseEvent.getX() && mouseEvent.getX() < this.areaSelectingEx) {
                    if (this.areaSelectingSy < mouseEvent.getY() && mouseEvent.getY() < this.areaSelectingEy) {
                        this.dragAndDropElement.setImage(this.listIconImage);
                        this.dragAndDropFrag = true;
                        this.areaSelected = true;
                        this.areaSelecting = false;
                    } else {
                        this.fileReserveWindow.format();
                        this.fileReserveWindow.setVisible(false);
                        this.areaSelected = false;
                        this.areaSelecting = false;
                        this.displayPanel.repaint3DRequest();
                    }
                } else {
                    this.fileReserveWindow.format();
                    this.fileReserveWindow.setVisible(false);
                    this.areaSelected = false;
                    this.areaSelecting = false;
                    this.displayPanel.repaint3DRequest();
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseListenerEnabled) {
            if (this.mainMenuBar.isBackgroundMode()) {
                this.toBack();
            }
            if (this.dragAndDropFrag) {
                this.mouse_cursorX = mouseEvent.getX();
                this.mouse_cursorY = mouseEvent.getY();
                if (this.linkDragging && !this.dragAndDropLocker) {
                    double d = this.fileLinkDefaultZ;
                    double d2 = this.screen.getReverseProjectedX(this.mouse_cursorX, d);
                    double d3 = this.screen.getReverseProjectedY(this.mouse_cursorY, d);
                    this.links[this.draggingLinkIndex].setVertex(d2, d3, d - this.desktopSphereOffsetZ);
                    this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
                } else {
                    this.dragAndDropElement.setOffset(-this.mouse_cursorX + 25, this.height / 2 - this.mouse_cursorY + 25);
                }
                if (this.mouse_cursorX > this.width - this.iconDx * this.numberOfApplication_X) {
                    this.cell_x = (this.width - this.mouse_cursorX) / this.iconDx + 1;
                    this.cell_y = this.mouse_cursorY / this.iconDy + 1;
                    this.id = this.getPalletIndex(this.cell_x, this.cell_y);
                    this.id = 0 <= this.id && this.id < this.palletApplicationID.length ? this.getPalletIndex(this.cell_x, this.cell_y) : -1;
                    if (0 <= this.id && this.id <= this.palletApplicationID.length - 1 && this.cell_y <= this.numberOfApplication_Y) {
                        this.iconButtonElement.setOffset(-this.width + this.iconOffsetX + this.iconDx * this.cell_x, this.height / 2 + this.iconOffsetY - this.iconDy * (this.cell_y - 1));
                    } else {
                        this.iconButtonElement.setOffset(10000, 10000);
                    }
                } else {
                    this.iconButtonElement.setOffset(10000, 10000);
                }
                this.displayPanel.repaint3DRequest();
            } else {
                this.mouse_ex = mouseEvent.getX();
                this.mouse_ey = mouseEvent.getY();
                this.mouse_dx = (double)this.mouse_sx - (double)this.mouse_ex;
                this.mouse_dy = (double)this.mouse_sy - (double)this.mouse_ey;
                boolean bl = false;
                int n = 0;
                if (this.links != null && (n = this.getOnCursorFileLink(this.mouse_sx, this.mouse_sy)) != -1) {
                    bl = true;
                }
                if (bl && !this.dragAndDropLocker) {
                    this.linkDragStartX = this.links[n].getX();
                    this.linkDragStartY = this.links[n].getY();
                    this.linkDragStartZ = this.links[n].getZ();
                    this.linkDragging = true;
                    this.draggingLinkIndex = n;
                    this.dragAndDropFrag = true;
                } else if (!this.dragAndDropLocker) {
                    if (this.fileGripping) {
                        double d = -this.mouse_ex + this.mouse_sx_first;
                        double d4 = -this.mouse_ey + this.mouse_sy_first;
                        this.ringImageElements[this.cursorOnIndex].setOffset(d * 0.045 + this.iconOffsetX_on, d4 * 0.045 + this.iconOffsetY_on);
                        this.subThread.fileWaveAnimation();
                        if (d * d + d4 * d4 > this.springStrength * this.springStrength) {
                            this.fileGripping = false;
                            this.dragAndDropElement.setImage(this.ringImageElements[this.cursorOnIndex].image);
                            this.dragAndDropFrag = true;
                        }
                    } else if (this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_ex, this.mouse_ey) || this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_ex, this.mouse_ey + 20)) {
                        this.fileGripping = true;
                        this.grippingTargetFileIndex = this.cursorOnIndex;
                    } else {
                        this.dragAndDropLocker = true;
                    }
                } else {
                    this.dragAndDropLocker = true;
                }
                if (this.dragAndDropLocker) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.withCrystalBrowserState) {
                        if (this.subThread.isAnimating()) {
                            this.subThread.stopFileWaveAnimation();
                        }
                        this.mouse_iconDy = ((double)this.mouse_sy - (double)this.mouse_ey) * this.dragSpeed;
                        this.lambda += this.mouse_iconDy;
                        this.rotRing();
                    } else if (this.areaSelecting) {
                        this.areaSelectingEx = mouseEvent.getX();
                        this.areaSelectingEy = mouseEvent.getY();
                    } else {
                        this.screen.canvasGraphics.setColor(Color.red);
                        this.screen.canvasGraphics.drawLine(mouseEvent.getX() - 10, mouseEvent.getY(), mouseEvent.getX() + 10, mouseEvent.getY());
                        this.screen.canvasGraphics.drawLine(mouseEvent.getX(), mouseEvent.getY() - 10, mouseEvent.getX(), mouseEvent.getY() + 10);
                        this.displayPanel.repaint();
                        this.areaSelectingSx = mouseEvent.getX();
                        this.areaSelectingSy = mouseEvent.getY();
                        this.areaSelecting = true;
                        this.areaSelected = false;
                        this.fileReserveWindow.format();
                    }
                }
                this.mouse_sx = mouseEvent.getX();
                this.mouse_sy = mouseEvent.getY();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseListenerEnabled) {
            if (this.mainMenuBar.isBackgroundMode()) {
                this.toBack();
            }
            if (this.fileGripping) {
                this.fileGripping = false;
            }
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
            this.transformVertexVectors();
            if (this.dragAndDropFrag) {
                if (this.linkDragging) {
                    this.cell_x = (this.width - this.mouse_sx) / this.iconDx + 1;
                    this.cell_y = this.mouse_sy / this.iconDy + 1;
                    this.id = this.getPalletIndex(this.cell_x, this.cell_y);
                    this.id = 0 <= this.id && this.id < this.palletApplicationID.length ? this.getPalletIndex(this.cell_x, this.cell_y) : -1;
                    if (0 <= this.id && this.id <= this.numberOfApplication_TOTAL - 1 && this.cell_y <= this.numberOfApplication_Y) {
                        this.links[this.draggingLinkIndex].setVertex(this.linkDragStartX, this.linkDragStartY, this.linkDragStartZ);
                        this.setDesktopSphereOffset(this.desktopSphereOffsetX, this.desktopSphereOffsetY, this.desktopSphereOffsetZ);
                        this.generate(this.links[this.draggingLinkIndex].getFile(), this.palletApplicationID[this.id]);
                    }
                    this.linkDragging = false;
                    if (!this.subThread.isAnimating()) {
                        this.delayedRepaint(50);
                    }
                } else if (this.mouse_sx > this.width - this.iconDx * this.numberOfApplication_X) {
                    this.cell_x = (this.width - this.mouse_sx) / this.iconDx + 1;
                    this.cell_y = this.mouse_sy / this.iconDy + 1;
                    this.id = this.getPalletIndex(this.cell_x, this.cell_y);
                    this.id = 0 <= this.id && this.id < this.palletApplicationID.length ? this.getPalletIndex(this.cell_x, this.cell_y) : -1;
                    if (0 <= this.id && this.id <= this.palletApplicationID.length - 1 && this.cell_y <= this.numberOfApplication_Y) {
                        if (this.areaSelected && !this.areaSelecting) {
                            this.generate(this.selectingFiles, this.palletApplicationID[this.id]);
                            this.areaSelected = false;
                            this.areaSelecting = false;
                            this.fileReserveWindow.format();
                            this.fileReserveWindow.setVisible(false);
                        } else {
                            this.generate(this.getTargetFile(), this.palletApplicationID[this.id]);
                        }
                    }
                    if (this.subThread.isAnimating()) {
                        this.subThread.stopFileWaveAnimation();
                    }
                    this.setTargetFileEffect(this.cursorOnIndex);
                } else if (this.areaSelected && !this.areaSelecting) {
                    this.areaSelected = false;
                    this.areaSelecting = false;
                    this.fileReserveWindow.format();
                    this.fileReserveWindow.setVisible(false);
                } else {
                    this.addFileLink(this.getTargetFile(), this.mouse_sx, this.mouse_sy);
                    this.reloadRing();
                    this.setTargetFileEffect(this.cursorOnIndex);
                }
            }
            if (this.areaSelecting) {
                int n;
                int n2;
                int n3;
                int n4;
                this.rotRing_NOREPAINT();
                int n5 = Math.max(this.areaSelectingSx, this.areaSelectingEx);
                int n6 = Math.min(this.areaSelectingSx, this.areaSelectingEx);
                int n7 = Math.max(this.areaSelectingSy, this.areaSelectingEy);
                int n8 = Math.min(this.areaSelectingSy, this.areaSelectingEy);
                this.areaSelectingSx = n6;
                this.areaSelectingEx = n5;
                this.areaSelectingSy = n8;
                this.areaSelectingEy = n7;
                this.areaSelecting = false;
                this.areaSelected = true;
                this.screen.canvasGraphics.setColor(new Color(200, 255, 255, 120));
                this.screen.canvasGraphics.fillRect(n6, n8, n5 - n6, n7 - n8);
                this.screen.canvasGraphics.setColor(Color.red);
                this.screen.canvasGraphics.drawRect(n6, n8, n5 - n6, n7 - n8);
                this.displayPanel.repaint();
                int n9 = 0;
                int n10 = 0;
                if (this.links != null) {
                    for (n4 = 0; n4 < this.links.length; ++n4) {
                        n3 = this.links[n4].getProjectedX(this.screen);
                        n2 = this.links[n4].getProjectedY(this.screen);
                        if (n6 >= n3 || n3 >= n5 || n8 >= n2 || n2 >= n7) continue;
                        ++n9;
                    }
                }
                for (n4 = 0; n4 < this.ringFiles.length; ++n4) {
                    n3 = this.ringVertexProjectedX[n4];
                    n2 = this.ringVertexProjectedY[n4];
                    if (n6 >= n3 || n3 >= n5 || n8 >= n2 || n2 >= n7) continue;
                    ++n10;
                }
                File[] fileArray = new File[n9 + n10];
                int n11 = 0;
                if (this.links != null) {
                    for (n = 0; n < this.links.length; ++n) {
                        n3 = this.links[n].getProjectedX(this.screen);
                        n2 = this.links[n].getProjectedY(this.screen);
                        if (n6 >= n3 || n3 >= n5 || n8 >= n2 || n2 >= n7) continue;
                        fileArray[n11] = this.links[n].getFile();
                        this.subThread.lockOnAnimation(n3, n2, fileArray[n11]);
                        ++n11;
                    }
                }
                n11 = 0;
                for (n = 0; n < this.ringFiles.length; ++n) {
                    n3 = this.ringVertexProjectedX[n];
                    n2 = this.ringVertexProjectedY[n];
                    if (n6 >= n3 || n3 >= n5 || n8 >= n2 || n2 >= n7) continue;
                    fileArray[n11 + n9] = this.ringFiles[n];
                    this.subThread.lockOnAnimation(n3 - 20, n2, fileArray[n11]);
                    ++n11;
                }
                this.selectingFiles = fileArray;
                this.fileReserveWindow.format();
                this.fileReserveWindow.reserve(fileArray);
            }
            this.dragAndDropLocker = false;
            if (this.dragAndDropFrag) {
                this.dragAndDropElement.setOffset(10000, 10000);
                this.delayedRepaint(30);
                this.dragAndDropFrag = false;
            }
            this.realtimeFrag = false;
            this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseListenerEnabled && !this.areaSelected) {
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
            this.pointerElement.setOffset(10000, 10000);
            if (this.mouse_sx < 170 && this.mouse_sy < this.height / 2 && this.mouse_sy > this.height / 2 - 100) {
                this.iconButtonElement.setOffset(10000, 10000);
                if (this.withCrystalBrowserState) {
                    this.returnIconElement.setOffset(-12, 128);
                    this.returnIconElement.setImage(this.browserCloseImage);
                } else {
                    this.returnIconElement.setImage(this.browserOpenImage);
                    this.returnIconElement.setOffset(10, 110);
                }
                if (this.systemFragInt != 211) {
                    this.repaintAndDelay(10);
                }
                this.systemFragInt = 211;
            } else if (this.mouse_sx > this.width - this.iconDx * this.numberOfApplication_X) {
                this.returnIconElement.setOffset(-20, 110);
                if (this.withCrystalBrowserState) {
                    this.returnIconElement.setImage(this.returnIconImage);
                } else {
                    this.returnIconElement.setImage(this.browserStayImage);
                }
                this.cell_x = (this.width - this.mouse_sx) / this.iconDx + 1;
                this.cell_y = this.mouse_sy / this.iconDy + 1;
                if (this.palletApplicationID != null && this.palletApplicationID.length > 0) {
                    this.id = this.getPalletIndex(this.cell_x, this.cell_y);
                    this.id = 0 <= this.id && this.id < this.palletApplicationID.length ? this.getPalletIndex(this.cell_x, this.cell_y) : -1;
                }
                if (0 <= this.id && this.id <= this.palletApplicationID.length - 1 && this.cell_y <= this.numberOfApplication_Y) {
                    this.iconButtonElement.setOffset(-this.width + this.iconOffsetX + this.iconDx * this.cell_x, this.height / 2 + this.iconOffsetY - this.iconDy * (this.cell_y - 1));
                    this.repaintAndDelay(33);
                } else {
                    this.iconButtonElement.setOffset(10000, 10000);
                    this.repaintAndDelay(33);
                }
                this.systemFragInt = 2;
            } else {
                this.returnIconElement.setOffset(-20, 110);
                this.iconButtonElement.setOffset(10000, 10000);
                if (this.withCrystalBrowserState) {
                    this.returnIconElement.setOffset(-20, 110);
                    this.returnIconElement.setImage(this.returnIconImage);
                } else {
                    this.returnIconElement.setOffset(-20, 110);
                    this.returnIconElement.setImage(this.browserStayImage);
                }
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                int n2 = 0;
                if (this.withCrystalBrowserState) {
                    if (this.cursorOnIndex < this.ringFiles.length && (this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy) || this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy + 20))) {
                        bl = true;
                        n2 = this.getTargetFileIndex();
                    }
                    if (bl && n2 != this.cursorOnIndexStock) {
                        if (this.subThread.isAnimating()) {
                            this.subThread.stopFileWaveAnimation();
                        }
                        if (!this.subThread.isAnimating()) {
                            this.subThread.lockOnAnimation(this.ringVertexProjectedX[n2] - 25, this.ringVertexProjectedY[n2] - 10, this.ringFiles[n2]);
                        }
                        this.cursorOnIndexStock = this.cursorOnIndex;
                    }
                }
                if (this.links != null && (n = this.getOnCursorFileLink(mouseEvent.getX(), mouseEvent.getY())) != -1) {
                    bl2 = true;
                }
                if (bl2) {
                    if (n != this.targetedLinkIndex && !this.subThread.isAnimating()) {
                        this.displayPanel.repaint3D();
                        this.subThread.lockOnAnimation(this.links[n].getProjectedX(this.screen), this.links[n].getProjectedY(this.screen), this.links[n].getFile());
                    }
                    this.targetedLinkIndex = n;
                } else {
                    this.targetedLinkIndex = -1;
                }
                if (this.withCrystalBrowserState) {
                    if (this.withCrystalBrowserState) {
                        this.returnIconElement.setImage(this.returnIconImage);
                    } else {
                        this.returnIconElement.setImage(this.browserStayImage);
                    }
                    for (int i = 0; i < this.ringFiles.length; ++i) {
                        if (!this.mouseOnRingFiles(i, this.mouse_sx, this.mouse_sy)) continue;
                        this.setTargetFile(this.ringFiles[i]);
                        if (i == this.cursorOnIndex) continue;
                        this.cursorOnIndex = i;
                        if (!this.subThread.isAnimating()) {
                            this.setTargetFileEffect(i);
                        } else {
                            this.setTargetFileEffect(i);
                            this.subThread.fileWaveAnimation_INIT();
                        }
                        this.systemFragInt = 0;
                    }
                }
                if (this.systemFragInt != 7) {
                    try {
                        if (!this.subThread.isAnimating()) {
                            this.repaintAndDelay(10);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        this.repaintAndDelay(10);
                    }
                }
                this.systemFragInt = 7;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mainMenuBar.isBackgroundMode()) {
            this.toBack();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mainMenuBar.isBackgroundMode()) {
            this.toBack();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mouseListenerEnabled) {
            if (this.mainMenuBar.isBackgroundMode()) {
                this.toBack();
            }
            this.realtimeFrag = false;
            this.displayPanel.setProcessMode(Realtime3DPanel.SEMI_REALTIME_MODE);
            this.pointerElement.setOffset(10000, 10000);
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
            if (this.mouse_sx < 180 && this.mouse_sy < this.height / 2 && this.mouse_sy > this.height / 2 - 100) {
                if (this.withCrystalBrowserState) {
                    this.returnIconElement.setOffset(-10, 128);
                    this.returnIconElement.setImage(this.browserCloseImage);
                } else {
                    this.returnIconElement.setImage(this.browserOpenImage);
                    this.returnIconElement.setOffset(10, 110);
                }
                if (this.withCrystalBrowserState) {
                    this.subThread.browserCloseAnimation();
                } else {
                    this.subThread.browserOpenAnimation();
                }
            } else if (this.mouse_sx > this.width - this.iconDx * this.numberOfApplication_X) {
                this.cell_x = (this.width - this.mouse_sx) / this.iconDx + 1;
                this.cell_y = this.mouse_sy / this.iconDy + 1;
                this.id = this.getPalletIndex(this.cell_x, this.cell_y);
                this.id = 0 <= this.id && this.id < this.palletApplicationID.length ? this.getPalletIndex(this.cell_x, this.cell_y) : -1;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.rightClickedApplicationID = this.palletApplicationID[this.id];
                    this.applicationMenu.setApplication(this.application[this.palletApplicationID[this.id]]);
                    this.applicationMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (0 <= this.id && this.id <= this.palletApplicationID.length - 1 && this.cell_y <= this.numberOfApplication_Y) {
                    this.generate(this.palletApplicationID[this.id]);
                }
            } else {
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                int n2 = 0;
                if (this.withCrystalBrowserState && this.cursorOnIndex < this.ringFiles.length && (this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy) || this.mouseOnRingFiles(this.cursorOnIndex, this.mouse_sx, this.mouse_sy + 20))) {
                    this.rightClickTargetFile = this.getTargetFile();
                    bl = true;
                    n2 = this.getTargetFileIndex();
                }
                if (this.links != null && (n = this.getOnCursorFileLink(this.mouse_sx, this.mouse_sy)) != -1) {
                    this.rightClickTargetFile = this.links[n].file;
                    bl2 = true;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (bl && this.withCrystalBrowserState) {
                        this.pointerElement.setOffset(-mouseEvent.getX() + 25, this.height / 2 - mouseEvent.getY() + 25);
                        this.delayedRepaint(30);
                        this.fileMenu.setFile(this.rightClickTargetFile);
                        this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (bl2) {
                        this.pointerElement.setOffset(-mouseEvent.getX() + 25, this.height / 2 - mouseEvent.getY() + 25);
                        this.delayedRepaint(30);
                        this.fileMenu.setLink(this.rightClickTargetFile);
                        this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.fileMenu.setBlank();
                        this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (this.keyPressing_CTRL) {
                    if (bl2) {
                        this.fileReserveWindow.reserve(this.links[n].getFile());
                    } else {
                        this.fileReserveWindow.reserve(this.ringFiles[this.cursorOnIndex]);
                    }
                } else if (bl2) {
                    if (mouseEvent.getClickCount() == 2) {
                        if (this.links[n].getFile().isDirectory()) {
                            if (this.withCrystalBrowserState) {
                                this.directoryManager.setCurrentDirectory(this.links[n].getFile());
                                this.subThread.goDifferentRingAnimation(this.links[n].getFile());
                            } else {
                                int n3 = this.getFileBrowserApplicationID();
                                if (n3 != -1) {
                                    this.generate(this.links[n].getFile(), n3);
                                }
                            }
                        } else {
                            this.generate(this.links[n].getFile(), this.linkTypes[n]);
                        }
                    } else if (mouseEvent.getClickCount() == 1) {
                        this.pointerElement.setOffset(-mouseEvent.getX() + 25, this.height / 2 - mouseEvent.getY() + 25);
                        this.delayedRepaint(30);
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    if (this.withCrystalBrowserState) {
                        if (this.ringFiles[this.cursorOnIndex].isDirectory()) {
                            this.directoryManager.setCurrentDirectory(this.ringFiles[this.cursorOnIndex]);
                            this.subThread.goLowerRingAnimation(this.ringFiles[this.cursorOnIndex]);
                        } else {
                            this.generate(this.ringFiles[this.cursorOnIndex], this.ringFileTypes[this.cursorOnIndex]);
                        }
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    if (bl) {
                        this.pointerElement.setOffset(-mouseEvent.getX() + 25, this.height / 2 - mouseEvent.getY() + 25);
                    }
                    this.delayedRepaint(30);
                }
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d = (double)mouseWheelEvent.getScrollAmount() * 0.037;
        this.lambda = mouseWheelEvent.getWheelRotation() < 0 ? (this.lambda += d) : (this.lambda -= d);
        if (this.lambda >= Math.PI * 2) {
            this.lambda -= Math.PI * 2;
        } else if (this.lambda <= 0.0) {
            this.lambda += Math.PI * 2;
        }
        this.rotRing();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        int n;
        if (actionEvent.getActionCommand().equals("Make Directory")) {
            String string = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file = new File(this.currentDirectory.getPath() + this.fileSeparator + string);
            if (file.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The directory already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The directory already exists.", 1);
            } else {
                file.mkdir();
                this.reloadRing();
                for (int i = 0; i < this.ringFiles.length; ++i) {
                    if (!this.ringFiles[i].getPath().equals(file.getPath())) continue;
                    this.rotRing(i);
                    this.setTargetFileEffect(i);
                }
                this.delayedRepaint(50);
            }
        } else if (actionEvent.getActionCommand().equals("Make File")) {
            String string = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file = new File(this.currentDirectory.getPath() + this.fileSeparator + string);
            if (file.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", 1);
            } else {
                try {
                    file.createNewFile();
                    this.reloadRing();
                    for (int i = 0; i < this.ringFiles.length; ++i) {
                        if (!this.ringFiles[i].getPath().equals(file.getPath())) continue;
                        this.rotRing(i);
                        this.setTargetFileEffect(i);
                    }
                    this.delayedRepaint(50);
                }
                catch (IOException iOException) {}
            }
        } else if (actionEvent.getActionCommand().equals("Rename")) {
            String string = JOptionPane.showInputDialog(this, (Object)"\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002/ Please input the name.");
            File file = new File(this.currentDirectory.getPath() + this.fileSeparator + string);
            if (file.exists()) {
                JOptionPane.showMessageDialog(this, "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", "\u305d\u306e\u540d\u524d\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002/ The file already exists.", 1);
            } else {
                this.rightClickTargetFile.renameTo(file);
                this.reloadRing();
            }
        } else if (actionEvent.getActionCommand().equals("Copy")) {
            this.copyTargetFile = this.rightClickTargetFile;
        } else if (actionEvent.getActionCommand().equals("Paste")) {
            File file = new File(this.currentDirectory.getPath() + this.fileSeparator + this.copyTargetFile.getName());
            File file2 = this.getPreferedNamedFile(file);
            this.copy(this.copyTargetFile, file2);
            for (int i = 0; i < this.ringFiles.length; ++i) {
                if (!this.ringFiles[i].getPath().equals(file2.getPath())) continue;
                this.rotRing(i);
                this.setTargetFileEffect(i);
            }
            this.delayedRepaint(50);
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            if (this.isTrashReserved(this.rightClickTargetFile)) {
                String[] stringArray2 = new String[]{"" + this.rightClickTargetFile, " ", "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u30b3\u30f3\u30d4\u30e5\u30fc\u30bf\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u3002", "\u524a\u9664\u3059\u308b\u3068\u3001\u30b4\u30df\u7bb1\u306a\u3069\u304b\u3089\u3082\u5fa9\u5143\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002", "\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b?", "You will be unable to restor this file ( or directory ) anyway, if you delete it.", "Are you sure you want to delete this file ( or directory ) from your computer?"};
                int n2 = JOptionPane.showConfirmDialog(null, stringArray2, "\uff01 CAUTION ", 0);
                if (n2 == 0) {
                    this.deleteFile(this.rightClickTargetFile);
                }
            } else {
                String[] stringArray3 = new String[]{"" + this.rightClickTargetFile, " ", "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\uff08\u53c8\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3092\u524a\u9664\u4fdd\u7ba1\u5834\u6240\u306b\u79fb\u52d5\u3057\u307e\u3059\u304b?", "Do you want to move this file ( or directory ) to `TrashReserver' directory?"};
                int n3 = JOptionPane.showConfirmDialog(null, stringArray3, "\uff01 CAUTION ", 0);
                if (n3 == 0) {
                    this.trashFile(this.rightClickTargetFile);
                    this.reloadRing();
                    this.delayedRepaint(50);
                }
            }
        } else if (actionEvent.getActionCommand().equals("Delete ( desktop link )")) {
            this.removeFileLink(this.rightClickTargetFile);
            this.delayedRepaint(50);
        } else if (actionEvent.getActionCommand().equals("Location")) {
            this.directoryManager.setCurrentDirectory(new File(this.rightClickTargetFile.getParent()));
            this.reloadRing();
        } else if (actionEvent.getActionCommand().equals("Property and settings")) {
            if (this.applicationPropertyWindow == null) {
                this.applicationPropertyWindow = new PinsetApplicationPropertyWindow();
            }
            this.applicationPropertyWindow.setApplication(this.application[this.rightClickedApplicationID]);
            this.applicationPropertyWindow.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Uninstall") && (n = JOptionPane.showConfirmDialog(this, stringArray = new String[]{"\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u767b\u9332\u89e3\u9664\u3057\u307e\u3059\u304b?", "Are you sure you want to uninstall this application?"}, "\uff01", 0)) == 0) {
            String string;
            this.application[this.rightClickedApplicationID].name = string = "NULLTYPE";
            this.application[this.rightClickedApplicationID].info = string;
            this.application[this.rightClickedApplicationID].name = string;
            this.application[this.rightClickedApplicationID].corePath_absolute = string;
            this.application[this.rightClickedApplicationID].corePath_relative = string;
            this.application[this.rightClickedApplicationID].applicationImagePath_absolute = string;
            this.application[this.rightClickedApplicationID].applicationImagePath_relative = string;
            this.application[this.rightClickedApplicationID].fileImagePath_absolute = string;
            this.application[this.rightClickedApplicationID].fileImagePath_relative = string;
            this.application[this.rightClickedApplicationID].extention = new String[]{""};
            String[] stringArray4 = new String[]{"\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u767b\u9332\u89e3\u9664\u3057\u307e\u3057\u305f\u3002\u5909\u66f4\u3092\u53cd\u6620\u3055\u305b\u308b\u306b\u306f\u3001\u3053\u306e\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "You must restart this software for the configuration changes."};
            JOptionPane.showMessageDialog(null, stringArray4, "ApplicationImporter", 1);
        }
    }

    public int getTargetApplicationID() {
        int n = (this.width - this.mouse_cursorX) / this.iconDx + 1;
        int n2 = this.mouse_cursorY / this.iconDy + 1;
        int n3 = -1;
        if (this.palletApplicationID != null && this.palletApplicationID.length > 0) {
            n3 = this.getPalletIndex(n, n2);
            if (0 <= this.id && this.id < this.palletApplicationID.length) {
                n3 = this.palletApplicationID[this.id];
            }
        }
        if (n3 <= this.palletApplicationID.length - 1 && n2 <= this.numberOfApplication_Y) {
            return n3;
        }
        return -1;
    }

    public int getTargetFileIndex() {
        return this.cursorOnIndex;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    public void rotRing(int n) {
        double d = Math.PI * 2 / (double)this.ringFiles.length;
        this.lambda = Math.PI * 2 - (double)n * d;
        this.ringSystem.setAngle(this.theta, this.phi, this.lambda);
        this.displayPanel.repaint3DRequest();
        this.transformVertexVectors();
    }

    public void rotRing() {
        this.rotRing_NOREPAINT();
        this.displayPanel.repaint3DRequest();
    }

    public void rotRing_NOREPAINT() {
        try {
            if (this.lambda >= Math.PI * 2) {
                this.lambda -= Math.PI * 2;
            } else if (this.lambda <= 0.0) {
                this.lambda += Math.PI * 2;
            }
            this.ringSystem.setAngle(this.theta, this.phi, this.lambda + this.d_angle * 0.5);
            double d = Math.PI * 2 / (double)this.ringFiles.length;
            this.cursorOnIndex = (int)((Math.PI * 2 - this.lambda) / d);
            for (int i = 0; i < this.ringFiles.length; ++i) {
                this.ringStringElements[i].setColor(this.offCursorColor);
                this.ringStringElements[i].setFont(this.offCursorFont);
                this.ringStringElements[i].setSize(this.offCursorSize);
                this.ringStringShadowElements[i].setFont(this.offCursorFont);
                this.ringStringShadowElements[i].setSize(this.offCursorSize);
                this.ringImageElements[i].setSize(0.8, 0.8);
                this.ringImageElements[i].setOffset(this.iconOffsetX_off, this.iconOffsetX_off);
            }
            Color color = Color.red;
            try {
                this.ringStringElements[this.cursorOnIndex].setColor(color);
                this.ringStringElements[this.cursorOnIndex].setFont(this.onCursorFont);
                this.ringStringElements[this.cursorOnIndex].setSize(this.onCursorSize);
                this.ringStringShadowElements[this.cursorOnIndex].setFont(this.onCursorFont);
                this.ringStringShadowElements[this.cursorOnIndex].setSize(this.onCursorSize);
                this.ringImageElements[this.cursorOnIndex].setSize(2.07, 2.07);
                this.ringImageElements[this.cursorOnIndex].setOffset(this.iconOffsetX_on, this.iconOffsetX_on);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.transformVertexVectors();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void goParentRing_NOREPAINT() {
        this.directoryManager.goParent();
        this.reloadRing();
    }

    public void goParentRing() {
        this.goParentRing_NOREPAINT();
        this.rotRing();
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public File[] getCurrentList() {
        return null;
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public Image getPreferredImage(File file) {
        String string = file.getName();
        String[] stringArray = string.split("\\.");
        Image image = this.unknownIconImage;
        if (stringArray.length == 1 || file.isDirectory()) {
            image = this.directoryIconImage;
        } else if (stringArray[1].equals("class") || stringArray.equals("CLASS")) {
            image = this.classFileIconImage;
        } else {
            for (int i = 0; i < this.application.length; ++i) {
                int n = this.application[i].extention.length;
                for (int j = 0; j < n; ++j) {
                    if (!this.application[i].extention[j].equals(stringArray[1])) continue;
                    image = this.application[i].image_file;
                }
            }
        }
        return image;
    }

    public int getPreferredApplicationID(File file) {
        String string = file.getName();
        String[] stringArray = string.split("\\.");
        int n = -1;
        if (!(stringArray.length == 1 || file.isDirectory() || stringArray[1].equals("class") || stringArray.equals("CLASS"))) {
            for (int i = 0; i < this.application.length; ++i) {
                int n2 = this.application[i].extention.length;
                for (int j = 0; j < n2; ++j) {
                    if (!this.application[i].extention[j].equals(stringArray[1])) continue;
                    n = i;
                }
            }
        }
        return n;
    }

    public int getPreferredType(File file) {
        String string = file.getName();
        String[] stringArray = string.split("\\.");
        int n = UNKNOWN;
        if (stringArray.length == 1 || file.isDirectory()) {
            n = DIRECTORY;
        } else {
            for (int i = 0; i < this.application.length; ++i) {
                int n2 = this.application[i].extention.length;
                for (int j = 0; j < n2; ++j) {
                    if (!this.application[i].extention[j].equals(stringArray[1])) continue;
                    n = i;
                }
            }
        }
        return n;
    }

    public boolean copy(File file, File file2) {
        return this.copy_DIRECT(file, file2);
    }

    public boolean copy_DIRECT(File file, File file2) {
        boolean bl = false;
        String[] stringArray = file.list();
        String string = ".";
        if (file.exists()) {
            if (!file.isDirectory()) {
                bl = this.copyFile(file, file2);
                this.reloadRing();
                return bl;
            }
            if (file2.exists()) {
                file2 = this.getPreferedNamedFile(file2);
            }
            file2.mkdir();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file.getPath() + this.fileSeparator + stringArray[i]);
                File file4 = new File(file2.getPath() + this.fileSeparator + stringArray[i]);
                bl = file3.isDirectory() ? (file3.list().length == 0 ? file4.mkdir() : this.copy(file3, file4)) : this.copyFile(file3, file4);
                if (bl) continue;
                this.statusDisplayWindow.setVisible(false);
                return false;
            }
            this.reloadRing();
            return bl;
        }
        return false;
    }

    public File getPreferedNamedFile(File file) {
        String string = file.getName();
        String string2 = file.getParent();
        File file2 = new File(file.getPath());
        if (file2.exists()) {
            int n = 2;
            while (file2.exists()) {
                file2 = new File(string2 + this.fileSeparator + "(" + n + ")" + string);
                ++n;
            }
        }
        return file2;
    }

    public boolean copyFile(File file, File file2) {
        FileChannel fileChannel;
        FileChannel fileChannel2;
        boolean bl = true;
        if (file2.exists()) {
            file2 = this.getPreferedNamedFile(file2);
        }
        try {
            try {
                fileChannel2 = new FileInputStream(file.getPath()).getChannel();
                fileChannel = new FileOutputStream(file2.getPath()).getChannel();
                fileChannel2.transferTo(0L, fileChannel2.size(), fileChannel);
                fileChannel2.close();
                fileChannel.close();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            bl = false;
        }
        fileChannel2 = null;
        fileChannel = null;
        return bl;
    }

    public boolean trashFile(File file) {
        if (file != this.trashDirectory) {
            if (!this.trashDirectory.exists()) {
                this.trashDirectory.mkdir();
            }
            String string = file.getName();
            File file2 = new File(this.trashPath + this.fileSeparator + string);
            if (file2.exists()) {
                file2 = this.getPreferedNamedFile(file2);
            }
            boolean bl = file.renameTo(file2);
            return bl;
        }
        return false;
    }

    public boolean isTrashReserved(File file) {
        String string = file.getParent();
        return string.equals(this.trashPath);
    }

    public boolean deleteFile(File file) {
        boolean bl = false;
        String[] stringArray = file.list();
        String string = ".";
        if (file.exists()) {
            if (!file.isDirectory()) {
                bl = file.delete();
                this.reloadRing();
                return bl;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath() + this.fileSeparator + stringArray[i]);
                bl = file2.isDirectory() ? (file2.list().length == 0 ? file2.delete() : this.deleteFile(file2)) : file2.delete();
                if (bl) continue;
                return false;
            }
            bl = file.delete();
            this.reloadRing();
            return bl;
        }
        return false;
    }

    public void loadApplication(PinsetApplication[] pinsetApplicationArray) {
    }

    public File getFileFromDialog() {
        File file;
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(0);
        fileDialog.setTitle("\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002 Choose the file to open.");
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0 && (file = new File(string + string2)) != null) {
            return new File(string + string2);
        }
        return null;
    }

    public boolean isFileList(File file) {
        String string = file.getName();
        String[] stringArray = string.split("\\.");
        return stringArray.length >= 2 && stringArray[1].equals("filelist");
    }

    public File[] decodeFileList(File file) {
        try {
            String string;
            FileReader fileReader = new FileReader(file.getPath());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("") || string.equals(" ") || string.equals("\t")) continue;
                ++n;
            }
            File[] fileArray = new File[n];
            fileReader = new FileReader(file.getPath());
            bufferedReader = new BufferedReader(fileReader);
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("") || string.equals(" ") || string.equals("\t")) continue;
                String[] stringArray = string.split("\\(");
                fileArray[n2] = new File(stringArray[0]);
                if (!fileArray[n2].exists() && 2 <= stringArray.length) {
                    stringArray[1] = stringArray[1].replaceAll("\\)", "");
                    fileArray[n2] = new File(stringArray[1]);
                }
                if (!fileArray[n2].exists()) {
                    if (2 <= stringArray.length) {
                        JOptionPane.showMessageDialog(this, "File not found: " + stringArray[0] + " or " + stringArray[1], "!", 1);
                    } else {
                        JOptionPane.showMessageDialog(this, "File not found: " + stringArray[0], "!", 1);
                    }
                }
                ++n2;
            }
            fileReader = null;
            bufferedReader = null;
            return fileArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void registerDirectoriesHistory(File file) {
        if (file != this.directoriesHistory[0]) {
            for (int i = this.directoriesHistoryCapacity - 2; i >= 0; --i) {
                this.directoriesHistory[i + 1] = this.directoriesHistory[i];
            }
            this.directoriesHistory[0] = file;
            ++this.directoriesHistoryRegistered_N;
            if (this.directoriesHistoryRegistered_N > this.directoriesHistoryCapacity) {
                this.directoriesHistoryRegistered_N = this.directoriesHistoryCapacity;
            }
        }
    }

    public File loadPreviousDirectory() {
        if (this.directoriesHistoryRegistered_N >= 1) {
            File file = this.directoriesHistory[0];
            --this.directoriesHistoryRegistered_N;
            for (int i = 0; i < this.directoriesHistoryCapacity - 1; ++i) {
                this.directoriesHistory[i] = this.directoriesHistory[i + 1];
            }
            return file;
        }
        return this.currentDirectory;
    }

    public void generate(int n) {
        try {
            if (this.application[n] != null) {
                this.pinsetOperatorSecurityManager.setExitPermission(true);
                this.application[n].generate(this);
                this.pinsetOperatorSecurityManager.setExitPermission(false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void generate(File file, int n) {
        try {
            if (this.isFileList(file)) {
                if (this.application[n].name.equals("FileListMaker")) {
                    this.pinsetOperatorSecurityManager.setExitPermission(true);
                    this.application[n].generate(file, this);
                    this.pinsetOperatorSecurityManager.setExitPermission(false);
                } else if (this.application[n].name.equals("TrashBin")) {
                    this.pinsetOperatorSecurityManager.setExitPermission(true);
                    this.application[n].generate(file, this);
                    this.pinsetOperatorSecurityManager.setExitPermission(false);
                } else {
                    this.pinsetOperatorSecurityManager.setExitPermission(true);
                    this.application[n].generate(this.decodeFileList(file), this);
                    this.pinsetOperatorSecurityManager.setExitPermission(false);
                }
            } else {
                this.pinsetOperatorSecurityManager.setExitPermission(true);
                this.application[n].generate(file, this);
                this.pinsetOperatorSecurityManager.setExitPermission(false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void generate_DIRECT(File file, int n) {
        this.pinsetOperatorSecurityManager.setExitPermission(true);
        this.application[n].generate(file, this);
        this.pinsetOperatorSecurityManager.setExitPermission(false);
    }

    public void generate_DIRECT(String string, int n) {
        this.pinsetOperatorSecurityManager.setExitPermission(true);
        this.application[n].generate(string, this);
        this.pinsetOperatorSecurityManager.setExitPermission(false);
    }

    public void generate(File[] fileArray, int n) {
        try {
            this.pinsetOperatorSecurityManager.setExitPermission(true);
            this.application[n].generate(fileArray, this);
            this.pinsetOperatorSecurityManager.setExitPermission(false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void generate_DIRECT(File[] fileArray, int n) {
        try {
            this.pinsetOperatorSecurityManager.setExitPermission(true);
            this.application[n].generate(fileArray, this);
            this.pinsetOperatorSecurityManager.setExitPermission(false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void generate(String[] stringArray, int n) {
        try {
            this.pinsetOperatorSecurityManager.setExitPermission(true);
            this.application[n].generate(stringArray, this);
            this.pinsetOperatorSecurityManager.setExitPermission(false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void generate_DIRECT(String[] stringArray, int n) {
        try {
            this.pinsetOperatorSecurityManager.setExitPermission(true);
            this.application[n].generate(stringArray, this);
            this.pinsetOperatorSecurityManager.setExitPermission(false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

