/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rxvesapi.system.PinsetApplication;
import rxvesapi.system.PinsetOperatorApplicationMenu;
import rxvesapi.system.PinsetOperatorBrowsable;
import rxvesapi.system.PinsetOperatorKernel;

public class PinsetOperatorMenuBar
extends JMenuBar
implements ActionListener,
MouseListener,
MouseMotionListener {
    public PinsetOperatorKernel kernel;
    public JMenu applicationSelectMenu;
    public JMenu systemMenu;
    public JMenu fileSelectMenu;
    public PinsetOperatorApplicationMenu applicationMenu;
    public PinsetOperatorBrowsable browsable;
    public JLabel returnLabel;
    public JLabel goLabel;
    public JLabel upLabel;
    public ImageIcon returnIconOff;
    public ImageIcon returnIconOn;
    public ImageIcon goIconOff;
    public ImageIcon goIconOn;
    public ImageIcon upIconOff;
    public ImageIcon upIconOn;
    public JMenuItem applicationSelectCancelItem;
    public JMenu[] applicationSelectCategory;
    public JMenuItem[] systemSelectItem;
    public JMenuItem[] fileSelectItem;
    public JCheckBoxMenuItem backScreenModeItem;
    private JMenu mouseOnMenu;

    public PinsetOperatorMenuBar(PinsetOperatorKernel pinsetOperatorKernel) {
        this.kernel = pinsetOperatorKernel;
        this.componentInit();
    }

    public boolean isBackgroundMode() {
        return this.backScreenModeItem.getState();
    }

    public void setBackgroundMode(boolean bl) {
        this.backScreenModeItem.setState(bl);
    }

    public void componentInit() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("FileBrowser/return.png");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.returnIconOff = new ImageIcon(image);
        uRL = classLoader.getResource("FileBrowser/return_on.png");
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.returnIconOn = new ImageIcon(image);
        uRL = classLoader.getResource("FileBrowser/go.png");
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.goIconOff = new ImageIcon(image);
        uRL = classLoader.getResource("FileBrowser/go_on.png");
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.goIconOn = new ImageIcon(image);
        uRL = classLoader.getResource("FileBrowser/up.png");
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.upIconOff = new ImageIcon(image);
        uRL = classLoader.getResource("FileBrowser/up_on.png");
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.upIconOn = new ImageIcon(image);
        this.returnLabel = new JLabel();
        this.returnLabel.setIcon(this.returnIconOff);
        this.returnLabel.addMouseListener(this);
        this.add(this.returnLabel);
        this.goLabel = new JLabel();
        this.goLabel.setIcon(this.goIconOff);
        this.goLabel.addMouseListener(this);
        this.add(this.goLabel);
        this.upLabel = new JLabel();
        this.upLabel.setIcon(this.upIconOff);
        this.upLabel.addMouseListener(this);
        this.add(this.upLabel);
        this.systemMenu = new JMenu("SYSTEM");
        this.systemMenu.setFont(new Font("Dialog", 1, 14));
        this.add(this.systemMenu);
        this.systemSelectItem = new JMenuItem[5];
        this.systemSelectItem[0] = new JMenuItem("Setting");
        this.systemSelectItem[1] = new JMenuItem("\u65e5\u672c\u8a9e\u8868\u793a");
        this.systemSelectItem[2] = new JMenuItem("Display in English");
        this.backScreenModeItem = new JCheckBoxMenuItem("Backscreen-Mode");
        this.systemSelectItem[3] = this.backScreenModeItem;
        this.systemSelectItem[4] = new JMenuItem("Cancel");
        this.systemSelectItem[0].addActionListener(this);
        this.systemSelectItem[1].addActionListener(this);
        this.systemSelectItem[2].addActionListener(this);
        this.systemMenu.add(this.systemSelectItem[0]);
        this.systemMenu.addSeparator();
        this.systemMenu.add(this.systemSelectItem[1]);
        this.systemMenu.add(this.systemSelectItem[2]);
        this.systemMenu.add(this.systemSelectItem[3]);
        this.systemMenu.addSeparator();
        this.systemMenu.add(this.systemSelectItem[4]);
        this.fileSelectMenu = new JMenu("FILE");
        this.fileSelectMenu.setFont(new Font("Dialog", 1, 14));
        this.add(this.fileSelectMenu);
        this.fileSelectItem = new JMenuItem[4];
        this.fileSelectItem[0] = new JMenuItem("Desktop");
        this.fileSelectItem[1] = new JMenuItem("Home");
        this.fileSelectItem[2] = new JMenuItem("Current");
        this.fileSelectItem[0].addActionListener(this);
        this.fileSelectItem[1].addActionListener(this);
        this.fileSelectItem[2].addActionListener(this);
        this.fileSelectMenu.add(this.fileSelectItem[0]);
        this.fileSelectMenu.add(this.fileSelectItem[1]);
        this.fileSelectMenu.add(this.fileSelectItem[2]);
        this.fileSelectMenu.addSeparator();
        this.fileSelectItem[this.fileSelectItem.length - 1] = new JMenuItem("Current");
        this.fileSelectItem[this.fileSelectItem.length - 1].addActionListener(this);
        this.fileSelectMenu.add(this.fileSelectItem[this.fileSelectItem.length - 1]);
        this.applicationSelectMenu = new JMenu("APPLICATION");
        this.applicationSelectMenu.setFont(new Font("Dialog", 1, 14));
        this.add(this.applicationSelectMenu);
        this.applicationSelectCancelItem = new JMenuItem("Cancel");
        this.reloadApplicationMenu();
        this.applicationMenu = new PinsetOperatorApplicationMenu(this.kernel);
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_ENGLISH) {
            this.setEnglish();
        }
        if (this.kernel.getLanguage() == PinsetOperatorKernel.LANGUAGE_JAPANESE) {
            this.setJapanese();
        }
    }

    public void addApplicationMenuItem(PinsetApplication pinsetApplication) {
        JMenuItem jMenuItem = new JMenuItem(pinsetApplication.name);
        jMenuItem.addActionListener(this);
        boolean bl = false;
        Component[] componentArray = this.applicationSelectMenu.getMenuComponents();
        if (componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                try {
                    JMenu jMenu = (JMenu)componentArray[i];
                    String string = jMenu.getText();
                    if (!pinsetApplication.category.equals(string)) continue;
                    jMenu.add(jMenuItem);
                    bl = true;
                    break;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if (!bl || componentArray.length == 0) {
            JMenu jMenu = new JMenu(pinsetApplication.category);
            jMenu.addMouseListener(this);
            jMenu.addMouseMotionListener(this);
            jMenu.add(jMenuItem);
            this.applicationSelectMenu.add(jMenu);
        }
    }

    public void reloadApplicationMenu() {
        this.applicationSelectMenu.removeAll();
        JMenu jMenu = new JMenu("System-Interface");
        jMenu.addMouseListener(this);
        jMenu.addMouseMotionListener(this);
        this.applicationSelectMenu.add(jMenu);
        jMenu = new JMenu("System-Core");
        jMenu.addMouseListener(this);
        this.applicationSelectMenu.add(jMenu);
        this.applicationSelectMenu.addSeparator();
        for (int i = 0; i < this.kernel.getApplication().length; ++i) {
            this.addApplicationMenuItem(this.kernel.getApplication()[i]);
        }
        this.applicationSelectMenu.addSeparator();
        this.applicationSelectMenu.add(this.applicationSelectCancelItem);
    }

    public void setJapanese() {
        this.kernel.setLanguage(PinsetOperatorKernel.LANGUAGE_JAPANESE);
        this.systemMenu.setText("\u30b7\u30b9\u30c6\u30e0");
        this.fileSelectMenu.setText("\u30d5\u30a1\u30a4\u30eb");
        this.applicationSelectMenu.setText("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3");
        this.systemSelectItem[0].setText("\u8a2d\u5b9a");
        this.fileSelectItem[0].setText("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7");
        this.fileSelectItem[1].setText("\u30db\u30fc\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        this.fileSelectItem[2].setText("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        this.applicationSelectCancelItem.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.fileSelectItem[this.fileSelectItem.length - 1].setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.systemSelectItem[this.systemSelectItem.length - 1].setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.backScreenModeItem.setText("\u753b\u9762\u80cc\u666f\u3068\u3057\u3066\u63cf\u753b");
        this.applicationMenu.setJapanese();
    }

    public void setEnglish() {
        this.kernel.setLanguage(PinsetOperatorKernel.LANGUAGE_ENGLISH);
        this.systemMenu.setText("SYSTEM");
        this.fileSelectMenu.setText("FILE");
        this.applicationSelectMenu.setText("APPLICATION");
        this.systemSelectItem[0].setText("Setting");
        this.fileSelectItem[0].setText("Desktop");
        this.fileSelectItem[1].setText("Home");
        this.fileSelectItem[2].setText("Current");
        this.backScreenModeItem.setText("Background-Mode");
        this.applicationSelectCancelItem.setText("Cancel");
        this.fileSelectItem[this.fileSelectItem.length - 1].setText("Cancel");
        this.systemSelectItem[this.systemSelectItem.length - 1].setText("Cancel");
        this.applicationMenu.setEnglish();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (this.systemMenu.isMenuComponent(jMenuItem)) {
            this.systemMenuPerformed(jMenuItem);
        }
        if (this.applicationSelectMenu.isMenuComponent(jMenuItem)) {
            this.applicationSelectMenuPerformed(jMenuItem);
        }
        if (this.fileSelectMenu.isMenuComponent(jMenuItem)) {
            this.fileSelectMenuPerformed(string);
        }
        try {
            this.mouseOnMenu = (JMenu)jMenuItem;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void systemMenuPerformed(Object object) {
        if (object == this.systemSelectItem[0]) {
            int n = -1;
            File file = new File("a.SETTING");
            this.kernel.generate(this.kernel.getPreferredApplicationID(file));
        }
        if (object == this.systemSelectItem[1]) {
            this.setJapanese();
        }
        if (object == this.systemSelectItem[2]) {
            this.setEnglish();
        }
    }

    public void fileSelectMenuPerformed(String string) {
        File file;
        String string2 = this.kernel.getCurrentDirectory().getPath();
        if (string.equals("Home") || string.equals("\u30db\u30fc\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea")) {
            string2 = System.getProperty("user.home");
        }
        if (string.equals("Current") || string.equals("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea")) {
            string2 = System.getProperty("user.dir");
        }
        if (string.equals("Desktop") || string.equals("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7")) {
            file = new File(System.getProperty("user.home"), "Desktop");
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"), "DESKTOP");
            }
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"), "desktop");
            }
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"), "\u30c7\u30b9\u30af\u30c8\u30c3\u30d7");
            }
            if (file.exists()) {
                string2 = file.getPath();
            }
        }
        file = new File("a.DIRECTORY");
        int n = this.kernel.getPreferredApplicationID(file);
        file = new File(string2);
        this.kernel.generate(file, n);
    }

    public void applicationSelectMenuPerformed(Object object) {
        int n = -1;
        String string = ((JMenuItem)object).getText();
        for (int i = 0; i < this.kernel.getApplication().length; ++i) {
            if (!string.equals(this.kernel.getApplication()[i].name)) continue;
            n = i;
        }
        if (0 <= n) {
            this.applicationMenu.setApplication(this.kernel.getApplication()[n]);
            Rectangle rectangle = ((JComponent)object).getBounds();
            Rectangle rectangle2 = this.applicationSelectMenu.getBounds();
            Rectangle rectangle3 = this.mouseOnMenu.getBounds();
            this.applicationMenu.show(this, rectangle3.width + rectangle2.x + rectangle.x, rectangle3.y + rectangle2.y + rectangle.y + 30);
        }
    }

    public void addBrowserListener(PinsetOperatorBrowsable pinsetOperatorBrowsable) {
        this.browsable = pinsetOperatorBrowsable;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.returnLabel) {
            this.returnLabel.setIcon(this.returnIconOn);
        }
        if (object == this.goLabel) {
            this.goLabel.setIcon(this.goIconOn);
        }
        if (object == this.upLabel) {
            this.upLabel.setIcon(this.upIconOn);
        }
        try {
            this.mouseOnMenu = (JMenu)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.returnLabel) {
            this.returnLabel.setIcon(this.returnIconOff);
        }
        if (object == this.goLabel) {
            this.goLabel.setIcon(this.goIconOff);
        }
        if (object == this.upLabel) {
            this.upLabel.setIcon(this.upIconOff);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.browsable != null) {
            Object object = mouseEvent.getSource();
            if (object == this.returnLabel) {
                this.browsable.currentDirectoryChangedPrevious();
            }
            if (object == this.goLabel) {
                this.browsable.currentDirectoryChangedNext();
            }
            if (object == this.upLabel) {
                this.browsable.currentDirectoryChangedUpper();
            }
        }
    }
}

