/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.cache;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import rxvesapi.system.kernel.cache.VirtualizedFileConsoleElement;
import rxvesapi.system.kernel.cache.VirtualizedFileConsoleListener;
import rxvesapi.system.kernel.cache.VirtualizedFileConsolePanel;

public class VirtualizedFileConsole
implements MouseListener,
ComponentListener,
WindowListener {
    private JFrame frame = null;
    public JScrollPane scrollPane;
    private VirtualizedFileConsolePanel mainPanel = null;
    private int fileN = 0;
    private static final int WINDOW_X = 300;
    private static final int WINDOW_Y = 100;
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 200;
    private static final String WINDOW_TITLE = "Virtual File Cache";
    private VirtualizedFileConsoleListener listener;

    public VirtualizedFileConsole() {
        this.componentInit();
    }

    public void addVirtualizedFileConsoleListener(VirtualizedFileConsoleListener virtualizedFileConsoleListener) {
        this.listener = virtualizedFileConsoleListener;
    }

    public void dispose() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }

    public boolean disposed() {
        return this.frame == null;
    }

    public void componentInit() {
        this.frame = new JFrame();
        this.frame.setBounds(300, 100, 300, 200);
        this.frame.setTitle(WINDOW_TITLE);
        this.frame.setVisible(false);
        this.frame.setDefaultCloseOperation(2);
        this.mainPanel = new VirtualizedFileConsolePanel();
        this.mainPanel.setVisible(true);
        this.scrollPane = new JScrollPane(this.mainPanel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.frame.getContentPane().add(this.scrollPane);
        this.resize();
        this.frame.addComponentListener(this);
        this.frame.addWindowListener(this);
        this.frame.setVisible(false);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void addVirtualizedFileIcon(String string, String string2) {
        VirtualizedFileConsoleElement virtualizedFileConsoleElement = new VirtualizedFileConsoleElement(string, string2);
        virtualizedFileConsoleElement.addMouseListener(this);
        virtualizedFileConsoleElement.setVisible(true);
        this.mainPanel.add(virtualizedFileConsoleElement);
        virtualizedFileConsoleElement.repaint();
        this.mainPanel.repaint();
        this.frame.repaint();
        this.resize();
        ++this.fileN;
    }

    public void resize() {
        int n = this.fileN * VirtualizedFileConsoleElement.getDefaultWidth() / this.frame.getWidth();
        int n2 = n * VirtualizedFileConsoleElement.getDefaultHeight();
        this.mainPanel.setPreferredSize(new Dimension(this.scrollPane.getWidth() - 20, n2));
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void windowShown(WindowEvent windowEvent) {
    }

    public void windowHidden(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        try {
            ((VirtualizedFileConsoleElement)object).onMouseOver();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.mainPanel.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        try {
            ((VirtualizedFileConsoleElement)object).onMouseOut();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.mainPanel.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Object object = mouseEvent.getSource();
            String string = null;
            try {
                string = ((VirtualizedFileConsoleElement)object).getVirtualizedFilePath();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.listener.virtualizedFileOpened(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

