/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.cache;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VirtualizedFileConsoleElement
extends JPanel {
    private static final String ICON_FILE_PATH = "rxvesapi/system/kernel/cache/VirtualizedFileIcon.png";
    private String virtualFilePath = null;
    private String virtualFileFormat = "AUTO";
    private static Image iconImage = null;
    private JLabel fileIconLabel;
    private static final int X = 0;
    private static final int Y = 0;
    private static final int WIDTH = 100;
    private static final int HEIGHT = 100;

    public static int getDefaultWidth() {
        return 100;
    }

    public static int getDefaultHeight() {
        return 100;
    }

    public VirtualizedFileConsoleElement(String string, String string2) {
        this.virtualFilePath = string;
        this.virtualFileFormat = string2;
        if (iconImage == null) {
            try {
                this.generateIconImage();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String string3 = this.virtualFilePath.replaceAll("\\./", "").replaceAll("\\.\\\\", "");
        this.fileIconLabel = new JLabel(string3, new ImageIcon(iconImage), 0);
        this.fileIconLabel.setBounds(0, 0, 100, 100);
        this.fileIconLabel.setHorizontalTextPosition(0);
        this.fileIconLabel.setVerticalTextPosition(3);
        this.add(this.fileIconLabel);
        this.fileIconLabel.setVisible(true);
        this.onMouseOut();
    }

    public void onMouseOver() {
        this.setBackground(Color.WHITE);
        this.fileIconLabel.setForeground(Color.BLACK);
        this.fileIconLabel.repaint();
        this.repaint();
    }

    public void onMouseOut() {
        this.setBackground(new Color(0, 0, 0, 0));
        this.repaint();
        this.fileIconLabel.setForeground(Color.WHITE);
        this.fileIconLabel.repaint();
        this.repaint();
    }

    public String getVirtualizedFilePath() {
        return this.virtualFilePath;
    }

    public void generateIconImage() throws IOException {
        if (iconImage != null) {
            return;
        }
        URL uRL = this.getClass().getClassLoader().getResource(ICON_FILE_PATH);
        iconImage = Toolkit.getDefaultToolkit().getImage(uRL);
    }
}

