/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StringUnit;
import rxvesapi.system.kernel.process.SystemNativeProcessEvent;
import rxvesapi.system.kernel.process.SystemNativeProcessListener;
import rxvesapi.system.kernel.process.SystemNativeProcessThread;

public class SystemNativeProcess {
    public SystemNativeProcessListener listener = null;
    public ProcessEngine engine;
    public int id;
    public Runtime runtime = null;
    public Process process = null;
    public InputStream inputStream = null;
    public OutputStream outputStream = null;
    public InputStream errorStream = null;
    public SystemNativeProcessThread stdOutThread = null;
    public SystemNativeProcessThread stdErrorThread = null;
    public boolean ENABLED = false;
    public String[] commandBuff = new String[1];
    public String inputStock = null;
    public boolean COMMAND_ENABLED = true;
    public String standardInputEncoding = null;
    public String standardOutputEncoding = null;
    public String standardErrorEncoding = null;
    String[] commandStock = null;
    File currentDirStock = null;
    private OutputStreamWriter osw = null;
    private BufferedWriter bw = null;
    ProcessUnit[] terminateArgUnit;
    FunctionCallKernel[] terminateKernel;
    FunctionCallUnit[] terminateUnit;
    boolean terminateEventInited = false;
    ProcessUnit[] outputArgUnit;
    FunctionCallKernel[] outputKernel;
    FunctionCallUnit[] outputUnit;
    boolean outputEventInited = false;
    ProcessUnit[] errorArgUnit;
    FunctionCallKernel[] errorKernel;
    FunctionCallUnit[] errorUnit;
    boolean errorEventInited = false;

    public SystemNativeProcess(String[] stringArray) {
        this(stringArray, null);
    }

    public SystemNativeProcess(String[] stringArray, File file) {
        this.commandStock = stringArray;
        this.currentDirStock = file;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirStock = file;
    }

    public void setStandardInputEncoding(String string) {
        this.standardInputEncoding = string;
    }

    public void setStandardOutputEncoding(String string) {
        this.standardOutputEncoding = string;
    }

    public void setStandardErrorEncoding(String string) {
        this.standardErrorEncoding = string;
    }

    public void clearOutput() {
        if (this.stdOutThread != null) {
            this.stdOutThread.clear();
        }
    }

    public void clearError() {
        if (this.stdErrorThread != null) {
            this.stdErrorThread.clear();
        }
    }

    public void flushOutput() {
        if (this.stdOutThread != null) {
            this.stdOutThread.flush();
        }
    }

    public void flushError() {
        if (this.stdErrorThread != null) {
            this.stdErrorThread.flush();
        }
    }

    public void start() throws UnsupportedEncodingException, IOException {
        if (this.process != null) {
            this.destroy();
            return;
        }
        String[] stringArray = this.commandStock;
        File file = this.currentDirStock;
        this.runtime = Runtime.getRuntime();
        IOException iOException = null;
        try {
            this.process = this.runtime.exec(stringArray, null, file);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (this.process == null) {
            String string = "";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string = string + stringArray[i] + " ";
            }
            if (1 <= stringArray.length) {
                string = string + stringArray[stringArray.length - 1];
            }
            try {
                this.process = this.runtime.exec(string, null, file);
            }
            catch (IOException iOException3) {
                iOException = iOException3;
            }
        }
        if (this.process == null && stringArray.length == 1) {
            stringArray[0] = stringArray[0].replaceAll("\t", " ");
            stringArray = stringArray[0].split(" ");
            try {
                this.process = this.runtime.exec(stringArray, null, file);
            }
            catch (IOException iOException4) {
                iOException = iOException4;
            }
        }
        if (this.process == null) {
            this.COMMAND_ENABLED = false;
            throw iOException;
        }
        this.COMMAND_ENABLED = true;
        try {
            this.inputStream = this.process.getInputStream();
            this.errorStream = this.process.getErrorStream();
            this.outputStream = this.process.getOutputStream();
            this.generate();
            if (this.inputStock != null) {
                this.standardInput(this.inputStock);
                this.inputStock = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void addSystemNativeProcessListener(SystemNativeProcessListener systemNativeProcessListener) {
        this.listener = systemNativeProcessListener;
    }

    public void destroy() {
        this.process.destroy();
    }

    public void dispose() {
        int n;
        this.engine = null;
        this.listener = null;
        if (this.terminateArgUnit != null) {
            for (n = 0; n < this.terminateArgUnit.length; ++n) {
                try {
                    this.terminateArgUnit[n].disposeResource();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.terminateArgUnit[n] = null;
            }
        }
        if (this.terminateKernel != null) {
            for (n = 0; n < this.terminateKernel.length; ++n) {
                this.terminateKernel[n] = null;
            }
        }
        if (this.terminateUnit != null) {
            for (n = 0; n < this.terminateUnit.length; ++n) {
                this.terminateUnit[n] = null;
            }
        }
        if (this.outputArgUnit != null) {
            for (n = 0; n < this.outputArgUnit.length; ++n) {
                try {
                    this.outputArgUnit[n].disposeResource();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outputArgUnit[n] = null;
            }
        }
        if (this.outputKernel != null) {
            for (n = 0; n < this.outputKernel.length; ++n) {
                this.outputKernel[n] = null;
            }
        }
        if (this.outputUnit != null) {
            for (n = 0; n < this.outputUnit.length; ++n) {
                this.outputUnit[n] = null;
            }
        }
        if (this.errorArgUnit != null) {
            for (n = 0; n < this.errorArgUnit.length; ++n) {
                try {
                    this.errorArgUnit[n].disposeResource();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.errorArgUnit[n] = null;
            }
        }
        if (this.errorKernel != null) {
            for (n = 0; n < this.errorKernel.length; ++n) {
                this.errorKernel[n] = null;
            }
        }
        if (this.errorUnit != null) {
            for (n = 0; n < this.errorUnit.length; ++n) {
                this.errorUnit[n] = null;
            }
        }
        if (this.stdOutThread != null) {
            this.stdOutThread.dispose();
        }
        if (this.stdOutThread != null) {
            this.stdErrorThread.dispose();
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.stdOutThread = null;
        this.stdErrorThread = null;
        try {
            if (this.bw == null) {
                this.bw.close();
            }
            if (this.osw == null) {
                this.osw.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bw = null;
        this.osw = null;
        this.commandBuff = null;
    }

    public void threadTerminated() {
        if (this.listener != null) {
            SystemNativeProcessEvent systemNativeProcessEvent = new SystemNativeProcessEvent(this);
            this.listener.systemNativeProcessTerminated(systemNativeProcessEvent);
        }
        if (this.engine != null) {
            this.terminateEventCall(this.id);
        }
    }

    public void standardError(String string) {
        if (this.listener != null) {
            SystemNativeProcessEvent systemNativeProcessEvent = new SystemNativeProcessEvent(this);
            this.listener.systemNativeProcessStandardError(systemNativeProcessEvent);
        }
        if (this.engine != null) {
            this.errorEventCall(this.id, string);
        }
    }

    public void standardOutput(String string) {
        if (this.listener != null) {
            SystemNativeProcessEvent systemNativeProcessEvent = new SystemNativeProcessEvent(this);
            this.listener.systemNativeProcessStandardOutput(systemNativeProcessEvent);
        }
        if (this.engine != null) {
            this.outputEventCall(this.id, string);
        }
    }

    public void standardInput(String string) {
        if (this.ENABLED) {
            try {
                if (this.osw == null) {
                    this.osw = this.standardInputEncoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, this.standardInputEncoding);
                }
                if (this.bw == null) {
                    this.bw = new BufferedWriter(this.osw);
                }
                this.bw.write(string);
                this.bw.flush();
                this.osw.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            if (this.inputStock == null) {
                this.inputStock = "";
            }
            this.inputStock = this.inputStock + string;
        }
    }

    public void standardInput(String string, String string2) {
        if (this.ENABLED) {
            try {
                if (this.osw == null) {
                    this.osw = this.standardInputEncoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, this.standardInputEncoding);
                }
                if (this.bw == null) {
                    this.bw = new BufferedWriter(this.osw);
                }
                this.bw.write(string);
                this.bw.flush();
                this.osw.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            if (this.inputStock == null) {
                this.inputStock = "";
            }
            this.inputStock = this.inputStock + string;
        }
    }

    public void waitFor() {
        if (!this.ENABLED) {
            return;
        }
        try {
            this.process.waitFor();
            this.stdOutThread.join();
            this.stdErrorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getOutput() {
        if (!this.ENABLED) {
            return "";
        }
        return this.stdOutThread.toString();
    }

    public String getError() {
        if (!this.ENABLED) {
            return "";
        }
        return this.stdErrorThread.toString();
    }

    public int getExitValue() {
        return this.process.exitValue();
    }

    public void generate() throws UnsupportedEncodingException {
        this.stdOutThread = this.standardOutputEncoding == null ? new SystemNativeProcessThread(this, this.inputStream, SystemNativeProcessThread.STANDARD_OUTPUT) : new SystemNativeProcessThread(this, this.inputStream, SystemNativeProcessThread.STANDARD_OUTPUT, this.standardOutputEncoding);
        this.stdErrorThread = this.standardErrorEncoding == null ? new SystemNativeProcessThread(this, this.errorStream, SystemNativeProcessThread.STANDARD_ERROR) : new SystemNativeProcessThread(this, this.errorStream, SystemNativeProcessThread.STANDARD_ERROR, this.standardErrorEncoding);
        this.ENABLED = true;
    }

    void terminateEvent() {
        if (!this.terminateEventInited) {
            this.terminateArgUnit = new ProcessUnit[1];
            this.terminateArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.terminateKernel = this.engine.getAllFunctionCallKernel("onProcessEnd");
            if (this.terminateKernel != null) {
                this.terminateUnit = new FunctionCallUnit[this.terminateKernel.length];
                for (int i = 0; i < this.terminateKernel.length; ++i) {
                    this.terminateUnit[i] = new FunctionCallUnit(this.terminateArgUnit, this.terminateKernel[i], this.engine);
                    this.terminateUnit[i].setProcessKernel(this.terminateKernel[i]);
                }
            }
            this.terminateEventInited = true;
        }
    }

    public void terminateEventCall(int n) {
        this.terminateEvent();
        if (this.terminateKernel != null) {
            this.terminateArgUnit[0].setIntegerValue(n);
            for (int i = 0; i < this.terminateKernel.length; ++i) {
                this.terminateUnit[i].process();
            }
        }
    }

    void outputEvent() {
        if (!this.outputEventInited) {
            this.outputArgUnit = new ProcessUnit[2];
            this.outputArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.outputArgUnit[1] = new StringUnit("", this.engine);
            this.outputKernel = this.engine.getAllFunctionCallKernel("onProcessOutput");
            if (this.outputKernel != null) {
                this.outputUnit = new FunctionCallUnit[this.outputKernel.length];
                for (int i = 0; i < this.outputKernel.length; ++i) {
                    this.outputUnit[i] = new FunctionCallUnit(this.outputArgUnit, this.outputKernel[i], this.engine);
                    this.outputUnit[i].setProcessKernel(this.outputKernel[i]);
                }
            }
            this.outputEventInited = true;
        }
    }

    public void outputEventCall(int n, String string) {
        this.outputEvent();
        if (this.outputKernel != null) {
            this.outputArgUnit[0].setIntegerValue(n);
            this.outputArgUnit[1].setStringValue(string);
            for (int i = 0; i < this.outputKernel.length; ++i) {
                this.outputUnit[i].process();
            }
        }
    }

    void errorEvent() {
        if (!this.errorEventInited) {
            this.errorArgUnit = new ProcessUnit[2];
            this.errorArgUnit[0] = new IntegerUnit(this.id, this.engine);
            this.errorArgUnit[1] = new StringUnit("", this.engine);
            this.errorKernel = this.engine.getAllFunctionCallKernel("onProcessError");
            if (this.errorKernel != null) {
                this.errorUnit = new FunctionCallUnit[this.errorKernel.length];
                for (int i = 0; i < this.errorKernel.length; ++i) {
                    this.errorUnit[i] = new FunctionCallUnit(this.errorArgUnit, this.errorKernel[i], this.engine);
                    this.errorUnit[i].setProcessKernel(this.errorKernel[i]);
                }
            }
            this.errorEventInited = true;
        }
    }

    public void errorEventCall(int n, String string) {
        this.errorEvent();
        if (this.errorKernel != null) {
            this.errorArgUnit[0].setIntegerValue(n);
            this.errorArgUnit[1].setStringValue(string);
            for (int i = 0; i < this.errorKernel.length; ++i) {
                this.errorUnit[i].process();
            }
        }
    }
}

