/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import rxvesapi.system.kernel.process.SystemNativeProcess;

public class SystemNativeProcessThread
extends Thread {
    public InputStream stream;
    public StringBuffer buff;
    public static int STANDARD_OUTPUT = 1;
    public static int STANDARD_ERROR = 2;
    private static int STANDARD_OUTPUT_DEFAULT_BUFFER_LENGTH = 32;
    int channel = 0;
    public BufferedReader buffReader;
    public SystemNativeProcess nativeProcess;
    String lfc = System.getProperty("line.separator");
    private String lineBuffer = "";

    public SystemNativeProcessThread(SystemNativeProcess systemNativeProcess, InputStream inputStream, int n) {
        this.channel = n;
        this.nativeProcess = systemNativeProcess;
        this.stream = inputStream;
        this.buffReader = new BufferedReader(new InputStreamReader(this.stream));
        this.buff = new StringBuffer(STANDARD_OUTPUT_DEFAULT_BUFFER_LENGTH);
        this.start();
    }

    public SystemNativeProcessThread(SystemNativeProcess systemNativeProcess, InputStream inputStream, int n, String string) throws UnsupportedEncodingException {
        this.channel = n;
        this.nativeProcess = systemNativeProcess;
        this.stream = inputStream;
        this.buffReader = new BufferedReader(new InputStreamReader(this.stream, string));
        this.buff = new StringBuffer(STANDARD_OUTPUT_DEFAULT_BUFFER_LENGTH);
        this.start();
    }

    public void dispose() {
        this.flush();
        this.nativeProcess = null;
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.stream = null;
        this.buff = null;
    }

    public synchronized void clear() {
        this.flush();
        this.buff = null;
        this.buff = new StringBuffer();
    }

    @Override
    public synchronized String toString() {
        this.flush();
        if (this.buff == null) {
            return "";
        }
        try {
            String string = this.buff.toString();
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private synchronized void output(String string) {
        if (this.nativeProcess != null) {
            if (this.channel == 1) {
                this.nativeProcess.standardOutput(string);
            }
            if (this.channel == 2) {
                this.nativeProcess.standardError(string);
            }
        }
    }

    private synchronized void putBuffer(char c, boolean bl, boolean bl2) {
        if (!bl) {
            this.buff.append(c);
            this.lineBuffer = this.lineBuffer + c;
        }
        if (bl2) {
            this.output(this.lineBuffer);
            this.lineBuffer = "";
            return;
        }
        if (!(bl || c != '\r' && c != '\n')) {
            this.output(this.lineBuffer);
            this.lineBuffer = "";
            return;
        }
    }

    public synchronized void flush() {
        try {
            this.putBuffer('?', true, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void run() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            int n;
            boolean bl2 = false;
            String string = "";
            while ((n = this.buffReader.read()) != -1) {
                this.putBuffer((char)n, false, false);
            }
            if (this.channel == 1) {
                this.flush();
                this.nativeProcess.threadTerminated();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                this.stream.close();
                this.buffReader = null;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }
}

