/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import rxvesapi.system.kernel.process.SystemScriptProcess;

public class SystemScriptProcessThread
implements Runnable {
    Thread thread = null;
    SystemScriptProcess process;
    int clock = 0;
    static final int CLOCK_MAX = 1000;
    static final int CLOCK_MIN = 50;
    boolean loopState = true;

    public SystemScriptProcessThread() {
    }

    public SystemScriptProcessThread(SystemScriptProcess systemScriptProcess) {
        this.process = systemScriptProcess;
        this.thread = new Thread(this);
        this.start();
    }

    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            while (this.loopState) {
                try {
                    Thread.sleep(this.clock);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.process == null) continue;
                long l = System.currentTimeMillis();
                this.process.flushPrintData();
                long l2 = System.currentTimeMillis();
                this.clock = (int)(l2 - l);
                if (this.clock < 50) {
                    this.clock = 50;
                    continue;
                }
                if (1000 >= this.clock) continue;
                this.clock = 1000;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        this.loopState = false;
        this.process = null;
    }
}

