/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.geometry;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.geometry.Structure3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;

public class CoordinateSystem3DEG {
    Vector3DEG buffVector = new Vector3DEG(0.0, 0.0, 0.0);
    public double[] Origin = new double[]{0.0, 0.0, 0.0};
    public double[] Angle = new double[]{0.0, 0.0, 0.0};
    public double[][] Evector = new double[3][3];
    public double[] wVector = new double[]{0.0, 0.0, 0.0, 1.0};
    public CoordinateSystem3DEG belongingSystem;
    public CoordinateSystem3DEG belongingScreenSystem = null;
    public int rendererID = -1;
    CoordinateSystem3DEG belong;
    double[] vertexProcessCacheDouble = new double[]{0.0, 0.0, 0.0, 0.0};

    public CoordinateSystem3DEG() {
        this.Evector[0] = new double[]{1.0, 0.0, 0.0};
        this.Evector[1] = new double[]{0.0, 1.0, 0.0};
        this.Evector[2] = new double[]{0.0, 0.0, 1.0};
    }

    public CoordinateSystem3DEG(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.Evector[0] = new double[]{1.0, 0.0, 0.0};
        this.Evector[1] = new double[]{0.0, 1.0, 0.0};
        this.Evector[2] = new double[]{0.0, 0.0, 1.0};
        this.setAutomaticRequest(coordinateSystem3DEG);
    }

    public void disposeResource() {
        this.Origin = null;
        this.Angle = null;
        this.Evector = null;
        this.belongingSystem = null;
        this.belongingScreenSystem = null;
    }

    public double[] getWTransform() {
        return this.wVector;
    }

    public void setWTransform(double[] dArray) {
        this.wVector = dArray;
    }

    public Element3DEG see(Element3DEG element3DEG) {
        Element3DEG element3DEG2 = new Element3DEG();
        int n = element3DEG.vertex.length;
        element3DEG2.vertex = new Vector3DEG[n];
        element3DEG2.color = element3DEG.color;
        for (int i = 0; i < n; ++i) {
            element3DEG2.vertex[i] = this.see(element3DEG.vertex[i]);
        }
        return element3DEG2;
    }

    public void see(Model3DEG model3DEG, Model3DEG model3DEG2) {
        int n;
        int n2 = model3DEG.element.length;
        if (n2 != model3DEG2.element.length) {
            for (n = 0; n < n2; ++n) {
                if (model3DEG2.element[n] == null) continue;
                model3DEG2.element[n].disposeResource();
                model3DEG2.element[n] = null;
            }
            model3DEG2.element = new Element3DEG[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.see(model3DEG.element[n], model3DEG2.element[n]);
        }
    }

    public void see(Element3DEG element3DEG, Element3DEG element3DEG2) {
        this.see(element3DEG, element3DEG2, false, false);
    }

    public void transformAll(Element3DEG element3DEG, Element3DEG element3DEG2) {
        this.see(element3DEG, element3DEG2, true, false);
    }

    public void transform(Element3DEG element3DEG, Element3DEG element3DEG2) {
        int n = element3DEG.vertex.length;
        if (element3DEG2.vertex.length != n) {
            element3DEG2.vertex = new Vector3DEG[n];
        }
        for (int i = 0; i < n; ++i) {
            this.setTransformedVertex(element3DEG.vertex[i], element3DEG2.vertex[i], this);
        }
        this.syncElement(element3DEG, element3DEG2);
    }

    public void unTransform(Element3DEG element3DEG, Element3DEG element3DEG2) {
        int n = element3DEG.vertex.length;
        if (element3DEG2.vertex.length != n) {
            element3DEG2.vertex = new Vector3DEG[n];
        }
        for (int i = 0; i < n; ++i) {
            this.setUnTransformedVertex(element3DEG.vertex[i], element3DEG2.vertex[i], this);
        }
        this.syncElement(element3DEG, element3DEG2);
    }

    public void see(Element3DEG element3DEG, Element3DEG element3DEG2, boolean bl, boolean bl2) {
        int n = element3DEG.vertex.length;
        if (element3DEG2.vertex.length != n) {
            element3DEG2.vertex = new Vector3DEG[n];
        }
        for (int i = 0; i < n; ++i) {
            this.setTransformedVertex(element3DEG.vertex[i], element3DEG2.vertex[i], bl, bl2);
        }
        element3DEG2.setOffsetView(element3DEG.getOffsetView());
        element3DEG2.setDepthOffsetView(element3DEG.getDepthOffsetView());
        if (element3DEG.getOffset() == null) {
            element3DEG2.setOffset((Vector3DEG)null);
        } else {
            if (element3DEG2.getOffset() == null) {
                element3DEG2.setOffset(new Vector3DEG(0.0, 0.0, 0.0));
            }
            element3DEG.getOffset().belongingSystem = element3DEG.belongingSystem;
            this.setTransformedVertex(element3DEG.getOffset(), element3DEG2.getOffset(), bl, bl2, false);
        }
        if (element3DEG.getDepthOffset() == null) {
            element3DEG2.setDepthOffset(null);
        } else {
            if (element3DEG2.getDepthOffset() == null) {
                element3DEG2.setDepthOffset(new Vector3DEG(0.0, 0.0, 0.0));
            }
            element3DEG.getDepthOffset().belongingSystem = element3DEG.belongingSystem;
            this.setTransformedVertex(element3DEG.getDepthOffset(), element3DEG2.getDepthOffset(), bl, bl2, false);
        }
        this.syncElement(element3DEG, element3DEG2);
    }

    public void syncElement(Element3DEG element3DEG, Element3DEG element3DEG2) {
        element3DEG2.color = new Color(element3DEG.color.getRed(), element3DEG.color.getGreen(), element3DEG.color.getBlue(), element3DEG.color.getAlpha());
        element3DEG2.resourceID = element3DEG.resourceID;
        element3DEG2.type = element3DEG.type;
        element3DEG2.directional = element3DEG.directional;
        element3DEG2.diffractional = element3DEG.diffractional;
        element3DEG2.diffuse = element3DEG.diffuse;
        element3DEG2.ambient = element3DEG.ambient;
        element3DEG2.emissive = element3DEG.emissive;
        element3DEG2.shininess = element3DEG.shininess;
        element3DEG2.optimumAngle = element3DEG.optimumAngle;
        element3DEG2.offset_x = element3DEG.offset_x;
        element3DEG2.offset_y = element3DEG.offset_y;
        element3DEG2.offset_d = element3DEG.offset_d;
        element3DEG2.perspective = element3DEG.perspective;
        element3DEG2.fill = element3DEG.fill;
        element3DEG2.font = element3DEG.font;
        element3DEG2.string = element3DEG.string;
        element3DEG2.info[0] = element3DEG.info[0];
        element3DEG2.info[1] = element3DEG.info[1];
        element3DEG2.info[2] = element3DEG.info[2];
        element3DEG2.info[3] = element3DEG.info[3];
        element3DEG2.info[4] = element3DEG.info[4];
        element3DEG2.image = element3DEG.image;
    }

    public Vector3DEG see(Vector3DEG vector3DEG) {
        double[] dArray = this.getProjectedVertex(vector3DEG);
        Vector3DEG vector3DEG2 = new Vector3DEG(dArray[0], dArray[1], dArray[2]);
        return vector3DEG2;
    }

    public void see(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.setTransformedVertex(vector3DEG, vector3DEG2, false, false);
    }

    public void transformAll(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.setTransformedVertex(vector3DEG, vector3DEG2, true, false);
    }

    public void transform(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.setTransformedVertex(vector3DEG, vector3DEG2, this);
    }

    public void unTransform(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.setUnTransformedVertex(vector3DEG, vector3DEG2, this);
    }

    public double[] getProjectedVertex(Vector3DEG vector3DEG) {
        double[] dArray = new double[]{vector3DEG.x, vector3DEG.y, vector3DEG.z};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        this.belong = vector3DEG.belongingSystem;
        while (this.belong != null && this.belong != this) {
            dArray2[0] = dArray[0] * this.belong.Evector[0][0] + dArray[1] * this.belong.Evector[1][0] + dArray[2] * this.belong.Evector[2][0];
            dArray2[1] = dArray[0] * this.belong.Evector[0][1] + dArray[1] * this.belong.Evector[1][1] + dArray[2] * this.belong.Evector[2][1];
            dArray2[2] = dArray[0] * this.belong.Evector[0][2] + dArray[1] * this.belong.Evector[1][2] + dArray[2] * this.belong.Evector[2][2];
            for (int i = 0; i < 3; ++i) {
                dArray[i] = dArray2[i];
                int n = i;
                dArray[n] = dArray[n] + this.belong.Origin[i];
            }
            this.belong = this.belong.belongingSystem;
        }
        return dArray;
    }

    public void setTransformedVertex(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.setTransformedVertex(vector3DEG, vector3DEG2, false, false);
    }

    public void setTransformedVertex(Vector3DEG vector3DEG, Vector3DEG vector3DEG2, boolean bl, boolean bl2) {
        this.setTransformedVertex(vector3DEG, vector3DEG2, false, false, true);
    }

    public void setTransformedVertex(Vector3DEG vector3DEG, Vector3DEG vector3DEG2, boolean bl, boolean bl2, boolean bl3) {
        vector3DEG2.x = vector3DEG.x;
        vector3DEG2.y = vector3DEG.y;
        vector3DEG2.z = vector3DEG.z;
        this.belong = bl2 ? this : vector3DEG.belongingSystem;
        while (this.belong != null && (this.belong != this || bl)) {
            vector3DEG2.w = vector3DEG2.x * this.belong.wVector[0] + vector3DEG2.y * this.belong.wVector[1] + vector3DEG2.z * this.belong.wVector[2] + vector3DEG2.w * this.belong.wVector[3];
            this.vertexProcessCacheDouble[0] = vector3DEG2.x * this.belong.Evector[0][0] + vector3DEG2.y * this.belong.Evector[1][0] + vector3DEG2.z * this.belong.Evector[2][0];
            this.vertexProcessCacheDouble[1] = vector3DEG2.x * this.belong.Evector[0][1] + vector3DEG2.y * this.belong.Evector[1][1] + vector3DEG2.z * this.belong.Evector[2][1];
            this.vertexProcessCacheDouble[2] = vector3DEG2.x * this.belong.Evector[0][2] + vector3DEG2.y * this.belong.Evector[1][2] + vector3DEG2.z * this.belong.Evector[2][2];
            vector3DEG2.x = this.vertexProcessCacheDouble[0];
            vector3DEG2.y = this.vertexProcessCacheDouble[1];
            vector3DEG2.z = this.vertexProcessCacheDouble[2];
            if (bl3) {
                vector3DEG2.x += this.belong.Origin[0];
                vector3DEG2.y += this.belong.Origin[1];
                vector3DEG2.z += this.belong.Origin[2];
            }
            if (this.belong == this) break;
            this.belong = this.belong.belongingSystem;
        }
    }

    public void setTransformedVertex(Vector3DEG vector3DEG, Vector3DEG vector3DEG2, CoordinateSystem3DEG coordinateSystem3DEG) {
        vector3DEG2.x = vector3DEG.x;
        vector3DEG2.y = vector3DEG.y;
        vector3DEG2.z = vector3DEG.z;
        this.belong = coordinateSystem3DEG;
        vector3DEG2.w = vector3DEG2.x * this.belong.wVector[0] + vector3DEG2.y * this.belong.wVector[1] + vector3DEG2.z * this.belong.wVector[2] + vector3DEG2.w * this.belong.wVector[3];
        this.vertexProcessCacheDouble[0] = vector3DEG2.x * this.belong.Evector[0][0] + vector3DEG2.y * this.belong.Evector[1][0] + vector3DEG2.z * this.belong.Evector[2][0];
        this.vertexProcessCacheDouble[1] = vector3DEG2.x * this.belong.Evector[0][1] + vector3DEG2.y * this.belong.Evector[1][1] + vector3DEG2.z * this.belong.Evector[2][1];
        this.vertexProcessCacheDouble[2] = vector3DEG2.x * this.belong.Evector[0][2] + vector3DEG2.y * this.belong.Evector[1][2] + vector3DEG2.z * this.belong.Evector[2][2];
        vector3DEG2.x = this.vertexProcessCacheDouble[0];
        vector3DEG2.x += this.belong.Origin[0];
        vector3DEG2.y = this.vertexProcessCacheDouble[1];
        vector3DEG2.y += this.belong.Origin[1];
        vector3DEG2.z = this.vertexProcessCacheDouble[2];
        vector3DEG2.z += this.belong.Origin[2];
    }

    public void setUnTransformedVertex(Vector3DEG vector3DEG, Vector3DEG vector3DEG2, CoordinateSystem3DEG coordinateSystem3DEG) {
        vector3DEG2.x = vector3DEG.x;
        vector3DEG2.y = vector3DEG.y;
        vector3DEG2.z = vector3DEG.z;
        this.belong = coordinateSystem3DEG;
        vector3DEG2.x -= this.belong.Origin[0];
        vector3DEG2.y -= this.belong.Origin[1];
        vector3DEG2.z -= this.belong.Origin[2];
        this.vertexProcessCacheDouble[0] = vector3DEG2.x * this.belong.Evector[0][0] + vector3DEG2.y * this.belong.Evector[0][1] + vector3DEG2.z * this.belong.Evector[0][2];
        this.vertexProcessCacheDouble[1] = vector3DEG2.x * this.belong.Evector[1][0] + vector3DEG2.y * this.belong.Evector[1][1] + vector3DEG2.z * this.belong.Evector[1][2];
        this.vertexProcessCacheDouble[2] = vector3DEG2.x * this.belong.Evector[2][0] + vector3DEG2.y * this.belong.Evector[2][1] + vector3DEG2.z * this.belong.Evector[2][2];
        vector3DEG2.x = this.vertexProcessCacheDouble[0];
        vector3DEG2.y = this.vertexProcessCacheDouble[1];
        vector3DEG2.z = this.vertexProcessCacheDouble[2];
    }

    public void request(Element3DEG element3DEG) {
    }

    public void setAutomaticRequest(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.belongingScreenSystem = coordinateSystem3DEG;
    }

    public void add(CoordinateSystem3DEG coordinateSystem3DEG) {
        coordinateSystem3DEG.setBelongingSystem(this);
    }

    public void remove(CoordinateSystem3DEG coordinateSystem3DEG) {
        coordinateSystem3DEG.setBelongingSystem(null);
    }

    public void add(Vector3DEG vector3DEG) {
        vector3DEG.belongingSystem = this;
    }

    public void remove(Vector3DEG vector3DEG) {
        vector3DEG.belongingSystem = null;
    }

    public void add(Element3DEG element3DEG) {
        element3DEG.setBelongingSystem(this);
        if (this.belongingScreenSystem != null) {
            this.belongingScreenSystem.request(element3DEG);
        }
    }

    public void remove(Element3DEG element3DEG) {
        element3DEG.setBelongingSystem(null);
    }

    public void add(Element3DEG[] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(element3DEGArray[i]);
        }
    }

    public void remove(Element3DEG[] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.remove(element3DEGArray[i]);
        }
    }

    public void add(Element3DEG[][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(element3DEGArray[i]);
        }
    }

    public void add(Element3DEG[][][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(element3DEGArray[i]);
        }
    }

    public void add(Model3DEG model3DEG) {
        this.add(model3DEG.element);
    }

    public void remove(Model3DEG model3DEG) {
        this.remove(model3DEG.element);
    }

    public void add(Model3DEG[] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(model3DEGArray[i]);
        }
    }

    public void add(Model3DEG[][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(model3DEGArray[i]);
        }
    }

    public void add(Model3DEG[][][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(model3DEGArray[i]);
        }
    }

    public void add(Structure3DEG structure3DEG) {
        this.add(structure3DEG.model);
    }

    public void add(Structure3DEG[] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(structure3DEGArray[i]);
        }
    }

    public void add(Structure3DEG[][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(structure3DEGArray[i]);
        }
    }

    public void add(Structure3DEG[][][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(structure3DEGArray[i]);
        }
    }

    public void setBelongingSystem(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.belongingSystem = coordinateSystem3DEG;
    }

    public void move(double d, double d2, double d3) {
        this.Origin[0] = this.Origin[0] + d;
        this.Origin[1] = this.Origin[1] + d2;
        this.Origin[2] = this.Origin[2] + d3;
    }

    public void walk(double d, double d2, double d3) {
        this.Origin[0] = this.Origin[0] + (d * this.Evector[0][0] + d2 * this.Evector[1][0] + d3 * this.Evector[2][0]);
        this.Origin[1] = this.Origin[1] + (d * this.Evector[0][1] + d2 * this.Evector[1][1] + d3 * this.Evector[2][1]);
        this.Origin[2] = this.Origin[2] + (d * this.Evector[0][2] + d2 * this.Evector[1][2] + d3 * this.Evector[2][2]);
    }

    public void move(Vector3DEG vector3DEG) {
        this.Origin[0] = this.Origin[0] + vector3DEG.x;
        this.Origin[1] = this.Origin[1] + vector3DEG.y;
        this.Origin[2] = this.Origin[2] + vector3DEG.z;
    }

    public void setOrigin(double d, double d2, double d3) {
        this.Origin[0] = d;
        this.Origin[1] = d2;
        this.Origin[2] = d3;
    }

    public void setOrigin(Vector3DEG vector3DEG) {
        this.Origin[0] = vector3DEG.x;
        this.Origin[1] = vector3DEG.y;
        this.Origin[2] = vector3DEG.z;
    }

    public void resetBase() {
        this.Evector[0][0] = 1.0;
        this.Evector[0][1] = 0.0;
        this.Evector[0][2] = 0.0;
        this.Evector[1][0] = 0.0;
        this.Evector[1][1] = 1.0;
        this.Evector[1][2] = 0.0;
        this.Evector[2][0] = 0.0;
        this.Evector[2][1] = 0.0;
        this.Evector[2][2] = 1.0;
    }

    public void resetAngle() {
        double d = Math.sqrt(this.Evector[0][0] * this.Evector[0][0] + this.Evector[0][1] * this.Evector[0][1] + this.Evector[0][2] * this.Evector[0][2]);
        double d2 = Math.sqrt(this.Evector[1][0] * this.Evector[1][0] + this.Evector[1][1] * this.Evector[1][1] + this.Evector[1][2] * this.Evector[1][2]);
        double d3 = Math.sqrt(this.Evector[2][0] * this.Evector[2][0] + this.Evector[2][1] * this.Evector[2][1] + this.Evector[2][2] * this.Evector[2][2]);
        this.Evector[0][0] = d;
        this.Evector[0][1] = 0.0;
        this.Evector[0][2] = 0.0;
        this.Evector[1][0] = 0.0;
        this.Evector[1][1] = d2;
        this.Evector[1][2] = 0.0;
        this.Evector[2][0] = 0.0;
        this.Evector[2][1] = 0.0;
        this.Evector[2][2] = d3;
    }

    public void setEulerAngle(double d, double d2, double d3) {
        this.resetAngle();
        this.spinZ(d);
        this.spinX(d2);
        this.spinZ(d3);
    }

    public double getEulerAngleAlpha() {
        return this.getEulerAnglePhi(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getEulerAngleBeta() {
        return this.getEulerAngleTheta(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getEulerAngleGamma() {
        return this.getEulerAngleTau(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getEulerAngleTheta(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d2 = Math.acos(dArray[2] / d);
        return d2;
    }

    public double getEulerAngleTheta(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = this.getEulerAngleTheta(dArray3);
        return d;
    }

    public double getEulerAnglePhi(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = Math.acos(dArray[0]);
            if (dArray[1] < 0.0) {
                d2 = Math.PI * 2 - d2;
            }
        } else if (0.0 == dArray3[0]) {
            if (0.0 < dArray3[1]) {
                d2 = Math.PI;
            } else if (0.0 > dArray3[1]) {
                d2 = 0.0;
            }
        } else if (0.0 < dArray3[0]) {
            d2 = Math.acos(-dArray3[1] / d);
        } else if (0.0 > dArray3[0]) {
            d2 = Math.acos(-dArray3[1] / d);
            d2 = Math.PI * 2 - d2;
        }
        return d2;
    }

    public double getEulerAngleTau(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        if (d2 != 0.0) {
            double d3 = this.getEulerAnglePhi(dArray, dArray2, dArray3);
            double d4 = this.getEulerAngleTheta(dArray, dArray2, dArray3);
            double[] dArray4 = new double[]{Math.cos(d3), Math.sin(d3), 0.0};
            double[] dArray5 = d4 < 1.5707963267948966 ? new double[]{-Math.sin(d3), Math.cos(d3), Math.sin(d4)} : new double[]{Math.sin(d3), -Math.cos(d3), Math.sin(d4)};
            double d5 = this.getCosin(dArray4, dArray);
            d = 1.0 < d5 ? 0.0 : (d5 <= -1.0 ? Math.PI : Math.acos(d5));
            double d6 = dArray[0] * dArray5[0] + dArray[1] * dArray5[1] + dArray[2] * dArray5[2];
            if (d6 < 0.0) {
                d = Math.PI * 2 - d;
            }
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public double getTheta(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d2 = Math.acos(dArray[2] / d);
        return d2;
    }

    public double getTheta(double[] dArray, double[] dArray2, double[] dArray3) {
        return this.getTheta(dArray3);
    }

    public double getPhi(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        double d2 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        if (d2 != 0.0) {
            d = Math.acos(dArray3[0] / d2);
            if (dArray3[1] < 0.0) {
                d *= -1.0;
            }
        } else {
            d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            d = Math.acos(dArray[0] / d2);
            if (dArray[1] < 0.0) {
                d = Math.PI * 2 - d;
            }
        }
        return d;
    }

    public double getTau(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        double d2 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        if (d2 == 0.0) {
            d = 0.0;
        } else {
            double d3 = this.getPhi(dArray, dArray2, dArray3);
            double[] dArray4 = new double[]{-Math.sin(d3), Math.cos(d3), 0.0};
            double d4 = this.getCosin(dArray4, dArray2);
            d = Math.acos(d4);
            double[] dArray5 = new double[]{dArray4[1] * dArray2[2] - dArray4[2] * dArray2[1], dArray4[2] * dArray2[0] - dArray4[0] * dArray2[2], dArray4[0] * dArray2[1] - dArray4[1] * dArray2[0]};
            double d5 = this.getCosin(dArray3, dArray5);
            if (d5 < 0.0) {
                d = Math.PI * 2 - d;
            }
        }
        return d;
    }

    public double[] getAngle(double[][] dArray) {
        double[] dArray2 = new double[]{this.getTheta(dArray[0], dArray[1], dArray[2]), this.getPhi(dArray[0], dArray[1], dArray[2]), this.getTau(dArray[0], dArray[1], dArray[2])};
        return dArray2;
    }

    public double getOriginX() {
        return this.Origin[0];
    }

    public double getOriginY() {
        return this.Origin[1];
    }

    public double getOriginZ() {
        return this.Origin[2];
    }

    public void reOrtho() {
        if (this.Angle[0] != 0.0 || this.Angle[1] != 0.0 || this.Angle[2] != 0.0) {
            double d = this.getTheta(this.Evector[0], this.Evector[1], this.Evector[2]);
            double d2 = this.getPhi(this.Evector[0], this.Evector[1], this.Evector[2]);
            double d3 = this.getTau(this.Evector[0], this.Evector[1], this.Evector[2]);
            this.setAngle(d, d2, d3);
            this.Angle = new double[]{d, d2, d3};
        }
    }

    public double getAlphaAngle() {
        return this.getPhi(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getBetaAngle() {
        return this.getTheta(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getGammaAngle() {
        return this.getTau(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getAngleAlpha() {
        return this.getPhi(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getAngleBeta() {
        return this.getTheta(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public double getAngleGamma() {
        return this.getTau(this.Evector[0], this.Evector[1], this.Evector[2]);
    }

    public void setAngle(double d, double d2, double d3) {
        double d4 = Math.PI * 2;
        while (d < 0.0) {
            d += d4;
        }
        while (d4 < d) {
            d -= d4;
        }
        while (d2 < 0.0) {
            d2 += d4;
        }
        while (d4 < d2) {
            d2 -= d4;
        }
        while (d3 < 0.0) {
            d3 += d4;
        }
        while (d4 < d3) {
            d3 -= d4;
        }
        this.Evector = this.getEvector(d, d2, d3);
        this.Angle = new double[]{d, d2, d3};
        this.reOrtho();
    }

    public void setAngle_plus(double d, double d2, double d3) {
        double d4;
        this.reOrtho();
        double d5 = this.getPhi(this.Evector[0], this.Evector[1], this.Evector[2]) + d2;
        double d6 = this.getTau(this.Evector[0], this.Evector[1], this.Evector[2]) + d3;
        double d7 = Math.PI * 2;
        for (d4 = this.getTheta(this.Evector[0], this.Evector[1], this.Evector[2]) + d; d4 < 0.0; d4 += d7) {
        }
        while (d7 < d4) {
            d4 -= d7;
        }
        while (d5 < 0.0) {
            d5 += d7;
        }
        while (d7 < d5) {
            d5 -= d7;
        }
        while (d6 < 0.0) {
            d6 += d7;
        }
        while (d7 < d6) {
            d6 -= d7;
        }
        this.setAngle(d4, d5, d6);
        this.reOrtho();
    }

    public void spinX(double d) {
        double[] dArray = new double[]{this.Evector[1][0], this.Evector[1][1], this.Evector[1][2]};
        double[] dArray2 = new double[]{this.Evector[2][0], this.Evector[2][1], this.Evector[2][2]};
        this.Evector[1] = this.andVector(3, Math.cos(d), dArray, Math.sin(d), dArray2);
        this.Evector[2] = this.andVector(3, -Math.sin(d), dArray, Math.cos(d), dArray2);
    }

    public void spinY(double d) {
        double[] dArray = new double[]{this.Evector[2][0], this.Evector[2][1], this.Evector[2][2]};
        double[] dArray2 = new double[]{this.Evector[0][0], this.Evector[0][1], this.Evector[0][2]};
        this.Evector[2] = this.andVector(3, Math.cos(d), dArray, Math.sin(d), dArray2);
        this.Evector[0] = this.andVector(3, -Math.sin(d), dArray, Math.cos(d), dArray2);
    }

    public void spinZ(double d) {
        double[] dArray = new double[]{this.Evector[0][0], this.Evector[0][1], this.Evector[0][2]};
        double[] dArray2 = new double[]{this.Evector[1][0], this.Evector[1][1], this.Evector[1][2]};
        this.Evector[0] = this.andVector(3, Math.cos(d), dArray, Math.sin(d), dArray2);
        this.Evector[1] = this.andVector(3, -Math.sin(d), dArray, Math.cos(d), dArray2);
    }

    public void spin(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d5 * this.Evector[0][0] + d6 * this.Evector[1][0] + d7 * this.Evector[2][0] + this.Origin[0];
        double d9 = d5 * this.Evector[0][1] + d6 * this.Evector[1][1] + d7 * this.Evector[2][1] + this.Origin[1];
        double d10 = d5 * this.Evector[0][2] + d6 * this.Evector[1][2] + d7 * this.Evector[2][2] + this.Origin[2];
        double d11 = d2 * this.Evector[0][0] + d3 * this.Evector[1][0] + d4 * this.Evector[2][0];
        double d12 = d2 * this.Evector[0][1] + d3 * this.Evector[1][1] + d4 * this.Evector[2][1];
        double d13 = d2 * this.Evector[0][2] + d3 * this.Evector[1][2] + d4 * this.Evector[2][2];
        this.rot(d, d11, d12, d13, d8, d9, d10);
    }

    public void spin(double d, double d2, double d3, double d4) {
        this.spin(d, d2, d3, d4, 0.0, 0.0, 0.0);
    }

    public void spin(double d, Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.spin(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z);
    }

    public void spin(double d, Vector3DEG vector3DEG) {
        this.spin(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, 0.0, 0.0, 0.0);
    }

    public void rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.buffVector.x = this.Evector[0][0];
        this.buffVector.y = this.Evector[0][1];
        this.buffVector.z = this.Evector[0][2];
        this.buffVector.rot(d, d2, d3, d4);
        this.Evector[0][0] = this.buffVector.x;
        this.Evector[0][1] = this.buffVector.y;
        this.Evector[0][2] = this.buffVector.z;
        this.buffVector.x = this.Evector[1][0];
        this.buffVector.y = this.Evector[1][1];
        this.buffVector.z = this.Evector[1][2];
        this.buffVector.rot(d, d2, d3, d4);
        this.Evector[1][0] = this.buffVector.x;
        this.Evector[1][1] = this.buffVector.y;
        this.Evector[1][2] = this.buffVector.z;
        this.buffVector.x = this.Evector[2][0];
        this.buffVector.y = this.Evector[2][1];
        this.buffVector.z = this.Evector[2][2];
        this.buffVector.rot(d, d2, d3, d4);
        this.Evector[2][0] = this.buffVector.x;
        this.Evector[2][1] = this.buffVector.y;
        this.Evector[2][2] = this.buffVector.z;
        this.buffVector.x = this.Origin[0];
        this.buffVector.y = this.Origin[1];
        this.buffVector.z = this.Origin[2];
        this.buffVector.rot(d, d2, d3, d4, d5, d6, d7);
        this.Origin[0] = this.buffVector.x;
        this.Origin[1] = this.buffVector.y;
        this.Origin[2] = this.buffVector.z;
    }

    public void rot(double d, double d2, double d3, double d4) {
        this.rot(d, d2, d3, d4, 0.0, 0.0, 0.0);
    }

    public void rot(double d, Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z);
    }

    public void rot(double d, Vector3DEG vector3DEG) {
        this.rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, 0.0, 0.0, 0.0);
    }

    public void rotZ(double d) {
        d *= -1.0;
        double d2 = this.Evector[0][0];
        double d3 = this.Evector[0][1];
        double d4 = this.Evector[1][0];
        double d5 = this.Evector[1][1];
        double d6 = this.Evector[2][0];
        double d7 = this.Evector[2][1];
        this.Evector[0][0] = d2 * Math.cos(d) + d3 * Math.sin(d);
        this.Evector[0][1] = -d2 * Math.sin(d) + d3 * Math.cos(d);
        this.Evector[1][0] = d4 * Math.cos(d) + d5 * Math.sin(d);
        this.Evector[1][1] = -d4 * Math.sin(d) + d5 * Math.cos(d);
        this.Evector[2][0] = d6 * Math.cos(d) + d7 * Math.sin(d);
        this.Evector[2][1] = -d6 * Math.sin(d) + d7 * Math.cos(d);
        double d8 = this.Origin[0];
        double d9 = this.Origin[1];
        this.Origin[0] = d8 * Math.cos(d) + d9 * Math.sin(d);
        this.Origin[1] = -d8 * Math.sin(d) + d9 * Math.cos(d);
    }

    public void rotX(double d) {
        d *= -1.0;
        double d2 = this.Evector[0][1];
        double d3 = this.Evector[0][2];
        double d4 = this.Evector[1][1];
        double d5 = this.Evector[1][2];
        double d6 = this.Evector[2][1];
        double d7 = this.Evector[2][2];
        this.Evector[0][1] = d2 * Math.cos(d) + d3 * Math.sin(d);
        this.Evector[0][2] = -d2 * Math.sin(d) + d3 * Math.cos(d);
        this.Evector[1][1] = d4 * Math.cos(d) + d5 * Math.sin(d);
        this.Evector[1][2] = -d4 * Math.sin(d) + d5 * Math.cos(d);
        this.Evector[2][1] = d6 * Math.cos(d) + d7 * Math.sin(d);
        this.Evector[2][2] = -d6 * Math.sin(d) + d7 * Math.cos(d);
        double d8 = this.Origin[1];
        double d9 = this.Origin[2];
        this.Origin[1] = d8 * Math.cos(d) + d9 * Math.sin(d);
        this.Origin[2] = -d8 * Math.sin(d) + d9 * Math.cos(d);
    }

    public void rotY(double d) {
        d *= -1.0;
        double d2 = this.Evector[0][0];
        double d3 = this.Evector[0][2];
        double d4 = this.Evector[1][0];
        double d5 = this.Evector[1][2];
        double d6 = this.Evector[2][0];
        double d7 = this.Evector[2][2];
        this.Evector[0][2] = d3 * Math.cos(d) + d2 * Math.sin(d);
        this.Evector[0][0] = -d3 * Math.sin(d) + d2 * Math.cos(d);
        this.Evector[1][2] = d5 * Math.cos(d) + d4 * Math.sin(d);
        this.Evector[1][0] = -d5 * Math.sin(d) + d4 * Math.cos(d);
        this.Evector[2][2] = d7 * Math.cos(d) + d6 * Math.sin(d);
        this.Evector[2][0] = -d7 * Math.sin(d) + d6 * Math.cos(d);
        double d8 = this.Origin[2];
        double d9 = this.Origin[0];
        this.Origin[2] = d8 * Math.cos(d) + d9 * Math.sin(d);
        this.Origin[0] = -d8 * Math.sin(d) + d9 * Math.cos(d);
    }

    public double getCosin(double[] dArray, double[] dArray2) {
        double d = (dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]) / (Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]) * Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
        return d;
    }

    public double[] getCross(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public double[] getNvector_e(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[4];
        dArray4[0] = (dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray2[2] - dArray[2]) * (dArray3[1] - dArray[1]);
        dArray4[1] = (dArray2[2] - dArray[2]) * (dArray3[0] - dArray[0]) - (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]);
        dArray4[2] = (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray2[1] - dArray[1]) * (dArray3[0] - dArray[0]);
        double d = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        if (d != 0.0) {
            dArray4[0] = dArray4[0] / d;
            dArray4[1] = dArray4[1] / d;
            dArray4[2] = dArray4[2] / d;
            dArray4[3] = d;
        } else {
            dArray4[0] = 0.0;
            dArray4[1] = 0.0;
            dArray4[2] = 0.0;
            dArray4[3] = d;
        }
        return dArray4;
    }

    public double[] getNvector(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[]{(dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray2[2] - dArray[2]) * (dArray3[1] - dArray[1]), (dArray2[2] - dArray[2]) * (dArray3[0] - dArray[0]) - (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]), (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray2[1] - dArray[1]) * (dArray3[0] - dArray[0])};
        return dArray4;
    }

    public double[] getNvector(double[][] dArray) {
        double[] dArray2 = new double[3];
        dArray2 = this.getNvector(dArray[0], dArray[1], dArray[2]);
        return dArray2;
    }

    public double[][] getEvector(double d, double d2, double d3) {
        double[][] dArray = this.getEvector_Z(d, d2, d3);
        return dArray;
    }

    public double[][] getEvector_Z(double d, double d2, double d3) {
        double[][] dArray = new double[3][3];
        dArray[2][0] = Math.sin(d) * Math.cos(-d2);
        dArray[2][1] = -Math.sin(d) * Math.sin(-d2);
        dArray[2][2] = Math.cos(d);
        dArray[0][0] = Math.sin(-d2) * Math.sin(d3) + Math.cos(-d2) * (Math.cos(d) * Math.cos(d3));
        dArray[0][1] = Math.cos(-d2) * Math.sin(d3) - Math.sin(-d2) * (Math.cos(d) * Math.cos(d3));
        dArray[0][2] = -Math.sin(d) * Math.cos(d3);
        dArray[1][0] = dArray[2][1] * dArray[0][2] - dArray[2][2] * dArray[0][1];
        dArray[1][1] = dArray[2][2] * dArray[0][0] - dArray[2][0] * dArray[0][2];
        dArray[1][2] = dArray[2][0] * dArray[0][1] - dArray[2][1] * dArray[0][0];
        return dArray;
    }

    public double[] andVector(int n, double d, double[] dArray, double d2, double[] dArray2) {
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = d * dArray[i] + d2 * dArray2[i];
        }
        return dArray3;
    }
}

