/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.geometry;

import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;

public class GeometryEngine3DEG {
    double[] intersectionStockBuff = new double[3];
    double[] normalStockBuff = new double[3];
    double[] planeProcessVectorBuff1 = new double[3];
    double[] planeProcessVectorBuff2 = new double[3];
    double[] planeProcessVectorBuff3 = new double[3];
    double[] planeParameterBuff1 = new double[4];
    double[] intersectionVectorBuffer = new double[3];
    double[] intersectionProcessVectorBuff1 = new double[3];
    double[] intersectionProcessPlaneBuff1 = new double[4];
    double[] clippingProcessDVectorBuff1 = new double[3];
    double[] clippingProcessDVectorBuff2 = new double[3];
    double[] clippingProcessDVectorBuff3 = new double[3];
    double[] clippingProcessNVectorBuff1 = new double[3];
    double[] clippingProcessNVectorBuff2 = new double[3];
    double[] clippingProcessNVectorBuff3 = new double[3];

    public void disposeResource() {
        this.planeProcessVectorBuff1 = null;
        this.planeProcessVectorBuff2 = null;
        this.planeProcessVectorBuff3 = null;
        this.planeParameterBuff1 = null;
        this.intersectionVectorBuffer = null;
        this.intersectionProcessVectorBuff1 = null;
        this.intersectionProcessPlaneBuff1 = null;
        this.clippingProcessDVectorBuff1 = null;
        this.clippingProcessDVectorBuff2 = null;
        this.clippingProcessDVectorBuff3 = null;
        this.clippingProcessNVectorBuff1 = null;
        this.clippingProcessNVectorBuff2 = null;
        this.clippingProcessNVectorBuff3 = null;
        this.intersectionStockBuff = null;
        this.normalStockBuff = null;
    }

    public boolean setIntersection(Model3DEG model3DEG, Vector3DEG vector3DEG, Vector3DEG vector3DEG2, Vector3DEG vector3DEG3, Vector3DEG vector3DEG4) {
        boolean bl = this.setIntersection(model3DEG, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z, this.intersectionStockBuff, this.normalStockBuff);
        if (bl) {
            vector3DEG3.x = this.intersectionStockBuff[0];
            vector3DEG3.y = this.intersectionStockBuff[1];
            vector3DEG3.z = this.intersectionStockBuff[2];
            vector3DEG4.x = this.normalStockBuff[0];
            vector3DEG4.y = this.normalStockBuff[1];
            vector3DEG4.z = this.normalStockBuff[2];
            double d = Math.sqrt(vector3DEG4.x * vector3DEG4.x + vector3DEG4.y * vector3DEG4.y + vector3DEG4.z * vector3DEG4.z);
            vector3DEG4.x /= d;
            vector3DEG4.y /= d;
            vector3DEG4.z /= d;
            return true;
        }
        return false;
    }

    public boolean setIntersection(Element3DEG element3DEG, Vector3DEG vector3DEG, Vector3DEG vector3DEG2, Vector3DEG vector3DEG3, Vector3DEG vector3DEG4) {
        boolean bl = this.setIntersection(element3DEG, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z, this.intersectionStockBuff, this.normalStockBuff);
        if (bl) {
            vector3DEG3.x = this.intersectionStockBuff[0];
            vector3DEG3.y = this.intersectionStockBuff[1];
            vector3DEG3.z = this.intersectionStockBuff[2];
            vector3DEG4.x = this.normalStockBuff[0];
            vector3DEG4.y = this.normalStockBuff[1];
            vector3DEG4.z = this.normalStockBuff[2];
            double d = Math.sqrt(vector3DEG4.x * vector3DEG4.x + vector3DEG4.y * vector3DEG4.y + vector3DEG4.z * vector3DEG4.z);
            vector3DEG4.x /= d;
            vector3DEG4.y /= d;
            vector3DEG4.z /= d;
            return true;
        }
        return false;
    }

    void setCross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    void setNormalVector(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double[] dArray) {
        this.planeProcessVectorBuff1[0] = d4 - d;
        this.planeProcessVectorBuff1[1] = d5 - d2;
        this.planeProcessVectorBuff1[2] = d6 - d3;
        this.planeProcessVectorBuff2[0] = d7 - d;
        this.planeProcessVectorBuff2[1] = d8 - d2;
        this.planeProcessVectorBuff2[2] = d9 - d3;
        this.setCross(this.planeProcessVectorBuff1, this.planeProcessVectorBuff2, dArray);
    }

    void setPlaneParameter(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double[] dArray) {
        this.setNormalVector(d, d2, d3, d4, d5, d6, d7, d8, d9, this.planeProcessVectorBuff3);
        dArray[0] = this.planeProcessVectorBuff3[0];
        dArray[1] = this.planeProcessVectorBuff3[1];
        dArray[2] = this.planeProcessVectorBuff3[2];
        dArray[3] = -(dArray[0] * d + dArray[1] * d2 + dArray[2] * d3);
    }

    public boolean setIntersection_NOCLIPPING(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double[] dArray, double[] dArray2) {
        double[] dArray3 = this.intersectionProcessPlaneBuff1;
        this.setPlaneParameter(d, d2, d3, d4, d5, d6, d7, d8, d9, dArray3);
        double d16 = dArray3[0] * d10 + dArray3[1] * d11 + dArray3[2] * d12;
        if (d16 != 0.0) {
            double d17 = -(dArray3[3] + (dArray3[0] * d13 + dArray3[1] * d14 + dArray3[2] * d15)) / d16;
            dArray[0] = d13 + d17 * d10;
            dArray[1] = d14 + d17 * d11;
            dArray[2] = d15 + d17 * d12;
            double d18 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
            dArray2[0] = dArray3[0] / d18;
            dArray2[1] = dArray3[1] / d18;
            dArray2[2] = dArray3[2] / d18;
            return 0.0 <= (dArray[0] - d13) * d10 + (dArray[1] - d14) * d11 + (dArray[2] - d15) * d12;
        }
        return false;
    }

    public void test() {
        boolean bl = this.isTriangleInner(-0.7370180247543501, 0.3276131213172051, 0.591163322549695, 0.1956088731836098, 0.7310670835074188, 0.6536651192650524, -0.75685186435808, 0.5252899336502896, -0.3889032540663204, 0.0, 0.7814361153584652, 0.0);
        System.out.println("TEST = " + bl);
    }

    public boolean isTriangleInner(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double[] dArray = this.clippingProcessDVectorBuff1;
        double[] dArray2 = this.clippingProcessDVectorBuff2;
        double[] dArray3 = this.clippingProcessDVectorBuff3;
        dArray[0] = d - d10;
        dArray[1] = d2 - d11;
        dArray[2] = d3 - d12;
        dArray2[0] = d4 - d10;
        dArray2[1] = d5 - d11;
        dArray2[2] = d6 - d12;
        dArray3[0] = d7 - d10;
        dArray3[1] = d8 - d11;
        dArray3[2] = d9 - d12;
        double[] dArray4 = this.clippingProcessNVectorBuff1;
        double[] dArray5 = this.clippingProcessNVectorBuff2;
        double[] dArray6 = this.clippingProcessNVectorBuff3;
        this.setCross(dArray, dArray2, dArray4);
        this.setCross(dArray2, dArray3, dArray5);
        this.setCross(dArray3, dArray, dArray6);
        double d13 = dArray4[0] * dArray5[0] + dArray4[1] * dArray5[1] + dArray4[2] * dArray5[2];
        double d14 = dArray5[0] * dArray6[0] + dArray5[1] * dArray6[1] + dArray5[2] * dArray6[2];
        double d15 = dArray6[0] * dArray4[0] + dArray6[1] * dArray4[1] + dArray6[2] * dArray4[2];
        if (d13 > 0.0 && d14 > 0.0 && d15 > 0.0 || d13 < 0.0 && d14 < 0.0 && d15 < 0.0) {
            return true;
        }
        return d13 == 0.0 || d14 == 0.0 || d15 == 0.0;
    }

    public boolean setIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double[] dArray, double[] dArray2) {
        double[] dArray3 = this.intersectionVectorBuffer;
        boolean bl = this.setIntersection_NOCLIPPING(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, dArray3, dArray2);
        if (bl) {
            if (this.isTriangleInner(d, d2, d3, d4, d5, d6, d7, d8, d9, dArray3[0], dArray3[1], dArray3[2])) {
                dArray[0] = dArray3[0];
                dArray[1] = dArray3[1];
                dArray[2] = dArray3[2];
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean setIntersection(Element3DEG element3DEG, double d, double d2, double d3, double d4, double d5, double d6, double[] dArray, double[] dArray2) {
        if (element3DEG.type == 3) {
            return this.setIntersection(element3DEG.vertex[0].x, element3DEG.vertex[0].y, element3DEG.vertex[0].z, element3DEG.vertex[1].x, element3DEG.vertex[1].y, element3DEG.vertex[1].z, element3DEG.vertex[2].x, element3DEG.vertex[2].y, element3DEG.vertex[2].z, d, d2, d3, d4, d5, d6, dArray, dArray2);
        }
        if (element3DEG.type == 4) {
            boolean bl = this.setIntersection(element3DEG.vertex[0].x, element3DEG.vertex[0].y, element3DEG.vertex[0].z, element3DEG.vertex[1].x, element3DEG.vertex[1].y, element3DEG.vertex[1].z, element3DEG.vertex[2].x, element3DEG.vertex[2].y, element3DEG.vertex[2].z, d, d2, d3, d4, d5, d6, dArray, dArray2);
            if (bl) {
                return true;
            }
            boolean bl2 = this.setIntersection(element3DEG.vertex[2].x, element3DEG.vertex[2].y, element3DEG.vertex[2].z, element3DEG.vertex[3].x, element3DEG.vertex[3].y, element3DEG.vertex[3].z, element3DEG.vertex[1].x, element3DEG.vertex[1].y, element3DEG.vertex[1].z, d, d2, d3, d4, d5, d6, dArray, dArray2);
            return bl2;
        }
        return false;
    }

    public boolean setIntersection(Model3DEG model3DEG, double d, double d2, double d3, double d4, double d5, double d6, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d7 = Double.MAX_VALUE;
        Element3DEG[] element3DEGArray = model3DEG.element;
        boolean bl = false;
        for (int i = 0; i < element3DEGArray.length; ++i) {
            boolean bl2 = this.setIntersection(element3DEGArray[i], d, d2, d3, d4, d5, d6, dArray3, dArray4);
            if (!bl2) continue;
            bl = true;
            double d8 = (dArray3[0] - d4) * (dArray3[0] - d4) + (dArray3[1] - d5) * (dArray3[1] - d5) + (dArray3[2] - d6) * (dArray3[2] - d6);
            if (!(d8 < d7)) continue;
            d7 = d8;
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
            dArray[2] = dArray3[2];
            dArray2[0] = dArray4[0];
            dArray2[1] = dArray4[1];
            dArray2[2] = dArray4[2];
        }
        return bl;
    }
}

