/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.geometry;

import java.awt.Color;
import java.awt.Font;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;
import rxvesapi.system3d.renderer.TriangleElement3DEG;

public class Model3DEG {
    public static final int QUADRANGLE_LIST = 400;
    public static final int QUADRANGLE_GRID = 401;
    public static final int TRIANGLE_LIST = 300;
    public static final int TRIANGLE_STRIP = 301;
    public static final int TRIANGLE_FAN = 302;
    public Element3DEG[] element;
    public Model3DEG[] child;
    public int processID = -1;

    public Model3DEG() {
    }

    public Model3DEG(int n) {
        this.element = new Element3DEG[n];
    }

    public Model3DEG(Element3DEG[] element3DEGArray) {
        this.element = element3DEGArray;
    }

    public Model3DEG(Model3DEG[] model3DEGArray) {
        int n;
        int n2 = 0;
        this.child = new Model3DEG[model3DEGArray.length];
        for (n = 0; n < model3DEGArray.length; ++n) {
            this.child[n] = model3DEGArray[n];
            n2 += model3DEGArray[n].element.length;
        }
        this.element = new Element3DEG[n2];
        n = 0;
        for (int i = 0; i < model3DEGArray.length; ++i) {
            for (int j = 0; j < model3DEGArray[i].element.length; ++j) {
                this.element[n] = model3DEGArray[i].element[j];
                ++n;
            }
        }
    }

    public Model3DEG(int n, double[][][] dArray, Color color) {
        if (n == 300) {
            this.createTriangleList(dArray, color);
        }
        if (n == 400) {
            this.createQuadrangleList(dArray, color);
        }
        if (n == 401) {
            this.createQuadrangleGrid(dArray, color);
        }
        if (n == 301) {
            this.createTriangleStrip(dArray[0], color);
        }
        if (n == 302) {
            this.createTriangleFan(dArray[0], color);
        }
    }

    public Model3DEG(int n, double[][] dArray, Color color) {
        if (n == 301) {
            this.createTriangleStrip(dArray, color);
        }
        if (n == 302) {
            this.createTriangleFan(dArray, color);
        }
    }

    private void createQuadrangleGrid(double[][][] dArray, Color color) {
        int n = dArray.length - 1;
        int n2 = dArray[0].length - 1;
        this.element = new QuadrangleElement3DEG[n * n2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, color);
        }
        this.setVertex_QuadrangleGrid(dArray);
    }

    private void createQuadrangleList(double[][][] dArray, Color color) {
        int n = dArray.length;
        this.element = new QuadrangleElement3DEG[n];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, color);
        }
        this.setVertex_QuadrangleList(dArray);
    }

    private void createTriangleList(double[][][] dArray, Color color) {
        int n = dArray.length;
        this.element = new TriangleElement3DEG[n];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new TriangleElement3DEG(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, color);
        }
        this.setVertex_TriangleList(dArray);
    }

    private void createTriangleFan(double[][] dArray, Color color) {
        int n = dArray.length - 2;
        this.element = new TriangleElement3DEG[n];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new TriangleElement3DEG(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, color);
        }
        this.setVertex_TriangleFan(dArray);
    }

    private void createTriangleStrip(double[][] dArray, Color color) {
        int n = dArray.length - 2;
        this.element = new TriangleElement3DEG[n];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new TriangleElement3DEG(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, color);
        }
        this.setVertex_TriangleStrip(dArray);
    }

    public void setVertex(int n, double[][] dArray) {
        if (n == 301) {
            this.setVertex_TriangleStrip(dArray);
        }
        if (n == 302) {
            this.setVertex_TriangleFan(dArray);
        }
    }

    public void setVertex(int n, double[][][] dArray) {
        if (n == 300) {
            this.setVertex_TriangleList(dArray);
        }
        if (n == 400) {
            this.setVertex_QuadrangleList(dArray);
        }
        if (n == 401) {
            this.setVertex_QuadrangleGrid(dArray);
        }
        if (n == 301) {
            this.setVertex_TriangleStrip(dArray[0]);
        }
        if (n == 302) {
            this.setVertex_TriangleFan(dArray[0]);
        }
    }

    private void setVertex_TriangleStrip(double[][] dArray) {
        int n = dArray.length - 2;
        for (int i = 0; i < n; ++i) {
            if (i % 2 == 0) {
                this.element[i].setVertex(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i + 1][0], dArray[i + 1][1], dArray[i + 1][2], dArray[i + 2][0], dArray[i + 2][1], dArray[i + 2][2]);
                continue;
            }
            this.element[i].setVertex(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i + 2][0], dArray[i + 2][1], dArray[i + 2][2], dArray[i + 1][0], dArray[i + 1][1], dArray[i + 1][2]);
        }
    }

    private void setVertex_TriangleFan(double[][] dArray) {
        int n = dArray.length - 2;
        for (int i = 0; i < n; ++i) {
            this.element[i].setVertex(dArray[0][0], dArray[0][1], dArray[0][2], dArray[i + 1][0], dArray[i + 1][1], dArray[i + 1][2], dArray[i + 2][0], dArray[i + 2][1], dArray[i + 2][2]);
        }
    }

    private void setVertex_TriangleList(double[][][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].setVertex(dArray[i][0][0], dArray[i][0][1], dArray[i][0][2], dArray[i][1][0], dArray[i][1][1], dArray[i][1][2], dArray[i][2][0], dArray[i][2][1], dArray[i][2][2]);
        }
    }

    private void setVertex_QuadrangleList(double[][][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].setVertex(dArray[i][0][0], dArray[i][0][1], dArray[i][0][2], dArray[i][1][0], dArray[i][1][1], dArray[i][1][2], dArray[i][2][0], dArray[i][2][1], dArray[i][2][2], dArray[i][3][0], dArray[i][3][1], dArray[i][3][2]);
        }
    }

    private void setVertex_QuadrangleGrid(double[][][] dArray) {
        int n = dArray.length - 1;
        int n2 = dArray[0].length - 1;
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                n3 = j + n2 * i;
                dArray4 = dArray[i][j];
                dArray5 = dArray[i][j + 1];
                dArray3 = dArray[i + 1][j + 1];
                dArray2 = dArray[i + 1][j];
                this.element[n3].setVertex(dArray4[0], dArray4[1], dArray4[2], dArray5[0], dArray5[1], dArray5[2], dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2]);
            }
        }
    }

    public Element3DEG[] getElements() {
        return this.element;
    }

    public Model3DEG[] getChildren() {
        return this.child;
    }

    public Model3DEG getChild(int n) {
        return this.child[n];
    }

    public Model3DEG copy() {
        int n = this.element.length;
        Model3DEG model3DEG = new Model3DEG();
        model3DEG.element = new Element3DEG[n];
        for (int i = 0; i < n; ++i) {
            model3DEG.element[i] = this.element[i].copy();
        }
        return model3DEG;
    }

    public void dispose() {
        int n;
        if (this.element != null) {
            for (n = 0; n < this.element.length; ++n) {
                if (this.element[n] == null) continue;
                this.element[n].disposeResource();
                this.element[n] = null;
            }
        }
        if (this.child != null) {
            for (n = 0; n < this.child.length; ++n) {
                if (this.child[n] == null) continue;
                this.child[n].disposeResource();
                this.child[n] = null;
            }
        }
    }

    public void disposeResource() {
        this.dispose();
    }

    public void setSortOffset(double d) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].setSortOffset(d);
        }
    }

    public void setFrontCulling(boolean bl) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].setFrontCulling(bl);
        }
    }

    public void setBackCulling(boolean bl) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].setBackCulling(bl);
        }
    }

    public void setFill(boolean bl) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].setFill(bl);
        }
    }

    public void setColor(Color color) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].color = color;
        }
    }

    public void setFont(Font font) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].font = font;
        }
    }

    public void scaleX(double d) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].scaleX(d);
        }
    }

    public void scaleY(double d) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].scaleY(d);
        }
    }

    public void scaleZ(double d) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].scaleZ(d);
        }
    }

    public void scale(double d, double d2, double d3) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].scale(d, d2, d3);
        }
    }

    public void mirrorX() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].mirrorX();
        }
    }

    public void mirrorY() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].mirrorY();
        }
    }

    public void mirrorZ() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].mirrorZ();
        }
    }

    public void mirror(boolean bl, boolean bl2, boolean bl3) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].mirror(bl, bl2, bl3);
        }
    }

    public void reverse() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            this.element[i].reverse();
        }
    }

    public void setSize(double[] dArray) {
    }

    public void setText(String[] stringArray) {
    }

    public void setSurface(boolean bl) {
    }

    public void setDirectionalReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].directional = d;
        }
    }

    public void setDiffractiveReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].diffractional = d;
        }
    }

    public void setDiffractionalReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].diffractional = d;
        }
    }

    public void setDiffuseReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].diffuse = d;
        }
    }

    public void setAmbientReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].ambient = d;
        }
    }

    public void setEmission(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].emissive = d;
        }
    }

    public void setShinyAngle(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].optimumAngle = d;
        }
    }

    public void setShinyReflection(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].shininess = d;
        }
    }

    public void setSpecular(double d, double d2) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].shininess = d;
            this.element[i].optimumAngle = d2;
        }
    }

    public void rotX(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rotX(d);
        }
    }

    public void rotY(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rotY(d);
        }
    }

    public void rotZ(double d) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rotZ(d);
        }
    }

    public void rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rot(d, d2, d3, d4, d5, d6, d7);
        }
    }

    public void rot(double d, double d2, double d3, double d4) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rot(d, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public void rot(double d, Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z);
        }
    }

    public void rot(double d, Vector3DEG vector3DEG) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, 0.0, 0.0, 0.0);
        }
    }

    public void move(double d, double d2, double d3) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].move(d, d2, d3);
        }
    }

    public void move(Vector3DEG vector3DEG) {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i].move(vector3DEG.x, vector3DEG.y, vector3DEG.z);
        }
    }
}

