/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class DiskModel3DEG
extends Model3DEG {
    private double Rx;
    private double Ry;
    private int N1 = 27;
    private int N2 = 1;
    private int sn1 = 0;
    private int sn2 = 0;
    private int en1 = 27;
    private int en2 = 1;
    private Color color = Color.lightGray;
    private boolean face = true;

    public DiskModel3DEG() {
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public DiskModel3DEG(int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = 0;
        this.sn2 = 0;
        this.en1 = n;
        this.en2 = n2;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public DiskModel3DEG(int n, int n2, int n3, int n4, int n5, int n6) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = n3;
        this.sn2 = n4;
        this.en1 = n5;
        this.en2 = n6;
        this.element = new QuadrangleElement3DEG[(this.en1 - this.sn1) * (this.en2 - this.sn2)];
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2); ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public DiskModel3DEG(double d, double d2, Color color) {
        this.Rx = d;
        this.Ry = d2;
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public DiskModel3DEG(double d, Color color) {
        this.Rx = d;
        this.Ry = d;
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    @Override
    public void setSize(double[] dArray) {
        if (dArray.length == 1) {
            this.Rx = dArray[0];
            this.Ry = dArray[0];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
        if (dArray.length == 2) {
            this.Rx = dArray[0];
            this.Ry = dArray[1];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
    }

    @Override
    public void setSurface(boolean bl) {
        this.setFace(bl);
    }

    public void setFace(boolean bl) {
        this.face = bl;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d) {
        this.Rx = d;
        this.Ry = d;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d, double d2) {
        this.Rx = d;
        this.Ry = d2;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2); ++i) {
            this.element[i].color = color;
        }
    }

    public void make() {
        this.Circle(0, 0.0, 0.0, 0.0, this.Rx, this.Ry, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
    }

    public void make_REV() {
        this.Circle(0, 0.0, 0.0, 0.0, this.Rx, this.Ry, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
    }

    public int Circle(int n, double d, double d2, double d3, double d4, double d5, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d6 = d4 * ((double)i / (double)n3);
            double d7 = d4 * (((double)i + 1.0) / (double)n3);
            double d8 = d5 * ((double)i / (double)n3);
            double d9 = d5 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d10 = 6.2831853 * ((double)j / (double)n2);
                double d11 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d6 * Math.cos(d10) + d;
                dArray[1] = d8 * Math.sin(d10) + d2;
                dArray[2] = d3;
                dArray2[0] = d6 * Math.cos(d11) + d;
                dArray2[1] = d8 * Math.sin(d11) + d2;
                dArray2[2] = d3;
                dArray3[0] = d7 * Math.cos(d11) + d;
                dArray3[1] = d9 * Math.sin(d11) + d2;
                dArray3[2] = d3;
                dArray4[0] = d7 * Math.cos(d10) + d;
                dArray4[1] = d9 * Math.sin(d10) + d2;
                dArray4[2] = d3;
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2]);
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray3[0], dArray3[1], dArray3[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                    continue;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }

    public int Circle_REV(int n, double d, double d2, double d3, double d4, double d5, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d6 = d4 * ((double)i / (double)n3);
            double d7 = d4 * (((double)i + 1.0) / (double)n3);
            double d8 = d5 * ((double)i / (double)n3);
            double d9 = d5 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d10 = 6.2831853 * ((double)j / (double)n2);
                double d11 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d6 * Math.cos(d10) + d;
                dArray[1] = d8 * Math.sin(d10) + d2;
                dArray[2] = d3;
                dArray2[0] = d6 * Math.cos(d11) + d;
                dArray2[1] = d8 * Math.sin(d11) + d2;
                dArray2[2] = d3;
                dArray3[0] = d7 * Math.cos(d11) + d;
                dArray3[1] = d9 * Math.sin(d11) + d2;
                dArray3[2] = d3;
                dArray4[0] = d7 * Math.cos(d10) + d;
                dArray4[1] = d9 * Math.sin(d10) + d2;
                dArray4[2] = d3;
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2]);
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray2[0], dArray2[1], dArray2[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                    continue;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }
}

