/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.renderer;

public class FastTrigonometricFunctionGenerator {
    double[] cosval;
    double[] sinval;
    double[] acosval;
    double[] asinval;
    int N = 630;
    int arcN = 256;
    double dx = 1.0 / (double)this.N;
    double arcN_half = (double)this.arcN * 0.5;

    FastTrigonometricFunctionGenerator() {
        int n;
        this.cosval = new double[this.N];
        this.sinval = new double[this.N];
        this.acosval = new double[this.arcN];
        this.asinval = new double[this.arcN];
        for (n = 0; n < this.N; ++n) {
            this.cosval[n] = Math.cos((double)n / 100.0);
            this.sinval[n] = Math.sin((double)n / 100.0);
        }
        for (n = 0; n < this.arcN; ++n) {
            this.acosval[n] = Math.acos(((double)n - (double)this.arcN * 0.5) / ((double)this.arcN * 0.5));
            this.asinval[n] = Math.asin(((double)n - (double)this.arcN * 0.5) / ((double)this.arcN * 0.5));
        }
    }

    double cos(double d) {
        if (0.0 <= d && d <= 6.29) {
            return this.cosval[(int)(d * 100.0)];
        }
        if ((d *= 100.0) < 0.0) {
            d *= -1.0;
        }
        return this.cosval[(int)(d % 629.0)];
    }

    double sin(double d) {
        if (0.0 <= d && d <= 6.29) {
            return this.sinval[(int)(d * 100.0)];
        }
        if ((d *= 100.0) < 0.0) {
            return -this.sinval[(int)((d *= -1.0) % 629.0)];
        }
        return this.sinval[(int)(d % 629.0)];
    }

    double acos(double d) {
        return this.acosval[(int)((d + 1.0) * this.arcN_half)];
    }

    double asin(double d) {
        return this.asinval[(int)((d + 1.0) * this.arcN_half)];
    }
}

