/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import rxvesapi.system3d.geometry.CoordinateSystem3DEG;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.geometry.Structure3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;
import rxvesapi.system3d.renderer.Realtime3DPanel;
import rxvesapi.system3d.renderer.Realtime3DScreenRefreshEvent;
import rxvesapi.system3d.renderer.Realtime3DScreenRefreshListener;
import rxvesapi.system3d.renderer.ScreenSystem3DEG;

public class Realtime3DFrame
extends JFrame
implements Realtime3DScreenRefreshListener,
ComponentListener,
KeyListener,
WindowListener {
    public Realtime3DPanel panel3d;
    public static int IDLE_MODE = Realtime3DPanel.IDLE_MODE;
    public static int SEMI_IDLE_MODE = Realtime3DPanel.SEMI_IDLE_MODE;
    public static int SEMI_REALTIME_MODE = Realtime3DPanel.SEMI_REALTIME_MODE;
    public static int REALTIME_MODE = Realtime3DPanel.REALTIME_MODE;
    public static int ZERO_LIMITER_MODE = Realtime3DPanel.ZERO_LIMITER_MODE;
    public static int WIRE_FRAME_MODE = Realtime3DPanel.WIRE_FRAME_MODE;
    public static int FLAT_SHADING_MODE = Realtime3DPanel.FLAT_SHADING_MODE;
    private int systemEnable = 0;
    private Dimension frameDim = new Dimension();
    public JFrame frame;
    private boolean shiftKeyPressing = false;
    int width;
    int height;
    boolean whiteOutFrag = false;
    private Realtime3DScreenRefreshListener[] realtime3DScreenRefreshListener = new Realtime3DScreenRefreshListener[0];
    private Realtime3DScreenRefreshEvent realtime3DScreenRefreshEvent;

    public void addRealtime3DScreenRefreshListener(Realtime3DScreenRefreshListener realtime3DScreenRefreshListener) {
        int n;
        int n2 = this.realtime3DScreenRefreshListener.length;
        Realtime3DScreenRefreshListener[] realtime3DScreenRefreshListenerArray = new Realtime3DScreenRefreshListener[n2];
        for (n = 0; n < n2; ++n) {
            realtime3DScreenRefreshListenerArray[n] = this.realtime3DScreenRefreshListener[n];
        }
        this.realtime3DScreenRefreshListener = new Realtime3DScreenRefreshListener[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.realtime3DScreenRefreshListener[n] = realtime3DScreenRefreshListenerArray[n];
        }
        this.realtime3DScreenRefreshListener[n2] = realtime3DScreenRefreshListener;
    }

    @Override
    public void screenRefreshed(Realtime3DScreenRefreshEvent realtime3DScreenRefreshEvent) {
        for (int i = 0; i < this.realtime3DScreenRefreshListener.length; ++i) {
            Realtime3DScreenRefreshEvent realtime3DScreenRefreshEvent2 = new Realtime3DScreenRefreshEvent();
            realtime3DScreenRefreshEvent2.setSource(this);
            this.realtime3DScreenRefreshListener[i].screenRefreshed(realtime3DScreenRefreshEvent2);
        }
    }

    public static void main(String[] stringArray) {
        Realtime3DFrame realtime3DFrame = new Realtime3DFrame();
    }

    public Realtime3DFrame() {
        this.setBackground(Color.white);
        this.getContentPane().setLayout(null);
        this.addComponentListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.setBounds(0, 0, 690, 540);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.panel3d = new Realtime3DPanel();
        this.panel3d.addRealtime3DScreenRefreshListener(this);
        this.panel3d.setSize(690, 540);
        this.getContentPane().add(this.panel3d);
        this.reSize();
    }

    public Realtime3DPanel getDisplayPanel() {
        return this.panel3d;
    }

    public double getCurrentPolygonRate() {
        return this.panel3d.getCurrentPolygonRate();
    }

    public int getCurrentNumberOfPolygons() {
        return this.panel3d.getCurrentNumberOfPolygons();
    }

    public double getCurrentFrameRate() {
        return this.panel3d.getCurrentFrameRate();
    }

    public int getCurrentFrameWait() {
        return this.panel3d.getCurrentFrameWait();
    }

    public void setProcessMode(int n) {
        this.panel3d.setProcessMode(n);
    }

    public void setScreenCenter(int n, int n2) {
        this.panel3d.setScreenCenter(n, n2);
    }

    public void setFrameRate(double d) {
        this.panel3d.setFrameRate(d);
    }

    public void setFrameWaitLimiter(int n) {
        this.panel3d.setFrameWaitLimiter(n);
    }

    public void setInformationDisplay(boolean bl) {
        this.panel3d.setInformationDisplay(bl);
    }

    public boolean isInformationDisplay() {
        return this.panel3d.isInformationDisplay();
    }

    public void setShadingMode(int n) {
        this.panel3d.setShadingMode(n);
    }

    public ScreenSystem3DEG getScreenSystem() {
        return this.panel3d.getScreenSystem();
    }

    public CoordinateSystem3DEG getWorldSystem() {
        return this.panel3d.getWorldSystem();
    }

    public Image getScreenImage() {
        return this.panel3d.screen.getScreenImage();
    }

    public void setScreenSystem(ScreenSystem3DEG screenSystem3DEG) {
        this.panel3d.setScreenSystem(screenSystem3DEG);
    }

    public void setWorldSystem(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.panel3d.setWorldSystem(coordinateSystem3DEG);
    }

    public void repaint3D() {
        this.panel3d.repaint3D();
    }

    public void setScreenBackground(Color color) {
        this.panel3d.setScreenBackground(color);
    }

    public void setInformationColor(Color color) {
        this.panel3d.setInformationColor(color);
    }

    void reSize() {
        this.frameDim = this.getSize();
        this.width = this.frameDim.width;
        this.height = this.frameDim.height;
        try {
            this.panel3d.setSize(this.width, this.height);
            this.panel3d.reSize();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.repaint3D();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        try {
            this.reSize();
            this.repaint3D();
            this.panel3d.resizeInt = 1;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.getDefaultCloseOperation() == 3 || this.getDefaultCloseOperation() == 2) {
            this.disposeResource();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void disposeResource() {
        this.setVisible(false);
        this.panel3d.disposeResource();
        this.panel3d = null;
        this.dispose();
        for (int i = 0; i < this.realtime3DScreenRefreshListener.length; ++i) {
            this.realtime3DScreenRefreshListener[i] = null;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        double d = 0.3 / this.panel3d.screen.getMagnification();
        switch (keyEvent.getKeyCode()) {
            case 16: {
                this.shiftKeyPressing = true;
                break;
            }
            case 39: {
                this.panel3d.world.move(-d, 0.0, 0.0);
                break;
            }
            case 37: {
                this.panel3d.world.move(d, 0.0, 0.0);
                break;
            }
            case 38: {
                if (this.shiftKeyPressing) {
                    this.panel3d.world.move(0.0, 0.0, d);
                    break;
                }
                this.panel3d.world.move(0.0, -d, 0.0);
                break;
            }
            case 40: {
                if (this.shiftKeyPressing) {
                    this.panel3d.world.move(0.0, 0.0, -d);
                    break;
                }
                this.panel3d.world.move(0.0, d, 0.0);
                break;
            }
            case 32: {
                if (this.panel3d.isInformationDisplay()) {
                    this.panel3d.setInformationDisplay(false);
                    if (this.panel3d.getShadingMode() == Realtime3DPanel.FLAT_SHADING_MODE) {
                        this.panel3d.setShadingMode(Realtime3DPanel.WIRE_FRAME_MODE);
                        this.panel3d.setInformationDisplay(false);
                        break;
                    }
                    if (this.panel3d.getShadingMode() != Realtime3DPanel.WIRE_FRAME_MODE) break;
                    this.panel3d.setShadingMode(Realtime3DPanel.FLAT_SHADING_MODE);
                    this.panel3d.setInformationDisplay(false);
                    break;
                }
                this.panel3d.setInformationDisplay(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 16: {
                this.shiftKeyPressing = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.getKeyCode();
    }

    public void add(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.panel3d.add(coordinateSystem3DEG);
    }

    public void add(Element3DEG element3DEG) {
        this.panel3d.add(element3DEG);
    }

    public void add(Vector3DEG vector3DEG) {
        this.panel3d.add(vector3DEG);
    }

    public void add(Element3DEG[] element3DEGArray) {
        this.panel3d.add(element3DEGArray);
    }

    public void add(Element3DEG[][] element3DEGArray) {
        this.panel3d.add(element3DEGArray);
    }

    public void add(Element3DEG[][][] element3DEGArray) {
        this.panel3d.add(element3DEGArray);
    }

    public void add(Model3DEG model3DEG) {
        this.panel3d.add(model3DEG);
    }

    public void add(Model3DEG[] model3DEGArray) {
        this.panel3d.add(model3DEGArray);
    }

    public void add(Model3DEG[][] model3DEGArray) {
        this.panel3d.add(model3DEGArray);
    }

    public void add(Model3DEG[][][] model3DEGArray) {
        this.panel3d.add(model3DEGArray);
    }

    public void add(Structure3DEG structure3DEG) {
        this.panel3d.add(structure3DEG.model);
    }

    public void add(Structure3DEG[] structure3DEGArray) {
        this.panel3d.add(structure3DEGArray);
    }

    public void add(Structure3DEG[][] structure3DEGArray) {
        this.panel3d.add(structure3DEGArray);
    }

    public void add(Structure3DEG[][][] structure3DEGArray) {
        this.panel3d.add(structure3DEGArray);
    }

    public void remove(Element3DEG element3DEG) {
        this.panel3d.cancel(element3DEG);
    }

    public void remove(Element3DEG[] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void remove(Element3DEG[][] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void remove(Element3DEG[][][] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void remove(Model3DEG model3DEG) {
        this.panel3d.cancel(model3DEG);
    }

    public void remove(Model3DEG[] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void remove(Model3DEG[][] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void remove(Model3DEG[][][] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void remove(Structure3DEG structure3DEG) {
        this.panel3d.cancel(structure3DEG);
    }

    public void remove(Structure3DEG[] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void remove(Structure3DEG[][] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void remove(Structure3DEG[][][] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void cancel(Element3DEG element3DEG) {
        this.panel3d.cancel(element3DEG);
    }

    public void cancel(Element3DEG[] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void cancel(Element3DEG[][] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void cancel(Element3DEG[][][] element3DEGArray) {
        this.panel3d.cancel(element3DEGArray);
    }

    public void cancel(Model3DEG model3DEG) {
        this.panel3d.cancel(model3DEG);
    }

    public void cancel(Model3DEG[] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void cancel(Model3DEG[][] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void cancel(Model3DEG[][][] model3DEGArray) {
        this.panel3d.cancel(model3DEGArray);
    }

    public void cancel(Structure3DEG structure3DEG) {
        this.panel3d.cancel(structure3DEG);
    }

    public void cancel(Structure3DEG[] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void cancel(Structure3DEG[][] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void cancel(Structure3DEG[][][] structure3DEGArray) {
        this.panel3d.cancel(structure3DEGArray);
    }

    public void format() {
        this.panel3d.format();
    }
}

