/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptException;
import org.vcssl.connect.ConnectorException;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.Compiler;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.interconnect.MetaQualifiedFileLoader;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.VirtualMachine;

public final class VnanoEngine {
    private VirtualMachine virtualMachine = null;
    private Interconnect interconnect = new Interconnect();
    private String lastScript = null;
    private boolean lastStateIsSame = false;
    private boolean lastAutoActivationIsEnabled = false;

    public VnanoEngine() {
        this.virtualMachine = new VirtualMachine();
    }

    public Object executeScript(String string) throws VnanoException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.lastScript != null && this.lastStateIsSame && (string == this.lastScript || string.equals(this.lastScript))) {
            return this.reexecuteLastScript();
        }
        try {
            try {
                string = MetaQualifiedFileLoader.postprocess(null, string);
            }
            catch (VnanoException vnanoException) {
                String string2 = vnanoException.getMessageWithoutLocation();
                throw new ScriptException(string2);
            }
            String string3 = (String)this.interconnect.getOptionMap().get("MAIN_SCRIPT_NAME");
            this.interconnect.setMainScript(string3, string);
            boolean bl = (Boolean)this.interconnect.getOptionMap().get("AUTOMATIC_ACTIVATION_ENABLED");
            if (bl) {
                this.interconnect.activate();
            }
            String[] stringArray = this.interconnect.getScriptContents();
            String[] stringArray2 = this.interconnect.getScriptPaths();
            String string4 = new Compiler().compile(stringArray, stringArray2, this.interconnect);
            Object object = this.virtualMachine.executeAssemblyCode(string4, this.interconnect);
            if (bl) {
                this.interconnect.deactivate();
            }
            this.lastScript = string;
            this.lastStateIsSame = true;
            this.lastAutoActivationIsEnabled = bl;
            return object;
        }
        catch (VnanoException vnanoException) {
            Locale locale = (Locale)this.interconnect.getOptionMap().get("LOCALE");
            vnanoException.setLocale(locale);
            if (vnanoException.getCause() instanceof ConnectorException && ((ConnectorException)vnanoException.getCause()).getMessage().startsWith("___")) {
                this.handleSpecialConnectorException((ConnectorException)vnanoException.getCause(), vnanoException);
                return null;
            }
            throw vnanoException;
        }
        catch (Exception exception) {
            throw new VnanoException(exception);
        }
    }

    private Object reexecuteLastScript() throws VnanoException {
        if (this.lastAutoActivationIsEnabled) {
            this.interconnect.activate();
        }
        Object object = this.virtualMachine.reexecuteLastAssemblyCode(this.interconnect);
        if (this.lastAutoActivationIsEnabled) {
            this.interconnect.deactivate();
        }
        return object;
    }

    private void handleSpecialConnectorException(ConnectorException connectorException, VnanoException vnanoException) throws VnanoException {
        String string = connectorException.getMessage();
        if (string.startsWith("___EXIT")) {
            return;
        }
        if (string.startsWith("___ERROR")) {
            String string2 = string.split(":")[1];
            VnanoException vnanoException2 = vnanoException.clone();
            vnanoException2.setErrorType(ErrorType.UNMODIFIED);
            vnanoException2.setErrorWords(new String[]{string2});
            throw vnanoException2;
        }
    }

    public void terminateScript() {
        if (!this.isTerminatorEnabled()) {
            throw new VnanoFatalException(ErrorType.TERMINATOR_IS_DISABLED);
        }
        this.virtualMachine.terminate();
    }

    public boolean isTerminatorEnabled() {
        return (Boolean)this.interconnect.getOptionMap().get("TERMINATOR_ENABLED");
    }

    public void resetTerminator() {
        if (!this.isTerminatorEnabled()) {
            throw new VnanoFatalException(ErrorType.TERMINATOR_IS_DISABLED);
        }
        this.virtualMachine.resetTerminator();
    }

    public void activate() throws VnanoException {
        this.interconnect.activate();
    }

    public void deactivate() throws VnanoException {
        this.interconnect.deactivate();
    }

    public void connectPlugin(String string, Object object) throws VnanoException {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        this.lastStateIsSame = false;
        this.interconnect.connectPlugin(string, object);
    }

    public void disconnectAllPlugins() throws VnanoException {
        this.lastStateIsSame = false;
        this.interconnect.disconnectAllPlugins();
    }

    public void registerLibraryScript(String string, String string2) throws VnanoException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.lastStateIsSame = false;
        this.interconnect.addLibraryScript(string, string2);
    }

    public void unregisterAllLibraryScripts() throws VnanoException {
        this.lastStateIsSame = false;
        this.interconnect.removeAllLibraryScripts();
    }

    public void setOptionMap(Map<String, Object> map) throws VnanoException {
        if (map == null) {
            throw new NullPointerException();
        }
        this.lastStateIsSame = false;
        this.interconnect.setOptionMap(map);
    }

    public boolean hasOptionMap() {
        return this.interconnect.getOptionMap() != null;
    }

    public Map<String, Object> getOptionMap() {
        if (!this.hasOptionMap()) {
            throw new VnanoFatalException(ErrorType.CAN_NOT_GET_OPTION_MAP);
        }
        return this.interconnect.getOptionMap();
    }

    public void setPermissionMap(Map<String, String> map) throws VnanoException {
        if (map == null) {
            throw new NullPointerException();
        }
        this.lastStateIsSame = false;
        this.interconnect.setPermissionMap(map);
    }

    public boolean hasPermissionMap() {
        return this.interconnect.getPermissionMap() != null;
    }

    public Map<String, String> getPermissionMap() {
        if (!this.hasPermissionMap()) {
            throw new VnanoFatalException(ErrorType.CAN_NOT_GET_PERMISSION_MAP);
        }
        return this.interconnect.getPermissionMap();
    }

    public boolean hasPerformanceMap() {
        return (Boolean)this.interconnect.getOptionMap().get("PERFORMANCE_MONITOR_ENABLED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPerformanceMap() {
        VnanoEngine vnanoEngine = this;
        synchronized (vnanoEngine) {
            if (!this.hasPerformanceMap()) {
                throw new VnanoFatalException(ErrorType.PERFORMANCE_MONITOR_IS_DISABLED);
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (this.virtualMachine != null) {
                int n = this.virtualMachine.getExecutedInstructionCountIntValue();
                linkedHashMap.put("EXECUTED_INSTRUCTION_COUNT_INT_VALUE", n);
                OperationCode[] operationCodeArray = this.virtualMachine.getCurrentlyExecutedOperationCodes();
                if (operationCodeArray.length != 0) {
                    String[] stringArray = new String[operationCodeArray.length];
                    for (int i = 0; i < operationCodeArray.length; ++i) {
                        stringArray[i] = operationCodeArray[i].toString();
                    }
                    linkedHashMap.put("CURRENTLY_EXECUTED_OPERATION_CODE", stringArray);
                }
            }
            return linkedHashMap;
        }
    }
}

