/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class LiteralCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testIntLiterals();
            this.testFloatLiterals();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testFloatLiterals() throws VnanoException {
        String string = "1.23E-45;";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.23E-45, "float literal (1.23E-45)", string);
    }

    private void testIntLiterals() throws VnanoException {
        String string = "0x123;";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 291L, "int literal (0x123)", string);
        string = "123;";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int literal (123)", string);
        string = "0o123;";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 83L, "int literal (0o123)", string);
        string = "0b1010;";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "int literal (0b1010)", string);
    }
}

