/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class ScalarLogicalOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAndOperations();
            this.testOrOperations();
            this.testNotOperations();
            this.testDualOperations();
            this.testTripleOperations();
            this.testQuadOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAndOperations() throws VnanoException {
        String string = " true && true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && true", string);
        string = " true && false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "true && false", string);
        string = " false && true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false && true", string);
        string = " false && false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false && false", string);
    }

    private void testOrOperations() throws VnanoException {
        String string = " true || true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true || true", string);
        string = " true || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true || false", string);
        string = " false || true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "false || true", string);
        string = " false || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false || false", string);
    }

    private void testNotOperations() throws VnanoException {
        String string = " ! true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "! true", string);
        string = " ! false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "! false", string);
    }

    private void testDualOperations() throws VnanoException {
        String string = " true && true || true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && true || true", string);
        string = " false && true || true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "false && true || true", string);
        string = " false && (true || true) ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false && (true || true)", string);
        string = " true && false || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "true && false || false", string);
        string = " false && (true || true) ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false && (true || true)", string);
        string = " true && (false || false); ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "true && (false || false)", string);
        string = " true || (false && false); ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true || (false && false)", string);
    }

    private void testTripleOperations() throws VnanoException {
        String string = " true && true || true && true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && true || true && true", string);
        string = " true && false || true && true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && false || true && true", string);
        string = " true && (false || true) && true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && (false || true) && true", string);
        string = " true || true && true || true ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true || true && true || true", string);
        string = " true || false && true || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true || false && true || false", string);
        string = " false || false && true || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "false || false && true || false", string);
    }

    private void testQuadOperations() throws VnanoException {
        String string = " true && true && true && true && true ; ";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && true && true && true && true", string);
        string = " true && true || true && false || false ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "true && true || true && false || false", string);
        string = " true && (true || true) && (false || false) ; ";
        bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "true && (true || true) && (false || false)", string);
    }
}

